/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/********************************************************************
 * Graphics Interface
 * ------------------ 
 * This file contains the external declarations for global variables
 * used in the Graphics Interface package of the Rochester
 * Connectionist Simulator.
 *
 * Note: to make it easy for the simulator or user code to avoid
 *       name clashes, ALL external variables (and procedure names)
 *       should begin with the prefix "gi_".
 *
 * Kenton Lynne
 ********************************************************************/

/********************************************************/
/* definition of the default (main mode) display cursor */
/********************************************************/
extern struct cursor *gi_cursor;

/*************************************************************************/
/* SUNTOOL handles for various window and panel structures               */
/*************************************************************************/
extern struct tool *gi_tool;            /* global tool handle            */
extern struct gfxsubwindow *gi_gfx;     /* display panel handle          */
extern struct rect gi_rects[];          /* holds panel dimensions        */ 
extern struct inputmask gi_mask[];      /*input masks for display panel */

/***********************************************/
/* holds the current display window dimensions */
/***********************************************/
extern int gi_origin_x;     /* left_most coordinate   */
extern int gi_origin_y;     /* top_most coordinate    */
extern int gi_extent_x;     /* right_most coordinate  */
extern int gi_extent_y;     /* bottom_most coordinate */

/*************************************************************/
/* header and pointers for maintaining the gricon structures */
/*************************************************************/
extern struct gricons *gi_icon_head;
extern struct pixrect **gi_pixptr_start;
extern struct pixrect **gi_last_pixptr;

/*************************************************************/
/* header structures for anchoring the drawn, text and grobj */
/* doubly linked chain structures                            */
/*************************************************************/
extern struct grobj gi_marker,  /* the on display grobj header  */
             gi_off_display;    /* the "off display" header     */
extern struct txobj gi_text_head;
extern struct drobj  gi_draw_head;

/*************************************************************************/
/* the header and default pointers for maintaining text fonts in storage */
/*************************************************************************/
extern struct saved_fonts *gi_font_head;  
extern struct pixfont *gi_dft_font, *gi_cur_font;

/****************************************************************/
/* pointers for maintaining the vertex and string storage areas */
/****************************************************************/
extern int *gi_vertex_start;
extern int *gi_last_vertex;
extern char *gi_string_start;
extern char *gi_last_char;

/*******************************************************/
/* array for maintaining the columns of the info panel */
/*******************************************************/
extern int gi_info_next;  /* indicates next column to use */
extern struct info_unit gi_info_item[];             

/****************************************************************/
/* variables that maintain the log file and its parameters      */
/****************************************************************/
extern char gi_log_on;      /* indicates whether loggin enabled */
extern FILE *gi_log_fp;     /* log file pointer                 */
extern int gi_log_start_x;  /* position of prompt on mode panel */

/****************************************************************/
/* variables for maintaining size of display panel              */
/****************************************************************/
extern int gi_old_width;    /* width of display panel           */
extern int gi_old_height;   /* height of display panel          */

/****************************************************************/
/* consists of bit flags for controlling gi_reshow behavior     */
/****************************************************************/
extern int gi_reshow_flag;

/****************************************************************/
/* variables that are maintained for LINK mode processing       */
/****************************************************************/
extern char gi_new_link_parms;     /* link parms have changed   */
extern int gi_link_direction;      /* current link direction    */
extern int gi_cur_link_target;     /* current target unit index */
extern char *gi_cur_link_site;     /* current target site       */
extern struct pixrect **gi_cur_link_image; /* points to link icon array */
struct grobj *gi_cur_target_ptr;   /* points to target grobj    */

/**********************************/
/* miscellaneous global variables */
/**********************************/
extern int gi_mode;                  /* current panel mode            */
extern char gi_off_display_ok;       /* off display values are ok     */
extern int gi_draw_type;             /* current draw parameter        */   
extern struct grobj *gi_last_tagged; /* points to last tagged unit    */
extern int gi_cur_image_value;       /* holds currently selected icon */
extern int gi_cur_unit_what;         /* contains current aspect       */

/***********************/
/* external procedures */
/***********************/
extern struct pixfont 
  *gi_get_font();

extern struct grobj
  *gi_find_xy(),
  *gi_find_grobj(),
  *gi_find_unit();

extern struct drobj
  *gi_find_drobj(),
  *gi_remember_drobj();

extern struct txobj
  *gi_find_txobj(),
  *gi_remember_txobj();

extern char
  *gi_strip(),
  *gi_sim_get_name(),
  *gi_sim_get_type(),
  *gi_save_string(),
  *gi_get_site(),
  *gi_string();

extern FLINT
  gi_sim_get_link(),
  gi_sim_get_output(),
  gi_sim_get_pot(),
  gi_sim_get_state(),
  gi_sim_get_data();
  
extern int
  gi_mark_bound(),
  gi_move_bound(),
  gi_contains(),
  gi_bind_bind(),
  gi_parse_cmd(),
  gi_command(),
  gi_make_control_panel(),
  gi_make_display_panel(),
  gi_sim_get_clock(),
  gi_sim_read_cmd(),
  gi_sim_get_unit(),
  gi_get_info(),
  gi_get_values(),
  gi_get_links(),
  gi_sim_go(),
  gi_make_info_panel(),
  gi_show_info(),
  gi_do_info(),
  gi_do_steps(),
  gi_erase_grobj(),
  gi_erase_drobj(),
  gi_erase_txobj(),
  gi_save_vertex (),
  gi_save_char(),
  gi_update_origin(),
  gi_update_clock(),
  gi_overlap(),
  gi_overlap_txobj(),
  gi_overlap_grobj(),
  gi_overlap_drobj(),
  gi_display_drobj(),
  gi_display_grobj(),
  gi_display_txobj(),
  gi_move_drobj(),
  gi_move_grobj(),
  gi_move_txobj(),
  gi_marker_here(),
  gi_move_marker(),
  gi_check_num(),
  gi_make_mode_panel(),
  gi_log(),
  gi_log_info(),
  gi_log_delete(),
  gi_log_move(),
  gi_log_text(),
  gi_log_draw(),
  gi_make_msg_panel(),
  gi_put_error(),
  gi_put_message(),
  gi_do_erase(),
  gi_do_change(),
  gi_do_show(),
  gi_reshow(),
  gi_move_grobj_chain(),
  gi_change_origin(),
  gi_get_target(),
  gi_conv_coord(),
  gi_set_new_target(),
  gi_display_link(),
  gi_update_grobj_chain();
