/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/* Context-free parsing network.  Written by Mark Fanty, April 1987.
 * Computer Science Department, University of Rochester   
 */

/* This file contains fuctions defining the behavior of the network. */

#include <stdio.h>
#include <math.h>
#include "sim.h"
#include "parsing.h"

#define MIN(x,y) (((x) > (y)) ? (y) : (x))

/* UFendmarker(up)
 *
 * The purpose of endmarkers is to provide top-down feedback to
 * bottom-up primed start symbols whose yield is the entire input.
 * They come on automatically if no terminal units are on in their position.
 */

UFendmarker(up)
     Unit *up;
{
  if(SiteValue("inhibit",up->sites) > 0) /* terminal units? */
    {
      up->potential = up->output = 0;
      up->state = off;
    }
  else
    {
      up->potential = up->output = 1000;
      up->state = on;
    }
}

/* UFmatch(up)
 * 
 * Match units represent one instantiation of a production.  If all
 * their bottom-up inputs are primed, the production instance is
 * satisfied and they become primed.  This will prime the nonterminal unit.
 */

UFmatch(up)		/* Unit function for match units */
     Unit *up;
{
  if(up->state == off)
    /* site function is "min" */
    if(SiteValue("bottom",up->sites) >= 500)
      {
	up->state = primed; /* set here instead of state function */
	up->potential = up->output = 500;
      }
    else
      up->potential = up->output = 0;
  else if(up->state == primed)
    /* see if top-down activation has reached this far -- only if
       already primed. */
    if(SiteValue("top",up->sites) > 900)
      {
	up->state = on;
	up->potential = up->output = 1000;
      }
}

/* UFnt(up)
 *
 * Nonterminal units are like match units, except their bottom-up site
 * function is max (sum would work).  Only one of their match units
 * need be primed for it to be primed.
 */

UFnt(up) 
     Unit *up;
{
  if(up->state == off)
    if(SiteValue("bottom",up->sites) >= 500)
      {
	up->state = primed; 
	up->potential = up->output = 500;
      }
    else
      up->potential = up->output = 0;
  else if(up->state == primed)
    /* look for strong top-down activation: am I part of a successful
       parse tree? */
    if(SiteValue("top",up->sites) > 900)
      {
	up->state = on;
	up->potential = up->output = 1000;
      }
}

/* UFt(up)
 *
 * Terminal units are primed by hand.  They are fully activated if
 * they receive top-down input.
 */

UFt(up)
     Unit *up;
{
  if(up->state == off)
    {
      up->potential = up->output = 0;
    }
  else if(SiteValue("top",up->sites) > 900)
    {
      up->state = on;
      up->potential = up->output = 1000;
    }
  else
    {
      up->state = primed;
      up->potential = up->output = 500;
    }
}

