/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/* unit states */
#define off 0
#define primed 1
#define on 2

/* return values of the various symbol reading functions */
#define TERMINATOR -2
#define ENDFILE -1
#define NT 0
#define T  1
#define UNKNOWN 2
#define OK 3

#define MAXT 20			/* maximum number of terminal symbols */
#define MAXNT 20		/* maximum number of nonterminal symbols */
#define MAXWORDS (MAXT > MAXNT ? MAXT : MAXNT)

char *strcpy();

static struct production	/* linked list of grammar's productions */
{
  char *left,			/* left side of production */
       *first,			/* first symbol on right */
       *second;			/* second symbol on right (if needed) */
  int type;			/* either T (1 terminal) or NT
				   (2 nonterminals) */
  struct production *next;	/* next production (NULL terminated) */
} *productions;			/* points to head of list */
