/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

#include "scheme.h"
#include "primitive.h"

extern int NoUnits;
static int firstcall = 1;

Define_Primitive(init_rochester_simulator, 0, "SIMULATOR-INIT")
{
  Primitive_0_Args();
  if (firstcall)
    simulator_setup(1,Saved_argv);
  else
    printf("Cannot initialize simulator again!\n\n");
  firstcall = 0;
  return NIL;				/*  */
}

Define_Primitive(activate_graphics_window, 0, "SIMULATOR-RUN")
{
  Primitive_0_Args();
  simulator_run();
  return NIL;
}

Define_Primitive(activate_graphics_window, 0, "SIMULATOR-QUIT")
{
  Primitive_0_Args();
  simulator_quit();
  return NIL;
}

Define_Primitive(graphics_command, 1, "SIMULATOR-GRAPHICS-COMMAND")
{
  Primitive_1_Args();
  gi_command(Scheme_String_To_C_String(Arg1));
  gi_reshow();
  return C_Integer_To_Scheme_Integer(NoUnits-1);
}

Define_Primitive(scheme_net_steps, 2, "SIMULATOR-STEPS")
{ long steps,update;
  int flag,i,j,k;
  char cmd[80];
  Primitive_2_Args();
  flag = Scheme_Integer_To_C_Integer(Arg1,&steps);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg2,&update);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  i = steps%update;		/* no of steps at end */
  j = steps/update;		/* no of times to update */
  sprintf(cmd,"go %d",(int) update);
  for (k = 0; k < j; k++)	/* go update steps k times */
    {
      gi_command(cmd);		/* go update steps */
      gi_reshow();		/* reshow graphics */
    }
  sprintf(cmd,"go %d",i);	/* remaining steps */
  gi_command(cmd);
  gi_reshow();			/* and reshow graphics */
  return NIL;
}

Define_Primitive(sim_name_to_func, 1, "SIMULATOR-NAME-TO-FUNC")
{ 
  Primitive_1_Args();
  return(C_Integer_To_Scheme_Integer
	 (NameToFunc(Scheme_String_To_C_String(Arg1))));
}

Define_Primitive(sim_make_unit, 8, "SIMULATOR-MAKE-UNIT")
{
  char *type;
  long func,ipot,pot,data,out,istate,state;
  int flag;
  Primitive_8_Args();
  type = Scheme_String_To_C_String(Arg1);
  flag = Scheme_Integer_To_C_Integer(Arg2,&func);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg3,&ipot);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg4,&pot);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg5,&data);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg6,&out);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg7,&istate);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg8,&state);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  return(C_Integer_To_Scheme_Integer
	 (MakeUnit(type,func,ipot,pot,data,out,istate,state)));
}

Define_Primitive(sim_add_site, 4, "SIMULATOR-ADD-SITE")
{
  long index,func,data;
  char* name;
  int flag;
  Primitive_4_Args();
  flag = Scheme_Integer_To_C_Integer(Arg1,&index);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  name = Scheme_String_To_C_String(Arg2);
  flag = Scheme_Integer_To_C_Integer(Arg3,&func);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg4,&data);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  AddSite(index,name,func,data);
  return(NIL);
}


Define_Primitive(sim_make_link, 6, "SIMULATOR-MAKE-LINK")
{
  long src,dest,weight,data,func;
  char *site;
  int flag;
  Primitive_6_Args();
  flag = Scheme_Integer_To_C_Integer(Arg1,&src);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg2,&dest);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  site = Scheme_String_To_C_String(Arg3);
  flag = Scheme_Integer_To_C_Integer(Arg4,&weight);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg5,&data);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg6,&func);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  MakeLink(src,dest,site,weight,data,func);
  return(NIL);
}

Define_Primitive(set_unit_output, 2, "SIMULATOR-SET-UNIT-OUTPUT")
{ long unit_index,value;
  int flag;
  Primitive_2_Args();
  flag = Scheme_Integer_To_C_Integer(Arg1,&unit_index);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg2,&value);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  SetOutput(unit_index,value);
  return(NIL);
}
Define_Primitive(get_unit_output, 1, "SIMULATOR-GET-UNIT-OUTPUT")
{ long unit_index;
  int flag;
  Primitive_1_Args();
  flag = Scheme_Integer_To_C_Integer(Arg1,&unit_index);
  if (flag == PRIM_DONE)
     return C_Integer_To_Scheme_Integer(GetOutput(unit_index));
  Primitive_Error(flag);
}

Define_Primitive(set_unit_potential, 2, "SIMULATOR-SET-UNIT-POTENTIAL")
{ long unit_index,value;
  int flag;
  Primitive_2_Args();
  flag = Scheme_Integer_To_C_Integer(Arg1,&unit_index);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg2,&value);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  SetPotential(unit_index,value);
  return(NIL);
}
Define_Primitive(get_unit_potential, 1, "SIMULATOR-GET-UNIT-POTENTIAL")
{ long unit_index;
  int flag;
  Primitive_1_Args();
  flag = Scheme_Integer_To_C_Integer(Arg1,&unit_index);
  if (flag == PRIM_DONE)
     return C_Integer_To_Scheme_Integer(GetPotential(unit_index));
  Primitive_Error(flag);
}

Define_Primitive(set_unit_state, 2, "SIMULATOR-SET-UNIT-STATE")
{ long unit_index,value;
  int flag;
  Primitive_2_Args();
  flag = Scheme_Integer_To_C_Integer(Arg1,&unit_index);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg2,&value);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  SetState(unit_index,value);
  return(NIL);
}
Define_Primitive(get_unit_state, 1, "SIMULATOR-GET-UNIT-STATE")
{ long unit_index;
  int flag;
  Primitive_1_Args();
  flag = Scheme_Integer_To_C_Integer(Arg1,&unit_index);
  if (flag == PRIM_DONE)
     return C_Integer_To_Scheme_Integer(GetState(unit_index));
  Primitive_Error(flag);
}

Define_Primitive(set_unit_data, 2, "SIMULATOR-SET-UNIT-DATA")
{ long unit_index,value;
  int flag;
  Primitive_2_Args();
  flag = Scheme_Integer_To_C_Integer(Arg1,&unit_index);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  flag = Scheme_Integer_To_C_Integer(Arg2,&value);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  SetData(unit_index,value);
  return(NIL);
}
Define_Primitive(get_unit_data, 1, "SIMULATOR-GET-UNIT-DATA")
{ long unit_index;
  int flag;
  Primitive_1_Args();
  flag = Scheme_Integer_To_C_Integer(Arg1,&unit_index);
  if (flag == PRIM_DONE)
     return C_Integer_To_Scheme_Integer(GetData(unit_index));
  Primitive_Error(flag);
}

Define_Primitive(sim_declare_state, 2, "SIMULATOR-DECLARE-STATE")
{
  char *name;
  long value;
  int flag;
  Primitive_2_Args();
  name = Scheme_String_To_C_String(Arg1);
  flag = Scheme_Integer_To_C_Integer(Arg2,&value);
  if (flag != PRIM_DONE)
    Primitive_Error(flag);
  DeclareState(name,value);
  return(NIL);
}

