#include "sim.h"
#include <sys/time.h>

UFweightedsum(up)
     Unit * up;

{
  register Link * ip;
  register FLINT sum = 0;

  for (ip = up->sites->inputs;
       ip != NULL;
       sum += (ip->weight) * (*(ip->value)), ip = ip->next);
  up->output = (sum/1000);
}

build()

{
  int i,j,k,n;
  int l,m;
  int start, finish;
  Unit * up;

  struct timeval tp;
  struct timezone tzp;

  printf("how many units > ");
  scanf("%d",&l);
  printf("how many links per unit > ");
  scanf("%d",&m);
  printf("%d units, %d links per unit\n",l,m);
  i = l;
  j = m;
  gettimeofday(&tp,&tzp);
  start = tp.tv_sec;

  AllocateUnits(i);
  for (k = 0; k < i; k++)
    {
      MakeUnit("vertex",UFweightedsum,(FLINT)0,(FLINT)0,(FLINT)k,(FLINT)0,0,0);
      AddSite(k,"excite",NULL, (FLINT) k);
      SetFlagP((up = UnitList+k),NO_SITE_FUNC_FLAG);
      SetFlagP(up,NO_LINK_FUNC_FLAG);
    }
  for (k = 0; k < i; k++)
    for (n = 0; n < j; n++)
      MakeLink(random() % i,k,"excite",(FLINT)1000,(FLINT)k,NULL);

  gettimeofday(&tp,&tzp);
  finish = tp.tv_sec;
  printf("time = %ld seconds\n",finish - start);
}

                
