static char rcsid[] = "$Header: globals.c,v 1.2 87/10/21 17:37:25 goddard Exp $";
/*----------------------------------------------------------------------------

  The Rochester Connectionist Simulator.  Copyright Univesity of Rochester.
  Author: Nigel Goddard
  Date: May 1 1987

----------------------------------------------------------------------------*/

#pragma segment SEGM2

/*  This file contains the global variables used by all modules of the
    simulator.  A selection of these are availible to the user
*/


#ifdef BFLY
# ifdef BSIM
#  include "bflysim.h"
# else
#  include "bflycontrol.h"
# endif
#else
#  include "Stupido:rochester:include:uniproc.h"
#endif

/* unit array */
#ifdef BFLY
int NumberOfSims;               /* number of simulators */
int UnitsEach;                  /* number of units on each sim */
SimInfo *Sims;                  /* information about each sim */
OID *Outlist;                   /* array of OID's for output arrays */
short *InLock;                  /* lock for reading from stdin (debug) */

char **Names;                   /* name list poiner */
int no_Names = 0;               /* actual number of Names */
int NameSize = 497;             /* default size of name table */
#endif

#ifndef BCNTL
  Unit *UnitList;               /* unit array pointer */
  Outvec *Outputs;              /* output list pointer */
#endif

#ifdef BSIM
Output ** OutputArrays;         /* array of sim outputs */
int MySimNumber;                /* as it says */
unsigned int TimeStart = 0;     /* to time simulation */
unsigned int TimeFinish = 0;   
#endif


int NoUnits = 0;                /* number of units in the net */
int LastUnit = 0;               /* size of unit array */


char **StateNames;              /* state Names */
int NoStates = 100;             /* number of states with Names */
int StateCount = 0;             /* actual number of states with Names */

char *SetNames[32] = {NULL,};   /* set Names */
int LastSet = 32;               /* max number of sets */
int NoSets = 0;                 /* actual number of sets */

int NoLinks = 0;                /* for user info */

int Clock = 0;                  /* the system Clock */


FILE *Dispf = stdout;           /* display output (pipe to more) */

int Pause = 0;                  /* if 1, Pause after every Show */

int Echo = 1;                   /* echoing turned on */
int EchoStep = 1;               /* print message after EchoStep steps
                                   of simulation */
int Yyint;                      /* integer found by lex */
float Yyfloat;                  /* float found by lex */
char Yyarg[ARGLEN];             /* string found by lex */

int Curarg;                     /* current command arg */
int Ulow,Uhigh,Uset,Usetind;    /* for FOR_UNITS macro */
int Cmdindex = 0;               /* index into argv[Curarg] */

char PipeCommand[80] = "/usr/ucb/more";
                                /* default command */
int PipeFlag = 1;               /* piping on if equal to 1 */

int SyncFlag = 1;               /* 0 async, 1 sync, 2 fair async */

int ExecFract = 0;              /* fraction of units updated each step */
int ExecLimit = 1;              /* every unit updated within this no steps */

char * si_Program;              /* holds name of executable (for timestamp) */
int Debug = 1;                  /* 0 if no debug, !=0 if debugging */
int AutoFix = 0;                /* 0 if no auto-fix for debug errors */
unsigned int Errors = 0;        /* bit vector for debug errors */
int Logging = 0;                /* 0 if not logging, 1 if logging */
FILE * LogFile;                 /* file pointer for logfile */
int LogCmd = 0;                 /* 0 if not logging commands, 1 if so */
FILE * CmdFile;                 /* file pointer for command log file */
int Format = 0;                 /* on for auto line-breaking in display */

int Guarded = 0;                /* 0 means interrupts processed at once */

int si_GiErrCnt = 0;            /* count of errors for graphics */

int Show;                       /* global flag indicating Show on/off */ 
int ShowStep = 1;               /* plot values at ShowStep time steps */ 
FLINT ShowPot = 1000000;        /* potential threshold for Showing */
unsigned int ShowSets;          /* set bits for sets to be shown */


int (* si_User_Unit_Display)(); /* pointers to user supplied functions */
int (* si_User_Site_Display)(); /* for displaying and listing the data */
int (* si_User_Link_Display)(); /* in user-defined data fields of the */
int (* si_User_Link_List)();    /* standard structures */
int (* si_User_Unit_Checkpoint)(); /* for checkpointing unit data */
int (* si_User_Site_Checkpoint)(); /* for checkpointing site data */
int (* si_User_Link_Checkpoint)(); /* for checkpointing link data */
int (* si_User_Unit_Restore)(); /* for Restoring unit data */
int (* si_User_Site_Restore)(); /* for Restoring site data */
int (* si_User_Link_Restore)(); /* for Restoring link data */
int (* si_User_Unit_Save)(); /* for Saving unit data */
int (* si_User_Site_Save)(); /* for Saving site data */
int (* si_User_Link_Save)(); /* for Saving link data */
int (* si_User_Unit_Load)(); /* for Loading unit data */
int (* si_User_Site_Load)(); /* for Loading site data */
int (* si_User_Link_Load)(); /* for Loading link data */
int (* si_User_Help_Info)(); /* for Loading link data */

/*----------------------------------------------------------------------------

  si_InitGlobals initializes all the global variables.  It is called on
  startup and by the "trash" command.

----------------------------------------------------------------------------*/

si_InitGlobals()

{
        int i,j;

#ifdef BFLY
        no_Names = 0;               /* actual number of Names */
        NameSize = 497;             /* default size of name table */
#endif

#ifdef BSIM
        TimeStart = 0;  
        TimeFinish = 0;   
#endif


        NoUnits = 0;            /* number of units in the net */
        LastUnit = 0;           /* size of unit array */

        NoStates = 100;         /* number of states with Names */
        StateCount = 0;         /* actual number of states with Names */

        for (i = 0; i < 32; i++)
          SetNames[i] = NULL;   /* set Names */
        LastSet = 32;           /* max number of sets */
        NoSets = 0;             /* actual number of sets */

        NoLinks = 0;            /* for user info */

        Clock = 0;              /* the system Clock */

        Dispf = stdout;         /* display output (pipe to more) */

        Pause = 0;              /* if 1, Pause after every Show */

        Echo = 1;               /* echoing turned on */
        EchoStep = 1;           /* print message after EchoStep steps
                                   of simulation */
        Cmdindex = 0;           /* index into argv[Curarg] */

        PipeFlag = 1;           /* piping on if equal to 1 */

        SyncFlag = 1;           /* 0 async, 1 sync, 2 fair async */

        ExecFract = 0;          /* fraction of units updated each step */
        ExecLimit = 1;          /* every unit updated within this no steps */

        Debug = 1;              /* 0 if no debug, !=0 if debugging */
        AutoFix = 0;            /* 0 if no auto-fix for debug errors */
        Errors = 0;             /* bit vector for debug errors */

        Guarded = 0;            /* 0 means interrupts processed at once */

        ShowStep = 1;           /* plot values at ShowStep time steps */ 
        ShowPot = 1000000;      /* potential threshold for Showing */
        ShowSets = 0;           /* set bits for sets to be shown */

}

