(set-macro-character #\% #'(lambda(stream char) (values (read-line stream)))))

(defmacro defsimentry (name)
 (let* ((name (string-downcase (symbol-name name)))
	(add-name (intern (string-upcase (string-append "kcl_si_add_" name)))))
      
  `(progn
    (clines ,(string-append "void kcl_si_add_" name "()")
	    ,(string-append "{ AddItemToTable(\"" name "\"," name ", 7, -1,NULL,-1);}"))
    (defun ,add-name () ())
    (defentry ,add-name () (void ,add-name))
    (,add-name))))

(defun string-append (&rest strings)
  (let ((new-string (make-string (apply #'+ (mapcar #'length strings))))
	(indx 0))
    (do ((lst strings (cdr lst)))
	((null lst))
	(do ((i 0 (+ i 1)))
	    ((= i (length (car lst))))
	    (setf (aref new-string indx) (aref (car lst) i))
	    (setq indx (+ indx 1))))
    new-string))

(clines 
%        extern char ** ARGV;
%
%        void kcl_si_start()
%
%        {
%          simulator_setup(1,ARGV);
%          simulator_run();
%        }
)
(defentry sim-init () (void kcl_si_start))

(clines "void kcl_si_transfer()

         {
           simulator_run();
         }"
)
(defentry sim () (void kcl_si_transfer))

(clines
%      char * copy_kcl_string(obj)
%      object obj;
%      {
%        char * tmpstring;
%	 int stringlength, i;
%	 stringlength = obj->st.st_fillp;
%	 tmpstring = (char *) malloc((stringlength+1)*sizeof(char));
%	 for (i=0; i < stringlength; ++i)
%	     tmpstring[i] = obj->st.st_self[i];
%	 tmpstring[stringlength] = '\0';
%	 return(tmpstring);
%      }
)
(defentry kcl-string-to-c-string (object) (int copy_kcl_string))

(clines
% int kcl_si_name_to_func(name)
% object *name;
% {
%   char *str;
%   int func_ptr;
%   str = copy_kcl_string(name);
%   func_ptr = NameToFunc(str);
%   free(str);
%   return(func_ptr);
% }
)
(defentry name-to-func (object) (int kcl_si_name_to_func))

(clines
% int kcl_si_make_link(src,dest,site,weight,data,func)
% int src,dest;
% int weight,data;
% char *site;
% int func;
% { return(MakeLink(src,dest,site,weight,data,func)); }
)
(defentry MakeLink (int int int int int int) (int kcl_si_make_link))

(clines "extern int NoUnits;
         int kcl_si_command(obj)
            object obj;

         {
	   char * tmpstring;
	   /* copy string to non-relocatable area */
	   tmpstring = copy_kcl_string(obj);
           gi_command(tmpstring);
           gi_reshow();
	   free(tmpstring);
	   return (NoUnits - 1);
          }"
) 

(defentry sim-cmd (object) (int kcl_si_command))
          
(clines "int kcl_si_getoutput(index)
               int index;

         {
           return (GetOutput(index));
         }"
)
(defentry get-output (int) (int kcl_si_getoutput))

(clines
%      void kcl_si_setpotential(index,value)
%      int index,value;
%      { SetPotential(index,value); }
)
(defentry set-potential (int int) (void kcl_si_setpotential))

(clines
%	void kcl_si_setoutput(index,value)
%	int index,value;
%	{ SetOutput(index,value); }
)
(defentry set-output (int int) (void kcl_si_setoutput))

(clines
%	void kcl_si_setstate(index,value)
%	int index,value;
%	{ SetState(index,value); }
)
(defentry kcl-set-state (int int) (void kcl_si_setstate))

(clines
% void kcl_si_setdata(index,value)
% int index,value;
%{ SetData(index,value); }
)
(defentry set-data (int int) (void kcl_si_setdata))

(clines
% int kcl_si_getdata(index)
% int index;
% { return(GetData(index)); }
)
(defentry get-data (int) (int kcl_si_getdata))

(clines "void kcl_si_quit()

         {
           gi_end_session();
         }"
)
(defentry sim-quit () (void kcl_si_quit))

(clines "void kcl_si_steps(steps,update)
              int steps,update;

        {
          int i,j,k;
          char cmd[80];

          i = steps%update;             /* no of steps at end */
          j = steps/update;             /* no of times to update */"
%         sprintf(cmd,"go %d",(int) update);
"         for (k = 0; k < j; k++)       /* go update steps k times */
            {
              gi_command(cmd);          /* go update steps */
              gi_reshow();              /* reshow graphics */
            }"
%         sprintf(cmd,"go %d",i);       /* remaining steps */
"         if(i > 0)  
            { gi_command(cmd);
              gi_reshow();  }  /* and reshow graphics */
        }"
)						  
(defentry sim-step (int int) (void kcl_si_steps))

(clines 
%	void kcl_si_step_wo_graphics(num)
%	int num;
%	{ Step(num); }
)
(defentry sim-step-w/o-graphics (int) (void kcl_si_step_wo_graphics))

(clines
%      int kcl_si_declare_state(obj,num)
%      object * obj;
%      int num;
%      {
%        char * tmpstring;
%	 /* copy string to non-relocatable area */
%	 tmpstring = copy_kcl_string(obj);
%	 DeclareState(tmpstring,num);
%	 free(tmpstring);
%      }
)

(defentry kcl-si-declare-state (object int) (int kcl_si_declare_state))

(defmacro declare-state (symbol number)
   `(progn
     (clines ,(format nil "#define ~a ~d" symbol number))
     (kcl-si-declare-state ,(string-downcase (symbol-name symbol)) ,number)
     (setf (get ',symbol '*simulator-state-value*) ,number)))

(defun set-state (unit state)
  (kcl-set-state unit
		 (if (symbolp state)
		     (get state '*simulator-state-value*)
		   state)))

(defmacro declare-C-global (name initial-value)
 (let ((setter (intern (format nil "SET_~a" name)))
       (getter (intern (format nil "GET_~a" name))))
 `(progn
   (clines
    ,(format nil "int ~a = ~d;" name initial-value)
    ,(format nil "void ~a(num) int num; { ~a = num; }"
                 (string-downcase (symbol-name setter)) name)
    ,(format nil "int ~a() {return ~a; }"
                 (string-downcase (symbol-name getter)) name))
   (defentry ,setter (int) (void ,setter))
   (defentry ,getter () (int ,getter)))))


(defun cload (file)
  (compile-file (concatenate 'string (string-downcase (symbol-name file))
			     ".lsp"))
  (load (concatenate 'string (string-downcase (symbol-name file))
		     ".o")))

(clines
% int kcl_si_make_unit(type,func,ipot,pot,data,out,istate,state)
% char *type;
% int func;
% int ipot,pot,data,istate,state,out;
% { return(MakeUnit(type,func,ipot,pot,data,out,istate,state)); }
)
(defentry MakeUnit (int int int int int int int int) (int kcl_si_make_unit))

(clines
% int kcl_si_add_site(index,name,func,data)
% int index,data;
% char *name;
% int func;
% { return(AddSite(index,name,func,data)); }
)
(defentry AddSite (int int int int) (int kcl_si_add_site))
(clines "int kcl_si_getpotential(index)
               int index;

         {
           return (GetPotential(index));
         }"
)
(defentry get-potential (int) (int kcl_si_getpotential))

(clines "int kcl_si_getstate(index)
               int index;

         {
           return (GetState(index));
         }"
)
(defentry get-state (int) (int kcl_si_getstate))

(clines
% int kcl_si_malloc(size)
% int size;
% { return (malloc(size)); }
)
(defentry malloc (int) (int kcl_si_malloc))

(clines
% int kcl_si_valloc(size)
% int size;
% { return (valloc(size)); }
)
(defentry valloc (int) (int kcl_si_valloc))


(clines
% void kcl_si_free(ptr)
% int ptr;
% { free(ptr); }
)
(defentry free (int) (void kcl_si_free))

(clines
% void kcl_si_poke(ptr,val)
% char *ptr;
% char val;
% { *ptr = val; }
)
(defentry poke (int int) (void kcl_si_poke))

(clines
% int kcl_si_peek(ptr)
% char *ptr;
% { return((int)*ptr); }
)
(defentry peek (int) (int kcl_si_peek))
