/* --------------------------------------------- */
/* The init routine for setting up a image widget.
 *
 *	By Upi Bhalla April 1990.
 *  If this code does not work it is not my fault.
 *	You may hack this code if the acknowledgement
 *	remains intact.
 *	Parts of the code are taken from xgif, by
 *	John Bradley, University of Pennsylvania, who in turn got
 *	portions of code from Patrick J. Naughton. See xgifload.c
 *
 */
/* --------------------------------------------- */

/* All the necessary include files */

#include <stdio.h>
#include <math.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "ImageP.h"

Boolean ImageSetHook();
void ImageGetHook();
static char	*GetImageValue();
static int CleanImageHl();
void ImageResize();

/* --------------------------------------------- */

static XtResource ImageResources[] = {
#define offset(field) XtOffset(ImageWidget, image.field)
    {XtNfilename, XtCFilename, XtRString, sizeof(char *),
		offset(filename), XtRString, "image.gif"
    },
    {XtNfileformat, XtCFileformat, XtRString, sizeof(char *),
        offset(fileformat), XtRString, "gif"
    },
    {XtNstoremode, XtCStoremode, XtRString, sizeof(char *),
        offset(storemode), XtRString, "mem"
    },
    {XtNrescaleable, XtCRescaleable, XtRBoolean, sizeof(int),
        offset(rescaleable), XtRString, "FALSE"
    },
    {XtNvalue, XtCValue, XtRString, sizeof(char *),
        offset(value), XtRString, "none"
    },
    {XtNsrcx, XtCSrcx, XtRInt, sizeof(int),
        offset(srcx), XtRString, "0"
    },
    {XtNsrcy, XtCSrcy, XtRInt, sizeof(int),
        offset(srcy), XtRString, "0"
    },
    {XtNdstx, XtCDstx, XtRInt, sizeof(int),
        offset(dstx), XtRString, "0"
    },
    {XtNdsty, XtCDsty, XtRInt, sizeof(int),
        offset(dsty), XtRString, "0"
    },
    {XtNwx, XtCWx, XtRInt, sizeof(int),
        offset(wx), XtRString, "700"
    },
    {XtNwy, XtCWy, XtRInt, sizeof(int),
        offset(wy), XtRString, "400"
    },
};

static Boolean ImageSetValues();
static void Destroy();
void ImageDisplay();

static char translations[] = "";

static void ImageAction();
static void ImageInit();
static XtActionsRec actions[] = {
	{"image",	ImageAction},
};

ImageClassRec imageClassRec = {
  { /* core fields */
    /* superclass       */  (WidgetClass) &widgetClassRec,
    /* class_name       */  "Image",
    /* widget_size      */  sizeof(ImageRec),
    /* class_initialize     */  NULL,
    /* class_part_initialize    */  NULL,
    /* class_inited     */  FALSE,
    /* initialize       */  ImageInit,
    /* initialize_hook      */  NULL,
    /* realize          */  XtInheritRealize,
    /* actions          */  actions,
    /* num_actions      */  XtNumber(actions),
    /* resources        */  ImageResources,
    /* num_resources        */  XtNumber(ImageResources),
    /* xrm_class        */  NULLQUARK,
    /* compress_motion      */  TRUE,
    /* compress_exposure    */  TRUE,
    /* compress_enterleave  */  TRUE,
    /* visible_interest     */  FALSE,
    /* destroy          */  Destroy,
    /* resize           */  ImageResize,
    /* expose           */  ImageResize,
    /* set_values       */  ImageSetValues,
    /* set_values_hook      */  NULL,
    /* set_values_almost    */  XtInheritSetValuesAlmost,
    /* get_values_hook      */  NULL,
    /* accept_focus     */  NULL,
    /* version          */  XtVersion,
    /* callback_private     */  NULL,
    /* tm_table         */  translations,
    /* query_geometry       */  XtInheritQueryGeometry,
    /* display_accelerator  */  XtInheritDisplayAccelerator,
    /* extension        */  NULL
  },
  { /* image fields */
    /* empty            */  0
  }
};


WidgetClass imageWidgetClass = (WidgetClass)&imageClassRec;

static void Destroy(w)
    ImageWidget w;
{
	if (w->image.image && w->image.filename) {
		XDestroyImage(w->image.image);
	}
}

static void ImageInit(request,new)
	ImageWidget request,new;
{
	if (request->image.image)
		new->image.image = NULL;
}

void ImageResize(w)
	ImageWidget	w;
{
	GC gc;

	gc = XDefaultGCOfScreen(XtScreen(w));
	/*
	gc = XtGetGC(w,
	*/

	if (XtIsRealized(w) && w->image.image) {
		XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,False);
		XPutImage(XtDisplay(w),XtWindow(w),gc,w->image.image,
			w->image.srcx,w->image.srcy,w->image.dstx,w->image.dsty,
			w->image.wx,w->image.wy);
	}
}

static void ImageExpose(w,event,region)
		ImageWidget w;
		XEvent	*event;
		Region	region;
{
}



static Boolean ImageSetValues(current,request,new)
	ImageWidget	current;
	ImageWidget	request;
	ImageWidget	new;
{
	Boolean do_redraw = FALSE;
	Boolean do_rescale = FALSE;

	if (strcmp(current->image.fileformat,request->image.fileformat) != 0 ||
	strcmp(current->image.filename,request->image.filename) != 0 ||
	strcmp(current->image.storemode,request->image.storemode) != 0) {
		LoadImage(new);
	}

	if (strcmp(current->image.fileformat,request->image.fileformat) != 0 ||
	strcmp(current->image.filename,request->image.filename) != 0 ||
	strcmp(current->image.storemode,request->image.storemode) != 0 ||
	current->image.srcx != request->image.srcx ||
	current->image.srcy != request->image.srcy ||
	current->image.dstx != request->image.dstx ||
	current->image.dsty != request->image.dsty ||
	current->image.wx != request->image.wx ||
	current->image.wy != request->image.wy) {
		/*
		printf("returning true at ImageSetValues\n");
		*/
		return(TRUE);
	} else
		return(FALSE);
}

static void	ImageGetValues(w,rl,args,nargs)
	ImageWidget	w;
	XrmResourceList	rl;
	ArgList	args;
	Cardinal	nargs;
{
}

LoadImage(w)
	ImageWidget w;
{
	XImage	*UpiLoadGIF();
	int	screen;

	screen = XDefaultScreen(XtDisplay(w));

	if (w->image.image && w->image.filename) {
		XDestroyImage(w->image.image);
		w->image.image = NULL;
	}
	w->image.image = UpiLoadGIF(w->image.filename,XtDisplay(w),
		screen);
}

SetStoreMode()
{
}

ImageRescale()
{
}

static void ImageAction(w,e,str,num)
	ImageWidget w;
	XEvent	*e;
	String	*str;
	Cardinal	*num;
{
}
