#include "gen_ext.h"
#include "xodus_args.h"

extern	XtCallbackProc	xform_callback();
extern	Widget		do_xform();
extern  char		*g_copy();

/*
** xform_func:	Handle GENESIS->XODUS events for xform_type elements.
**
** Returns:	1 on successful execution, 0 on failure.
**
*/
xform_func(element,action)
	struct xform_type 	*element;
	Action			*action;
{
	struct xform_type 	*new;
	MsgIn	*msg;
	char	*valuestr;
	char	*field, *value;
	char	**argv;
	Widget	widget, parent;
	int	n;
	Position	x,y;
	Arg	arg[10];

	static	XtCallbackRec	callback[2];
	static struct valid_arg xform_args[] = {
		{"label_flag", 0, -1},
		{"END", -1, -1}
	};


	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}

	callback[0].callback = (XtCallbackProc)xform_callback;
	callback[0].closure = (caddr_t)NULL;
	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;


	switch(action->type) {

    		case CREATE: 
			widget = do_xform(action->argc, action->argv);
			if (widget == NULL)
				return(0);

			parent = (Widget)XtParent(widget);

			element->widget = widget;
			element->x = (float)parent->core.x;
			element->y = (float)parent->core.y;
			element->width = (Dimension)widget->core.width;
			element->height = (Dimension)widget->core.height;
			element->absolute_x = (float)parent->core.x;
			element->absolute_y = (float)parent->core.y;
			element->absolute_width = (Dimension)widget->core.width;
			element->absolute_height =
			 (Dimension)widget->core.height;


			element->labelflag = atoi(x_arg(ARG_LABEL));
			element->title = g_copy(x_arg(ARG_TITLE));
			element->form = NULL;
			element->xwidget = NULL;
			element->ywidget = NULL;
			element->wwidget = NULL;
			element->hwidget = NULL;
			element->xtype = LAYOUT_ABSOLUTE;
			element->ytype = LAYOUT_ABSOLUTE;
			element->widthtype = LAYOUT_ABSOLUTE;
			element->heightype = LAYOUT_ABSOLUTE;

			n = 0;
			XtSetArg(arg[n], XtNlayout_callback, callback); n++;
			XtSetArg(arg[n], XtNlayout_element, (char *)element); 
				n++;
			XtSetValues(widget, arg, n);
			break;

    		case SET:
		argv = (char **) calloc(action->argc + 2,sizeof(char *));
		XoParseCoords(&(action->argc), action->argv, argv);
			if (x_parse_set(action->argc, argv, xform_args))
				xfunc_parse_set(element, action->argc,
					 argv, NULL);
			free(argv);
			break;
		case DELETE:
			genesis_destroy_widget(element);
			free(element->title);
			break;

		case	COPY:
			genesis_no_copy();
			return(0);
	}
	return(1);
}

/*
** xform_callback:	When xform is changed from the screen this is 
**			called.
**
*/
XtCallbackProc
xform_callback(w, client_data, call_data)
	LayoutWidget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
	Widget	parent;
	struct xform_type *element;
	element = (struct xform_type *)w->layout.layout_element;
	if (element == NULL) {
			fprintf(stderr,"xform_callback: null element\n");
			return;
	}
	
	parent = XtParent((Widget)w);
	if (parent == NULL)
		return;
	/* Assumes absolute coordinates for form widget at all times */
	element->x = (float)parent->core.x;
	element->y = (float)parent->core.y;
	element->width = parent->core.width;
	element->height = parent->core.height;
	element->absolute_x = (float)parent->core.x;
	element->absolute_y = (float)parent->core.y;
	element->absolute_width = parent->core.width;
	element->absolute_height = parent->core.height;
}


