#include "gen_ext.h"
#include "draw_w.h"

int	XoCreateCell();

void xcell_callback(w, client, call)
	LayoutWidget	w;
	caddr_t	client;
	caddr_t	call;
{
	struct xcell_type	*element;

	element = (struct xcell_type *)
		(((LayoutConstraints)(w->core.constraints))->
				layout.layout_element);
	if (element == NULL) {
		fprintf(stderr,"xcell_callback: null element\n");
		return;
	}
	xodus_core_set(element, w);
}

xcell_func(element,action)
	struct xcell_type *element;
	Action		*action;
{
	char	*field, *value;
	LayoutWidget	widget;
	static	XtCallbackRec	callback[2];
	static struct valid_arg xcell_args[] = {
		{"pix", 0, 2},
		{"pixname", 0, 2},
		{"fatfield", 0, 2},
		{"autofat", 0, 2},
		{"fatmin", 0, 2},
		{"fatmax", 0, 2},
		{"fatfix", 0, 2},
		{"fatrange", 0, 2},
		{"colfield", 0, 2},
		{"autocol", 0, 2},
		{"colmin", 0, 2},
		{"colmax", 0, 2},
		{"colfix", 0, 2},
		{"path", 0, 2},
		{"rootpath", 0, 2},
		{"fieldpath", 0, 2},
		{"labelmode", 0, 2},
		{"rooticon", 0, 2},
		/*
		{"iconscale", 0, 2},
		*/
		{"ox", 0, 2},
		{"oy", 0, 2},
		{"oz", 0, 2},
		{"hlhistmode", 0, 2},
		{"hldispmode", 0, 2},
		{"END", -1, -1}
	};

	if(debug > 1){
		ActionHeader("Xcell",element,action);
	}
	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}

	switch(action->type) {
		case PROCESS :
			update_pix(((struct xdraw_type *)(element->parent))->widget,
				(Pix *)(element->pix));
			break;
    	case CREATE: 
				XoCreateElmPix(element,
					((struct xdraw_type *)action->data)->widget,
					action->argc, action->argv, XoCreateCell);
			break;
    	case DELETE:
                drop_pix(Pathname(element->parent),
                                ((Pix *)(element->pix))->name);
			break;
    	case SET:
			if (x_parse_set(action->argc, action->argv, 
				xcell_args))
			XoSetElmPix(element, action->argc, action->argv);
			break;
		case RESET:
			break;
		case	COPY:
			genesis_no_copy();
			return(0);
		default:
			InvalidAction("Xcell",element,action);
			break;
	}
	return(1);
}

xcell_update(argc,argv)
	int	argc;
	char	**argv;
{

}
