/* --------------------------------------------- */
/* The init routines for setting up draw widgets.
 *
 *	By Upi Bhalla
 */
/* --------------------------------------------- */

#include "draw_ext.h"
#include "LayoutP.h"


#define	DEFAULT_DRAW_WIDTH	30
#define DEFAULT_DRAW_HEIGHT	250
#define DRAW_TEXT_HEIGHT 30
#define DRAW_VERT_SPACE 5

#ifndef EPSILON
#define EPSILON		1.0e-60
#endif EPSILON

extern	Widget x_ntw_get();
Pix		*find_pix();
void SetDrawRange();
int execute_parent_script();

Widget init_3d_draw_w();

/* --------------------------------------------- */
/* The routine for setting up a plain draw window without scale dbuts
**
**	By Upi Bhalla
*/
/* --------------------------------------------- */

/*
**
** init_plain_draw routine
** sets up draw window using wid, ht, cx,cy and 2D ortho projection
**
*/
Widget
init_plain_draw_w(parent,name,title,script,x,y,width,height,vwid,vht,vcx,vcy,
		xt,yt,wt,ht,xw,yw,ww,hw,usercoord)
	Widget		parent;
	char		*name,*title,*script;
	Position	x,y;
	Dimension	width,height;
	float		vwid,vht,vcx,vcy;
	int		xt,yt,wt,ht,usercoord;
	char	*xw, *yw, *hw, *ww;
{
	Widget	w;

	w = init_3d_draw_w(parent,name,title,script,x,y,width,height,
			xt,yt,wt,ht,xw,yw,ww,hw,usercoord);

	return(w);
}


/* --------------------------------------------- */
/* The routine for setting up a plain draw window using 
** the new picture struct as a whole.
**
**	By Upi Bhalla
*/
/* --------------------------------------------- */

/*
**
** init_3d_draw routine
** sets up tree window using draw widget
**
*/
Widget
init_3d_draw_w(parent,name,title,script,x,y,width,height,
	xt, yt, wt, ht, xwidget, ywidget, wwidget, hwidget, usercoord)
	Widget		parent;
	char		*name,*title,*script;
	Position	x,y;
	Dimension	width,height;
	int	xt,yt,wt,ht, usercoord;
	char	*xwidget, *ywidget, *wwidget, *hwidget;
	
{
/* variable definitions valid only within procedure 'main' */
	static XtCallbackRec callback[2];
	Arg arg[25];
	int n,i,j;
	LayoutWidget	draw_form;
	Widget	draw_name,draw;
	DrawWidget	dw;
	Position	layout_x, layout_y;
	Dimension	layout_w, layout_h;

/* --------------------------------------------- */

	callback[0].callback = (XtCallbackProc)execute_parent_script;
	callback[0].closure = (caddr_t)script;
	n = 0;
	if (!usercoord) {
		if (height < 40) height = 250;
		XtSetArg(arg[n], XtNappend, TRUE); n++;
	} else {
		XtSetArg(arg[n], XtNlayout_x, x); n++;
		XtSetArg(arg[n], XtNlayout_y, y); n++;
		XtSetArg(arg[n], XtNlayout_w, width); n++;
		XtSetArg(arg[n], XtNlayout_h, height); n++;
		XtSetArg(arg[n], XtNlayout_wx, xwidget); n++;
		XtSetArg(arg[n], XtNlayout_wy, ywidget); n++;
		XtSetArg(arg[n], XtNlayout_ww, wwidget); n++;
		XtSetArg(arg[n], XtNlayout_wh, hwidget); n++;
		XtSetArg(arg[n], XtNxtype, xt); n++;
		XtSetArg(arg[n], XtNytype, yt); n++;
		XtSetArg(arg[n], XtNwidthtype, wt); n++;
		XtSetArg(arg[n], XtNheightype, ht); n++;
	}
		
	XtSetArg(arg[n], XtNx, 0); n++;
	XtSetArg(arg[n], XtNy, 0); n++;
	XtSetArg(arg[n], XtNwidth, width); n++;
	XtSetArg(arg[n], XtNheight, height); n++;
	XtSetArg(arg[n], XtNcallback, callback); n++;

	draw = XtCreateWidget("draw", drawWidgetClass,
		parent, arg, n);

	/* note: 	normal append, if it occured, will have a
	**		very small height.  Let's resize it... 
	n = 0;
	XtSetArg(arg[n], XtNlayout_h,  ); n++;
	if (!usercoord && height < 40) 
		XtSetArg(arg[n], XtNheight, 250); n++;
	*/
	XtSetValues(draw, arg, n);

	XtManageChild(draw);
	return((Widget)draw);
}

