/* --------------------------------------------- */
/* The init routine for setting up a image pix.
 *
 *	By Upi Bhalla Feb 1990.
 *  If this code does not work it is not my fault.
 *	You may hack this code if the acknowledgement
 *	remains intact.
 *	Parts of the code are taken from xgif, by
 *	John Bradley, University of Pennsylvania, who in turn got
 *	portions of code from Patrick J. Naughton.
 *
 */
/* --------------------------------------------- */

/* All the necessary include files */

#include "draw_ext.h"
#include "draw_funcs.h"
#include "Image.h"
#include "xodus_defs.h"

Boolean ImageSetHook();
void ImageGetHook();
static char	*GetImageValue();
static int CleanImageHl();
int	DrawImage();

/* --------------------------------------------- */

static XtResource ImageResources[] = {
    {XtNpixname, XtCPixname, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,name),
        XtRString, "image"
    },
    {XtNfilename, XtCFilename, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,filename),
        XtRString, "image.gif"
    },
    {XtNfileformat, XtCFileformat, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,fileformat),
        XtRString, "gif"
    },
    {XtNstoremode, XtCStoremode, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,storemode),
        XtRString, "mem"
    },
    {XtNrescaleable, XtCRescaleable, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,rescaleable),
        XtRString, "FALSE"
    },
    {XtNvalue, XtCValue, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,value),
        XtRString, "none"
    },
    {XtNox, XtCOx, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,ox),
        XtRString, "0.0000000000"
    },
    {XtNoy, XtCOy, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,oy),
        XtRString, "0.0000000000"
    },
    {XtNoz, XtCOz, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,oz),
        XtRString, "0.0000000000"
    },
    {XtNsrcx, XtCSrcx, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,srcx),
        XtRString, "10"
    },
    {XtNsrcy, XtCSrcy, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,srcy),
        XtRString, "10"
    },
    {XtNwx, XtCWx, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,wx),
        XtRString, "10"
    },
    {XtNwy, XtCWy, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,wy),
        XtRString, "10"
    },
    {XtNhlhistmode, XtCHlhistmode, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,hlhistmode),
        XtRString, "lastone"
    },
    {XtNhldispmode, XtCHldispmode, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,hldispmode),
        XtRString, "star"
    },
};

Pix *
XoCreateImage(parent,args,num_args)
	DrawWidget	parent;
	ArgList		args;
	Cardinal	num_args;
{
	ImagePix	*pix;
	Pix	*image,*icon;
	CoordRescale	*rescale;
	int			i;
	int			len;
	char		*fillstr();

	pix = (ImagePix *)calloc(1,sizeof(ImagePix));

    image = parent->draw.images;
    icon = parent->draw.icons;

	parent->draw.pixvalue = (char *) calloc(200,sizeof(char));

    XtGetSubresources(parent,pix,XtNimages,XtCPix,ImageResources,
        XtNumber(ImageResources),args,num_args);

    parent->draw.pixname = fillstr(pix->name);

	if ((len = strlen(pix->name )) > 5 && 
		strcmp(&(pix->name[len - 4]),"icon") == 0) {
	  	parent->draw.icons = (Pix *)pix;
    	pix->next = icon;
    	parent->draw.images = image;
	} else {
    	parent->draw.images = (Pix *)pix;
    	pix->next = image;
    	parent->draw.icons = icon;
	}

	SetHlHistMode(pix,pix->hlhistmode);
	SetHlDispMode(pix,pix->hldispmode);

    pix->resources = ImageResources;
    pix->num_resources = XtNumber(ImageResources);

    pix->update = (Update *) calloc(1,sizeof(Update));
    pix->update->func = DrawImage;

	pix->npts = 1;
	pix->pts = (XPoint *) calloc(2,sizeof(XPoint));

	pix->rescale = (Rescale *) calloc(1,sizeof(Rescale));
	pix->rescale->func = UsePt;
	pix->refresh_func = DrawImage;
    pix->set_hook = ImageSetHook;
    pix->get_hook = ImageGetHook;
	pix->hilight->get_value = GetImageValue;
	pix->hilight->hl_clean_disp = CleanImageHl;
	pix->color = "Black";

	return((Pix *)pix);
}


static Boolean ImageSetHook(parent,pix,argnames,nargs)
	DrawWidget	parent;
	ImagePix	*pix;
	char	**argnames;
	int		nargs;
{
	int		i;
	Boolean do_redraw = FALSE;
	Boolean do_rescale = FALSE;
	Pix		*icon;

	if (nargs == 0) 
		return(FALSE);

	for (i = 0 ; i < nargs ; i++) {
		if (strcmp(argnames[i],XtNfilename) == 0) {
			LoadImage(parent,pix);
			do_redraw = TRUE;
		} else if (strcmp(argnames[i],XtNfileformat) == 0) {
		} else if (strcmp(argnames[i],XtNstoremode) == 0) {
			SetStoreMode();
		} else if (strcmp(argnames[i],XtNrescaleable) == 0) {
		} else if (strcmp(argnames[i],XtNhlhistmode) == 0) {
			SetHlHistMode(pix,pix->hlhistmode);
		} else if (strcmp(argnames[i],XtNhldispmode) == 0) {
			SetHlDispMode(pix,pix->hldispmode);
		} else if (strcmp(argnames[i],XtNvalue) == 0) {
		} else if (strcmp(argnames[i],XtNox) == 0) {
			pix->rescale->offset.x = atof(pix->ox);
			do_redraw = TRUE;
		} else if (strcmp(argnames[i],XtNoy) == 0) {
			pix->rescale->offset.y = atof(pix->oy);
			do_redraw = TRUE;
		} else if (strcmp(argnames[i],XtNoz) == 0) {
			pix->rescale->offset.z = atof(pix->oz);
			do_redraw = TRUE;
		} else if (strcmp(argnames[i],XtNsrcx) == 0) {
			do_redraw = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNsrcy) == 0) {
			do_redraw = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNwx) == 0) {
			do_redraw = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNwy) == 0) {
			do_redraw = TRUE;
			do_rescale = TRUE;
		} else printf("Field '%s' not known\n",argnames[i]);
	}
	if (do_rescale)
		ImageRescale();
	if (do_redraw)
		return(TRUE);
	return(FALSE);
}

static void	ImageGetHook(pix,rl,args,nargs)
	ImagePix	*pix;
	XrmResourceList	rl;
	ArgList	args;
	Cardinal	nargs;
{
}

DrawImage(pict,pix)
	DrawPart	*pict;
	ImagePix	*pix;
{
	int dstx,dsty;

	dstx = pix->pts[0].x - atoi(pix->wx)/2;
	dsty = pix->pts[0].y - atoi(pix->wy)/2;

	if (pict->display && pict->d && pict->gc && pix->image)
		XPutImage(pict->display,pict->d,pict->gc,pix->image,
			atoi(pix->srcx),atoi(pix->srcy),dstx,dsty,
			atoi(pix->wx),atoi(pix->wy));
}

RescaleImage(pict,pix)
	DrawPart	*pict;
	ImagePix	*pix;
{
}

static char *
GetImageValue(pict,pix,index)
	DrawPart	*pict;
	ImagePix		*pix;
	int			index;
{
	char		*fillstr();

	if (pix->value)
		return(fillstr(pix->value));
	return(NULL);
}

static int CleanImageHl(pict,pix,index)
	DrawPart	*pict;
	ImagePix 	*pix;
	int			index;
{
	(pix->refresh_func)(pict,pix);
}

LoadImage(dw,pix)
	DrawWidget	dw;
	ImagePix	*pix;
{
	XImage	*UpiLoadGIF();

	int	screen;

	screen = XDefaultScreen(dw->draw.display);

	pix->image = UpiLoadGIF(pix->filename,dw->draw.display,	
		screen, XDefaultDepth(dw->draw.display,screen));
}

SetStoreMode()
{
}

ImageRescale()
{
}
