/* --------------------------------------------- */
/* The routine for setting the XODUS logo and colorscale
 *
 *	By Upi Bhalla
 */
/* --------------------------------------------- */

#include "X11_includes.h"
#include <X11/IntrinsicP.h>
#include <X11/LabelP.h>
#include "sim_ext.h"
#include "draw_wP.h"

int	HColorScaleFunc();

MakeLogo(argc,argv)
	int	argc;
	char **argv;

{
	add_pix(LOGONAME,"background",HColorScaleFunc,sizeof(Pix));
	MakeNameIcons();
	ArrangeLogo();
	RefreshDraw(LOGONAME);
}


int	HColorScaleFunc(pict,pix)
	DrawPart	*pict;
	Pix	*pix;
{
	Display		*display;
	Drawable	d = pict->d;
	GC			gc = pict->gc;
	Screen		*screen;
	int			ncells;
	unsigned	short	 w,h;
	float		cumx = 0.0,dx;
	short		x;
	int			i;

	display = pict->display;
	screen = XDefaultScreenOfDisplay(display);
	ncells = XCellsOfScreen(screen);
	h = pict->w->core.height;

	if (ncells > 256) ncells = 245 ;
	if (ncells < 10 ) {
		XSetForeground(display,gc,XBlackPixelOfScreen(screen));
		XFillRectangle(display,d,gc,0,0,pict->w->core.width,h);
	} else {
		dx = (float)(pict->w->core.width)/245.0;
	
		for ( i = 10 ; i < 256 ; i++ ) {
			XSetForeground(display,gc,i);
			x = (short)cumx;
			cumx += dx;
			w = (unsigned short)cumx - x;
			XFillRectangle(display,d,gc,x,0,w,h);
		}
		XSetForeground(display,gc,1);
	}
	return(1);
}

MakeNameIcons()
{
	Coord	coords[20];
	CoordRescale	*rescale;

	/*
	** the triangle icons : directions from compass
	*/
	rescale = (CoordRescale *) calloc(1,sizeof(CoordRescale));
	add_pix(LOGONAME,"swt.icon",FillPoly,sizeof(Pix));
	add_pix(LOGONAME,"nwt.icon",FillPoly,sizeof(Pix));
	add_pix(LOGONAME,"net.icon",FillPoly,sizeof(Pix));
	add_pix(LOGONAME,"set.icon",FillPoly,sizeof(Pix));
		
	add_pix(LOGONAME,"sqr.icon",FillRects,sizeof(Pix));
	add_pix(LOGONAME,"box.icon",FillRects,sizeof(Pix));

	/*
	** Positions are referenced from the right angle of the triangle 
	*/
	coords[0].x = 0; coords[0].y = 0; coords[0].z = 0;
	coords[1].x = 0; coords[1].y = 30; coords[0].z = 0;
	coords[2].x = 30; coords[2].y = 0; coords[0].z = 0;
	load_pix_coords(LOGONAME,"swt.icon",coords,3);

	coords[0].x = 0; coords[0].y = 0; coords[0].z = 0;
	coords[1].x = 0; coords[1].y = -30; coords[0].z = 0;
	coords[2].x = 30; coords[2].y = 0; coords[0].z = 0;
	load_pix_coords(LOGONAME,"nwt.icon",coords,3);

	coords[0].x = 0; coords[0].y = 0; coords[0].z = 0;
	coords[1].x = 0; coords[1].y = -30; coords[0].z = 0;
	coords[2].x = -30; coords[2].y = 0; coords[0].z = 0;
	load_pix_coords(LOGONAME,"net.icon",coords,3);

	coords[0].x = 0; coords[0].y = 0; coords[0].z = 0;
	coords[1].x = 0; coords[1].y = 30; coords[0].z = 0;
	coords[2].x = -30; coords[2].y = 0; coords[0].z = 0;
	load_pix_coords(LOGONAME,"set.icon",coords,3);

	coords[0].x = 0; coords[0].y = 0; coords[0].z = 0;
	coords[1].x = 40; coords[1].y = 40; coords[0].z = 0;
	load_pix_coords(LOGONAME,"sqr.icon",coords,2);

	coords[0].x = 0; coords[0].y = 0; coords[0].z = 0;
	coords[1].x = 70; coords[1].y = 20; coords[0].z = 0;
	load_pix_coords(LOGONAME,"box.icon",coords,2);
}

ArrangeLogo()
{
	Coord	coords[40];
	char	*labels[40];
	Pix		*icons[40];
	IconPix	*pix;
	Pix		*find_pix();
	int		i = 0;
	int		j;
	Pix		*set_icon = find_pix(LOGONAME,"set.icon");
	Pix		*swt_icon = find_pix(LOGONAME,"swt.icon");
	Pix		*net_icon = find_pix(LOGONAME,"net.icon");
	Pix		*nwt_icon = find_pix(LOGONAME,"nwt.icon");
	Pix		*sqr_icon = find_pix(LOGONAME,"sqr.icon");
	Pix		*box_icon = find_pix(LOGONAME,"box.icon");

	add_pix(LOGONAME,"logo",DrawIcons,sizeof(IconPix));

	/* The letter X */
	coords[i].x = 50; coords[i].y = 0; icons[i] = set_icon; i++;
	coords[i].x = 50; coords[i].y = 0; icons[i] = swt_icon; i++;

	coords[i].x = 0; coords[i].y = 50; icons[i] = nwt_icon; i++;
	coords[i].x = 0; coords[i].y = 50; icons[i] = swt_icon; i++;

	coords[i].x = 50; coords[i].y = 100; icons[i] = nwt_icon; i++;
	coords[i].x = 50; coords[i].y = 100; icons[i] = net_icon; i++;

	coords[i].x = 100; coords[i].y = 50; icons[i] = set_icon; i++;
	coords[i].x = 100; coords[i].y = 50; icons[i] = net_icon; i++;

	/* The letter O */
	coords[i].x = 100; coords[i].y = 0; icons[i] = swt_icon; i++;
	coords[i].x = 100; coords[i].y = 100; icons[i] = nwt_icon; i++;
	coords[i].x = 200; coords[i].y = 100; icons[i] = net_icon; i++;
	coords[i].x = 200; coords[i].y = 0; icons[i] = set_icon; i++;

	coords[i].x = 130; coords[i].y = 30; icons[i] = sqr_icon; i++;

	/* The letter D */
	coords[i].x = 300; coords[i].y = 100; icons[i] = net_icon; i++;
	coords[i].x = 300; coords[i].y = 0; icons[i] = set_icon; i++;

	coords[i].x = 230; coords[i].y = 30; icons[i] = sqr_icon; i++;

	/* The letter U */
	coords[i].x = 300; coords[i].y = 0; icons[i] = swt_icon; i++;
	coords[i].x = 400; coords[i].y = 0; icons[i] = set_icon; i++;

	coords[i].x = 330; coords[i].y = 30; icons[i] = sqr_icon; i++;
	coords[i].x = 330; coords[i].y = 60; icons[i] = sqr_icon; i++;

	/* The letter S */
	coords[i].x = 400; coords[i].y = 100; icons[i] = nwt_icon; i++;
	coords[i].x = 500; coords[i].y = 0; icons[i] = set_icon; i++;
	
	coords[i].x = 400; coords[i].y = 20; icons[i] = box_icon; i++;
	coords[i].x = 400; coords[i].y = 30; icons[i] = swt_icon; i++;
	
	coords[i].x = 430; coords[i].y = 60; icons[i] = box_icon; i++;
	coords[i].x = 500; coords[i].y = 70; icons[i] = net_icon; i++;

	for (j = 0 ; j < i ; j++)
		coords[i].z = 0.0;
	load_pix_coords(LOGONAME,"logo",coords,i);
	pix = (IconPix *)find_pix(LOGONAME,"logo");
	pix->icons = (Pix **) malloc(i * sizeof(Pix *));
	for (j = 0 ; j < i ; j++)
		pix->icons[j] = icons[j];
}
