#include "com_ext.h"
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#ifdef X11R3
#include <X11/Form.h>
#include <X11/Label.h>
#include <X11/AsciiText.h>
#else
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#define XAW_BC
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h>
#undef XAW_BC
#endif X11R3
#include <X11/Shell.h>
#include "LayoutP.h"
#include "color_ext.h"
#include	"dbut_w.h"
#include	"toggle_w.h"
#include	"button_w.h"
#include	"xodus_ext.h"
#include	"graph_w.h"
#include	"Image.h"

#define	DEFAULT_X	10
#define	DEFAULT_Y	10
#define	DEFAULT_WIDTH	20	
#define	DEFAULT_HEIGHT	20
extern	char	*genesis_copy_str();



/*
** x_dbut : dialog-button window where return is equivalent to a 
** button event
*/
Widget
x_dialog(form,dialogname,title,defstr,x,y,width,height, xt, yt, wt, ht,
		xw, yw, ww, hw, usercoord)
	char	*form,*dialogname,*title,*defstr;
	Position	x,y;
	Dimension	width,height;
	int	xt, yt, wt, ht;
	char	*xw, *yw, *ww, *hw;
	int	usercoord;
{
	Widget	parent,d_widget,x_ntw_get();
	Arg		arg[30];
	int		n;
	static XtCallbackRec	callback[2];

	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;

	parent = x_ntw_get(form);
	if (parent == NULL) {
		fprintf(stderr,"no widget named '%s' was found\n",form);
		return(0);
	}

	/*
	callback[0].callback = (XtCallbackProc)execute_button;
	callback[0].closure = (caddr_t)my_script;
	*/
	n = 0;
	if (!usercoord) {
		XtSetArg(arg[n], XtNappend, TRUE); n++;
	} else {
		XtSetArg(arg[n], XtNlayout_x, x); n++;
		XtSetArg(arg[n], XtNlayout_y, y); n++;
		XtSetArg(arg[n], XtNlayout_w, width); n++;
		XtSetArg(arg[n], XtNlayout_h, height); n++;
		XtSetArg(arg[n], XtNlayout_wx, g_copy(xw)); n++;
		XtSetArg(arg[n], XtNlayout_wy, g_copy(yw)); n++;
		XtSetArg(arg[n], XtNlayout_ww, g_copy(ww)); n++;
		XtSetArg(arg[n], XtNlayout_wh, g_copy(hw)); n++;
		XtSetArg(arg[n], XtNxtype, xt); n++;
		XtSetArg(arg[n], XtNytype, yt); n++;
		XtSetArg(arg[n], XtNwidthtype, wt); n++;
		XtSetArg(arg[n], XtNheightype, ht); n++;
	}
	XtSetArg(arg[n], XtNx,0); n++;
	XtSetArg(arg[n], XtNy,0); n++;
	XtSetArg(arg[n], XtNwidth, width); n++;
	XtSetArg(arg[n], XtNheight, height); n++;
	XtSetArg(arg[n], XtNbackground, dialog_background_color); n++;
	XtSetArg(arg[n], XtNforeground, dialog_foreground_color); n++;
	XtSetArg(arg[n], XtNlabel, title); n++;
	XtSetArg(arg[n], XtNresizable, TRUE); n++;
	XtSetArg(arg[n], XtNdefstring, defstr); n++;
	d_widget = XtCreateManagedWidget(dialogname,dbutWidgetClass,
		parent,arg,n);

	x_ntw_add(dialogname,d_widget);
	return((Widget)d_widget);
}

/*
** x_toggle : toggle widget setup
*/
Widget
x_toggle(form,togglename,title,x,y,width,height,xt,yt,wt,ht,
			xw, yw, ww, hw, usercoord)
	char	*form,*title,*togglename;
	Position	x,y;
	Dimension	width,height;
	int	xt, yt, wt, ht;
	char	*xw, *yw, *ww, *hw;
	int	usercoord;
{
	Widget	parent,toggle_w,x_ntw_get();
	LayoutWidget	help;
	Arg		arg[20];
	int		n;
	static XtCallbackRec	callback[2];

	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;

	parent = (Widget)x_ntw_get(form);
	if (parent == NULL) {
		fprintf(stderr,"no widget named '%s' was found\n",form);
		return(0);
	}


	n = 0;
	if (!usercoord) {
		XtSetArg(arg[n], XtNappend, TRUE); n++;
	} else {
		XtSetArg(arg[n], XtNlayout_x, x); n++;
		XtSetArg(arg[n], XtNlayout_y, y); n++;
		XtSetArg(arg[n], XtNlayout_w, width); n++;
		XtSetArg(arg[n], XtNlayout_h, height); n++;
		XtSetArg(arg[n], XtNlayout_wx, g_copy(xw)); n++;
		XtSetArg(arg[n], XtNlayout_wy, g_copy(yw)); n++;
		XtSetArg(arg[n], XtNlayout_ww, g_copy(ww)); n++;
		XtSetArg(arg[n], XtNlayout_wh, g_copy(hw)); n++;
		XtSetArg(arg[n], XtNxtype, xt); n++;
		XtSetArg(arg[n], XtNytype, yt); n++;
		XtSetArg(arg[n], XtNwidthtype, wt); n++;
		XtSetArg(arg[n], XtNheightype, ht); n++;
	}
	XtSetArg(arg[n], XtNx,DEFAULT_X); n++;
	XtSetArg(arg[n], XtNy,DEFAULT_Y); n++;
	XtSetArg(arg[n], XtNwidth,DEFAULT_WIDTH); n++;
	XtSetArg(arg[n], XtNheight,DEFAULT_HEIGHT); n++;
	
	XtSetArg(arg[n], XtNbackground, toggle_background_color); n++;
	XtSetArg(arg[n], XtNlabel, title); n++;
	

#ifdef X11R3
	toggle_w = XtCreateManagedWidget(togglename,toggleWidgetClass,
		parent,arg,n);
#else
	toggle_w = XtCreateManagedWidget(togglename,genesisToggleWidgetClass,
		parent,arg,n);
#endif X11R3
	x_ntw_add(togglename,toggle_w);
	return((Widget)toggle_w);
}

/*
** x_label : label widget setup
*/
Widget
x_label(form,labelname,title,x,y,width,height, xt,yt,wt,ht,xw, yw, ww, hw,usercoord)
	char	*form,*title, *labelname;
	Position	x, y;
	Dimension	width,height;
	int	xt,yt,wt,ht;
	char	*xw, *yw, *ww, *hw;
	int	usercoord;

{
	Widget	parent,label_w,x_ntw_get();
	Arg		arg[30];
	int		n;

	parent = x_ntw_get(form);
	if (parent == NULL) {
		fprintf(stderr,"no widget named '%s' was found\n",form);
		return(0);
	}

	n = 0;
	if (!usercoord) {
		XtSetArg(arg[n], XtNappend, TRUE); n++;
	} else {
		XtSetArg(arg[n], XtNlayout_x, x); n++;
		XtSetArg(arg[n], XtNlayout_y, y); n++;
		XtSetArg(arg[n], XtNlayout_w, width); n++;
		XtSetArg(arg[n], XtNlayout_h, height); n++;
		XtSetArg(arg[n], XtNlayout_wx, g_copy(xw)); n++;
		XtSetArg(arg[n], XtNlayout_wy, g_copy(yw)); n++;
		XtSetArg(arg[n], XtNlayout_ww, g_copy(ww)); n++;
		XtSetArg(arg[n], XtNlayout_wh, g_copy(hw)); n++;
		XtSetArg(arg[n], XtNxtype, xt); n++;
		XtSetArg(arg[n], XtNytype, yt); n++;
		XtSetArg(arg[n], XtNwidthtype, wt); n++;
		XtSetArg(arg[n], XtNheightype, ht); n++;
	}
	XtSetArg(arg[n], XtNx,DEFAULT_X); n++;
	XtSetArg(arg[n], XtNy,DEFAULT_Y); n++;
	XtSetArg(arg[n], XtNwidth,DEFAULT_WIDTH); n++;
	XtSetArg(arg[n], XtNheight,DEFAULT_HEIGHT); n++;
	XtSetArg(arg[n], XtNbackground, label_background_color); n++;
	XtSetArg(arg[n], XtNforeground, label_foreground_color); n++;
	XtSetArg(arg[n], XtNresizable, FALSE); n++;
	XtSetArg(arg[n], XtNlabel,title); n++;

	label_w = XtCreateManagedWidget(labelname,labelWidgetClass,
		parent,arg,n);
	x_ntw_add(labelname,label_w);
	return((Widget)label_w);
}


/*
** x_text : textfile  widget setup
*/
Widget
x_text(form,labelname,filename, title,x,y,width,height, xt,yt,wt,ht,xw, yw, ww, hw,usercoord)
	char	*form,*title, *filename, *labelname;
	Position	x, y;
	Dimension	width,height;
	int	xt,yt,wt,ht;
	char	*xw, *yw, *ww, *hw;
	int	usercoord;

{
	Widget	parent,outer_w,text_w,x_ntw_get();
	Arg		arg[30];
	int		n;
	/*
	static  XtTextSelectType TextNoSelect[] = {
		XtselectNull
	};
	*/
	static char XoTextTranslations[] = "\
		<Btn1Down>(2):		previous-page()\n\
		<Btn3Down>(2):		next-page()\n\
		<Btn1Down>:			scroll-one-line-down()\n\
		<Btn3Down>:			scroll-one-line-up()\n\
		Ctrl<Key>F:			next-page()\n\
		Ctrl<Key>B:			previous-page()\n\
		<Key>k:				scroll-one-line-up()\n\
		<Key>j:				scroll-one-line-down()\n\
		<Key>f:				next-page()\n\
		<Key>b:				previous-page()\n\
		<Key>a:				beginning-of-file()\n\
		<Key>z:				end-of-file()";
	XtTranslations			XoParsedTranslations;

	parent = x_ntw_get(form);
	if (parent == NULL) {
		fprintf(stderr,"no widget named '%s' was found\n",form);
		return(0);
	}
	XoParsedTranslations = XtParseTranslationTable(XoTextTranslations);

	n = 0;
	if (!usercoord) {
		XtSetArg(arg[n], XtNappend, TRUE); n++;
	} else {
		XtSetArg(arg[n], XtNlayout_x, x); n++;
		XtSetArg(arg[n], XtNlayout_y, y); n++;
		XtSetArg(arg[n], XtNlayout_w, width); n++;
		XtSetArg(arg[n], XtNlayout_h, height); n++;
		XtSetArg(arg[n], XtNlayout_wx, g_copy(xw)); n++;
		XtSetArg(arg[n], XtNlayout_wy, g_copy(yw)); n++;
		XtSetArg(arg[n], XtNlayout_ww, g_copy(ww)); n++;
		XtSetArg(arg[n], XtNlayout_wh, g_copy(hw)); n++;
		XtSetArg(arg[n], XtNxtype, xt); n++;
		XtSetArg(arg[n], XtNytype, yt); n++;
		XtSetArg(arg[n], XtNwidthtype, wt); n++;
		XtSetArg(arg[n], XtNheightype, ht); n++;
	}
	XtSetArg(arg[n], XtNx,DEFAULT_X); n++;
	XtSetArg(arg[n], XtNy,DEFAULT_Y); n++;
	XtSetArg(arg[n], XtNwidth,DEFAULT_WIDTH); n++;
	XtSetArg(arg[n], XtNheight,200); n++;
	XtSetArg(arg[n], XtNbackground, form_background_color); n++;
	XtSetArg(arg[n], XtNresizable, FALSE); n++;
	outer_w = (Widget)XtCreateManagedWidget("textform", 
		layoutWidgetClass, parent, arg, n);


	n = 0;
	XtSetArg(arg[n], XtNlayout_x, 0); n++;
	XtSetArg(arg[n], XtNlayout_y, 0); n++;
	XtSetArg(arg[n], XtNlayout_w, 100); n++;
	XtSetArg(arg[n], XtNlayout_h, 100); n++;
	XtSetArg(arg[n], XtNx,0); n++;
	XtSetArg(arg[n], XtNy,0); n++;
	XtSetArg(arg[n], XtNwidth,100); n++;
	XtSetArg(arg[n], XtNheight,100); n++;
	XtSetArg(arg[n], XtNwidthtype,LAYOUT_RELATIVE); n++;
	XtSetArg(arg[n], XtNheightype,LAYOUT_RELATIVE); n++;
	XtSetArg(arg[n], XtNresizable, FALSE); n++;
	XtSetArg(arg[n], XtNfile,filename); n++;
	XtSetArg(arg[n], XtNeditType, XttextRead); n++;
	/*
	XtSetArg(arg[n], XtNselectTypes,TextNoSelect); n++;
	*/
	XtSetArg(arg[n], XtNleftMargin,10); n++;
	XtSetArg(arg[n], XtNtranslations,XoParsedTranslations); n++;
#ifdef X11R3
	/*
	XtTextSetSource(text_w, XtTextGetSource(text_w), 0);
	*/

#else
	XtSetArg(arg[n], XtNtype, "file"); n++;
	XtSetArg(arg[n], XtNscrollVertical, XawtextScrollAlways); n++;
	XtSetArg(arg[n], XtNscrollHorizontal, XawtextScrollNever); n++;
	XtSetArg(arg[n], XtNresize, XtEtextResizeBoth); n++;
	/*
	XawTextSetSource(text_w, XawTextGetSource(text_w), 0);
	*/
#endif
  	text_w = (Widget) XtCreateManagedWidget("textFile", 
		asciiDiskWidgetClass,outer_w , arg, n);
	x_ntw_add(labelname,text_w);
	return((Widget)outer_w);
}





Widget
x_form(name, title, labelflag, x, y, width, height, usercoord)
	char	*name;
	char	*title;
	Position		x, y;
	Dimension		width, height;
	int	labelflag;
	int	usercoord;
{
	
	Widget	frame_widget;
	Widget	form_widget;
	Widget	button_widget;
	Widget	label_widget;
	Widget	d_widget;
	Arg		arg[20];
	int		n;
	XSizeHints	hints;
	XWMHints	wm_hints;


	n = 0;
	XtSetArg(arg[n], XtNallowShellResize, TRUE); n++;
	XtSetArg(arg[n], XtNx, x); n++;
	XtSetArg(arg[n], XtNy, y); n++;
	XtSetArg(arg[n], XtNwidth, width); n++;
	XtSetArg(arg[n], XtNheight, height); n++;
	XtSetArg(arg[n], XtNmappedWhenManaged, FALSE); n++;
	XtSetArg(arg[n], XtNbackground, form_background_color); n++;

	frame_widget = XtAppCreateShell(title, "genesis",
		 applicationShellWidgetClass, display, arg, n);
	x_add_toplevel(frame_widget);

	n = 0;
	XtSetArg(arg[n], XtNx, x); n++;
	XtSetArg(arg[n], XtNy, y); n++;
	XtSetArg(arg[n], XtNwidth, width); n++;
	XtSetArg(arg[n], XtNheight, height); n++;
	XtSetArg(arg[n], XtNbackground, form_background_color); n++;
	if (!usercoord)
		XtSetArg(arg[n], XtNappend, TRUE); n++;
	form_widget = XtCreateManagedWidget(name, layoutWidgetClass,
		 frame_widget, arg, n);

	if (labelflag) {
		n = 0;
		XtSetArg(arg[n], XtNx, (Position)(0.02 * (float)width)); n++;
		XtSetArg(arg[n], XtNy, (Position)(0.02 * (float)height)); n++;
		XtSetArg(arg[n], XtNwidth, (Dimension)(0.96 * (float)width)); 
			n++;
		XtSetArg(arg[n], XtNheight, 30); n++;

		XtSetArg(arg[n], XtNxtype, LAYOUT_RELATIVE); n++;
		XtSetArg(arg[n], XtNytype, LAYOUT_ABSOLUTE); n++;
		XtSetArg(arg[n], XtNwidthtype, LAYOUT_RELATIVE); n++;
		XtSetArg(arg[n], XtNheightype, LAYOUT_ABSOLUTE); n++;
		XtSetArg(arg[n], XtNlayout_x, 2); n++;
		XtSetArg(arg[n], XtNlayout_y, (Position)(0.02*(float)height));
			 n++;
		XtSetArg(arg[n], XtNlayout_w, 96); n++;
		XtSetArg(arg[n], XtNlayout_h, 30); n++;

		XtSetArg(arg[n], XtNlabel, title); n++;
		XtSetArg(arg[n], XtNbackground, form_title_background_color);
			 n++;

		label_widget = XtCreateManagedWidget(name, labelWidgetClass,
			 form_widget, arg, n);
	}
	XtRealizeWidget(frame_widget);
	XtRealizeWidget(form_widget);
	XtMapWidget(form_widget);
	if (labelflag)
		XtRealizeWidget(label_widget);
	XSetIconName(display, XtWindow(frame_widget), title);
	x_ntw_add(name, form_widget);
	hints.flags = USSize|USPosition;
        hints.x = x;
        hints.y = y;
        hints.width =  width;
        hints.height = height;
        XSetSizeHints(display, XtWindow(frame_widget), &hints,
		XA_WM_NORMAL_HINTS);

	wm_hints.flags = InputHint;
	wm_hints.input = True;
	XSetWMHints(display, XtWindow(frame_widget), &wm_hints);
	return((Widget)form_widget);
}

/*
** x_button:	Reinstate a button within a form
**
*/
Widget
x_button(parent, name, title,x,y,width,height, xt,yt,wt,ht,
		xw, yw, ww, hw, usercoord)
	char	*parent; 
	char	*name;
	char	*title;
	Position	x, y;
	Dimension	width, height;
	int	xt, yt, wt, ht;
	char	*xw, *yw, *hw, *ww;
	int	usercoord;
{

	Arg	arg[20];
	int	n;
	Widget	new;
	Widget	parent_widget;

	parent_widget = x_ntw_get(parent);
	if (parent_widget == NULL) {
	fprintf(stderr,"no widget named '%s' was found\n", parent);
		return(0);
	}

	n = 0;
	if (!usercoord) {
		XtSetArg(arg[n], XtNappend, TRUE); n++;
	} else {
		XtSetArg(arg[n], XtNlayout_x, x); n++;
		XtSetArg(arg[n], XtNlayout_y, y); n++;
		XtSetArg(arg[n], XtNlayout_w, width); n++;
		XtSetArg(arg[n], XtNlayout_h, height); n++;
		XtSetArg(arg[n], XtNlayout_wx, g_copy(xw)); n++;
		XtSetArg(arg[n], XtNlayout_wy, g_copy(yw)); n++;
		XtSetArg(arg[n], XtNlayout_ww, g_copy(ww)); n++;
		XtSetArg(arg[n], XtNlayout_wh, g_copy(hw)); n++;
		XtSetArg(arg[n], XtNxtype, xt); n++;
		XtSetArg(arg[n], XtNytype, yt); n++;
		XtSetArg(arg[n], XtNwidthtype, wt); n++;
		XtSetArg(arg[n], XtNheightype, ht); n++;
	}
	XtSetArg(arg[n], XtNx, DEFAULT_X); n++;
	XtSetArg(arg[n], XtNy, DEFAULT_Y); n++;
	XtSetArg(arg[n], XtNwidth, DEFAULT_WIDTH); n++;
	XtSetArg(arg[n], XtNheight, DEFAULT_HEIGHT); n++;

	XtSetArg(arg[n], XtNbackground, xbutton_up_bg); n++;
	XtSetArg(arg[n], XtNresizable, FALSE); n++;
	XtSetArg(arg[n], XtNlabel, title); n++;
	new = XtCreateManagedWidget
		(name, buttonWidgetClass, parent_widget, arg, n);
	/*
	XtAddCallback(new, XtNcallback, execute_button, (char *)
		script);
	*/

	x_ntw_add(name,new);
	return((Widget)new);
}

Widget
x_axis_graph(form,name,title,x,y,width,height,xmin,ymin,xmax,ymax, xt,yt,wt,ht,
		xw, yw, ww, hw, usercoord)
	char	*form;
	char	*name;
	char	*title;
	Position	x, y;
	Dimension	width,height;
	float	xmax,ymax,xmin,ymin;
	int	xt, yt, wt, ht;
	char	*xw, *yw, *ww, *hw;
	int	usercoord;
{
	GraphWidget	 ag_widget;
	InnerGraphWidget		gw;
	LayoutWidget	parent;
	Arg		arg[30];
	char	*foo;
	char	*xmin_str, *ymin_str, *xmax_str, *ymax_str;
	char	string[30];
	int		n;

	parent = (LayoutWidget)x_ntw_get(form);
	if (parent == NULL) {
		fprintf(stderr,"no widget named '%s' was found\n",form);
		return(0);
	}

	n = 0;

	if (!usercoord) {
		XtSetArg(arg[n], XtNappend, TRUE); n++;
	} else {
		XtSetArg(arg[n], XtNlayout_x, x); n++;
		XtSetArg(arg[n], XtNlayout_y, y); n++;
		XtSetArg(arg[n], XtNlayout_w, width); n++;
		XtSetArg(arg[n], XtNlayout_h, height); n++;
		XtSetArg(arg[n], XtNlayout_wx, (char *)g_copy(xw)); n++;
		XtSetArg(arg[n], XtNlayout_wy, (char *)g_copy(yw)); n++;
		XtSetArg(arg[n], XtNlayout_ww, (char *)g_copy(ww)); n++;
		XtSetArg(arg[n], XtNlayout_wh, (char *)g_copy(hw)); n++;
		XtSetArg(arg[n], XtNxtype, xt); n++;
		XtSetArg(arg[n], XtNytype, yt); n++;
		XtSetArg(arg[n], XtNwidthtype, wt); n++;
		XtSetArg(arg[n], XtNheightype, ht); n++;
	}
	foo = (char *)g_copy(title);
	sprintf(string, "%f", xmin);
	xmin_str = (char *)g_copy(string);
	sprintf(string, "%f", xmax);
	xmax_str = (char *)g_copy(string);
	sprintf(string, "%f", ymin);
	ymin_str = (char *)g_copy(string);
	sprintf(string, "%f", ymax);
	ymax_str = (char *)g_copy(string);

	XtSetArg(arg[n], XtNx,DEFAULT_X); n++;
	XtSetArg(arg[n], XtNy,DEFAULT_Y); n++;
	XtSetArg(arg[n], XtNwidth, 400); n++;
	XtSetArg(arg[n], XtNheight, 400); n++;
	XtSetArg(arg[n], XtNbackground, graph_bg); n++;
	XtSetArg(arg[n], XtNxmin,xmin_str); n++;
	XtSetArg(arg[n], XtNymin,ymin_str); n++;
	XtSetArg(arg[n], XtNxmax,xmax_str); n++;
	XtSetArg(arg[n], XtNymax,ymax_str); n++;
	XtSetArg(arg[n], XtNtitle,foo); n++;
	ag_widget = (GraphWidget)XtCreateWidget(name,graphWidgetClass,
		parent,arg,n);


	gw = (InnerGraphWidget)XtNameToWidget(ag_widget, "internal_graph");
	if (gw == NULL) {
		fprintf(stderr,
			"x_axis_graph_kludge: no internal graph widget\n");
		return;
	}

	XtManageChild(parent);
	XtManageChildren(parent->composite.children, 
			parent->composite.num_children);
	XtResizeLayout(parent);
	x_ntw_add(name,ag_widget);
	return((Widget)ag_widget);
}

Widget
x_simple_graph(form,name,title,x,y,width,height,xmax,ymax,xmin,ymin,xt,yt,wt,
	ht,xw,yw,ww,hw,usercoord)
	char	*form;
	char	*name;
	char	*title;
	Position	x, y;
	Dimension	width,height;
	float	xmax,ymax,xmin,ymin;
	int	xt, yt, wt, ht;
	char	*xw, yw, ww, hw;
	int	usercoord;
{
	return((Widget)NULL);
}

/*
** x_image : image widget setup
*/
Widget
x_image(form,imagename,title,x,y,width,height,xt,yt,wt,ht,
			xw, yw, ww, hw, usercoord)
	char	*form,*title,*imagename;
	Position	x,y;
	Dimension	width,height;
	int	xt, yt, wt, ht;
	char	*xw, *yw, *ww, *hw;
	int	usercoord;
{
	Widget	parent,image_w,x_ntw_get();
	LayoutWidget	help;
	Arg		arg[20];
	int		n;
	static XtCallbackRec	callback[2];

	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;

	parent = (Widget)x_ntw_get(form);
	if (parent == NULL) {
		fprintf(stderr,"no widget named '%s' was found\n",form);
		return(0);
	}

	n = 0;
	if (!usercoord) {
		XtSetArg(arg[n], XtNappend, TRUE); n++;
	} else {
		XtSetArg(arg[n], XtNlayout_x, x); n++;
		XtSetArg(arg[n], XtNlayout_y, y); n++;
		XtSetArg(arg[n], XtNlayout_w, width); n++;
		XtSetArg(arg[n], XtNlayout_h, height); n++;
		XtSetArg(arg[n], XtNlayout_wx, g_copy(xw)); n++;
		XtSetArg(arg[n], XtNlayout_wy, g_copy(yw)); n++;
		XtSetArg(arg[n], XtNlayout_ww, g_copy(ww)); n++;
		XtSetArg(arg[n], XtNlayout_wh, g_copy(hw)); n++;
		XtSetArg(arg[n], XtNxtype, xt); n++;
		XtSetArg(arg[n], XtNytype, yt); n++;
		XtSetArg(arg[n], XtNwidthtype, wt); n++;
		XtSetArg(arg[n], XtNheightype, ht); n++;
	}
	XtSetArg(arg[n], XtNx,DEFAULT_X); n++;
	XtSetArg(arg[n], XtNy,DEFAULT_Y); n++;
	XtSetArg(arg[n], XtNwidth,DEFAULT_WIDTH); n++;
	XtSetArg(arg[n], XtNheight,height); n++;

#ifdef X11R3
	image_w = XtCreateManagedWidget(imagename,imageWidgetClass,
		parent,arg,n);
#else
	image_w = XtCreateManagedWidget(imagename,imageWidgetClass,
		parent,arg,n);
#endif X11R3
	x_ntw_add(imagename,image_w);
	return((Widget)image_w);
}

