#include <stdio.h>
#include <sys/wait.h>
#include <errno.h>

extern int errno;

/*
** proc.c
**
**	Handle process termination in a sane way.
*/


#define	FALSE	0
#define	TRUE	(!FALSE)

typedef struct _exit_node
  {
    int			en_status;
    int			en_pid;
    struct _exit_node	*en_next;
  } ExitNode;

static ExitNode	*ExitList = NULL;



#ifdef COMMENT
static ProcHandler(sig)

int	sig;

{	/* ProcHandler --- Handle process termination */

	ExitNode	*en;

	en = (ExitNode *) malloc(sizeof(ExitNode));
	if (en == NULL)
	  {
	    perror("Wait");
	    return(-1);
	  }

	en->en_pid = wait(&en->en_status);

	if (en->en_pid == -1)	/* no child or EINTR */
	    free(en);
	else
	  {
	    en->en_next = ExitList;
	    ExitList = en;
	  }

}	/* ProcHandler */
#endif


ProcInit()

{	/* ProcInit --- Set up to catch process termination signal */

	ExitList = NULL;

}	/* ProcInit */



CollectExitedProcs()

{	/* CollectExitedProcs --- Wait on any ZOMBIE procs */

	int		status;
	int		pid;
	ExitNode	*en;

	while ((pid = wait3(&status, WNOHANG, NULL)) > 0)
	  {
	    en = (ExitNode *) malloc(sizeof(ExitNode));
	    if (en == NULL)
	      {
	        perror("CollectExitedProcs");
	        return(-1);
	      }

	    en->en_pid = pid;
	    en->en_status = status;

	    en->en_next = ExitList;
	    ExitList = en;
	  }

}	/* CollectExitedProcs */



int ExitedProc(pid, status)

int	pid;
int	*status;

{	/* ExitedProc --- Return TRUE if process "pid" has exited */

	ExitNode	*cur;

	CollectExitedProcs();

	cur = ExitList;
	while (cur != NULL)
	  {
	    if (cur->en_pid == pid)
	      {
		if (status != NULL)
		    *status = cur->en_status;

		return(TRUE);
	      }

	    cur = cur->en_next;
	  }

	return(FALSE);

}	/* ExitedProc */



RmExitedProc(pid)

int	pid;

{	/* RmExitedProc --- Remove process "pid" from exited proc list */

	ExitNode	*cur, *prev;

	prev = NULL;
	cur = ExitList;
	while (cur != NULL)
	  {
	    if (cur->en_pid == pid)
	      {
		if (prev == NULL)
		    ExitList = cur->en_next;
		else
		    prev->en_next = cur->en_next;
		free(cur);

		break;
	      }

	    prev = cur;
	    cur = cur->en_next;
	  }

}	/* RmExitedProc */



#ifdef COMMENT
int Wait(status)

int	*status;

{	/* Wait --- wait for a terminated process */

	ExitNode	*en;

	en = (ExitNode *) malloc(sizeof(ExitNode));
	if (en == NULL)
	  {
	    perror("Wait");
	    return(-1);
	  }

	sighold(SIGCLD);
	
	en->en_pid = wait(&en->en_status);
	if (status != NULL)
	    *status = en->en_status;

	if (en->en_pid == -1)	/* no child or EINTR */
	    free(en);
	else
	  {
	    en->en_next = ExitList;
	    ExitList = en;
	  }
	sigrelse(SIGCLD);

1	return(en->en_pid);

}	/* Wait */
#endif



int WaitOn(pid, status)

int	pid;
int	*status;

{	/* WaitOn --- Atomic wait and check for process termination */

	while (pid > 0 && !ExitedProc(pid, status))
	    sleep(1);
	RmExitedProc(pid);

	return(pid);

}	/* WaitOn */
