#include "shell_ext.h"

static char 	default_prompt[80];
static int 	command_cnt = 0;
static char	prompt_str[100];

void do_set_prompt(argc,argv)
int argc;
char **argv;
{
    if(argc > 1)
	SetPrompt(argv[1]);
}

DefaultPrompt()
{
    strcpy(prompt_str,default_prompt);
}

SetDefaultPrompt(s)
char *s;
{
    if(s == NULL) return;
	strcpy(default_prompt,s);
}

SetPrompt(s)
char *s;
{
    if(s == NULL) return;
	strcpy(prompt_str,s);
}

inc_prompt() { 
    if(IsHistoryEnabled())
	command_cnt++; 
}

static char alternate_prompt_str[100];
static int alternate_prompt = 0;
AlternatePrompt(str)
char *str;
{
    if(str){
	alternate_prompt = 1;
	strcpy(alternate_prompt_str,str);
    } else {
	alternate_prompt = 0;
    }
}

show_prompt() { 
int 	i;
char 	string[100];
char	tmp[20];
char 	*numstr;
extern 	char *strchr();
extern 	char *itoa();

#ifdef NEW
    if(NestedLevel()){
	lprintf("? ");
	return;
    } else 
    if(alternate_prompt){
	lprintf("%s ",alternate_prompt_str);
	return;
    }
#else
    if(alternate_prompt){
	lprintf("%s ",alternate_prompt_str);
	return;
    }
#endif
    strcpy(string,prompt_str);
    if((numstr = strchr(string,'!')) != NULL){
	/*
	** substitute the command count for the !
	*/
	*numstr = '\0';
	sprintf(tmp,"%d",command_cnt);
	strcat(string,tmp);
	strcat(string,strchr(prompt_str,'!')+1);
    } 
    lprintf("%s >",string); 
    /*
    ** show the level of nesting
    */
#ifndef NEW
    for(i=0;i<NestingLevel();i++)
	lprintf(">");
#endif
    lprintf(" ");
}

