#include <stdio.h>
#include <math.h>
#include "header.h"

#define ARGV_RESIZE 10
#define ALPHA	1
#define SYMBOL	2

struct token_type {
    char 	*token;
    int		type;
};

char **NULLArgv()
{
char **argv;
    argv = (char **)malloc(sizeof(char *));
    argv[0] = NULL;
    return(argv);
}

char **CopyArgv(argc,argv)
int argc;
char **argv;
{
char **newargv;
int i;
int	length;

    if(argc == 0) return(NULL);
    newargv = (char **)calloc(argc +1,sizeof(char *));
    for(i=0;i<argc;i++){
	length = strlen(argv[i]);
	newargv[i] = (char *)malloc(length + 1);
	strcpy(newargv[i],argv[i]);
    }
    return(newargv);
}

void ReallocateArgList(argv,size)
char ***argv;
int *size;
{
char **new_argv;
int		new_size;
int		i;

    /*
    ** make the new list
    */
    new_size = *size + ARGV_RESIZE;
    new_argv = (char **)malloc(new_size*sizeof(char *));
    /*
    ** copy the old arguments
    */
    for(i=0;i<*size;i++){
	new_argv[i] = (*argv)[i];	
    }
    /*
    ** free the old list
    */
    free(*argv);
    /*
    ** set the pointers to the new list
    */
    *size = new_size;
    *argv = new_argv;
}

#ifdef NEW
void StringToArgList(string,argc,argv,expression_mode)
char 	*string;
int	*argc;
char 	***argv;
int	expression_mode;
{
char	**new_argv;
char	*sptr;
int	cnt;
short	string_on;
int	argv_size;
char	*arg_string;
int	length;
char	*begin;
int	mode;
char	*operator;
int	opsize;

    /*
    ** set up a pointer to the new string copy
    */
    sptr = string;
    /*
    ** keep track of the number of arguments in the list
    */
    cnt = 0;
    /*
    ** allocate the list
    */
    argv_size = ARGV_RESIZE;
    new_argv = (char **)malloc(argv_size*sizeof(char *));
    /*
    ** construct the argument list 
    */
    while(!IsStringEnd(*sptr)){
	/*
	* skip leading blanks
	*/
	string_on = 0;
	while(IsWhiteSpace(*sptr) || IsStringDelimiter(*sptr)){
	    if(IsStringDelimiter(*sptr)){
		string_on = 1;
		sptr++;
		break;
	    }
	    sptr++;
	}
	if(IsStringEnd(*sptr)){
	    break;
	}
	/*
	* point to the beginning of the arg
	*/
	new_argv[cnt] = sptr;
	/*
	* find the end of the arg
	*/
	length = 0;
	begin = sptr;
	while(!IsStringEnd(*sptr)){
	    if(!string_on){
		/*
		** break on white space
		*/
		if(IsWhiteSpace(*sptr)){
		    break;
		}
	    }
	    if(IsStringDelimiter(*sptr)){
		/*
		** end of the string delimiter
		*/
		string_on = 0;
		sptr++;
		break;
	    }
	    sptr++;
	    length++;
	}
	/*
	** copy the argument
	*/
	new_argv[cnt] = (char *)calloc(length+1,sizeof(char));
	bcopy(begin,new_argv[cnt],length);
	/*
	** increment the argument count
	** and check against the current size of the argv list
	**
	** if the argv list is too small then reallocate
	*/
	if(++cnt >= argv_size){
	    ReallocateArgList(&new_argv,&argv_size);
	}
    }
    new_argv[cnt] = NULL;
    *argc = cnt;
    *argv = new_argv;
}
#endif

char *ArgListToString(argc,argv)
int argc;
char **argv;
{
int	size;
char *string;
int	i;

    /*
    ** determine the size of the final string
    */
    size = 0;
    for(i = 0;i<argc;i++){
	size += strlen(argv[i]) + 1;
    }
    string = (char *)calloc(1,size+1);
    for(i = 0;i<argc;i++){
	strcat(string,argv[i]);
	strcat(string," ");
    }
    return(string);
}


#ifdef OLDTRACE
PTArgc(){}
char **PTArgv(){}
#endif

int do_argc()
{
    return(PTArgc());
}

#ifdef NEW
char **do_argv(argc,argv)
int argc;
char **argv;
{
char 	**list;
char	**PTArgv();

    if(argc > 1){
	list = PTArgv(atoi(argv[1]));
    } else {
	list = PTArgv(-1);
    }
    return(list);
}
#endif

