#include "hh_ext.h"

/* M.Wilson Caltech 2/89 */
VDepChannel(channel,action)
register struct vdep_channel_type *channel;
Action		*action;
{
double 	v;
double	astate,mstate;
MsgIn	*msg;

    if(debug > 1){
	ActionHeader("VDepChannel",channel,action);
    }

    SELECT_ACTION(action){
    case RESET:
	channel->Ik = 0;
	channel->Gk = 0;
	ClearElementFlag(channel,0);
	MSGLOOP(channel,msg) {
	case 2:				/* 2nd mult gate term */
	    SetElementFlag(channel,0);
	    break;
	}
    case PROCESS:
	/* channel->activation is used as the membrane potential */
	mstate = 1;
	astate = CheckElementFlag(channel,0);
	MSGLOOP(channel,msg) {
	case 0:				/* compartment */
	    /*
	    ** 0 = membrane potential
	    */
	    channel->activation = MSGVALUE(msg,0);
	    break;
	case 1:				/* multiplicative gate term */
	    /*
	    ** 0 = state
	    ** 1 = power
	    */
	    mstate *= pow(MSGVALUE(msg,0),MSGVALUE(msg,1));
	    break;
	case 2:				/* 2nd mult gate term */
	    /*
	    ** 0 = state
	    ** 1 = power
	    */
	    astate *= pow(MSGVALUE(msg,0),MSGVALUE(msg,1));
	    break;
	case 3:				/* gmax term */
	    channel->gbar = MSGVALUE(msg,0);
	    break;
	case 4:				/* Ek term */
	    channel->Ek = MSGVALUE(msg,0);
	    break;
	}
	channel->Gk = (mstate + astate)*channel->gbar;

	/* 
	** calculate the transmembrane current 
	*/
	channel->Ik = (channel->Ek - channel->activation) * channel->Gk;
	break;
    case CHECK:
	break;
    }
}
