#include "hh_ext.h" 

/*
** Evaluate steady-state value for HH state variable at v
*/

#define EXPONENTIAL  	1
#define SIGMOID		2
#define LINOID		3

/* M.Nelson Caltech 8/88 */
hh_evaluate(hh_state_var,v,
	  alphaFORM,alphaA,alphaB,alphaV0,
	  betaFORM,betaA,betaB,betaV0)
double *hh_state_var;
double v;

short alphaFORM;
float alphaA;
float alphaB;
float alphaV0;

short betaFORM;
float betaA;
float betaB;
float betaV0;

{
    double alpha,beta;

    if(debug > 1){
	printf("    hh_evaluate: alpha FORM = %d, A= %f B= %f V0 = %f\n",
	    alphaFORM,alphaA,alphaB,alphaV0);
	printf("    hh_evaluate:beta FORM = %d, A= %f B= %f V0 = %f\n",
	    betaFORM,betaA,betaB,betaV0);
    }

     switch(alphaFORM){
     case EXPONENTIAL:
	 alpha = alphaA*exp((v-alphaV0)/alphaB);
	 break;
     case SIGMOID:
	 alpha = alphaA/(exp((v-alphaV0)/alphaB)+1);
	 break;
     case LINOID:
	 if(v == alphaV0)
	     alpha = alphaA*alphaB;
	 else
	     alpha = alphaA*(v-alphaV0)/(exp((v-alphaV0)/alphaB)-1);
	 break;
    default:
	 printf("Warning - hh_update has no functional form for alpha\n");
	 break;
     }
     switch(betaFORM){
     case EXPONENTIAL:
	 beta = betaA*exp((v-betaV0)/betaB);
	 break;
     case SIGMOID:
	 beta = betaA/(exp((v-betaV0)/betaB)+1);
	 break;
     case LINOID:
	 if(v == betaV0)
	     beta = betaA*betaB;
	 else
	     beta = betaA*(v-betaV0)/(exp((v-betaV0)/betaB)-1);
	 break;
     Default:
	 break;
     }

    *hh_state_var = alpha/(alpha+beta);
}
