//genesis

float dt = 1.0e-4
float refresh_factor = 10.0

create xform /control [0,0,300,200]
create xbutton /control/quit -script "quit"
create xbutton /control/step -script "step"
create xbutton /control/stop -script "stop"
create xdialog /control/nstep -script "nstep <widget>" -value 100
create xbutton /control/RUN -script "autosweep /control/bar_vel(cells_per_step)"
create xdialog /control/current_time -script get_current_time \
	-value 0.000
create xdialog /control/dt_sec -script "setdt <widget>" -value 1.0e-4
create xdialog /control/refresh_every_n_steps \
	-script "setrefresh <widget>" -value 10
create xlabel /control/"Input pattern control"
create xdialog /control/"bar_vel(cells_per_step)" \
	-script "autosweep <widget>" -value 0.01
	// the autosweep script is in ret_input.g
create xdialog /control/bar_firing_rate -value 500.0

function get_current_time
	set /control/current_time value {status(-time)}
end

function nstep(widget)
str widget
	echo doing {get({widget},value)} steps
	step {get({widget},value)}
end

function setdt(widget)
str widget
	echo setting timesteps to {get({widget},value)} 
	dt = {get({widget},value)}
	setclock 0 {dt}	 //sec
	setclock 1 {dt * refresh_factor}  //sec : for the refresh views
end

function setrefresh(widget)
str widget
	echo setting refresh_factor to {get({widget},value)} 
	refresh_factor = {get({widget},value)}
	setclock 1 {dt * refresh_factor}  //sec : for the refresh views
end

create xtoggle /control/hide_xconn -script "showtoggle <widget> /conn"
set /control/hide_xconn state 1
create xtoggle /control/hide_xout -script "showtoggle  <widget> /xout"
set /control/hide_xout state 0
create xtoggle /control/hide_xtree -script "showtoggle  <widget> /tree"
set /control/hide_xtree state 1

function showtoggle(widget,form)
str widget
str form
	echo {widget} {form}
	if ({get({widget},state)} == 1)
		xhide {form}
	else
		xshow {form}
	end
end 
xshow /control

function do_refresh // for calling refreshes 
    xupdatepix /xout/draw3 vert
    xupdatepix /xout/draw3 horiz
    xupdatepix /xout/draw2 inputs
    get_current_time
    set /retina/recplane/rec[]/input state 0
end
