//genesis
// Creating lgn cells and arranging them in space.

float	LGN_SEPX = 80e-6
float	LGN_SEPY = 80e-6
float	LGN_SEPZ = 1e-3
float	LGN_NX = 5
float	LGN_NY = 5

create neutral /lgn

copy /library/compartment	/library/soma  
set /library/soma z 0 
	// Assigning exploded z coordinates for ease of display

ce /library/soma

// Creating the modules for the prototype lgn cell
copy /library/HH_Na_channel	/library/soma/HH_Na_channel  
set HH_Na_channel z {LGN_SEPZ * 1}

copy /library/HH_K_channel	/library/soma/HH_K_channel 
set HH_K_channel z {LGN_SEPZ  * 2}

copy /library/Na_channel	/library/soma/exc_syn  
set exc_syn z {LGN_SEPZ * 3}

copy /library/K_channel	/library/soma/inh_syn  
set inh_syn z {LGN_SEPZ * 4}

copy /library/spike	/library/soma/spike  
set spike z {LGN_SEPZ * -1}
set spike thresh 0
set spike abs_refract 10

create axon	/library/soma/axon
set axon z {LGN_SEPZ * -2}

ce /library/soma

// LINKING THE MODULES OF THE PROTOTYPE LGN CELL TOGETHER.
// link in the spike generating module
sendmsg . spike INPUT Vm

// link the spike generator to the axon
sendmsg spike axon BUFFER name

// link in HH_Na_channel
sendmsg HH_Na_channel . CHANNEL Gk Ek
sendmsg . HH_Na_channel VOLTAGE	Vm

// link in HH_K_channel
sendmsg HH_K_channel . CHANNEL Gk Ek
sendmsg . HH_K_channel VOLTAGE	Vm

// link in exc_syn
sendmsg exc_syn . CHANNEL Gk Ek
sendmsg . exc_syn VOLTAGE	Vm

// link in inh_syn
sendmsg inh_syn . CHANNEL Gk Ek
sendmsg . inh_syn VOLTAGE	Vm


// CREATING THE PLANE OF HORIZONTALLY SELECTIVE  LGN CELLS
createmap /library/soma /lgn/horiz \
	{LGN_NX} {LGN_NY} {LGN_SEPX} {LGN_SEPY} \
	{-LGN_NX * LGN_SEPX / 2} {-LGN_NY * LGN_SEPY / 2}

// Putting the horiz selective cells lower for ease of display
position /lgn/horiz 0 0 {-5 * LGN_SEPZ}

// CREATING THE PLANE OF VERTICALLY SELECTIVE  LGN CELLS
createmap /library/soma /lgn/vert \
	{LGN_NX} {LGN_NY} {LGN_SEPX} {LGN_SEPY} \
	{-LGN_NX * LGN_SEPX / 2} {-LGN_NY * LGN_SEPY / 2}

// Putting the vert selective cells higher for ease of display
position /lgn/vert 0 0 {5 * LGN_SEPZ}
