//genesis
// make_cable.g - routines to unlink compartments and insert a passive cable

function unlink_comp(comp1,comp2)
    str comp1, comp2
    int i, n, nmsg
// Delete incoming messages to comp1 from comp2
    nmsg=getmsg({comp1},IN,-count)
    for (i=0; i<nmsg; i=i+1)
        if(getmsg({comp1},IN,{i},src)=={comp2})
	    n=i
	    break
	else
	    n=-1
	end
    end
    if (n >= 0)
        deletemsg({comp1},IN,{n})
    end
// Now delete outgoing messages from comp1 to comp2
    nmsg=getmsg({comp1},OUT,-count)
    for (i=0; i<nmsg; i=i+1)
        if(getmsg({comp1},OUT,{i},dst)=={comp2})
	    n=i
	    break
	else
	    n=-1
	end
    end
    if (n >= 0)
        deletemsg({comp1},OUT,{n})
    end
end

function make_cable(nsects)
    int nsects, i
    makecompartment(/cell/cable[{0}],100e-4,2e-4,{Eleak})
    if(nsects>0)
      for (i=1; i<nsects; i=i+1)
        makecompartment(/cell/cable[{i}],100e-4,2e-4,{Eleak})
	link_compartment(/cell/cable[{i-1}],/cell/cable[{i}])
      end
    end
end

function add_cable
    int i, nsects       // number of cable sections after function call
// global variable:    int NCableSects = number of existing cable sections
// alternatively, use "return({NCableSects})" to pass it back via func name
    nsects=get(/output/control/cableform/nsections, value)
    if(nsects < 0)
        nsects=0
    end
    if(nsects != NCableSects) // otherwise, do nothing
        if(NCableSects > 0)   // delete the cable
	    for (i=0;i<NCableSects;i=i+1)
	        delete /cell/cable[{i}]  // also deletes messages to dend1,2
	    end
	else                  // if no cable, unlink dend2 and dend1
	    unlink_comp(/cell/dend2,/cell/dend1)
	end

	if(nsects > 0)
	    make_cable({nsects})
	    link_compartment(/cell/dend2,/cell/cable[0])
	    link_compartment(/cell/cable[{nsects-1}],/cell/dend1)
	else  // link dend2 and dend1 without intervening cable
	    link_compartment(/cell/dend2,/cell/dend1)
        end
        reset // simulator must be reset after altering connections
    end
    NCableSects=nsects
    xhide /output/control/cableform
    echo {nsects}" passive sections added between dendrite #2 and #1"
end
