//genesis
// cell.g
/* 
	functions defined in this script
=============================================================================
	FUNCTION NAME		ARGUMENTS
=============================================================================
	makeneuron		(path,soma_l,soma_d,dend_l,dend_d)
=============================================================================
*/

//=================================================
//                    NEURON
//=================================================
function makeneuron(path,soma_l,soma_d,dend_l,dend_d)
    str path
    float soma_l,soma_d
    float dend_l,dend_d

    float active_area = soma_l*PI*soma_d*1.0	// 100% of the soma active

    create 	neutral		{path}
    push {path}
    //=============================================
    //                   cell body
    //=============================================
    makecompartment(soma,{soma_l},{soma_d},{Eleak})
    position soma		I I R{-soma_l/2.0}

    //=============================================
    //          voltage dependent conductances
    //=============================================
    make_hhNa(soma,Ex_channel,{active_area},{ENa},{EREST})
    make_hhK(soma,Inh_channel,{active_area},{EK},{EREST})

    //=============================================
    //                   dendrites
    //=============================================
    makecompartment(dend1,{dend_l},{dend_d},{Eleak})
    link_compartment		dend1		soma
    makecompartment(dend2,{dend_l},{dend_d},{Eleak})
    link_compartment		dend2		dend1
    //=============================================
    //    synaptic conductances on the dendrites
    //=============================================
    makechannel(dend1,Ex_channel,{EEx},3.0,3.0,{GEx})
    makechannel(dend1,Inh_channel,{EInh},3.0,3.0,{GInh})
    makechannel(dend2,Ex_channel,{EEx},3.0,3.0,{GEx})
    makechannel(dend2,Inh_channel,{EInh},3.0,3.0,{GInh})

    //=============================================
    //                 spike detector
    //=============================================
    create	spike		spike
    set		spike	\
		thresh		0 \
		abs_refract	10 \
		output_amp	1
    /* use the soma membrane potential to drive the spike detector */
    sendmsg  	soma 		spike 		INPUT Vm

    //=============================================
    //                 output axon
    //=============================================
    create	axon		axon
    /* use the spike detector output to drive the axon */
    sendmsg	spike		axon		BUFFER name

    pop
end
