//genesis

float dt = 1.0e-5
float refresh_factor = 10.0
int i

function do_xcell_run_control
	for (i = 0 ; i < 10 ; i = i + 1)
		setclock {i} {dt}
	end
	setclock 9 {dt * refresh_factor}
	
	create xform /cell_run_control [0,30,430,800] \
		-title "CELL RUN CONTROL PANEL"
	ce ^ 
	disable .
	create xbutton stop [2%,45,20%,22] \
		-widgets [NULL,NULL,NULL,NULL] -script finish_run
	create xbutton reset [7,45,20%,22] \
		-widgets [stop.right,NULL,NULL,NULL] -script reset
	create xbutton run [7,45,20%,22] \
		-widgets [reset.right,NULL,NULL,NULL] \
		-script runsteps
	create xbutton "run paradigm" [7,45,10,22] \
		-widgets [run.right,NULL,NULL.right,NULL] \
		-script do_paradigm
	create xdialog nstep [2%,72,47%,30] \
		-widgets [NULL,NULL,NULL,NULL] \
		-script "nstep "<widget> -value 10000
	create xdialog "runtime (sec)" [7,72,10,30] \
		-widgets [nstep.right,NULL,NULL.right,NULL] \
		-script "runtime "<widget> -value 0.1
	
	/*
	** If we change the clock used by a script_out element to one with
	** another period, we can get commands executed different rates. 
	** Here, clock 1 starts up at 1/10 the simulation clock rate so
	** the script is executed every 10 timesteps 
	*/
	
	create script_out /output/refresh_out
	create disk_out /output/field_out
	disable /output/field_out
	create disk_out /output/plot_out
	disable /output/plot_out
	set /output/refresh_out command get_current_time
	useclock /output/refresh_out 9
	useclock /output/field_out 9
	useclock /output/plot_out 9

	create xlabel /cell_run_control/TIMING
	create xdialog current_time -script get_current_time -value 0.000
	create xdialog clock -value {dt} -script "setdt <widget> "
	create xdialog refresh_factor \
		-script "setrefresh <widget>" -value {refresh_factor}

	create xlabel "ELECTROPHYSIOLOGY"

	create xtoggle Recording [2%,4,15%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 
	create xtoggle Iclamp [18%,4,15%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 
	create xtoggle Vclamp [34%,4,15%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 
	create xtoggle "Syn act" [50%,4,15%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 
	create xtoggle "Syn spike" [66%,4,15%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 
	create xtoggle "Syn rand" [82%,4,17%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 

	create neutral /stimulus
	create random /stimulus/rand
		set ^ rate 100.0 \
			min_amp	1 \
			max_amp	1
	create axon /stimulus/axon
	sendmsg /stimulus/rand /stimulus/axon BUFFER name

	create xdialog "inject (nanoAmps)" -value 1.0 \
		-script "update_inject "<widget>
	create xdialog "Clamp voltage (mV)" [2%,29,96%,30] \ 
		-widgets [NULL,ELECTROPHYSIOLOGY.bottom,NULL,NULL] \
		-value 0 -script "set_vclamp "<widget>

	create xdialog "Spike rate for rand (Hz)" [2%,29,96%,30] \ 
		-widgets [NULL,ELECTROPHYSIOLOGY.bottom,NULL,NULL] \
		-value 100.0 -script "set_spike_rate "<widget>
	create neutral act_dummy
	create xdialog "Amount of synaptic activation" [2%,29,96%,30] \ 
		-widgets [NULL,ELECTROPHYSIOLOGY.bottom,NULL,NULL] \
		-value 1000.0 -script "set_act_dummy "<widget>
	create xdialog "Weight of spike" [2%,29,96%,30] \ 
		-widgets [NULL,ELECTROPHYSIOLOGY.bottom,NULL,NULL] \
		-value 0.1 -script "set_spike_wt "<widget>

	create xbutton "Remove all graph plots" -script remplot

	create xlabel "FILE IO"
	create xdialog filepath -value ../simlog
	create xdialog file_index -value 0

	create xtoggle save_run_info
		set ^ label1 "Save run info" label0 "Do Not Save run info"
	create xdialog info_file -value test
	create xdialog notes -value "This is just a test"

	create xtoggle save_plot
		set ^ label1 "Save Plots" label0 "Do Not Save Plots"
	create xdialog plot_file -value testplot

	create xtoggle save_field
		set ^ label1 "Save Field" label0 "Do Not Save Field"
	create xdialog field -value Vm
	create xdialog field_path -value {cellpath}/##[TYPE=compartment]
	create xdialog field_file -value testVm
end

function get_current_time
	set /cell_run_control/current_time value {status(-time)}
end

function nstep(widget)
str widget
	float nsteps = {get({widget},value)}
	set /cell_run_control/"runtime (sec)" value {nsteps * dt}
end

function runtime(widget)
str widget
	float runtime = {get({widget},value)}
	int nsteps

	nsteps = runtime / dt
	set /cell_run_control/nstep value {nsteps}
end

function setrefresh(widget)
str widget
	echo setting refresh_factor to {get({widget},value)} 
	refresh_factor = {get({widget},value)}
	setclock 9 {{getclock(0)} * refresh_factor}  //sec : for the refresh views
end

function showtoggle(widget,form)
str widget
str form
	echo {widget} {form}
	if ({get({widget},state)} == 1)
		xhide {form}
	else
		xshow {form}
	end
end 

function do_nothing // a dummy function
end

function setdt(widget)
str widget
str cell
int clockno

	dt = get({widget},value)
	echo setting {cell} timesteps to {dt}
	echo a reset may be necessary.
	setclock {clockno} {dt} // sec
	if (clockno == 0)
		setclock 9 {dt * refresh_factor} 
	end
end

function run_func
	source cellparms.g
end

/*
function run_para
	set dummy_para script {get(paradigm_file,value)}


	if (strcmp({get(paradigm_file,value)},"cellparms") == 0)
		cellparms
		return
	end
	if (strcmp({get(paradigm_file,value)},"para1") == 0)
		para1
		return
	end
	if (strcmp({get(paradigm_file,value)},"para2") == 0)
		para2
		return
	end
	// Default op is to step as many as specified
	nstep /cell_run_control/nstep
end
*/

str info_file
str plot_file
str field_file

function start_run
	push /cell_run_control

	info_file = {get(filepath,value)} + "/" + \
		{get(info_file,value)} + {get(file_index,value)}
	plot_file = {get(filepath,value)} + "/" + \
		{get(plot_file,value)} + {get(file_index,value)}
	field_file = {get(filepath,value)} + "/" + \
		{get(field_file,value)} + {get(file_index,value)}

	if ({get(save_run_info,state)} == 1)
		echo saving run info in {info_file}
		openfile {info_file} "a" 
		writefile {info_file}
		writefile {info_file} {date}
		/*
		writefile {info_file} paradigm : {get(paradigm_file,value)}
		*/
		writefile {info_file} Cell input res = {calc_Rm({cellpath}/soma)}
		writefile {info_file} Approx Cell cap = {calc_Cm({cellpath})}
		writefile {info_file} notes : {get(notes,value)}
		writefile {info_file}
    	if ({get(save_plot,state)} == 1)
        	writefile {info_file} storing plots in {plot_file}
    	end
	
    	if ({get(save_field,state)} == 1)
        	writefile {info_file} storing field '{get(field,value)}' in {field_file}
    	end
	end

	/* This makes the data go to a new file with the new header info.
	** It should overwrite existing files with the same name, so
	** beware ! */
	if ({get(save_plot,state)} == 1)
		enable /output/plot_out
		set /output/plot_out filename {plot_file} initialize 1
	end

	if ({get(save_field,state)} == 1)
		enable /output/field_out
		set /output/field_out filename {field_file} initialize 1
	end

	pop
end

function make_output_messages
	str name
	str field
	str src
	int nmsgs
	int	i

	push /cell_run_control
	if ({get(save_plot,state)} == 1)

		set /output/plot_out filename {plot_file} append 1 leave_open 1
		nmsgs = getmsg({cellpath}graph/graph,IN,-count)

		for ( i = 0 ; i < nmsgs ; i = i + 1)
			src = getmsg({cellpath}graph/graph,IN,{i},src)
			sendmsg {src} /output/plot_out SAVE Vm
		end
		// look at all messages going to the graph, and send them to
		// a file as well

		// openfile {plot_file} "a"
	end

	if ({get(save_field,state)} == 1)
		field = {get(field,value)}
		set /output/field_out filename {field_file} append 1 leave_open 1
		foreach name ({element_list({get(field_path,value)})})
			sendmsg {name} /output/field_out SAVE {field}
		end
	end
	pop
end

function finish_run
	push /cell_run_control

	stop

	if ({get(save_run_info,state)} == 1)
		closefile {info_file}
	end
	pop
	disable /output/field_out
	disable /output/plot_out
end

function clean_output_messages
	int nmsgs,i
	push /cell_run_control
	/* Getting rid of the messages */
	if ({get(save_plot,state)} == 1)
		nmsgs = getmsg(/output/plot_out,IN,-count)
		for ( i = 0 ; i < nmsgs ; i = i + 1)
			deletemsg /output/plot_out IN 0
		end
	end

	if ({get(save_field,state)} == 1)
		nmsgs = getmsg(/output/field_out,IN,-count)
		for ( i = 0 ; i < nmsgs ; i = i + 1)
			deletemsg /output/field_out IN 0
		end
	end
	pop
end

function whichsrcmsg(src,dest)
	str src,dest

	str name
	int nmsgs,i

	nmsgs = getmsg({src},OUT,-count)

	for ( i = 0 ; i < nmsgs ; i = i + 1)
		name = getmsg({src},OUT,{i},dst)
		if ({strcmp({name},{dest})} == 0)
			return({i})
		end
	end
	return(-1)
end
	
function do_transmitter(transmitter)
	str transmitter

	int nmsgs,i,msgno
	str dest = get({cellpath}xout/draw,value)
	str src
	str name 
	str iname
	str src
	str name
	float	act
	str widget = {cellpath} + "xout/draw"

	if (!{exists({dest})})
		echo Could not find compartment '{dest}', try clicking accurately
		return
	end

	nmsgs = getmsg({dest},IN,-count)

	for ( i = 0 ; i < nmsgs ; i = i + 1)
		src = getmsg({dest},IN,{i},src)
		name = get({src},name)
		if ({strcmp({name},{transmitter})} == 0)
			echo selected channel '{src}' 
			break
		end
	end
	name = get({src},name)
	if ({strcmp({name},{transmitter})} == 0)
		echo selected channel '{src}'
	else
		echo could not find channel named '{transmitter}' on '{dest}'
		return
	end

	iname = get({dest},name) + get({dest},index)

	push /cell_run_control
	if ({get("Syn spike",state)} == 0) // selected
		act = get("Weight of spike",value)
		set {src} X {act}
		echo delivering spike to '{src}' 
	end

	if ({get("Syn act",state)} == 0) // selected
		nmsgs = getmsg({src},IN,-count)
		for ( i = 0 ; i < nmsgs ; i = i + 1)
			name = getmsg({src},IN,{i},src)
			if ({strcmp({name},"/cell_run_control/act_dummy")} == 0)
			/* remove the preexisting activation message */
				echo deleting activation on {src}
				deletemsg {src} IN {i}
				delete {widget}/act{transmitter}{iname}
				pop
				return
			end
		end
		act = get("Amount of synaptic activation",value)
		set /cell_run_control/act_dummy z {act}
		echo setting activation on {src}
		sendmsg act_dummy {src} ACTIVATION z
		copy /xproto/draw/act{transmitter} \
			{widget}/act{transmitter}{iname}
		set {widget}/act{transmitter}{iname} \
			tx {get({dest},x)} ty {get({dest},y)} tz {get({dest},z)}
	end

	if ({get("Syn rand",state)} == 0) // selected
		if ({exists({widget}/rand{transmitter}{iname})})
			echo deleting random spike input to {src}
			delete_connection /stimulus/axon {src}
			delete {widget}/rand{transmitter}{iname}
			pop
			return
		end
		connect /stimulus/axon to {src} with synapse
		set /stimulus/axon:0 weight 1000
		copy /xproto/draw/rand{transmitter} \
			{widget}/rand{transmitter}{iname}
		set {widget}/rand{transmitter}{iname} \
			tx {get({dest},x)} ty {get({dest},y)} tz {get({dest},z)}
		echo delivering rand spikes to '{src}' 
	end
	pop
end

function do_dummy
end

int col = 15
function add_plot
	str newplot = get({cellpath}xout/draw,value)
	str name

	if (!{exists({newplot})})
		return
	end	

	name = {get({newplot},name)} + {get({newplot},index)}
	if ({exists({cellpath}xout/draw/Tr{name})})
		return
	end
	sendmsg {newplot} {cellpath}graph/graph PLOT Vm *{name} *hot{col}
	copy /xproto/draw/Trode {cellpath}xout/draw/Tr{name}
	set {cellpath}xout/draw/Tr{name} pixcolor "hot"{col} \
  		tx {get({newplot},x)} ty {get({newplot},y)} \
		tz {get({newplot},z)}
	col = col + 15
	if (col > 80)
		col = col - 70
	end
	echo adding plot for compartment '{newplot}'
end

function drop_plot
	int nmsgs,i
	str oldplot = get({cellpath}xout/draw,value)
	str src,name

	if (!{exists({oldplot})})
		return
	end	

	nmsgs = getmsg({cellpath}graph/graph,IN,-count)

	for ( i = 0 ; i < nmsgs ; i = i + 1)
		src = getmsg({cellpath}graph/graph,IN,{i},src)
		if (strcmp({src},{oldplot}) == 0)
			deletemsg({cellpath}graph/graph,IN,{i})
			i = i - 1
			nmsgs = nmsgs - 1
			name = {get({oldplot},name)} + {get({oldplot},index)}
			delete {cellpath}xout/draw/Tr{name}
		end
	end

	echo dropping plot for compartment '{oldplot}'
end

function set_spike_rate(widget)
	set /stimulus/rand rate {get({widget},value)}
end

function do_run_clickmode(widget)
	str widget

	str widgname = get({widget},name)

	ce /cell_run_control
	if ({get(Recording,state)} == 0)
		set Recording state 1
	end
	if ({get(Iclamp,state)} == 0)
		set Iclamp state 1
	end
	if ({get(Vclamp,state)} == 0)
		set Vclamp state 1
	end
	if ({get("Syn act",state)} == 0)
		set "Syn act" state 1
	end
	if ({get("Syn spike",state)} == 0)
		set "Syn spike" state 1
	end
	if ({get("Syn rand",state)} == 0)
		set "Syn rand" state 1
	end
	set {widget} state 0

	if (strcmp({widgname},"Recording") == 0)
		select_mouse({cellpath}xout/draw,add_plot,add_plot, \
			drop_plot,drop_plot,dummy,do_dummy)
		return
	end
	if (strcmp({widgname},"Iclamp") == 0)
		select_mouse({cellpath}xout/draw,inject,do_inject, \
			unject,clear_inject,dummy,do_dummy)
		xraise "inject (nanoAmps)"
		return
	end
	if (strcmp({widgname},"Vclamp") == 0)
		select_mouse({cellpath}xout/draw,Vclamp,do_vclamp, \
			unclamp,clear_vclamp,dummy,do_dummy)
		xraise "Clamp voltage (mV)"
		return
	end
	if (strcmp({widgname},"Syn act") == 0)
		select_mouse({cellpath}xout/draw,glu,"do_transmitter glu", \
			GABA,"do_transmitter GABA",ACh,"do_transmitter ACh")
		xraise "Amount of synaptic activation"
		return
	end
	if (strcmp({widgname},"Syn spike") == 0)
		xraise /cell_run_control/"Weight of spike"
		select_mouse({cellpath}xout/draw,glu,"do_transmitter glu", \
			GABA,"do_transmitter GABA",ACh,"do_transmitter ACh")
		return
	end
	if (strcmp({widgname},"Syn rand") == 0)
		xraise /cell_run_control/"Spike rate for rand (Hz)"
		select_mouse({cellpath}xout/draw,glu,"do_transmitter glu", \
			GABA,"do_transmitter GABA",ACh,"do_transmitter ACh")
		return
	end
end


function set_act_dummy(widget)
	str widget

	float act

	act = get({widget},value)
	set /cell_run_control/act_dummy z {act}
end

function cell_run_init
	xshow_on_top /cell_run_control
	xshow_on_top {cellpath}xout
	xshow_on_top {cellpath}graph
	set {cellpath}xout/draw/cell		colfield Vm \
							colmax 0.01 \
							colmin -0.1 \
							labelmode none

	set {cellpath}/##[TYPE=compartment] inject 0.0

	select_mouse({cellpath}xout/draw,inject,"do_inject {cellpath}xout/draw", \
		unject,"clear_inject {cellpath}xout/draw",dummy,do_dummy)
end

function cell_run_exit
	xhide /cell_run_control
	xhide {cellpath}xout
	xhide {cellpath}graph
end

function remplot
	int nmsgs,i
	str name

	stop
	nmsgs = getmsg({cellpath}graph/graph,IN,-count)

	for ( i = 0 ; i < nmsgs ; i = i + 1)
		deletemsg({cellpath}graph/graph,IN,0)
	end
	foreach name ({element_list({cellpath}xout/draw/##[TYPE=xshape])})
		delete {name}
		echo {name} in Tr
	end
	foreach name ({element_list({cellpath}##[TYPE=compartment])})
		set {name} inject 0.0
	end
	echo dropping all plots on graph
end

function update_inject(widget)
	str widget

	if ({strcmp({lastinjectsite},"none")} != 0)
		set {lastinjectsite} inject {get({widget},value) / 1e9}
	end
end

function set_vclamp(widget)
	str widget
	float temp = get({widget},value)
	str draww = {cellpath} + "xout/draw"
	str iname
	

	if ({strcmp({lastinjectsite},"none")} != 0)
		iname = get({lastinjectsite},name) + get({lastinjectsite},index)
		if ({exists({draww}/Vclamp{iname})})
			temp = temp/1e3
			set {draww}/Vclamp{iname}/Vclamp x {temp}
		end
	end
end

function runsteps
	echo doing {get(/cell_run_control/nstep,value)} steps
	start_run
	make_output_messages
	step {get(/cell_run_control/nstep,value)}
	finish_run
	clean_output_messages
	echo finished {get(/cell_run_control/nstep,value)} steps
end

