//genesis
/* 
	functions defined in this script
=============================================================================
	FUNCTION NAME		ARGUMENTS
=============================================================================
	makechannel		(compartment,channel,Ek,tau1,tau2,gmax)
	make_hhNa		(compartment,channel,activearea,ENa,Erest)
	make_hhK		(compartment,channel,activearea,EK,Erest)
=============================================================================
*/

// different forms for the HH rate coefficients 
int	EXPONENTIAL	=	1
int	SIGMOID		=	2
int	LINOID		=	3

//=================================================
//       BASIC TRANSMITTER ACTIVATED CHANNEL
//=================================================
function makechannel(compartment,channel,Ek,tau1,tau2,gmax)
    str compartment
    str channel
    float Ek				// mV
    float tau1,tau2			// msec
    float gmax				// mS

    create	channelC2		{compartment}/{channel}
    set		^ \
		Ek			{Ek} \	
		tau1			{tau1} \ 
		tau2			{tau2} \ 
		gmax			{gmax}
    link_channel2 	{compartment}/{channel} 	{compartment}
end

//=================================================
//                 HH NA CHANNEL
//=================================================
function make_hhNa(compartment,channel,activearea,ENa,Erest)
    str compartment
    str channel
    float activearea		// cm^2
    float ENa,Erest		// mV

    create	hh_channel	{compartment}/{channel}
    set	{compartment}/{channel} \
	    Ek 			{ENa} \			// mV
	    Gbar		{120.0*activearea} \	// mmhos/cm^2
	    Xpower		3.0 \
	    Ypower		1.0 \   
	    X_alpha_FORM	{LINOID} \
	    X_alpha_A		-0.1 \			// 1/mV-msec
	    X_alpha_B		-10.0 \			// mV
	    X_alpha_V0		{ 25.0 + Erest } \	// mV
	    X_beta_FORM		{EXPONENTIAL} \
	    X_beta_A		4.0 \			// 1/msec
	    X_beta_B		-18.0 \			// mV
	    X_beta_V0		{ 0.0 + Erest } \	// mV
	    Y_alpha_FORM	{EXPONENTIAL} \
	    Y_alpha_A		0.07 \			// 1/msec
	    Y_alpha_B		-20.0 \			// mV
	    Y_alpha_V0		{ 0.0 + Erest } \	// mV
	    Y_beta_FORM		{SIGMOID} \
	    Y_beta_A		1.0 \			// 1/msec
	    Y_beta_B		-10.0 \			// mV
	    Y_beta_V0		{ 30.0 + Erest } 	// mV
    link_channel2 	{compartment}/{channel}		{compartment} 
end

//=================================================
//                  HH K CHANNEL
//=================================================
function make_hhK(compartment,channel,activearea,EK,Erest)
    str compartment
    str channel
    float activearea
    float EK,Erest

    create	hh_channel	{compartment}/{channel}
    set		^ \
		Ek 		{EK} \			// mV
 		Gbar		{ 36.0 * activearea } \	// mmhos/cm^2 
		Xpower		4.0 \
		Ypower		0.0 \   
		X_alpha_FORM	{LINOID} \
		X_alpha_A	-0.01 \			// 1/mV-msec
		X_alpha_B	-10.0 \			// mV
		X_alpha_V0	{ 10.0 + Erest } \	// mV
		X_beta_FORM	{EXPONENTIAL} \
		X_beta_A	0.125 \			// 1/msec
		X_beta_B	-80.0 \			// mV
		X_beta_V0	{ 0.0 + Erest }  	// mV
    link_channel2 	{compartment}/{channel}		{compartment} 
end
