/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/rpc/sources/RCS/ui_rpcP.c,v $
  SHORTNAME      : ui_rpc
  SNNS VERSION   : 4.1

  PURPOSE        : 
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.7 $
  LAST CHANGE    : $Date: 1995/11/16 07:27:47 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#ifdef RPCSNNS
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <sys/types.h>

#include <netdb.h>
/*#include <dirent.h>*/
#include <malloc.h>

#include <string.h>		/* strcmp */
#include <sys/ioctl.h>		/* ioctl, TIOCNOTTY */
#include <sys/stat.h>		/* open */
#include <fcntl.h>		/* open */
#include <unistd.h>		/* getdtablesize */
#include <sys/socket.h>
#include <netinet/in.h>
#include <rpc/rpc.h>
#include <rpc/types.h>
#include <sys/errno.h>
#include <sys/param.h>		/* MAXHOSTNAMELEN */

#include "ui.h"

#include <X11/Shell.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Cardinals.h>

#include "kr_ui.h"
#include "kr_ui_rpc.h"
#include "kr_ui_rpc_main.h"
#include "ui_rpcsnns.h"

#include "ui_xWidgets.h"
#include "ui_confirmer.h"
#include "ui_main.h"
#include "ui_mainP.h"
#include "ui_fileP.h"
#include "ui_event.h"
#include "ui_control.h"
#include "ui_controlP.h"
#include "ui_display.h"
#include "ui_funcdispl.h"
#include "ui_rpc.h"
#include "ui_rpcsel.h"

#include "ui_rpcP.ph"

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/
char *ui_getDomainName(void)
{
    static char domain[MAXDOMAINDLEN+1];
    char *hp;
    if ( (hp = getenv("DOMAINNAME"))!= NULL){
	strncpy(&domain[0],hp,MAXDOMAINDLEN);
	return(&domain[0]);
    }
    if( getdomainname(domain,MAXDOMAINDLEN)==0){/* is used for Yellowpage */
	return(&domain[0]);
    }
    domain[0] = '.';
    domain[1] = '\0';
    return(&domain[0]);
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/
void
ui_BroadcastForServers(void)
{
    enum clnt_stat  clnt_stat;
    long min,max;
    long prog,vers;

    static par_get_kernel par;
    static char buf[127];

    gethostname(buf,127);
    strcat(&buf[0],".");
    strcat(&buf[0],ui_getDomainName());
    par.xguihost = &buf[0];
    par.xguipnumber = callbacknummer;
    par.xguiversion = SNNSUIVERS;
    par.xguiid = 0;
    par.uid = getuid();
    par.pid = getpid();

    prog = SNNSKERNELPROG;
    min  = SNNSKERNELVERS * 10000000 + (long) uid;
    max  = min + MAXKERNELS * 100000;
    for (vers = min ; vers <= max ; vers+=100000){
#ifdef DEBUG
	printf("Now Broadcasting Version %ld\n",vers);
#endif
	clnt_stat = kom_clnt_broadcast(prog, vers, GET_SNNS_KERNEL,
				       xdr_par_get_kernel, &par);
    }
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/
xgui_info * 
ui_register_new_kernel(register_info *r_info, struct svc_req *cl)
{  
    static xgui_info info;
    if (r_info->error == 0){
	info.kernelid = ui_AppendHost(r_info->host,r_info->domain,r_info->hostaddr,r_info->vers,r_info->pid,r_info->xguiid,(par_config *)&r_info->kernel_config);
	info.error = RPC_NO_ERROR;
    }else{
	/*Error*/
	info.error = RPC_UNKNOWN_ERROR;
     }

    return(&info);
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

int * ui_kernel_callback(callback_info *c_info, struct svc_req *cl)
{  
    static int res;
    int kernelnr;

    if( (kernelnr = ui_CheckKernelID(c_info->kernelid))==RPC_ID_NOT_REGISTERD){
	res = RPC_ID_NOT_REGISTERD;
	return(&res);
    }
    switch(c_info->callbackType){
      case LEARNINFO:
	if ( host[kernelnr].kernel_config->lastEpoch < host[kernelnr].kernel_config->epochsToLearn){
	    host[kernelnr].kernel_config->lastEpoch = c_info->lastEpoch;
	    host[kernelnr].kernel_config->lastLearnError = c_info->lastLearnError;
	}
	if ( host[kernelnr].kernel_config->lastEpoch 
	    == host[kernelnr].kernel_config->epochsToLearn){
	    /* Kernel has finished learning */ 
	    host[kernelnr].kernel_config->lastEpoch = c_info->lastEpoch;
	    host[kernelnr].kernel_config->lastLearnError = c_info->lastLearnError;
	    host[kernelnr].kernel_config->epochsToLearn = 0;
	    host[kernelnr].kernel_config->status = S_IDLE;
	}
	memcpy(host[kernelnr].kernel_config ,&c_info->kernel_config,sizeof(par_config2));
	ui_RPCchangeListEntry(kernelnr);
	ui_MakeHostList();
	res = RPC_NO_ERROR;
	break;
      case PING:
	/* For Identification */
	res = getpid();
	break;
    }
    return(&res);
}


/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/
int ui_CheckKernelID(int id)
{
    int i;
    for (i = 0; i < anzHostEntries; i++) {
	if ( host[i].kernelid  == id){
	    return(i);
	}
    }
    return(RPC_ID_NOT_REGISTERD);
}

/*****************************************************************************
  FUNCTION : ui_RPCCallGET_SNNS_KERNEL

  PURPOSE  :
  RETURNS  : int
  NOTES    :

  UPDATE   :
*****************************************************************************/
int 
ui_RPCCallGET_SNNS_KERNEL(struct sockaddr_in *addr,long vers,char *serv)
{   
    char *errstr;
    CLIENT *cl;
    int result;
    long svers;
    struct timeval oldtimeout,timeout;
    static par_get_kernel par;
    char            buf[127];

    /* Call Kernel */
#ifdef __linux__
    /* Linux do not have clnt_create_vers */
    cl = clnt_create(serv,SNNSKERNELPROG,vers,"udp");
#else
    cl = clnt_create_vers(serv,SNNSKERNELPROG,&svers,vers,vers,"udp");
#endif
    if (cl == NULL) {
	/*
	 * Couldn't establish connection with server.
	 * Print error message and return.
	 */
	errstr = clnt_spcreateerror(serv);
	ui_tw_errorMessage(errstr);
	return(-1);
    }
    cl->cl_auth = authunix_create_default();

    gethostname(buf,127);
    strcat(&buf[0],".");
    strcat(&buf[0],ui_getDomainName());
    par.xguihost = &buf[0];
    par.xguipnumber = callbacknummer;
    par.xguiversion = SNNSUIVERS;
    par.xguiid = 0;
    par.uid = getuid();
    par.pid = getpid();

    /* No wait => asynchronos Call */
    timeout.tv_sec = 0;
    timeout.tv_usec = 0;
    clnt_control(cl,CLGET_TIMEOUT,&oldtimeout);
    clnt_control(cl,CLSET_TIMEOUT,&timeout);
    get_snns_kernel_40(&par , cl);
    clnt_control(cl,CLSET_TIMEOUT,&oldtimeout);

    auth_destroy(cl->cl_auth);
    clnt_destroy(cl);
    return(result);
}

/*****************************************************************************
  FUNCTION : ui_AppendServer

  PURPOSE  : Appends only new servernames at the server list 
  RETURNS  : error
  NOTES    :

  UPDATE   :
*****************************************************************************/
int
ui_AppendServer(char *serv)
{
    int             i;
    bool_t          notinlist;

   /* If not in List -> append */
    notinlist = TRUE;
    for (i = 0; i < anzEntries; i++) {
	if (strcmp(serv, server[i].hostname) == 0)
	    notinlist = FALSE;
    }
    if (notinlist) {
	server[anzEntries].hostname = (char *) calloc(1, strlen(serv) + 1);
	strcpy(server[anzEntries].hostname, serv);
	server[anzEntries].listentry = server[anzEntries].hostname;

	anzEntries++;
	ui_MakeServerList();
    }
    return (0);
}


/*****************************************************************************
  FUNCTION : ui_AppendHost

  PURPOSE  : Appends new hosts at the host list and check for the broadcast 
             range.
  RETURNS  : kernelid or error
  NOTES    :

  UPDATE   :
*****************************************************************************/ 
int
ui_AppendHost(char *serv,char *domain,char *addr,long kernelno,u_int pid,int xguiid, par_config *kernel_conf)
{
    char *err;
    int i;
    bool_t          notinlist;

    /* If not in List -> append */
    notinlist = TRUE;
    for (i = 0; i < anzHostEntries; i++) {
	if (   (strcmp(serv, host[i].hostname) == 0) 
	    && (host[i].kernelno == kernelno) ){
	    notinlist = FALSE;
	}
    }
    if (notinlist) {
	/* Create RPC-Handle */
	host[anzHostEntries].cl = clnt_create(addr, SNNSKERNELPROG , kernelno , "tcp");
	if (host[anzHostEntries].cl == NULL) {
	    /*
	     * Couldn't establish connection with server.
	     * Print error message and die.
	     */
	    err = clnt_spcreateerror(addr);
	    ui_tw_errorMessage(err);
	    return(RPCERROR);
	}
	host[anzHostEntries].cl->cl_auth = authunix_create_default();
	host[anzHostEntries].kernelno=kernelno; 
	host[anzHostEntries].kernelid=globalkernelid++; 
	host[anzHostEntries].xguiid=xguiid; 
	if( (host[anzHostEntries].hostname = (char *)strdup(serv)) == NULL){
	    /*error*/
	    ui_tw_errorMessage("Not enough Memory to create Hostentry");
	    auth_destroy(host[anzHostEntries].cl->cl_auth);
	    clnt_destroy(host[anzHostEntries].cl);
	    return(RPCERROR);
	};
	if( (host[anzHostEntries].domainname = (char *)strdup(domain)) == NULL){
	    /*error*/
	    ui_tw_errorMessage("Not enough Memory to create Hostentry");
	    free(host[anzHostEntries].hostname);
	    auth_destroy(host[anzHostEntries].cl->cl_auth);
	    clnt_destroy(host[anzHostEntries].cl);
	    return(RPCERROR);
	};
	host[anzHostEntries].kernel_config = ui_RPCcreateKernelConfigEntry();
	if(kernel_conf != NULL){
	    /* Use kernel_conf */
	    host[anzHostEntries].hasKernelConfig = TRUE;
	    memcpy(host[anzHostEntries].kernel_config,kernel_conf
		   ,sizeof(par_config));
	}
	strcpy(host[anzHostEntries].hostaddr, addr);
	host[anzHostEntries].listentry =(char *) calloc(1,MAX_HOST_PANEL_SHOW);
	ui_RPCmakeListEntry(anzHostEntries,host[anzHostEntries].listentry);
	host[anzHostEntries].hasKernelConfig = FALSE;
	host[anzHostEntries].pid=pid; 
	host[anzHostEntries].SubPatPanel=-1;
#ifdef DEBUG
	printf("New Kernel on %s ,PID %d added\n",
	       host[anzHostEntries].hostname,
	       host[anzHostEntries].pid);
#endif
	anzHostEntries++;
        coopModified = ui_checkCoopMaster();
	ui_MakeHostList();

	/* Check broadcast */
	if(kernelno < minbroadcast)
	    minbroadcast = kernelno;
	if(kernelno > maxbroadcast)
	    maxbroadcast = kernelno;

    }
    return (host[anzHostEntries-1].kernelid);
}
/*****************************************************************************
  FUNCTION : ui_getKernelConfig

  PURPOSE  :
  RETURNS  : 
  NOTES    :

  UPDATE   :
*****************************************************************************/
int 
ui_getKernelConfig(int hostNum)
{
    int i;
    par_config *res;
    int oldkernelMode = -1;
    
    if(hostNum >0 && !host[hostNum].hasKernelConfig){
	res = get_rpc_kernel_config_40(&i , host[hostNum].cl);
	host[hostNum].hasKernelConfig = TRUE;
	/* Save local changed kernelMode */
	if((host[hostNum].kernel_config->kernelMode == COOP_M_KERNEL)
	   ||(host[hostNum].kernel_config->kernelMode == COOP_S_KERNEL)){
	    oldkernelMode = host[hostNum].kernel_config->kernelMode;
	}
	memcpy(host[hostNum].kernel_config,res,sizeof(par_config));
	/* Reset local changed kernelMode */
	if((oldkernelMode == COOP_M_KERNEL)
	   ||(oldkernelMode == COOP_S_KERNEL)){
	    host[hostNum].kernel_config->kernelMode = oldkernelMode;
	    /* Save local changes */
	    ui_setKernelConfig(hostNum);
	}
    }
    return(RPC_NO_ERROR);
}
/*****************************************************************************
  FUNCTION : ui_setKernelConfig

  PURPOSE  : 
  RETURNS  : 
  NOTES    :

  UPDATE   :
*****************************************************************************/
int 
ui_setKernelConfig(int hostNum)
{
    if( !host[hostNum].hasKernelConfig){
	/* Only for safety (set for get) */
	host[hostNum].kernel_config = ui_RPCcreateKernelConfigEntry();
	host[hostNum].hasKernelConfig = TRUE;
    }
    /* Send Kernel the new Config */
    if(hostNum >0){
	set_rpc_kernel_config_40(host[hostNum].kernel_config, 
				 host[hostNum].cl);
    }
    return(RPC_NO_ERROR);
}

    
/*****************************************************************************
  FUNCTION : ui_DeleteHost

  PURPOSE  : Deletes a hosts at the host list and check for the broadcast 
             range.
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

 void
ui_DeleteHost(u_int pos)
{
    int n;
    Arg args[5];
    /* Free Memory */
    if(pos != 0){
	auth_destroy(host[pos].cl->cl_auth);
	clnt_destroy(host[pos].cl);
	free(host[pos].kernel_config);

	/* Delete from list */
	memcpy(&host[pos],&host[pos+1],(anzHostEntries-pos)*sizeof(hostentry));
	anzHostEntries--;
	aktlistpos=0;
	clienthandle = (CLIENT *)NULL;
	akthostname = NULL;
	ui_MakeHostList();
	if(ui_RPCPannelPoppedUp&& akthost == pos){
	    n = 0;
	    XtSetArg(args[n], XtNstring, NULL);n++;
	    XtSetValues(ui_hostname, args, n);
	}
    }
    ui_RPCsetSetupValues();
}

/*****************************************************************************
  FUNCTION : ui_MakeHostList

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

void
ui_MakeHostList(void)
{
    int             i;

    for (i = 0; i < anzHostEntries; i++) {
	ui_RPCchangeListEntry(i);
	/* The first 4 chars are free */
	sprintf(host[i].listentry,"%3d",i); 
	host[i].listentry[3] = ' '; /* delete /0 */
	hostnames[i] = host[i].listentry;
    }
    hostnames[i]=NULL;
    if(ui_RPCPannelPoppedUp){
      ui_xSetLabel(ui_RPCItemsDesc,itemsNames);
      XawListChange(RPCHostList, hostnames, 0, 0, True);
      if (aktlistpos >= 0 && aktlistpos < anzHostEntries)
	XawListHighlight(RPCHostList,aktlistpos);
    }
}

/*****************************************************************************
  FUNCTION : ui_MakeServerList

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

void
ui_MakeServerList(void)
{
    int             i;

    for (i = 0; i < anzEntries; i++) {
	servernames[i] = server[i].listentry;
    }
    servernames[i]=NULL;
    XawListChange(RPCServerList, servernames, 0, 0, True);
}

/*****************************************************************************
  FUNCTION : ui_MakeServerList

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/
int 
ui_RPCswitchtoHost(int Hostnum,bool saveConfig)
{
    Arg             args[5];
    Cardinal        n;
    static char     buf[MAX_HOST_PANEL_SHOW];
    int             oldHost,i,msg,switchto;
    res_send_kernel_msg *res;
    int             *atEpoch,noOfErrors;
    double          *learnErrors;
    struct timeval  timeoutshort = {TIMEOUTSHORT,0};

    /* Update old Values (NoOfPattern...) only if saveconfig*/
    if (saveConfig)
      ui_RPCchangeControlPanelValues(akthost,akthost,FALSE);
    oldHost = akthost;
    if (Hostnum >= 0 && Hostnum < anzHostEntries) {
	
	/* If kernelsalve switch to master */
	if (host[Hostnum].kernel_config->kernelMode == COOP_S_KERNEL){
	    /* exist a master ?? */
	    if(coopMaster > 0 && coopMaster <  anzHostEntries) {
		switchto = ui_confirmYes("Can't switch to slave! use Master?");
		if(switchto){
		    Hostnum = coopMaster;
		}else{
		    return (FALSE);
		}
	    }
	}
	
	akthost = Hostnum;
	if(ui_RPCPannelPoppedUp){
	    sprintf(buf,"%-16s %-9ld",host[Hostnum].hostname,
		    host[Hostnum].kernelno);
	    n = 0;
	    XtSetArg(args[n], XtNstring,buf );n++;
	    XtSetValues(ui_hostname, args, n);
	    aktlistpos = Hostnum;
	    XawListHighlight(RPCHostList,Hostnum);
	}
	if(oldHost != akthost){
	    if(akthost >0){
		msg = PING;
		clnt_control(host[akthost].cl,CLGET_TIMEOUT,&oldtimeout);
		clnt_control(host[akthost].cl,CLSET_TIMEOUT
		     ,&timeoutshort);
		res = send_kernel_msg_40(&msg,host[akthost].cl);
		clnt_control(host[akthost].cl,CLSET_TIMEOUT,&oldtimeout);
		if(res == NULL || res->return_value != RPC_NO_ERROR){
		    switchto = ui_confirmYes("The selected host is not responding.\nMake a switch to that host?");
		    if(!switchto){
			/*Reset to old host */
			akthost = oldHost;
			if(ui_RPCPannelPoppedUp){
			    sprintf(buf,"%-16s %-9ld",host[akthost].hostname,
				    host[akthost].kernelno);
			    n = 0;
			    XtSetArg(args[n], XtNstring,buf );n++;
			    XtSetValues(ui_hostname, args, n);
			    aktlistpos = Hostnum;
			    XawListHighlight(RPCHostList,Hostnum);
			}
			return(FALSE);
		    }
		}
	    }
	    clienthandle = host[akthost].cl;
	    akthostname = host[akthost].hostname;
	    ui_getKernelConfig(oldHost);
	    ui_getKernelConfig(akthost);
	    memcpy(&longtimeout,&host[akthost].kernel_config->timeoutlong,
		   sizeof(struct timeval));
	    if (Hostnum == 0){
		rpckernel = FALSE;
	    }else{
		rpckernel = TRUE;
		krui_stopTraining();
		host[akthost].kernel_config->status = S_IDLE;
		host[akthost].kernel_config->epochsToLearn = 0;
		if( krui_getNetworkErrorArray(&learnErrors
					      ,&atEpoch,&noOfErrors)
		   == RPC_NO_ERROR && noOfErrors > 0){
		    host[akthost].kernel_config->lastEpoch 
			= atEpoch[noOfErrors-1];
		    host[akthost].kernel_config->lastLearnError 
			= learnErrors[noOfErrors-1];
		}
		/* Check for Functiondisplays */
		msg = FALSE;
		for (i = 0; i < 6 ;i++){
		    if(FUNC_GRAPH_win_ex[i]==1){
                        XtDestroyWidget(XtParent(XtParent(displaywidget[i])));
			FUNC_GRAPH_win_ex[i] = 0;
			msg = TRUE;
		    }
		}
		if(msg)
		    ui_confirmOk("The functions can only be displayed local");
		/* Check for SubPatPanels */
		if (SubPatPanel >= 0) {
		    /* Delete the Sub Pattern Panel */
		    XtDestroyWidget(ui_popPattern);
		    SubPatPanel = -1;
		}
 

	    }
	    
	    ui_RPCchangeControlPanelValues(oldHost,akthost,saveConfig);
	    ui_RPCchangeControlPanel();
	    ui_RPCchangeListEntry(aktlistpos);
	    ui_MakeHostList();
	    if(saveConfig)
		ui_setKernelConfig(oldHost);
	    ui_sel_unselectAll(ui_set_displayPtr, UI_GLOBAL);
	    ui_sel_resetList();
	    ui_net_completeRefresh(ui_set_displayPtr, UI_GLOBAL);
	    ui_stat_displayStatus(ui_gridPosMouse);
	    ui_file_updateShellLabels();
	}
    }
    return(TRUE);
}

/*****************************************************************************
  FUNCTION : ui_RPCmakeListEntry

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/
char *
ui_RPCmakeListEntry(int Hostnum,char *listentry)
{
  int i;
  char *hp=&listentry[4];
  char *hp2=&itemsNames[4];
  char *status_str,*hp3;

#define STR_CASE(str) if((strcmp(itemsList[selectedShowItems[i]].name,str))==0)

  sprintf(itemsNames,"No.");
  itemsNames[3] = ' '; /*delete /0 */
  for (i = 0 ; selectedShowItems[i] != -1 
       ; i++,hp += strlen(hp),hp2 +=strlen(hp2)){
      sprintf(hp2,itemsList[selectedShowItems[i]].formattitle,itemsList[selectedShowItems[i]].name);
      STR_CASE("HOSTNAME"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].hostname);
	  continue;
      }
      STR_CASE("DOMAINNAME"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].domainname);
	  continue;
      }
      STR_CASE("HOSTADRESS"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].hostaddr);
	  continue;
      }
      STR_CASE("KERNELNO"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernelno);
	  continue;
      }
      STR_CASE("KERNELID"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernelid);
	  continue;
      }
      STR_CASE("K_TYPE"){
	  switch(host[Hostnum].kernel_config->kernelMode){
	    case NORMALKERNEL:
	      sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		      ,"NORMAL");
	      break;
	    case COOP_S_KERNEL:
	      sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		      ,"SLAVE");
	      break;
	    case COOP_M_KERNEL:
	      sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		      ,"MASTER");
	      break;
	    default:
	      sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		      ,"NORMAL");
	      break;
	  }
	  continue;
      }
      STR_CASE("STATUS"){
	  switch(host[Hostnum].kernel_config->status){
	    case S_IDLE:
	      status_str = str_idle;
	      break;
	    case S_LEARNING:
	      status_str = str_learning;
	      break;
	    default:
	      status_str = str_idle;
	      break;
	  }
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,status_str);
	  continue;
      }
      STR_CASE("CYCLES"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_numberOfCycles);
	  continue;
      }
      STR_CASE("EPOCH"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->lastEpoch);
	  continue;
      }
      STR_CASE("SSE"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->lastLearnError);
	  continue;
      }
      STR_CASE("MSE"){
	  if (host[Hostnum].kernel_config->noOfPatterns > 0)
	    sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		    ,host[Hostnum].kernel_config->lastLearnError/host[Hostnum].kernel_config->noOfPatterns);
	  else
	    sprintf(hp,itemsList[selectedShowItems[i]].formattitle,"NaN");
	  continue;
      }
      STR_CASE("SSE/o-units"){
	  if(host[Hostnum].kernel_config->noOfOutput > 0)
	    sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		    ,host[Hostnum].kernel_config->lastLearnError/host[Hostnum].kernel_config->noOfOutput);
	  else
	    sprintf(hp,itemsList[selectedShowItems[i]].formattitle,"NaN");
	  continue;
      }
      STR_CASE("NO. PATTERN"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->noOfPatterns);
	  continue;
      }
      STR_CASE("NO. UNITS"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->noOfUnits);
	  continue;
      }
      STR_CASE("NO. INPUT"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->noOfInput);
	  continue;
      }
      STR_CASE("NO. HIDDEN"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->noOfHidden);
	  continue;
      }
      STR_CASE("NO. OUTPUT"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->noOfOutput);
	  continue;
      }
      STR_CASE("NET NAME"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_filenameNET);
	  continue;
      }
      STR_CASE("PATTERN SET NAME 1"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->PATTERN_SET_FILE);
	  continue;
      }
      STR_CASE("PATTERN SET NAME 2"){
	  hp3 = &host[Hostnum].kernel_config->PATTERN_SET_FILE[0];
	  hp3 += strlen(hp3)+1;
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,hp3);
	  continue;
      }
      STR_CASE("PATTERN SET NAME 3"){
	  hp3 = &host[Hostnum].kernel_config->PATTERN_SET_FILE[0];
	  hp3 += strlen(hp3)+1;
	  hp3 += strlen(hp3)+1;
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,hp3);
	  continue;
      }
      STR_CASE("PATTERN SET NAME 4"){
	  hp3 = &host[Hostnum].kernel_config->PATTERN_SET_FILE[0];
	  hp3 += strlen(hp3)+1;
	  hp3 += strlen(hp3)+1;
	  hp3 += strlen(hp3)+1;
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,hp3);
	  continue;
      }
      STR_CASE("PATTERN SET NAME 5"){
	  hp3 = &host[Hostnum].kernel_config->PATTERN_SET_FILE[0];
	  hp3 += strlen(hp3)+1;
	  hp3 += strlen(hp3)+1;
	  hp3 += strlen(hp3)+1;
	  hp3 += strlen(hp3)+1;
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,hp3);
	  continue;
      }
      STR_CASE("LEARN 1"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_learnParameters[0]);
	  continue;
      }
      STR_CASE("LEARN 2"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_learnParameters[1]);
	  continue;
      }
      STR_CASE("LEARN 3"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_learnParameters[2]);
	  continue;
      }
      STR_CASE("LEARN 4"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_learnParameters[3]);
	  continue;
      }
      STR_CASE("LEARN 5"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_learnParameters[4]);
	  continue;
      }
      STR_CASE("UPDATE 1"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_updateParameters[0]);
	  continue;
      }
      STR_CASE("UPDATE 2"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_updateParameters[1]);
	  continue;
      }
      STR_CASE("UPDATE 3"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_updateParameters[2]);
	  continue;
      }
      STR_CASE("UPDATE 4"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_updateParameters[3]);
	  continue;
      }
      STR_CASE("UPDATE 5"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_updateParameters[4]);
	  continue;
      }
      STR_CASE("INIT 1"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_initParameters[0]);
	  continue;
      }
      STR_CASE("INIT 2"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_initParameters[1]);
	  continue;
      }
      STR_CASE("INIT 3"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_initParameters[2]);
	  continue;
      }
      STR_CASE("INIT 4"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_initParameters[3]);
	  continue;
      }
      STR_CASE("INIT 5"){
	  sprintf(hp,itemsList[selectedShowItems[i]].formatstr
		  ,host[Hostnum].kernel_config->ui_initParameters[4]);
	  continue;
      }
  }
  
  return(listentry);
}

/*****************************************************************************
  FUNCTION : ui_RPCchangeListEntry

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/
char *
ui_RPCchangeListEntry(int Hostnum)
{
    return(ui_RPCmakeListEntry(Hostnum,host[Hostnum].listentry));
}

/*****************************************************************************
  FUNCTION : ui_RPCchangeControlPanel

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/
void
ui_RPCchangeControlPanel(void)
{
    Arg                args[5];
    Cardinal           n;
    Widget      doneButton, form;
    Position           x, y;
    int x1, y1, width, height, border_width, depth, border;
    Window   rootWin;

    if (!ui_controlIsCreated) {
	return;
    }
    n = 0;
    XtSetArg(args[n], XtNx, &x); n++;
    XtSetArg(args[n], XtNy, &y); n++;
    XtSetArg(args[n], XtNborderWidth, &border); n++;
    XtGetValues(ui_popControl, args, n);
    XGetGeometry(ui_display, (*ui_popControl).core.window, &rootWin,
                 &x1, &y1, &width, &height, &border_width, &depth);
    
    /* Destroy old window */
    XtDestroyWidget(ui_popControl);
    
    /* Set geometry for new window */
    n = 0;
    XtSetArg(args[n], XtNx, x-x1-border_width-1); n++;
    XtSetArg(args[n], XtNy, y-y1-border_width-1); n++;

    /* ui_display_Control */
    ui_popControl = 
	XtCreatePopupShell("snns-control", transientShellWidgetClass, 
			   ui_toplevel,args, n);

    form =   
	XtCreateManagedWidget("form", formWidgetClass, ui_popControl, 
			      NULL, ZERO);
 
    ui_xCreateControlPanel(form); 
 
    doneButton = 
	ui_xCreateButtonItem("done", form, NULL, ui_controlPanel);
    XtAddCallback(doneButton, XtNcallback, (XtCallbackProc) ui_popupDone, (caddr_t) UI_POPUP_CONTROL);

    ui_controlMessageWidget =
	ui_xCreateLabelItem("message",form, 10*8, 
			    doneButton, ui_controlPanel); 
    ui_xSetResize(ui_controlMessageWidget, TRUE);
    ui_xSetLabel(ui_controlMessageWidget, "");

    XawFormDoLayout(form, True);
    ui_checkWindowPosition(ui_popControl);
    XtPopup(ui_popControl, XtGrabNone);
    ui_xDontResizeWidget(ui_popControl); 
    ui_file_updateShellLabels();
}
/*****************************************************************************
  FUNCTION : ui_RPCchangeControlPanelValues

  PURPOSE  :
  RETURNS  : void
  NOTES    : call ui_RPCchangeControlPanel() to make the changes apear in 
             the Control panel


  UPDATE   :
*****************************************************************************/
void
ui_RPCchangeControlPanelValues(int fromHost,int toHost, bool saveConfig)
{
    int i;
    char *hp;
    
    if( fromHost < 0 || toHost < 0)
	return;

    if(!host[fromHost].hasKernelConfig)
	ui_getKernelConfig(fromHost);
    if(!host[toHost].hasKernelConfig)
	ui_getKernelConfig(toHost);

    /* Save values */
    host[fromHost].kernel_config->ui_noOfCurrentPattern = ui_noOfCurrentPattern;
    host[fromHost].kernel_config->NO_OF_PATTERN_SETS = NO_OF_PATTERN_SETS;
    host[fromHost].kernel_config->CURR_PATTERN_SET = CURR_PATTERN_SET;
    for(i = 0 ,hp = &host[fromHost].kernel_config->PATTERN_SET_FILE[0]; 
	i < NO_OF_PATTERN_SETS ;hp+=(strlen(hp)+1),i++){
	strncpy(hp,PATTERN_SET_FILE[i],19);
	/* for safety */
	hp[((strlen(PATTERN_SET_FILE[i])+1)>20) ? 20 : (strlen(PATTERN_SET_FILE[i]))]='\0';
	free(PATTERN_SET_FILE[i]);
    }
    host[fromHost].kernel_config->ui_patternLoadMode = ui_patternLoadMode;
    host[fromHost].kernel_config->ui_numberOfStepsDone = ui_numberOfStepsDone;
    memcpy(host[fromHost].kernel_config->subIPatSize,subIPatSize,sizeof(int)*5);
    memcpy(host[fromHost].kernel_config->subIPatPos,subIPatPos,sizeof(int)*5);
    memcpy(host[fromHost].kernel_config->subIPatStep,subIPatStep,sizeof(int)*5);    
    memcpy(host[fromHost].kernel_config->subOPatSize,subOPatSize,sizeof(int)*5);
    memcpy(host[fromHost].kernel_config->subOPatPos,subOPatPos,sizeof(int)*5);
    memcpy(host[fromHost].kernel_config->subOPatStep,subOPatStep,sizeof(int)*5);

    memcpy(host[fromHost].kernel_config->ui_learnParameters,
	   ui_learnParameters,
	   sizeof(float)*UI_NO_LEARN_PARAMS+UI_NO_OF_CASCADE_PARAMS);
    memcpy(host[fromHost].kernel_config->ui_updateParameters,
	   ui_updateParameters,
	   sizeof(float)*UI_NO_UPDATE_PARAMS);
    memcpy(host[fromHost].kernel_config->ui_initParameters,
	   ui_initParameters,
	   sizeof(float)*UI_NO_INIT_PARAMS);
    host[fromHost].kernel_config->subIPatNo = subIPatNo;
    host[fromHost].kernel_config->subIPatDims = subIPatDims;
    host[fromHost].kernel_config->subOPatDims = subOPatDims;
    host[fromHost].kernel_config->ui_shuffleFlg = ui_shuffleFlg;
    strncpy(host[fromHost].kernel_config->ui_filenameNET ,
	   ui_filenameNET,MAX_NAME_LENGTH);
    strncpy(host[fromHost].kernel_config->ui_filenamePAT ,
	   ui_filenamePAT,MAX_NAME_LENGTH);
    strncpy(host[fromHost].kernel_config->ui_filenameRES , 
	   ui_filenameRES,MAX_NAME_LENGTH);
    strncpy(host[fromHost].kernel_config->ui_filenameCFG , 
	   ui_filenameCFG,MAX_NAME_LENGTH);
    strncpy(host[fromHost].kernel_config->ui_filenameTXT , 
	   ui_filenameTXT,MAX_NAME_LENGTH);

    /* Save values from open Control-panel */
    if(ui_controlIsCreated){
	for(i = 0 ; i < UI_NO_LEARN_PARAMS ; i++){
	    host[fromHost].kernel_config->ui_learnParameters[i] =
		ui_xFloatFromAsciiWidget(ui_learnParameterWidgets[i]);
	    host[fromHost].kernel_config->ui_updateParameters[i] =
		ui_xFloatFromAsciiWidget(ui_updateParameterWidgets[i]);
	    host[fromHost].kernel_config->ui_initParameters[i] =
		ui_xFloatFromAsciiWidget(ui_initParameterWidgets[i]);
	}
	host[fromHost].kernel_config->ui_numberOfCycles = 
	    ui_xIntFromAsciiWidget(ui_numberOfCyclesWidget);
	host[fromHost].kernel_config->ui_numberOfSteps = 
	    ui_xIntFromAsciiWidget(ui_numberOfStepsWidget);
    }
    host[fromHost].SubPatPanel = SubPatPanel;
    
    /* Save modified values */
    if(saveConfig)
	ui_setKernelConfig(fromHost);


    /* Restore values */
    ui_noOfCurrentPattern = host[toHost].kernel_config->ui_noOfCurrentPattern;
    NO_OF_PATTERN_SETS = host[toHost].kernel_config->NO_OF_PATTERN_SETS;
    CURR_PATTERN_SET = host[toHost].kernel_config->CURR_PATTERN_SET;
    /* for safety */
    for(i = 0 ; i < NO_OF_PAT_SETS ;PATTERN_SET_FILE[i] = NULL,i++);
    for(i = 0 ,hp = &host[toHost].kernel_config->PATTERN_SET_FILE[0] 
	; i < host[toHost].kernel_config->NO_OF_PATTERN_SETS
	; i++ , hp += (strlen(hp)+1) ){
	PATTERN_SET_FILE[i]=(char *)strdup(hp);
    }
    ui_patternLoadMode = host[toHost].kernel_config->ui_patternLoadMode;
    ui_numberOfStepsDone = host[toHost].kernel_config->ui_numberOfStepsDone;
    memcpy(subIPatSize,host[toHost].kernel_config->subIPatSize,sizeof(int)*5);
    memcpy(subIPatPos,host[toHost].kernel_config->subIPatPos,sizeof(int)*5);
    memcpy(subIPatStep,host[toHost].kernel_config->subIPatStep,sizeof(int)*5);    
    memcpy(subOPatSize,host[toHost].kernel_config->subOPatSize,sizeof(int)*5);
    memcpy(subOPatPos,host[toHost].kernel_config->subOPatPos,sizeof(int)*5);
    memcpy(subOPatStep,host[toHost].kernel_config->subOPatStep,sizeof(int)*5);
    memcpy(ui_learnParameters,
	   host[toHost].kernel_config->ui_learnParameters,
	   sizeof(float)*UI_NO_LEARN_PARAMS+UI_NO_OF_CASCADE_PARAMS);
    memcpy(ui_updateParameters,
	   host[toHost].kernel_config->ui_updateParameters,
	   sizeof(float)*UI_NO_UPDATE_PARAMS);
    memcpy(ui_initParameters,
	   host[toHost].kernel_config->ui_initParameters,
	   sizeof(float)*UI_NO_INIT_PARAMS);
    subIPatNo = host[toHost].kernel_config->subIPatNo;
    subIPatDims = host[toHost].kernel_config->subIPatDims;
    subOPatDims = host[toHost].kernel_config->subOPatDims;
    ui_shuffleFlg = host[toHost].kernel_config->ui_shuffleFlg;

    strncpy(ui_filenameNET , host[toHost].kernel_config->ui_filenameNET,
	    MAX_NAME_LENGTH);
    strncpy(ui_filenamePAT , host[toHost].kernel_config->ui_filenamePAT,
	    MAX_NAME_LENGTH);
    strncpy(ui_filenameRES , host[toHost].kernel_config->ui_filenameRES,
	    MAX_NAME_LENGTH);
    strncpy(ui_filenameCFG , host[toHost].kernel_config->ui_filenameCFG,
	    MAX_NAME_LENGTH);
    strncpy(ui_filenameTXT , host[toHost].kernel_config->ui_filenameTXT,
	    MAX_NAME_LENGTH);

    ui_numberOfCycles = host[toHost].kernel_config->ui_numberOfCycles;
    ui_numberOfSteps = host[toHost].kernel_config->ui_numberOfSteps;

    SubPatPanel = host[toHost].SubPatPanel;
    if(host[toHost].kernel_config->status == S_IDLE){
	/* Only ask idle kernels */
	host[toHost].kernel_config->noOfPatterns = 
	    (krui_getNoOfPatterns()>0) ? krui_getNoOfPatterns() : 0;
	host[toHost].kernel_config->noOfUnits = krui_getNoOfUnits();
	host[toHost].kernel_config->noOfInput = krui_getNoOfInputUnits();
	host[toHost].kernel_config->noOfOutput = krui_getNoOfOutputUnits();
	host[toHost].kernel_config->noOfHidden = 
	    krui_getNoOfTTypeUnits(HIDDEN);
    }

}
/*****************************************************************************
  FUNCTION : ui_RPCcreateKernelConfigEntry

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

par_config *
ui_RPCcreateKernelConfigEntry(void)
{
    int i;
    par_config *hp;

    if( (hp = (par_config *)calloc(1,sizeof(par_config)))== NULL)
	return((par_config *)NULL);
    

    /* The real values are created and saveed in the kernel */
    hp->kernelMode = NORMALKERNEL;
    hp->isUDP = FALSE;
    hp->timeout.tv_sec = 25;
    hp->timeout.tv_usec = 0;
    hp->timeoutlong.tv_sec = MAXWAITTIME;
    hp->timeoutlong.tv_usec = 0;
    hp->exittimeout= TIMEOUTVAL;
    hp->switchtolocalall = 5;
    hp->switchtolocalsingle = 10;
    hp->status = S_IDLE;
    hp->epochsToLearn = 0;
    hp->PATTERN_SET_FILE[0] = '\0';

    /* Set default values */
    hp->ui_patternLoadMode = OUTPUT_ACT;
    hp->ui_shuffleFlg = FALSE;
    for(i=0 ; i <= 5 ; i++){
	hp->subIPatSize[i] = 1;
	hp->subIPatPos[i]  = 1;
	hp->subIPatStep[i] = 1;
	hp->subOPatStep[i] = 1;
	hp->subOPatSize[i] = 1;
	hp->subOPatPos[i]  = 1;
    }
    for(i=0 ; i < 25 ; i++){
	hp->ui_learnParameters[i] = 0.0;
    }
    for(i=0 ; i < 5 ; i++){
	hp->ui_updateParameters[i] = 0.0;
	hp->ui_initParameters[i] = 0.0;
    }
    hp->ui_learnParameters[0] = 0.2;
    hp->ui_updateParameters[0] = 0.0;
    hp->ui_initParameters[0] = 1.0;
    hp->ui_initParameters[1] = -1.0;

    hp->ui_numberOfCycles = 1;
    hp->ui_numberOfSteps = 1;

    hp->noOfUnits = krui_getNoOfUnits();
    hp->noOfInput = krui_getNoOfInputUnits();
    hp->noOfOutput = krui_getNoOfOutputUnits();
    hp->noOfHidden = krui_getNoOfTTypeUnits(HIDDEN);
     return(hp);
}
/*****************************************************************************
  FUNCTION : ui_RPCsetSetupValues

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

void ui_RPCsetSetupValues(void)
{
    char buf[60];

    if ( !ui_RPCSetupIsCreated)
	return;
    if (aktlistpos <= 0 ){
	ui_xSetToggleState(ui_RPCUDPtoggle, FALSE);
	ui_xSetToggleState(ui_RPCTCPtoggle, FALSE);
	ui_xSetToggleState(ui_RPCNormalToggle, TRUE);
	sprintf(buf,"%d",0);
	ui_xSetString(ui_RPCtimeout_sec,buf);
	ui_xSetString(ui_RPCtimeoutlong_sec,buf);
	ui_xSetString(ui_RPCexittimeout_min,buf);
	return;
    }
    ui_getKernelConfig(aktlistpos);
    host[aktlistpos].hasKernelConfig = TRUE;
    ui_xSetToggleState(ui_RPCUDPtoggle, host[aktlistpos].kernel_config->isUDP);
    ui_xSetToggleState(ui_RPCTCPtoggle, !host[aktlistpos].kernel_config->isUDP);
    switch(host[aktlistpos].kernel_config->kernelMode){
      case NORMALKERNEL:
	ui_xSetToggleState(ui_RPCCoop_M_Toggle, FALSE);
	ui_xSetToggleState(ui_RPCNormalToggle, TRUE);
	break;
      case COOP_M_KERNEL:
	ui_xSetToggleState(ui_RPCNormalToggle, FALSE);
	ui_xSetToggleState(ui_RPCCoop_M_Toggle, TRUE);
	break;
      case COOP_S_KERNEL:
	ui_xSetToggleState(ui_RPCNormalToggle, FALSE);
	ui_xSetToggleState(ui_RPCCoop_M_Toggle, FALSE);
	break;
    }
    sprintf(buf,"%ld",host[aktlistpos].kernel_config->timeout.tv_sec);
    ui_xSetString(ui_RPCtimeout_sec,buf);
    sprintf(buf,"%ld",host[aktlistpos].kernel_config->timeoutlong.tv_sec);
    ui_xSetString(ui_RPCtimeoutlong_sec,buf);
    sprintf(buf,"%ld",host[aktlistpos].kernel_config->exittimeout);
    ui_xSetString(ui_RPCexittimeout_min,buf);
    sprintf(buf,"%ld",host[aktlistpos].kernel_config->switchtolocalall);
    ui_xSetString(ui_RPCswitchtolocalall,buf);
    sprintf(buf,"%ld",host[aktlistpos].kernel_config->switchtolocalsingle);
    ui_xSetString(ui_RPCswitchtolocalsingle,buf);
}
/*****************************************************************************
  FUNCTION : ui_RPCstoreSetupValues

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

void ui_RPCstoreSetupValues(void)
{
    CLIENT *cltmp;
    char *err;
    parallel_kernels par;
    int i;

    if ( !ui_RPCSetupIsCreated)
	return;
    if (aktlistpos <= 0){
	ui_tw_errorMessage("Can't change values for direct local");	
	return;
    }
    /* not allowed to change the values of the slaves */
    if (host[aktlistpos].kernel_config->kernelMode == COOP_S_KERNEL){
	ui_tw_errorMessage("Can't change slave direct! Use master instead");
	return;
    }
    if(host[aktlistpos].kernel_config->isUDP 
       != ui_xGetToggleState(ui_RPCUDPtoggle)){
	if( (host[aktlistpos].kernel_config->isUDP 
	     = ui_xGetToggleState(ui_RPCUDPtoggle))){
	    /* save old handle */
	    cltmp =host[aktlistpos].cl;
	    /* Create RPC-Handle */
	    host[aktlistpos].cl = clnt_create(host[aktlistpos].hostaddr,SNNSKERNELPROG,host[aktlistpos].kernelno,"udp");
	    if (host[aktlistpos].cl == NULL) {
		/*
		 * Couldn't establish connection with server.
		 * Print error message
		 */
		err = clnt_spcreateerror(host[aktlistpos].hostaddr);
		ui_tw_errorMessage(err);
		host[aktlistpos].cl = cltmp;
	    }else{
		host[aktlistpos].cl->cl_auth = authunix_create_default();
		auth_destroy(cltmp->cl_auth);
		clnt_destroy(cltmp);
	    }
	}else{
	    /* save old handle */
	    cltmp  =host[aktlistpos].cl;
	    /* Create RPC-Handle */
	    host[aktlistpos].cl = clnt_create(host[aktlistpos].hostaddr,SNNSKERNELPROG,host[aktlistpos].kernelno,"tcp");
	    if (host[aktlistpos].cl == NULL) {
		/*
		 * Couldn't establish connection with server.
		 * Print error message
		 */
		err = clnt_spcreateerror(host[aktlistpos].hostaddr);
		ui_tw_errorMessage(err);
		host[aktlistpos].cl = cltmp;
	    }else{
		host[aktlistpos].cl->cl_auth = authunix_create_default();
		auth_destroy(cltmp->cl_auth);
		clnt_destroy(cltmp);
	    }
	}
    }
    if (ui_xGetToggleState(ui_RPCNormalToggle))
	host[aktlistpos].kernel_config->kernelMode = NORMALKERNEL;
    
    /* Coop-master not supported in this release */
    if (ui_xGetToggleState(ui_RPCCoop_M_Toggle)){
	ui_tw_errorMessage("coop-master not supported in this release");

	host[aktlistpos].kernel_config->kernelMode = NORMALKERNEL;
    }
/*    if (ui_xGetToggleState(ui_RPCCoop_M_Toggle))
	coopModified = ui_setCoopMaster(aktlistpos);
    if(ui_checkCoopMaster() || coopModified){
	par.kernels.kernels_val = &coopKernels[0];
	par.kernels.kernels_len = anzCoopEntries;
	par.learnFunc = 0;
	par.noOfEpochs = 0;
	ui_broadCoopConfig(&par);
	coopModified = FALSE;
    }
*/
    host[aktlistpos].kernel_config->timeout.tv_sec = 
	ui_xIntFromAsciiWidget(ui_RPCtimeout_sec);
    host[aktlistpos].kernel_config->timeout.tv_usec = 0;
    host[aktlistpos].kernel_config->timeoutlong.tv_sec = 
	ui_xIntFromAsciiWidget(ui_RPCtimeoutlong_sec);
    host[aktlistpos].kernel_config->timeoutlong.tv_usec = 0;
    host[aktlistpos].kernel_config->exittimeout = 
	ui_xIntFromAsciiWidget(ui_RPCexittimeout_min);
    host[aktlistpos].kernel_config->switchtolocalall = 
	ui_xIntFromAsciiWidget(ui_RPCswitchtolocalall);
    host[aktlistpos].kernel_config->switchtolocalsingle = 
	ui_xIntFromAsciiWidget(ui_RPCswitchtolocalsingle);
    /* Set Timeout */
    clnt_control(host[aktlistpos].cl,CLSET_TIMEOUT,
		 &host[aktlistpos].kernel_config->timeout);

    /* Set clienthandel to new handle */
    if(aktlistpos == akthost){
	clienthandle = host[akthost].cl;
	memcpy(&longtimeout,&host[akthost].kernel_config->timeoutlong,
	       sizeof(struct timeval));
	akthostname = host[akthost].hostname;
    }
    ui_RPCchangeListEntry(aktlistpos);
    ui_MakeHostList();

    /* Send values to kernel */
    ui_setKernelConfig(aktlistpos);

    /* If this is the master => save values also in the slaves*/
    if (host[aktlistpos].kernel_config->kernelMode == COOP_M_KERNEL){
	for(i = 1 ; i < anzHostEntries ; i++){
	    if (host[i].kernel_config->kernelMode == COOP_S_KERNEL){
		host[i].kernel_config->timeout.tv_sec = 
		  host[aktlistpos].kernel_config->timeout.tv_sec;
		host[i].kernel_config->timeout.tv_usec = 0;
		host[i].kernel_config->timeoutlong.tv_sec = 
		  host[aktlistpos].kernel_config->timeoutlong.tv_sec;
		host[i].kernel_config->timeoutlong.tv_usec = 0;
		host[i].kernel_config->exittimeout = 
		  host[aktlistpos].kernel_config->exittimeout;
		host[i].kernel_config->switchtolocalall = 
		  host[aktlistpos].kernel_config->switchtolocalall; 
		host[i].kernel_config->switchtolocalsingle = 
		  host[aktlistpos].kernel_config->switchtolocalsingle; 
		host[i].kernel_config->kernelMode = COOP_S_KERNEL;
		/* Send values to kernel */
		ui_setKernelConfig(i);
	    }
	}
    }
}



#endif

/* End of File */



