/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/kernel/sources/RCS/cc_mac.h,v $
  SHORTNAME      : mac.h
  SNNS VERSION   : 4.1

  PURPOSE        : macros for cascade correlation
  NOTES          :

  AUTHOR         : Michael Schmalzl
  DATE           : 24.2.93

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.5 $
  LAST CHANGE    : $Date: 1995/11/16 12:01:58 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

#ifndef _CC_MAC_DEFINED_
#define _CC_MAC_DEFINED_

#define CC 1
#define RCC 2

#define OFF 0
#define ON  1

#define ASYM_SIGMOID 0
#define SYM_SIGMOID  1
#define TANH         2
#define RANDOM       3

#define QUICKPROP    0
#define BACKPROP     1
#define RPROP        2

#define SBC          0
#define AIC          1
#define CMSEP        2

#define CASCADE      1
#define NO_CASCADE   0

/* output parameter definitions */
#define  OUT_PATIENCE                  50 
#define  MAX_NO_OF_ERROR_UPDATE_CYCLES 200
#define  MIN_ERROR_CHANGE              0.01

/* special parameter definitions */
#define  SPECIAL_PATIENCE                   25 
#define  MAX_NO_OF_COVARIANCE_UPDATE_CYCLES 200
#define  MIN_COVARIANCE_CHANGE              0.04
#define  MAX_SPECIAL_UNIT_NO                8
#define  SPECIAL_FUNC_TYPE                  SYM_SIGMOID

/* global parameter definitions */
#define  MAX_PIXEL_ERROR 0.2
#define  LEARNING_FUNC   QUICKPROP
#define  ON_OFF   ON

#define NO_OF_ACT_FUNCS 4

#define X_MIN_POS 2
#define Y_MIN_POS 2
#define HIDDEN_LAYER_HEIGHT 5     /* in 10 aendern */
#define MIN_HIDDEN_LAYER_HEIGHT 5

#define CC_TEST 0

#define CONTINUE_LEARNING 1
#define STOP_LEARNING 0

#define CC_MAX_VALUE  0.1 
#define RCC_MAX_VALUE 1.0
#define FLOAT_MAX 1E+37

#define LN_CURRENT_SLOPE(LinkPtr)       LinkPtr->value_a
#define LN_PREVIOUS_SLOPE(LinkPtr)      LinkPtr->value_b
#define LN_LAST_WEIGHT_CHANGE(LinkPtr)  LinkPtr->value_c

#define BIAS_CURRENT_SLOPE(UnitPtr)      UnitPtr->value_a
#define BIAS_PREVIOUS_SLOPE(UnitPtr)     UnitPtr->value_b
#define BIAS_LAST_WEIGHT_CHANGE(UnitPtr) UnitPtr->value_c


#define  NET_ERROR( param )      param[ 0 ]  /*    returns the net error   */

#define GET_UNIT_NO(UnitPtr) \
   UnitPtr - unit_array  

#define GET_UNIT_XPOS(UnitPtr) \
   (*UnitPtr).unit_pos.x

#define GET_UNIT_YPOS(UnitPtr) \
   (*UnitPtr).unit_pos.y

#define SET_UNIT_XPOS(UnitPtr,XPos) \
   (*UnitPtr).unit_pos.x = XPos 

#define SET_UNIT_YPOS(UnitPtr,YPos) \
   (*UnitPtr).unit_pos.y = YPos

#define ERROR_CHECK \
   if(KernelErrorCode!=KRERR_NO_ERROR) { \
     return(KernelErrorCode); \
   }  

#define CC_ERROR(ErrorCode) \
   return(ErrorCode)

#define IF_PTR_IS_NOT_NULL(ptr) if(ptr!=NULL)

#define FOR_ALL_INPUT_UNITS(UnitPtr,i) \
   for(UnitPtr= *FirstInputUnitPtr,i=0;UnitPtr!=NULL;UnitPtr=FirstInputUnitPtr[++i])

#define FOR_ALL_HIDDEN_UNITS(UnitPtr,h) \
   for(UnitPtr= *FirstHiddenUnitPtr,h=0;UnitPtr!=NULL;UnitPtr=FirstHiddenUnitPtr[++h])

#define FOR_ALL_OUTPUT_UNITS(UnitPtr,o) \
   for(UnitPtr= *FirstOutputUnitPtr,o=0;UnitPtr!=NULL;UnitPtr=FirstOutputUnitPtr[++o])

#define FOR_ALL_SPECIAL_UNITS(UnitPtr,s) \
   for(UnitPtr= *FirstSpecialUnitPtr,s=0;UnitPtr!=NULL;UnitPtr=FirstSpecialUnitPtr[++s])
          
#define FOR_ALL_PATTERNS(StartPattern,EndPattern,p) \
   for(p=StartPattern;p<=EndPattern;p++)

#define SIGN(n) ((n > 0) ? (1) : (-1))

#define GET_RECURRENT_LINK(unit_ptr,link_ptr) \
   (link_ptr) = (struct Link *) (unit_ptr)->sites 

#define FOR_ALL_NOT_RECURRENT_LINKS( unit_ptr, link_ptr ) \
for ((link_ptr) = ((struct Link *) (unit_ptr)->sites)->next; (link_ptr) != NULL; \
     (link_ptr) = (link_ptr)->next)

#endif
