/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/xgui/sources/RCS/ui_control.c,v $
  SHORTNAME      : control.c
  SNNS VERSION   : 4.0

  PURPOSE        : creates the widget containing all controls of the kernal.
  NOTES          : is called only during initialisation

  AUTHOR         : Tilman Sommer
  DATE           : 20.7.1990

  CHANGED BY     : Michael Vogt, Guenter Mamier
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.2 $ 
  LAST CHANGE    : $Date: 1995/05/11 15:05:30 $  

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG
             
******************************************************************************/


#include <stdio.h>

#include "ui.h"

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/MenuButton.h>

#include "ui_controlP.h"
#include "ui_xWidgets.h"
#include "ui_lists.h"
#include "ui_main.h"  /* ui_labelFontWidth */
#include "ui_mainP.h" /* ui_editPopup() */
#include "ui_infoP.h" /* ui_info_displayList() */
#include "ui_utilP.h" /* ui_cutTrailingZeros() */
#include "ui_fileP.h"

#ifdef MASPAR_KERNEL
#include "ui_maspar.h"  /* MASPAR Kernel Interface */
#endif


#include "ui_control.ph"

/*****************************************************************************
  FUNCTION : ui_xCreateControlPanel

  PURPOSE  : creates a form widget for user input of unit data
  RETURNS  : void
  NOTES    : some constants are used (see below) to get a relativ positioning
             of the items. This is VERY useful after changings.

  UPDATE   : 19.02.95
*****************************************************************************/

void ui_xCreateControlPanel (Widget parent)

{
    /* tabs for data fields and small buttons */

    static struct SimpleListType  listSiteFType; /* site list in
						    f-type edit panel */
    static struct SimpleListType  listSiteSite;  /* site list in
						    site edit panel */
    static struct SimpleListType  listLearnFunc;  /* func list */
    static struct SimpleListType  listUpdateFunc; /* func list */
    static struct SimpleListType  listInitFunc;   /* func list */

    Widget      stepLabel, learnLabel, updateLabel, learn2Label, pattLabel;
    Widget      mButton, sButton, button, menu, entry, mItem, subpattLabel;
    Widget      mdelButton,museButton, testLabel, initLabel;  
    Arg		args[10];
    Cardinal	n;
    int         i;
    char        buf[20], *func_name;


/*
    int  fontWidth = 8;
*/
    int  titelWidth  =  7 * ui_labelFontWidth;
    int  numberWidth =  7 * ui_labelFontWidth;
    int  nameWidth   =  6 * ui_labelFontWidth;
    int  fileWidth   =  26* ui_labelFontWidth;

/***************************************************************************/

    ui_controlPanel = 
	XtCreateManagedWidget("rPanel", formWidgetClass, parent, NULL, ZERO);

/****************************  Steps Line  *********************************/

    stepLabel =	ui_xCreateLabelItem("STEPS", ui_controlPanel,
				    titelWidth, NULL, NULL);

    sprintf(buf,"%d",ui_numberOfSteps);
    ui_numberOfStepsWidget = ui_xCreateDialogItem("numberOfSteps",
						  ui_controlPanel, buf, 
						  numberWidth, stepLabel, NULL);

    sButton = ui_xCreateButtonItem("multiStep", ui_controlPanel, 
				   ui_numberOfStepsWidget, NULL);
    XtAddCallback(sButton, XtNcallback, (XtCallbackProc) ui_rem_stepsProc, 
		  (caddr_t) TRUE);

    sprintf(buf,"%d",ui_numberOfStepsDone);
    ui_numberOfStepsDoneWidget = ui_xCreateLabelItem(buf, ui_controlPanel, 
						     numberWidth, sButton,NULL);
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNinternalHeight, 3); n++;
    XtSetArg(args[n], XtNinternalWidth , 5); n++;
    XtSetArg(args[n], XtNhorizDistance, 11); n++; 
    XtSetValues(ui_numberOfStepsDoneWidget, args, n);

    button = ui_xCreateButtonItem("init", ui_controlPanel, 
				  ui_numberOfStepsDoneWidget, NULL);
    XtSetArg(args[0], XtNhorizDistance, 11); 
    XtSetValues(button, args, 1);
    XtAddCallback(button, XtNcallback, (XtCallbackProc)ui_rem_doInitialization,
		  NULL);

    button = ui_xCreateButtonItem("reset", ui_controlPanel, button, NULL);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_resetNet, NULL);

    button = ui_xCreateButtonItem("error", ui_controlPanel, button, NULL);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_errProc, NULL);

    button = ui_xCreateButtonItem("info", ui_controlPanel, button, NULL);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_getKernelInfo, 
		  NULL);

/******************************  CYCLES  ***********************************/

    learnLabel = ui_xCreateLabelItem("CYCLES", ui_controlPanel,
				     titelWidth, NULL, stepLabel);

    sprintf(buf,"%d",ui_numberOfCycles);
    ui_numberOfCyclesWidget = ui_xCreateDialogItem("numberOfCycles", 
						   ui_controlPanel,
						   buf, numberWidth,  
						   learnLabel, stepLabel);

    button = ui_xCreateButtonItem("single", ui_controlPanel, 
				  ui_numberOfCyclesWidget, stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_learnProc, 
		  (caddr_t) UI_LEARN_SINGLE);

    button = ui_xCreateButtonItem("all", ui_controlPanel, sButton, stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_learnProc, 
		  (caddr_t) UI_LEARN_ALL);

    button = ui_xCreateButtonItem("stop", ui_controlPanel, button, stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_stopProc, NULL);

    button = ui_xCreateButtonItem("test", ui_controlPanel, button, stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_testProc, NULL);

    button = ui_xCreateToggleItem("shuffle", ui_controlPanel, NULL, button, 
				  stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_shuffleProc, 
		  NULL);
    
    button = ui_xCreateMenuButtonItem("options", ui_controlPanel,
				      button, stepLabel);

    menu = XtCreatePopupShell("menu", simpleMenuWidgetClass, button,
			      NULL, ZERO);

    mItem = XtCreateManagedWidget("jog weights", smeBSBObjectClass, 
				  menu, NULL, ZERO);
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_popupWeights, 
		  (caddr_t) UI_JOG);

    mItem = XtCreateManagedWidget("edit f-types", smeBSBObjectClass, 
				  menu, NULL, ZERO);
    sprintf(listSiteFType.msg,"Edit f-type table");
    listSiteFType.unitPtr  = NULL;
    listSiteFType.widgetPtr= button;
    listSiteFType.listType = UI_LIST_FTYPE_SITE;
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_editPopup, 
		  (caddr_t) &listSiteFType);

    mItem = XtCreateManagedWidget("edit sites", smeBSBObjectClass, 
				  menu, NULL, ZERO);
    sprintf(listSiteSite.msg,"Edit site table");
    listSiteSite.unitPtr  = NULL;
    listSiteSite.widgetPtr= button;
    listSiteSite.listType = UI_LIST_SITE;
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_editSitePopup, 
		  (caddr_t) &listSiteSite); 

    n=0;
    XtSetArg(args[n], XtNborderWidth, 1);n++;
    XtSetArg(args[n], XtNjustify, XtJustifyLeft); n++;
    XtSetArg(args[n], XtNinternalHeight, 0.99); n++;
    XtSetArg(args[n], XtNinternalWidth , 6); n++;
    XtSetArg(args[n], XtNfromVert , stepLabel);  n++;
    XtSetArg(args[n], XtNfromHoriz, button);  n++;
    XtSetArg(args[n], XtNvertDistance, 5); n++; 
    ui_showModeLabel = XtCreateManagedWidget("show", menuButtonWidgetClass, 
					     ui_controlPanel, args,n);
    ui_rem_showModeProc(NULL, ui_patternLoadMode, NULL); 

    n=0;
    XtSetArg(args[n], XtNvertDistance, -2); n++; 
    menu   = XtCreatePopupShell("menu",simpleMenuWidgetClass,ui_showModeLabel,
				args, n);
    entry = XtCreateManagedWidget("none", smeBSBObjectClass, menu,NULL,ZERO);
    XtAddCallback(entry, XtNcallback, (XtCallbackProc) 
		  ui_rem_showModeProc, (caddr_t) OUTPUT_NOTHING);
    entry = XtCreateManagedWidget("out", smeBSBObjectClass, menu,NULL,ZERO);
    XtAddCallback(entry, XtNcallback, 
		  (XtCallbackProc) ui_rem_showModeProc, (caddr_t) OUTPUT_OUT);
    entry = XtCreateManagedWidget("act", smeBSBObjectClass, menu,NULL,ZERO);
    XtAddCallback(entry, XtNcallback, 
		  (XtCallbackProc) ui_rem_showModeProc, (caddr_t) OUTPUT_ACT);


#ifdef PARAGON_KERNEL
    button = ui_xCreateToggleItem("parallel", ui_controlPanel, NULL, 
				  button, stepLabel);
    XtAddCallback(button, XtNcallback, 
		  (XtCallbackProc) ui_rem_SwitchParallel, NULL);
#endif
#ifdef MASPAR_KERNEL
    button = ui_xCreateButtonItem("maspar", ui_controlPanel, button, stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_masparPannel, 
		  (caddr_t) button);
#endif

/******************************* PATTERN  **********************************/

    pattLabel = ui_xCreateLabelItem("PATTERN", ui_controlPanel,
				    titelWidth, NULL, learnLabel);

    sprintf(buf,"%d",ui_noOfCurrentPattern);
    ui_numberOfPatternWidget = ui_xCreateDialogItem("patternNo", ui_controlPanel,
						    buf, numberWidth, 
						    pattLabel, learnLabel);

    button = ui_xCreateButtonItem("delete", ui_controlPanel, 
				  ui_numberOfPatternWidget, learnLabel);
    XtAddCallback(button, XtNcallback, 
		  (XtCallbackProc) ui_rem_deletePatternProc, NULL);

    button = ui_xCreateButtonItem("modify", ui_controlPanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, 
		  (XtCallbackProc) ui_rem_modifyPatternProc, NULL);

    button = ui_xCreateButtonItem("new", ui_controlPanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_newPatternProc, 
		  NULL);

    button = ui_xCreateButtonItem("goto", ui_controlPanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, 
		  (XtCallbackProc) ui_rem_moveInPatternsProc, (caddr_t)UI_JUMP);

    button = ui_xCreateButtonItem("first", ui_controlPanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, 
		  (XtCallbackProc)ui_rem_moveInPatternsProc,(caddr_t) UI_FIRST);

    button = ui_xCreateButtonItem("prev", ui_controlPanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, 
		  (XtCallbackProc)ui_rem_moveInPatternsProc, 
		  (caddr_t) UI_PREVIOUS);

    button = ui_xCreateButtonItem("next", ui_controlPanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, 
		  (XtCallbackProc) ui_rem_moveInPatternsProc,(caddr_t) UI_NEXT);

    button = ui_xCreateButtonItem("last", ui_controlPanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, 
		  (XtCallbackProc)ui_rem_moveInPatternsProc, (caddr_t)UI_LAST);

    button = ui_xCreateButtonItem("subpat", ui_controlPanel, button, learnLabel);
    XtAddCallback(button,XtNcallback,
		  (XtCallbackProc)ui_rem_defSubPat, (caddr_t)0);


/************************** SECOND PATTERN LINE  ***************************/


    mdelButton = ui_xCreateMenuButtonItem("del",ui_controlPanel,
					  ui_numberOfPatternWidget,pattLabel);
    REM_DFileMenu = XtCreatePopupShell("menu", simpleMenuWidgetClass, 
				       mdelButton, NULL, ZERO);

    if(PATTERN_SET_FILE[CURR_PATTERN_SET] != NULL){
	for(i=0; i<NO_OF_PATTERN_SETS;i++){
	    DELPattFileWidget[i] = XtCreateManagedWidget(PATTERN_SET_FILE[i],
						      smeBSBObjectClass,
						      REM_DFileMenu,NULL,ZERO);
	    XtAddCallback(DELPattFileWidget[i], XtNcallback, 
			  (XtCallbackProc)ui_rem_delPattSet, (caddr_t)i);
	}
    }else{
	DELPattFileWidget[0] = XtCreateManagedWidget("No Files",
						     smeBSBObjectClass, 
						     REM_DFileMenu,NULL,ZERO);
	XtAddCallback(DELPattFileWidget[0], XtNcallback, 
		      (XtCallbackProc)ui_rem_delPattSet, (caddr_t)0);
    }

    museButton = ui_xCreateMenuButtonItem("use",ui_controlPanel,mdelButton,
					  pattLabel);
    REM_UFileMenu = XtCreatePopupShell("menu",simpleMenuWidgetClass,museButton,
				       NULL, ZERO);

    if(PATTERN_SET_FILE[CURR_PATTERN_SET] != NULL){
	for(i=0; i<NO_OF_PATTERN_SETS;i++){
	    USEPattFileWidget[i] = XtCreateManagedWidget(PATTERN_SET_FILE[i],
						      smeBSBObjectClass,
						      REM_UFileMenu,NULL,ZERO);
	    XtAddCallback(USEPattFileWidget[i], XtNcallback, 
			  (XtCallbackProc)ui_rem_usePattSet, (caddr_t)i);
	}
	sprintf(buf,"%s",PATTERN_SET_FILE[CURR_PATTERN_SET]);
    }else{
	USEPattFileWidget[0] = XtCreateManagedWidget("No Files",
						     smeBSBObjectClass, 
						     REM_UFileMenu,NULL,ZERO);
	XtAddCallback(USEPattFileWidget[0], XtNcallback, 
		      (XtCallbackProc)ui_rem_usePattSet, (caddr_t)0);
	sprintf(buf,"Training Pattern File ?");
    }

    ui_showPattFile = ui_xCreateLabelItem(" ", ui_controlPanel, 
					  fileWidth, museButton, pattLabel);
    ui_xSetLabel(ui_showPattFile, buf);

/******************************** TEST *************************************/

    testLabel =	ui_xCreateLabelItem("VALID", ui_controlPanel, titelWidth, NULL, 
				    mdelButton);

    sprintf(buf,"%d",ui_testFrequency);
    ui_testFrequencyWidget = ui_xCreateDialogItem("testFrequency", 
						 ui_controlPanel,buf,numberWidth,
						 testLabel,mdelButton);

    button = ui_xCreateButtonItem("validate",ui_controlPanel, 
				  ui_testFrequencyWidget,mdelButton);
    XtAddCallback(button,XtNcallback,
		  (XtCallbackProc)ui_rem_performValidate, (caddr_t)0);

    museButton = ui_xCreateMenuButtonItem("use",ui_controlPanel,button,
					  mdelButton);
    REM_UTestFileMenu = XtCreatePopupShell("menu",simpleMenuWidgetClass,
					   museButton, NULL, ZERO);

    if(PATTERN_SET_FILE[CURR_TEST_PATTERN_SET] != NULL){
       for(i=0; i<NO_OF_PATTERN_SETS;i++){
	   USETestPattFileWidget[i] = 
	       XtCreateManagedWidget(PATTERN_SET_FILE[i],smeBSBObjectClass,
				     REM_UTestFileMenu,NULL,ZERO);
	    XtAddCallback(USETestPattFileWidget[i], XtNcallback, 
			  (XtCallbackProc)ui_rem_useTestPattSet, (caddr_t)i);
       }
       sprintf(buf,"%s",PATTERN_SET_FILE[CURR_TEST_PATTERN_SET]);
    }else{
	USETestPattFileWidget[0] = 
	    XtCreateManagedWidget("No Files",smeBSBObjectClass, 
				  REM_UTestFileMenu,NULL,ZERO);
	XtAddCallback(USETestPattFileWidget[0], XtNcallback, 
		      (XtCallbackProc)ui_rem_useTestPattSet, (caddr_t)0);
	sprintf(buf,"Validation Pattern File ?");
    }

    ui_showTestPattFile = ui_xCreateLabelItem(" ", ui_controlPanel, 
					      fileWidth, museButton,mdelButton);
    ui_xSetLabel(ui_showTestPattFile, buf);


/********************************** LEARN PARAMETER ************************/

    learn2Label = ui_xCreateLabelItem("LEARN", ui_controlPanel,
				      titelWidth, NULL, testLabel);

    for (i=0; i<UI_NO_LEARN_PARAMS; i++) {
	sprintf(buf,"%6.4f",ui_learnParameters[i]);
	ui_cutTrailingZeros(buf);
	ui_learnParameterWidgets[i] =
	    ui_xCreateDialogItem("learnParameter", ui_controlPanel,
				 buf, numberWidth, 
				 i==0?learn2Label:ui_learnParameterWidgets[i-1],
				 testLabel);
    }

    button = ui_xCreateMenuButtonItem("func",ui_controlPanel, 
				      ui_learnParameterWidgets[i-1], testLabel);

    /* Note:
    /* the construction of a dummy menu is necessary. Otherwise the creation */
    /* of the control panel would take more than 60 sec. with the RPC kernel  */

    menu = XtCreatePopupShell("menu", simpleMenuWidgetClass, button, NULL,ZERO);
    mItem = XtCreateManagedWidget("dummy",smeBSBObjectClass,menu, NULL,ZERO);

    sprintf(listLearnFunc.msg,"Select learning function");
    listLearnFunc.unitPtr  = NULL;
    listLearnFunc.widgetPtr= button;
    listLearnFunc.listType = UI_LIST_LEARN_FUNC;
    XtAddCallback(menu, XtNpopupCallback, (XtCallbackProc) ui_rem_displayList, 
		  (caddr_t) &listLearnFunc); 


/*****************************  UPDATE PARAMETER  **************************/

    updateLabel = ui_xCreateLabelItem("UPDATE", ui_controlPanel,
				      titelWidth, NULL,  learn2Label);

    for (i=0; i<UI_NO_UPDATE_PARAMS; i++) {
	sprintf(buf,"%6.4f",ui_updateParameters[i]);
	ui_cutTrailingZeros(buf);
	ui_updateParameterWidgets[i] =
	    ui_xCreateDialogItem("updateParameter", ui_controlPanel,
				 buf, numberWidth, 
				 i==0?
			           updateLabel:ui_updateParameterWidgets[i-1], 
				 learn2Label);
    }

    button = ui_xCreateMenuButtonItem("func",ui_controlPanel, 
				  ui_updateParameterWidgets[i-1], learn2Label);

    /* Note:
    /* the construction of a dummy menu is necessary. Otherwise the creation */
    /* of the control panel would take more than 60 sec. with the RPC kernel  */

    menu = XtCreatePopupShell("menu", simpleMenuWidgetClass, button,NULL,ZERO);
    mItem = XtCreateManagedWidget("dummy",smeBSBObjectClass,menu, NULL,ZERO);

    sprintf(listUpdateFunc.msg,"Select update function");
    listUpdateFunc.unitPtr  = NULL;
    listUpdateFunc.widgetPtr= button;
    listUpdateFunc.listType = UI_LIST_UPDATE_FUNC;
    XtAddCallback(menu, XtNpopupCallback, (XtCallbackProc) ui_rem_displayList, 
		  (caddr_t) &listUpdateFunc); 


/****************************** INIT PARAMETER *****************************/

    initLabel = ui_xCreateLabelItem("INIT", ui_controlPanel,
				      titelWidth, NULL, updateLabel);

    for (i=0; i<UI_NO_INIT_PARAMS; i++) {
	sprintf(buf,"%6.4f",ui_initParameters[i]);
	ui_cutTrailingZeros(buf);
	ui_initParameterWidgets[i] =
	    ui_xCreateDialogItem("initParameter", ui_controlPanel,
				 buf, numberWidth, 
				 i==0?initLabel:ui_initParameterWidgets[i-1],
				 updateLabel);
    }
    button = ui_xCreateMenuButtonItem("func",ui_controlPanel, 
				  ui_initParameterWidgets[i-1], updateLabel);


    /* Note:
    /* the construction of a dummy menu is necessary. Otherwise the creation */
    /* of the control panel would take more than 60 sec. with the RPC kernel  */

    menu = XtCreatePopupShell("menu", simpleMenuWidgetClass, button,NULL,ZERO);
    mItem = XtCreateManagedWidget("dummy",smeBSBObjectClass,menu,NULL,ZERO);
   
    sprintf(listInitFunc.msg,"Select init function");
    listInitFunc.unitPtr  = NULL;
    listInitFunc.widgetPtr= button;
    listInitFunc.listType = UI_LIST_INIT_FUNC;
    XtAddCallback(menu, XtNpopupCallback, (XtCallbackProc) ui_rem_displayList, 
		  (caddr_t) &listInitFunc); 


/***************************************************************************/

    XawFormDoLayout(ui_controlPanel, True);
    ui_controlIsCreated = TRUE;
}

/* end of file */
/* lines: 485 */

