/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/xgui/sources/RCS/bn_menu.c,v $
  SHORTNAME      : bn_menu
  SNNS VERSION   : 4.0

  PURPOSE        : Creates the BIGNET-window. 
  NOTES          :

  AUTHOR         : Kai-Uwe Herrmann
  DATE           : 15.1.1993

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.3 $
  LAST CHANGE    : $Date: 1995/03/14 14:15:34 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/



#include <stdlib.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Scrollbar.h>

#include "ui.h"
#include "glob_typ.h"
#include "kr_ui.h"
#include "ui_mainP.h"
#include "ui_confirmer.h"
#include "ui_textP.h"
#include "ui_utilP.h"
#include "ui_netUpdate.h"
#include "ui_status.h"
#include "ui_xWidgets.h"
#include "ui_fileP.h"
#include "ui_display.h"
#include "ui_event.h"
#include "ui_selection.h"

#include "bn_basics.h"
#include "bn_bignet.h"
#include "bn_TD_bignet.h"
#include "bn_art1.h"
#include "bn_art2.h"
#include "bn_artmap.h"
#include "bn_kohonen.h"
#include "bn_bighop.h"
#include "bn_JordElm.h"
#include "bn_assoz.h"

#include "bn_menu.ph"





/*****************************************************************************
  FUNCTION : bn_menu_exit

  PURPOSE  : Callback function for Feed Forward button
  NOTES    :

  UPDATE   : 20.1.1993
******************************************************************************/

static void bn_menu_exit (void)

{
   XtDestroyWidget (baseWidget);
   bn_menu_open = 0;
}


/*****************************************************************************
  FUNCTION : bn_menu_ff_PROC

  PURPOSE  : Callback function for Feed Forward button
  NOTES    :

  UPDATE   : 20.1.1993
******************************************************************************/

static void bn_menu_ff_PROC (void)

{

   bn_menu_exit();

   bn_createBignet(); /* call feed forward bignet */

}


/*****************************************************************************
  FUNCTION : bn_menu_td_PROC

  PURPOSE  : Callback function for Time Delay button
  NOTES    :

  UPDATE   : 20.1.1993
******************************************************************************/

static void bn_menu_td_PROC (void)

{

   bn_menu_exit();
   bn_create_TD_Bignet(); /* call Time Delay bignet */

}


/*****************************************************************************
  FUNCTION : bn_menu_art1_PROC

  PURPOSE  : Callback function for art1 button
  NOTES    :

  UPDATE   : 20.1.1993
******************************************************************************/

static void bn_menu_art1_PROC (void)

{
   bn_menu_exit();
   bn_createART1(); /* call ART1 bignet */
}


/*****************************************************************************
  FUNCTION : bn_menu_art2_PROC

  PURPOSE  : Callback function for art2 button
  NOTES    :

  UPDATE   : 20.1.1993
******************************************************************************/

static void bn_menu_art2_PROC (void)

{
   bn_menu_exit();
   bn_createART2(); /* call ART2 bignet */
}


/*****************************************************************************
  FUNCTION : bn_menu_artmap_PROC

  PURPOSE  : Callback function for artmap button
  NOTES    :

  UPDATE   : 20.1.1993
******************************************************************************/

static void bn_menu_artmap_PROC (void)

{
   bn_menu_exit();
   bn_createARTMAP(); /* call ARTMAP bignet */
}

/*****************************************************************************
  FUNCTION : bn_menu_bighop_PROC

  PURPOSE  : Callback function for Hopfield button
  NOTES    :

  UPDATE   : 27.5.1993
******************************************************************************/

static void bn_menu_bighop_PROC (void)

{
   bn_menu_exit();
   bn_createBigHop(); /* call Hopfield bignet */
}

/*****************************************************************************
  FUNCTION : bn_menu_kohonen_PROC

  PURPOSE  : Callback function for kohonen button
  NOTES    :

  UPDATE   : 
******************************************************************************/

static void bn_menu_kohonen_PROC (void)

{
   bn_menu_exit();
   bn_createKOHONEN();      /* call KOHONEN bignet */
}



/*****************************************************************************
  FUNCTION : bn_menu_jordan_PROC

  PURPOSE  : Callback function for jordan button
  NOTES    :

  UPDATE   :
******************************************************************************/

static void bn_menu_jordan_PROC (void)

{
   bn_menu_exit () ;
   bn_create_jordan () ; /* call BigNet (Jordan) */
}


/*****************************************************************************
  FUNCTION : bn_menu_elman_PROC

  PURPOSE  : Callback function for elman button
  NOTES    :

  UPDATE   : 
******************************************************************************/

static void bn_menu_elman_PROC (void)

{
   bn_menu_exit () ;
   bn_create_elman () ; /* call BigNet (Elman) */
}



/*****************************************************************************
  FUNCTION : bn_menu_assoz_PROC

  PURPOSE  : Callback function for elman button
  NOTES    :

  UPDATE   : 
******************************************************************************/
static void bn_menu_assoz_PROC (void)

{
   bn_menu_exit () ;
   bn_create_assoz () ; /* call BigNet (autoassozative) */
}



/*****************************************************************************
  FUNCTION : bn_menu_cancel_PROC

  PURPOSE  : Callback function for cancel button
  NOTES    :

  UPDATE   : 20.1.1993
******************************************************************************/

static void bn_menu_cancel_PROC (void)

{

   bn_menu_exit();
}



/*****************************************************************************
  FUNCTION : bn_BignetMenu

  PURPOSE  : create Bignet Selection Menu
  NOTES    : GUIButton has to be passed as parameter to find correct position
             for Bignet Menu Shell.

  UPDATE   : 19.1.1993
******************************************************************************/

void bn_BignetMenu (Widget w, XtPointer client_data, XtPointer call_data)

{
    Widget      bnmenubox, button, GUIButton;
    Arg		args[10];
    Cardinal	n = 0;
    char        buf[40];
    Dimension   GUIheight;
    Position    GUIx;
    Position    bn_menu_x, bn_menu_y;

    GUIButton = (Widget) client_data;

    if ( ! bn_menu_open) {


       /* get coordinates and height of GUI-Button */

       n = 0;
       XtSetArg(args[n],XtNx, &GUIx); n++;
       XtSetArg(args[n],XtNheight, &GUIheight); n++;

       XtGetValues (GUIButton, args, n);


       /* compute position of BigNet-Menu-Shell, which should be
          slightly below and slightly left of GUI Button
       */
       XtTranslateCoords (GUIButton,
                          (Position) ((int) GUIx - 15),
                          (Position) ((int) GUIheight + 2),
                          &bn_menu_x, &bn_menu_y);

       sprintf (buf, "BigNet");

       n = 0;
/*
       XtSetArg(args[n],XtNminHeight,114); n++;
       XtSetArg(args[n],XtNminWidth,95); n++;  
       XtSetArg(args[n],XtNmaxHeight,114); n++;
       XtSetArg(args[n],XtNmaxWidth,95); n++;
*/
       XtSetArg(args[n],XtNx,bn_menu_x); n++;
       XtSetArg(args[n],XtNy,bn_menu_y); n++;
       

       baseWidget = 
	    XtCreatePopupShell(buf, transientShellWidgetClass, ui_toplevel,
	                       args, n);


       bnmenubox = XtCreateManagedWidget ("form", formWidgetClass, baseWidget,
	                                  args, n);

    
       button = 
	   bn_basics_xCreateButtonItem("feed_forward",bnmenubox, NULL, NULL);
       XtAddCallback(button, XtNcallback, 
		     (XtCallbackProc) bn_menu_ff_PROC, NULL);

       button = 
	   bn_basics_xCreateButtonItem("time_delay",bnmenubox, NULL, button);
       XtAddCallback(button, XtNcallback, 
		     (XtCallbackProc) bn_menu_td_PROC, NULL);

       button = bn_basics_xCreateButtonItem("art1",bnmenubox, NULL, button);
       XtAddCallback(button, XtNcallback, 
		     (XtCallbackProc) bn_menu_art1_PROC, NULL);

       button = bn_basics_xCreateButtonItem("art2",bnmenubox, NULL, button);
       XtAddCallback(button, XtNcallback, 
		     (XtCallbackProc) bn_menu_art2_PROC, NULL);

       button = bn_basics_xCreateButtonItem("artmap",bnmenubox, NULL, button);
       XtAddCallback(button, XtNcallback, 
		     (XtCallbackProc) bn_menu_artmap_PROC, NULL);

       button = bn_basics_xCreateButtonItem("kohonen",bnmenubox, NULL, button);
       XtAddCallback(button, XtNcallback, 
		     (XtCallbackProc) bn_menu_kohonen_PROC, NULL);

       button = bn_basics_xCreateButtonItem("jordan",bnmenubox, NULL, button);
       XtAddCallback(button, XtNcallback, 
                     (XtCallbackProc) bn_menu_jordan_PROC, NULL) ;

       button = bn_basics_xCreateButtonItem("elman",bnmenubox, NULL, button) ;
       XtAddCallback(button, XtNcallback, 
                     (XtCallbackProc) bn_menu_elman_PROC, NULL) ;

       button = bn_basics_xCreateButtonItem("hopfield",bnmenubox, NULL, button);  
       XtAddCallback(button, XtNcallback,
                     (XtCallbackProc) bn_menu_bighop_PROC, NULL);


       button = bn_basics_xCreateButtonItem("assoz",bnmenubox, NULL, button);  
       XtAddCallback(button, XtNcallback,
                     (XtCallbackProc) bn_menu_assoz_PROC, NULL);

      
       button = bn_basics_xCreateButtonItem("cancel2",bnmenubox, NULL, button);
       XtAddCallback(button, XtNcallback, 
		     (XtCallbackProc) bn_menu_cancel_PROC, NULL);

       ui_checkWindowPosition(baseWidget);
       XtPopup (baseWidget, XtGrabNone);
       ui_xDontResizeWidget(baseWidget); 

       bn_menu_open = 1;

   } else {

       ui_confirmOk("BigNet menu already loaded\n");

   } /*if*/

}
