/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/rpc/sources/RCS/ui_rpc.c,v $
  SHORTNAME      : ui_rpc
  SNNS VERSION   : 4.0

  PURPOSE        : 
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.7 $
  LAST CHANGE    : $Date: 1995/05/08 11:11:10 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#ifdef RPCSNNS
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netdb.h>
/*#include <dirent.h>*/
#include <malloc.h>

#include <signal.h>
#include <sys/ioctl.h>		/* ioctl, TIOCNOTTY */
#include <sys/stat.h>		/* open */
#include <fcntl.h>		/* open */
#include <unistd.h>		/* getdtablesize */
#include <memory.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <syslog.h>
#include <sys/signal.h>
#include <sys/wait.h>
#include <rpc/rpc.h>
#include <rpc/types.h>
#include <sys/errno.h>
#include <sys/param.h>		/* MAXHOSTNAMELEN */
#include <sys/time.h>
#include <sys/resource.h>
#include <rpc/pmap_clnt.h>	/* for pmap_unset */
#include <rpc/pmap_prot.h>	/* for pmap_unset */

#include "ui.h"

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/AsciiSrc.h>

#include "kr_ui.h"
#include "kr_ui_rpc.h"
#include "kr_ui_rpc_main.h"
#include "ui_rpcsnns.h"

#include "ui_xWidgets.h"
#include "ui_confirmer.h"
#include "ui_main.h"
#include "ui_mainP.h"
#include "ui_event.h"
#include "ui_rpcP.h"
#include "ui_fileP.h"
#include "ui_control.h"
#include "ui_transfer.h"
#include "ui_rpcsel.h"

#include "ui_rpc.ph"

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/
void 
ui_RPCError(int err)
{
    int deletehost;
    int delete,switchto;

    ui_tw_errorMessage(krui_error(err));
    
    if (err == RPC_CALL_ERROR || err == RPC_NO_SERVER){
	if(host[akthost].kernel_config->status == S_IDLE){
	    delete = ui_confirmYes("RPC-ERROR : remove current host from hostlist?");
	    if (delete){
		/* switch to direct local */
		aktlistpos = 0;
		deletehost = akthost;
		ui_RPCswitchtoHost(0,FALSE);
		ui_DeleteHost(deletehost);
		return;
	    }
	}else{
	    ui_confirmOk("RPC-ERROR : the kernel is working => maybe the reason of the error");
	}
	switchto = ui_confirmYes("Switch to 'direct local'?");
	if(switchto){
	    /* switch to direct local */
	    aktlistpos = 0;
	    deletehost = akthost;
	    ui_RPCswitchtoHost(0,FALSE);
	}
    }
}
/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/


void
ui_RPCQuit(void)
{
    bool idlehosts=FALSE;
    int i;
    /* switch to direct local */
    aktlistpos = 0;
    ui_RPCswitchtoHost(0,TRUE);
    if(anzHostEntries >1){
	for(i=anzHostEntries - 1 ; i >0 ; i--){
	    /* Check for idle hosts */
	    if(host[i].kernel_config->status == S_IDLE)
		idlehosts=TRUE;
	}
	if(idlehosts){
	    if(ui_confirmYes("Delete Idle Hosts ?")){
		for(i=anzHostEntries - 1 ; i >0 ; i--){
		    /* Check for idle hosts */
		    if(host[i].kernel_config->status == S_IDLE){
			/* set hosts to delete */
			aktlistpos = i;
			ui_RPCshutdownCallback(NULL,NULL,NULL);
		    }
		}
	    }
	}
    }
    (void) pmap_unset(callbacknummer, SNNSUIVERS);
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/
#ifdef __linux__
static int
sigtermcallback(int sig, int code,const struct sigaction * scp, struct sigaction *addr)
#else
static void
sigtermcallback(int sig, int code, struct sigcontext * scp, char *addr)
#endif
{
    fprintf(stderr, "Caught Signal %d, terminating ... \n", sig);
    (void) pmap_unset(callbacknummer, SNNSUIVERS);
    exit(0);
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

#ifdef __linux__
static int 
sigpipecallback(int sig, int code,const struct sigaction * scp, struct sigaction *addr)
#else
static void
sigpipecallback(int sig, int code, struct sigcontext * scp, char *addr)
#endif
{
    fprintf(stderr,"Caught Signal Broken Pipe, ignoring ... \n");
    signal(SIGPIPE, (void *) sigpipecallback);
#ifdef __linux__
    return 0;
#endif
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/
#ifdef __linux__
static int
sigalarmcallback(int sig, int code, const struct sigaction * scp, struct sigaction *addr)
#else
static void
sigalarmcallback(int sig, int code, struct sigcontext * scp, char *addr)
#endif
{
    struct timeval timeout;

#ifdef FD_SETSIZE
    fd_set readfds;
#else
    int readfds;
#endif /* def FD_SETSIZE */
    extern int errno;

    signal(SIGALRM,(void *) sigalarmcallback);


#ifdef FD_SETSIZE
    readfds = svc_fdset;
#else
    readfds = svc_fds;
#endif /* def FD_SETSIZE */
    /*
     * get requests without waiting
     */
    timeout.tv_sec=0L;
    timeout.tv_usec=0L;
    
    switch (select(_rpc_dtablesize(), &readfds, (fd_set *)0, (fd_set *)0,
		   (struct timeval *)&timeout)) {
      case -1:
	if (errno == EINTR) {
#ifdef __linux__
	    return 0;
#else
	    return;
#endif
	}
#ifdef __linux__
	return 0;
#else
	return;
#endif
      case 0:
#ifdef __linux__
	return 0;
#else
	return;
#endif
      default:
	svc_getreqset(&readfds);
    }

#ifdef __linux__
    return 0;
#else
    return;
#endif
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
rpccallback(struct svc_req * rqstp, register SVCXPRT * transp)
{
    struct authunix_parms *unix_cred;

    if (!rqstp->rq_proc == NULLPROC) {
	switch (rqstp->rq_cred.oa_flavor) {
	case AUTH_UNIX:
	    unix_cred = (struct authunix_parms *) rqstp->rq_clntcred;
	    if (uid == unix_cred->aup_uid)
		break;
	default:
	    svcerr_weakauth(transp);
	    return;
	}
    }
	
    snnsuiprog_40(rqstp, transp); 
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

int
ui_initRPC(void)
{
    register SVCXPRT *transp;
    struct pmaplist *list, *list_hp;
    struct sockaddr_in addr, *addr_hp;
    char lserv[]="direct local";
    char buf[MAX_HOST_PANEL_SHOW];
    Arg             args[5];
    Cardinal        n;

    uid = getuid();
    /* Prognumber for Server */
    prognummer = SNNSKERNELPROG; 

    /* Prognumber for Callbacks */
    callbacknummer = SNNSUIPROG + (u_long) uid;

    if(!forcePortmapper){
	/* Look if number allready in use  */
	addr_hp = &addr;
	IN_SET_LOOPBACK_ADDR(addr_hp);
	list = pmap_getmaps(&addr);
	
	for (list_hp = list; list_hp != NULL; list_hp = list_hp->pml_next) {
	    if (list_hp->pml_map.pm_prog == callbacknummer && list_hp->pml_map.pm_vers == SNNSUIVERS) {
		fprintf(stderr, "Programnumber allready in use !!\n");
		exit(1);
	    }
	}
    }

    transp = svcudp_create(RPC_ANYSOCK);
    if (transp == NULL) {
	fprintf(stderr, "cannot create udp service.");
	exit(1);
    }
    if (!svc_register(transp, callbacknummer, SNNSUIVERS, rpccallback, IPPROTO_UDP)) {
	fprintf(stderr, "unable to register (callbacknummer, SNNSUIVERS, udp).");
	exit(1);
    }
    transp = svctcp_create(RPC_ANYSOCK, 0, 0);
    if (transp == NULL) {
	fprintf(stderr, "cannot create tcp service.");
	exit(1);
    }
    if (!svc_register(transp, callbacknummer, SNNSUIVERS, rpccallback, IPPROTO_TCP)) {
	fprintf(stderr, "unable to register (callbacknummer, SNNSUIVERS, tcp).");
	exit(1);
    }

    /* Register Error funktion */
    krui_setErrorHandler(ui_RPCError);

    /* Append local kernel */
    host[anzHostEntries].cl = NULL;
    host[anzHostEntries].kernelno=0; 
    host[anzHostEntries].kernelid=0; 
    host[anzHostEntries].SubPatPanel=-1;
    if( (host[anzHostEntries].hostname = (char *)strdup(lserv)) == NULL){
	/*error*/
	ui_tw_errorMessage("Not enough Memory to create Hostentry");
    };
    host[anzHostEntries].domainname = (char *)ui_getDomainName();
    host[anzHostEntries].listentry = (char *) calloc(1,MAX_HOST_PANEL_SHOW);
    if( (host[anzHostEntries].kernel_config = 
	 ui_RPCcreateKernelConfigEntry()) == NULL){
      /*error*/
      ui_tw_errorMessage("Not enough Memory to create Hostentry");
      free(host[anzHostEntries].hostname);
      free(host[anzHostEntries].domainname);
    };
    host[anzHostEntries].hasKernelConfig = TRUE;
    kernel_config_ptr = host[anzHostEntries].kernel_config; 
    host[anzHostEntries].kernel_config->kernelMode = NORMALKERNEL;
    ui_RPCchangeControlPanelValues(0,0,TRUE);
    /* set active */
    aktlistpos = 0;
    rpckernel = FALSE;
    ui_RPC_createItemsLists();
    ui_RPCmakeListEntry(0,host[0].listentry);
    anzHostEntries++;

    if(ui_RPCPannelPoppedUp){
	sprintf(buf,"%-16s %-9ld",host[0].hostname,
		host[0].kernelno);
	n = 0;
	XtSetArg(args[n], XtNstring,buf );n++;
	XtSetValues(ui_hostname, args, n);
        ui_MakeHostList();
    }

    /* SIGNALS caught for clean exit */
    signal(SIGHUP, (void *) sigtermcallback);
    signal(SIGINT, (void *) sigtermcallback);
    signal(SIGQUIT,(void *) sigtermcallback);
    signal(SIGILL, (void *) sigtermcallback);
    signal(SIGURG, (void *) sigtermcallback);
    signal(SIGBUS, (void *) sigtermcallback);
    signal(SIGSEGV,(void *) sigtermcallback);
    signal(SIGTERM,(void *) sigtermcallback);
    signal(SIGFPE, (void *) sigtermcallback);

    /* Ignore Broken Pipe */
    signal(SIGPIPE, (void *) sigpipecallback);
    /* Looking for Callbacks */
    signal(SIGALRM, (void *) sigalarmcallback);
  
    XtAppAddWorkProc(ui_appContext, (XtWorkProc) sigalarmcallback, (XtPointer)NULL);
    return(0);
}

/*****************************************************************************
  FUNCTION : ui_RPCselectionCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCselectionCallback(Widget w, caddr_t client_data, XawListReturnStruct * selektion)
{
    aktlistpos = selektion->list_index;
    ui_RPCsetSetupValues();
}

/*****************************************************************************
  FUNCTION : ui_RPCshutdownCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCshutdownCallback(Widget w, caddr_t client_data, caddr_t selektion)
{
    char            buf[127];
    int             deleteHost,par;
    Arg             args[5];
    Cardinal        n;
    struct timeval oldtimeout,timeout;

    if (aktlistpos < 0)
    return;
    if (aktlistpos == 0){
	ui_tw_errorMessage("'direct local' can't be deleted"); 
	return;
    }

    /* First send Shutdown then send SIGTERM signal */
    par = SHUTDOWN;
    timeout.tv_sec = 0;
    timeout.tv_usec = 0;
    clnt_control(host[aktlistpos].cl,CLGET_TIMEOUT,&oldtimeout);
    clnt_control(host[aktlistpos].cl,CLSET_TIMEOUT,&timeout);
    send_kernel_msg_40(&par , host[aktlistpos].cl);
    clnt_control(host[aktlistpos].cl,CLSET_TIMEOUT,&oldtimeout);
    
    deleteHost = aktlistpos;
    /* Create commandstring */
    sprintf(&buf[0],"rsh -n %s.%s \"sh -c 'HOME=${HOME-`pwd`} kill %d < /dev/null > /dev/null 2>&1 &'\"&",host[aktlistpos].hostname,host[aktlistpos].domainname,host[aktlistpos].pid);
    /* Execute Command */
    system(buf);
    /* switch to direct local */
    aktlistpos = 0;
    ui_RPCswitchtoHost(0,FALSE);

    /* delete host */
    ui_DeleteHost(deleteHost);

    if(ui_RPCPannelPoppedUp){
	sprintf(buf,"%-16s %-9ld",host[akthost].hostname,
		host[akthost].kernelno);
	n = 0;
	XtSetArg(args[n], XtNstring,buf );n++;
	XtSetValues(ui_hostname, args, n);
	XawListHighlight(RPCHostList,aktlistpos);
    }
    return;
}

/*****************************************************************************
  FUNCTION : ui_RPCinfoCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCinfoCallback(Widget w, caddr_t client_data, caddr_t selektion)
{
    char **res;
    static int dummy;

    if (aktlistpos == 0){
	ui_rem_getKernelInfo(NULL,NULL,NULL);
	return;
    }
    res = get_kernel_infotext_40(&dummy,host[aktlistpos].cl);
    if (res != NULL){
	printf("\n%s\n",*res);
    }else{
	ui_tw_errorMessage("RPC-Call failed"); 
    }
}

/*****************************************************************************
  FUNCTION : ui_RPCswitchtoCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCswitchtoCallback(Widget w, caddr_t client_data, caddr_t selektion)
{
    ui_RPCswitchtoHost(aktlistpos,TRUE);
}

/*****************************************************************************
  FUNCTION : ui_RPCSetupCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCSetupCallback(Widget w, int button, caddr_t selektion)
{
    char buf[60];
    switch(button){
      case RPC_DONE:
	ui_RPCSetupIsCreated = FALSE;
	XtDestroyWidget(ui_popRPCSetup);
	return;
      case RPC_APPLY:
	ui_RPCstoreSetupValues();
	ui_RPCsetSetupValues();
	break;
      case RPC_DEFAULT:
	ui_RPCsetSetupValues();
	ui_xSetToggleState(ui_RPCUDPtoggle, FALSE);
	ui_xSetToggleState(ui_RPCTCPtoggle, TRUE);
	ui_xSetToggleState(ui_RPCNormalToggle, TRUE);
	sprintf(buf,"%d",25);
	ui_xSetString(ui_RPCtimeout_sec,buf);
	sprintf(buf,"%d",MAXWAITTIME);
	ui_xSetString(ui_RPCtimeoutlong_sec,buf);
	sprintf(buf,"%d",TIMEOUTVAL);
	ui_xSetString(ui_RPCexittimeout_min,buf);
	sprintf(buf,"%d",SWITCH_TO_LOCAL_ALL);
	ui_xSetString(ui_RPCswitchtolocalall,buf);
	sprintf(buf,"%d",SWITCH_TO_LOCAL_SINGLE);
	ui_xSetString(ui_RPCswitchtolocalsingle,buf);
	break;
      case RPC_UDP:
	ui_xSetToggleState(ui_RPCTCPtoggle, !ui_xGetToggleState(ui_RPCUDPtoggle));
	break;
      case RPC_TCP:
	ui_xSetToggleState(ui_RPCUDPtoggle, !ui_xGetToggleState(ui_RPCTCPtoggle));
	break;
      case RPC_NORMAL:
	if(!ui_xGetToggleState(ui_RPCNormalToggle) &&
	   !ui_xGetToggleState(ui_RPCCoop_M_Toggle)){
	    ui_xSetToggleState(ui_RPCNormalToggle, TRUE);
	}
	break;
      case RPC_COOP_MASTER:
	ui_tw_errorMessage("coop-master not supported in this release");
	ui_xSetToggleState(ui_RPCCoop_M_Toggle, FALSE);
	ui_xSetToggleState(ui_RPCNormalToggle, TRUE);

/*	if(ui_xGetToggleState(ui_RPCCoop_M_Toggle)) {
	    ui_xSetToggleState(ui_RPCNormalToggle, FALSE);
	}*/
	break;
      case RPC_COOP_SLAVE:
	ui_xSetToggleState(ui_RPCNormalToggle, FALSE);
	ui_xSetToggleState(ui_RPCCoop_M_Toggle,FALSE);
	break;
    }
}

/*****************************************************************************
  FUNCTION : ui_RPCServerSelectionCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCServerSelectionCallback(Widget w, caddr_t client_data, XawListReturnStruct * selektion)
{
    Arg             args[5];
    Cardinal        n;

    aktserver = selektion->list_index;
    if(ui_RPCPannelPoppedUp){
	n = 0;
	XtSetArg(args[n], XtNstring, server[aktserver].hostname); n++;
	XtSetValues(ui_servername, args, n);
    }
}

/*****************************************************************************
  FUNCTION : ui_RPCServerCreateCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCServerCreateCallback(Widget w, caddr_t client_data, caddr_t selektion)
{
    char            serv[MAXHOSTNAMELEN + 1];
    char            path[MAX_PATH_LEN];
    char            parameter[MAX_PARAMETER_LEN];
    char            execstr[MAX_PARAMETER_LEN + MAXHOSTNAMELEN +127];
    char            buf[127];

    gethostname(buf,127);
    ui_xStringFromAsciiWidget(ui_servername,(char *)&serv, MAXHOSTNAMELEN);
    ui_xStringFromAsciiWidget(ui_path,(char *)&path, MAX_PATH_LEN);
    ui_xStringFromAsciiWidget(ui_parameter,(char *)&parameter, MAX_PARAMETER_LEN);

    /* Create commandstring */
    sprintf(&execstr[0],"rsh -n %s \"sh -c 'HOME=${HOME-`pwd`} %s -host %s.%s -program %ld -version %ld -uid %d %s < /dev/null > /dev/null 2>&1 &'\"&",serv,path,buf,ui_getDomainName(),callbacknummer,SNNSUIVERS,getuid(),parameter);
    /* Execute Command */
#ifdef DEBUG
    printf("Execute String ->%s<-\n",execstr);
#endif
    system(execstr);

    ui_AppendServer(serv);
}

/*****************************************************************************
  FUNCTION : ui_RPCServerReconnectCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCServerReconnectCallback(Widget w, caddr_t client_data, caddr_t selektion)
{
    struct pmaplist *list, *list_hp;
    struct sockaddr_in addr;
    struct hostent *ent;
    int i;
    char            serv[MAXHOSTNAMELEN + 1];
    bool_t          notinlist;
    long min,max;

    if (aktserver <0 ){
	ui_xStringFromAsciiWidget(ui_servername,(char *)&serv, MAXHOSTNAMELEN);
	ui_AppendServer(serv);
    }else{
	strncpy(serv,server[aktserver].hostname,MAXHOSTNAMELEN);
    }

    ent = gethostbyname(serv);
    if (ent == NULL){
	ui_tw_errorMessage("Host not found!");
	return;
    }

   /* Internet Adress */
    bcopy(ent->h_addr, (caddr_t)&addr.sin_addr.s_addr ,ent->h_length);
    addr.sin_family = AF_INET;
    addr.sin_port = 0;
    list =  pmap_getmaps(&addr);

    min = SNNSKERNELVERS * 10000000 + (long) uid;
    max = min + MAXKERNELS * 100000;

    for (list_hp = list; list_hp != NULL; list_hp = list_hp->pml_next) {
	if (list_hp->pml_map.pm_prot == IPPROTO_UDP &&
	    list_hp->pml_map.pm_prog == SNNSKERNELPROG && 
	    list_hp->pml_map.pm_vers >= min && 
	    list_hp->pml_map.pm_vers <= max ) {

	    /* If not in List -> append */
	    notinlist = TRUE;
	    for (i = 0; i < anzHostEntries; i++) {
		if ((strcmp(serv, host[i].hostname) == 0) &&
		    (host[i].kernelno == list_hp->pml_map.pm_vers)){
		    
		    notinlist = FALSE;
		}
	    }
	    if (notinlist) {
		ui_RPCCallGET_SNNS_KERNEL(&addr , list_hp->pml_map.pm_vers , serv);
	    }
	}
    }
}

/*****************************************************************************
  FUNCTION : ui_RPCServerBroadcastCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCServerBroadcastCallback(Widget w, caddr_t client_data, caddr_t selektion)
{
    ui_BroadcastForServers();
    ui_MakeServerList();
}


/*****************************************************************************
  FUNCTION : ui_xCreateRPCPanel

  PURPOSE  : create the RPC selector panel
  RETURNS  : void
  NOTES    : the wigdet will be created in relative position to eachother

  UPDATE   :
*****************************************************************************/

void
ui_xCreateRPCPanel(Widget parent)
/* the parent widget of the new form widget */

{
    int             fontWidth = 9;
    Arg             args[20];
    Cardinal        n;
    static char     buf[MAX_HOST_PANEL_SHOW];
    Widget          form,button, label, viewport;

    ui_RPCPanel =
	XtCreateManagedWidget("RPCPanel", formWidgetClass, parent, NULL, ZERO);
/*    n = 0;
    XtSetArg(args[n], XtNheight, 25 * fontWidth); n++;
    XtSetArg(args[n], XtNresizable, FALSE); n++;
    XtSetValues(ui_RPCPanel,args,n);
*/
    label = ui_xCreateLabelItem("CURRENT HOST:", ui_RPCPanel, 11 * fontWidth, NULL, NULL);
    ui_hostname = ui_xCreateDialogItem("'direct local'", ui_RPCPanel,"'direct local                  '", MAX_HOST_LEN_SHOW * fontWidth/2, label, NULL);
    n=0;
    XtSetArg(args[n], XtNeditType , XawtextRead);  n++;
    XtSetValues(ui_hostname,args,n);
    
    n = 0;
    XtSetArg(args[n], XtNwidth, 450 ); n++;
    XtSetArg(args[n], XtNheight, 10 * fontWidth); n++;
    XtSetArg(args[n], XtNresizable, FALSE); n++;
    XtSetArg(args[n], XtNfromVert, label); n++;
/*    XtSetArg(args[n], XtNvertDistance,9); n++; */
    XtSetArg(args[n], XtNallowHoriz, TRUE); n++;
    XtSetArg(args[n], XtNallowVert, TRUE); n++;
    XtSetArg(args[n], XtNuseBottom, TRUE); n++;
    XtSetArg(args[n], XtNforceBars, TRUE); n++;
/*    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainRight); n++;
    XtSetArg(args[n], XtNtop, XtChainTop); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;*/
    viewport = XtCreateManagedWidget("Viewport", viewportWidgetClass, ui_RPCPanel, args, n);

    form =
	XtCreateManagedWidget("Form", formWidgetClass, viewport, NULL, ZERO);

    ui_RPCItemsDesc = 
      ui_xCreateLabelItem(itemsNames, form 
			  , strlen(itemsNames) * fontWidth, NULL, NULL);
    n=0;
    XtSetArg(args[n], XtNborderWidth, 2); n++;	
    XtSetArg(args[n], XtNresizable, TRUE); n++;	
    XtSetArg(args[n], XtNresize,    TRUE); n++;
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainRight); n++;
    XtSetArg(args[n], XtNtop, XtChainTop); n++;
    XtSetArg(args[n], XtNbottom, XtChainTop); n++;
    XtSetValues(ui_RPCItemsDesc, args, n);

    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0); n++;	
/*    XtSetArg(args[n], XtNheight, 20 * fontWidth); n++;*/
    XtSetArg(args[n], XtNresizable, TRUE); n++;
    XtSetArg(args[n], XtNforceColumns, TRUE); n++;
    XtSetArg(args[n], XtNdefaultColumns, 1); n++;
    XtSetArg(args[n], XtNverticalList, FALSE); n++;
    XtSetArg(args[n], XtNfromVert, ui_RPCItemsDesc);n++;
/*    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainRight); n++;
    XtSetArg(args[n], XtNtop, XtChainTop); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;*/
    RPCHostList = XtCreateManagedWidget("ListWin"
					, listWidgetClass, form, args, n);
    XtAddCallback(RPCHostList, XtNcallback
		  , (XtCallbackProc) ui_RPCselectionCallback, NULL);


    button = ui_xCreateButtonItem("done", ui_RPCPanel, NULL, viewport);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_popupDone, (caddr_t) UI_POPUP_RPC);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainLeft); n++;
    XtSetArg(args[n], XtNtop, XtChainBottom); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;
    XtSetValues(button, args, n);

    button = ui_xCreateButtonItem("switchto", ui_RPCPanel, button, viewport);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_RPCswitchtoCallback, NULL);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainLeft); n++;
    XtSetArg(args[n], XtNtop, XtChainBottom); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;
    XtSetValues(button, args, n);

    button = ui_xCreateButtonItem("info", ui_RPCPanel, button, viewport);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_RPCinfoCallback, NULL);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainLeft); n++;
    XtSetArg(args[n], XtNtop, XtChainBottom); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;
    XtSetValues(button, args, n);

    button = ui_xCreateButtonItem("close", ui_RPCPanel, button, viewport);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_RPCshutdownCallback, NULL);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainLeft); n++;
    XtSetArg(args[n], XtNtop, XtChainBottom); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;
    XtSetValues(button, args, n);

    button = ui_xCreateButtonItem("setup", ui_RPCPanel, button, viewport);
    XtAddCallback(button, XtNcallback,(XtCallbackProc) ui_displayRPCSetupPanel, (caddr_t) button);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainLeft); n++;
    XtSetArg(args[n], XtNtop, XtChainBottom); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;
    XtSetValues(button, args, n);

    button = ui_xCreateButtonItem("new", ui_RPCPanel, button, viewport);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_displayRPCServerPanel, (caddr_t) button);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainLeft); n++;
    XtSetArg(args[n], XtNtop, XtChainBottom); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;
    XtSetValues(button, args, n);

    button = ui_xCreateButtonItem("put", ui_RPCPanel, button, viewport);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_displayRPCFileTransfer, (caddr_t) RPC_PUT);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainLeft); n++;
    XtSetArg(args[n], XtNtop, XtChainBottom); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;
    XtSetValues(button, args, n);

    button = ui_xCreateButtonItem("get", ui_RPCPanel, button, viewport);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_displayRPCFileTransfer, (caddr_t) RPC_GET);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainLeft); n++;
    XtSetArg(args[n], XtNtop, XtChainBottom); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;
    XtSetValues(button, args, n);

    button = ui_xCreateButtonItem("show info", ui_RPCPanel, button, viewport);
    XtAddCallback(button, XtNcallback 
		  , (XtCallbackProc) ui_displaySelectHostPanelItems 
		  , (caddr_t) button);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainLeft); n++;
    XtSetArg(args[n], XtNtop, XtChainBottom); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;
    XtSetValues(button, args, n);

    ui_MakeHostList();
    akthost = aktlistpos;
    sprintf(buf,"%-16s %-9ld",host[akthost].hostname,
	                      host[akthost].kernelno);
    n = 0;
    XtSetArg(args[n], XtNstring,buf);
    n++;
    XtSetValues(ui_hostname, args, n);
    
    XawFormDoLayout(ui_RPCPanel, True);
}

/*****************************************************************************
  FUNCTION : ui_xCreateRPCServerPanel

  PURPOSE  : create the RPC selector panel
  RETURNS  : void
  NOTES    : the widget will be created in relative position to eachother

  UPDATE   :
*****************************************************************************/

static void
ui_xCreateRPCServerPanel(Widget parent)
/* the parent widget of the new form widget */

{
    int             fontWidth = 9;
    int             labelWidth = 11 * fontWidth;
    Arg             args[20];
    Cardinal        n;
    Widget          button, label, viewport;
    char            buf[127];

    gethostname(buf,127);
    n = 0;
    XtSetArg(args[n], XtNresizable, TRUE);n++;
    ui_RPCServerPanel =
	XtCreateManagedWidget("RPCServerPanel", formWidgetClass
			      , parent, args, n);

    label = ui_xCreateLabelItem("HOST", ui_RPCServerPanel
				, labelWidth, NULL, NULL);
    ui_servername = ui_xCreateDialogItem("Host", ui_RPCServerPanel
					 ,buf, MAX_HOST_LEN_SHOW * fontWidth
					 , label, NULL);
    n = 0;
    XtSetArg(args[n], XtNresize, XawtextResizeWidth); n++;
/*
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
*/
    XtSetValues(ui_servername, args, n);
    label = ui_xCreateLabelItem("PATH", ui_RPCServerPanel
				, labelWidth, NULL,ui_servername);
    getcwd(&buf[0],115);
    sprintf(&buf[strlen(buf)],"/kernelrpc");
    ui_path = ui_xCreateDialogItem("Path", ui_RPCServerPanel, buf 
				   , MAX_PATH_LEN_SHOW * fontWidth
				   , label, ui_servername);
    XtSetValues(ui_path, args, n);
    label = ui_xCreateLabelItem("PARAMETER", ui_RPCServerPanel
				, labelWidth, NULL, ui_path);
    ui_parameter = ui_xCreateDialogItem("param", ui_RPCServerPanel, ""
					, MAX_PARAMETER_LEN_SHOW * fontWidth
					, label, ui_path);
    XtSetValues(ui_parameter, args, n);


    label = ui_xCreateLabelItem("HOSTS", ui_RPCServerPanel
				, labelWidth, NULL, ui_parameter);

    n = 0;
    XtSetArg(args[n], XtNwidth, MAX_HOST_LEN_SHOW * fontWidth + labelWidth); 
    n++;
    XtSetArg(args[n], XtNheight, 16 * fontWidth); 
    n++;
    XtSetArg(args[n], XtNresizable, FALSE);
    n++;
    XtSetArg(args[n], XtNfromVert, label);
    n++;
    /* XtSetArg(args[n], XtNvertDistance, 9); n++; */
    XtSetArg(args[n], XtNleft, XtChainLeft);
    n++;
    XtSetArg(args[n], XtNallowHoriz, TRUE);
    n++;
    XtSetArg(args[n], XtNallowVert, TRUE);
    n++;
    XtSetArg(args[n], XtNuseBottom, TRUE);
    n++;
    XtSetArg(args[n], XtNforceBars, TRUE);
    n++;
    XtSetArg(args[n], XtNright, XtChainRight);
    n++;
    XtSetArg(args[n], XtNtop, XtChainTop);
    n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom);
    n++;
    viewport = XtCreateManagedWidget("Viewport", viewportWidgetClass
				     , ui_RPCServerPanel, args, n);


    n = 0;
    XtSetArg(args[n], XtNresizable, TRUE);
    n++;
    XtSetArg(args[n], XtNforceColumns, TRUE);
    n++;
    XtSetArg(args[n], XtNdefaultColumns, 1);
    n++;
    XtSetArg(args[n], XtNverticalList, FALSE);
    n++;
    RPCServerList = XtCreateManagedWidget("ListWin", listWidgetClass
					  , viewport, args, n);
    XtAddCallback(RPCServerList, XtNcallback
		  , (XtCallbackProc) ui_RPCServerSelectionCallback, NULL);


    button = ui_xCreateButtonItem("done", ui_RPCServerPanel, NULL, viewport);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_popupDone
		  , (caddr_t) UI_POPUP_RPC_SERVER);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft);
    n++;
    XtSetArg(args[n], XtNright, XtChainLeft);
    n++;
    XtSetArg(args[n], XtNtop, XtChainBottom);
    n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom);
    n++;
    XtSetValues(button, args, n);

    button = ui_xCreateButtonItem("new", ui_RPCServerPanel, button, viewport);
    XtAddCallback(button, XtNcallback
		  , (XtCallbackProc) ui_RPCServerCreateCallback, NULL);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft);
    n++;
    XtSetArg(args[n], XtNright, XtChainLeft);
    n++;
    XtSetArg(args[n], XtNtop, XtChainBottom);
    n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom);
    n++;
    XtSetValues(button, args, n);

    button = ui_xCreateButtonItem("reconnect", ui_RPCServerPanel
				  , button, viewport);
    XtAddCallback(button, XtNcallback
		  , (XtCallbackProc) ui_RPCServerReconnectCallback, NULL);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft);
    n++;
    XtSetArg(args[n], XtNright, XtChainLeft);
    n++;
    XtSetArg(args[n], XtNtop, XtChainBottom);
    n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom);
    n++;
    XtSetValues(button, args, n);

    button = ui_xCreateButtonItem("broadcast", ui_RPCServerPanel
				  , button, viewport);
    XtAddCallback(button, XtNcallback
		  , (XtCallbackProc) ui_RPCServerBroadcastCallback, NULL);
    n = 0;
    XtSetArg(args[n], XtNleft, XtChainLeft);
    n++;
    XtSetArg(args[n], XtNright, XtChainLeft);
    n++;
    XtSetArg(args[n], XtNtop, XtChainBottom);
    n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom);
    n++;
    XtSetValues(button, args, n);

    ui_MakeServerList();

    XawFormDoLayout(ui_RPCServerPanel, True);
}


/*****************************************************************************
  FUNCTION : ui_xCreateRPCSetupPanel

  PURPOSE  : create the RPC Setup panel

  RETURNS  : void
  NOTES    : the wigdet will be created in relative position to eachother

  UPDATE   :
*****************************************************************************/

static void
ui_xCreateRPCSetupPanel(Widget parent)
/* the parent widget of the new form widget */
{
    Widget          topLabel;
    char            buf[80];
    int  fontWidth = 8;
    int  titelWidth  = 15 * fontWidth;

    ui_RPCSetupPanel =
	XtCreateManagedWidget("RPCSetupPanel"
			      ,formWidgetClass,parent,NULL,ZERO);

    topLabel =
	ui_xCreateLabelItem("connection type:", ui_RPCSetupPanel
			    ,titelWidth, NULL, NULL);
	

    ui_RPCUDPtoggle =
	ui_xCreateToggleItem("udp", ui_RPCSetupPanel,
			     NULL, NULL, topLabel);
    ui_xSetToggleState(ui_RPCUDPtoggle, TRUE);
    XtAddCallback(ui_RPCUDPtoggle, XtNcallback
		  , (XtCallbackProc) ui_RPCSetupCallback, 
		  (caddr_t) RPC_UDP);
    ui_RPCTCPtoggle =
	ui_xCreateToggleItem("tcp", ui_RPCSetupPanel,
			    ui_RPCUDPtoggle ,ui_RPCUDPtoggle,topLabel);
    ui_xSetToggleState(ui_RPCTCPtoggle, FALSE);
    XtAddCallback(ui_RPCTCPtoggle, XtNcallback
		  , (XtCallbackProc) ui_RPCSetupCallback, 
		  (caddr_t) RPC_TCP);

    topLabel =
	ui_xCreateLabelItem("kernel type:", ui_RPCSetupPanel, 
			   titelWidth, NULL, ui_RPCUDPtoggle);
	
    ui_RPCNormalToggle =
	ui_xCreateToggleItem("normal", ui_RPCSetupPanel,
			    NULL,NULL , topLabel );
    ui_xSetToggleState(ui_RPCNormalToggle, TRUE);
    XtAddCallback(ui_RPCNormalToggle, XtNcallback
		  , (XtCallbackProc) ui_RPCSetupCallback
		  ,(caddr_t) RPC_NORMAL);

    ui_RPCCoop_M_Toggle =
	ui_xCreateToggleItem("coop_master", ui_RPCSetupPanel,
			    ui_RPCNormalToggle ,ui_RPCNormalToggle ,topLabel );
    ui_xSetToggleState(ui_RPCCoop_M_Toggle, FALSE);
    XtAddCallback(ui_RPCCoop_M_Toggle, XtNcallback
		  , (XtCallbackProc) ui_RPCSetupCallback
		  ,(caddr_t) RPC_COOP_MASTER);

    topLabel =
	ui_xCreateLabelItem("Standard timeout      [sec]:",ui_RPCSetupPanel, 
			   fontWidth*25, NULL ,ui_RPCNormalToggle );
	
    sprintf(buf,"%d", 25);
    ui_RPCtimeout_sec =
	ui_xCreateDialogItem("timeout_sec",ui_RPCSetupPanel , buf, 6*fontWidth
			     ,topLabel, ui_RPCNormalToggle);


    topLabel =
	ui_xCreateLabelItem("Long duration timeout [sec]:",ui_RPCSetupPanel, 
			   fontWidth*25, NULL ,ui_RPCtimeout_sec);
	
    sprintf(buf,"%d", MAXWAITTIME);
    ui_RPCtimeoutlong_sec =
	ui_xCreateDialogItem("timeoutlong_sec",ui_RPCSetupPanel 
			     ,buf, 6*fontWidth,topLabel, ui_RPCtimeout_sec);

    topLabel =
	ui_xCreateLabelItem("timeout for autoexit  [min]:", ui_RPCSetupPanel, 
			    25 * fontWidth, NULL,   ui_RPCtimeoutlong_sec);

    sprintf(buf,"%d", 0);
    ui_RPCexittimeout_min =
	ui_xCreateDialogItem("exittimeout_min",ui_RPCSetupPanel , buf
			     , 6*fontWidth,topLabel, ui_RPCtimeoutlong_sec);

    topLabel =
	ui_xCreateLabelItem("switch to local (ALL)      :", ui_RPCSetupPanel, 
			    25 * fontWidth, NULL,  ui_RPCexittimeout_min );

    sprintf(buf,"%d", SWITCH_TO_LOCAL_ALL);
    ui_RPCswitchtolocalall =
	ui_xCreateDialogItem("switchtolocalall",ui_RPCSetupPanel , buf
			     , 6*fontWidth,topLabel,ui_RPCexittimeout_min);

    topLabel =
	ui_xCreateLabelItem("switch to local (SINGLE)   :", ui_RPCSetupPanel, 
			    25 * fontWidth, NULL,ui_RPCswitchtolocalall);

    sprintf(buf,"%d", SWITCH_TO_LOCAL_SINGLE);
    ui_RPCswitchtolocalsingle =
	ui_xCreateDialogItem("switchtolocalsingle",ui_RPCSetupPanel , buf
			     , 6*fontWidth,topLabel,ui_RPCswitchtolocalall);


    XawFormDoLayout(ui_RPCSetupPanel, True);

}

/*****************************************************************************
  FUNCTION : ui_displayRPCServerPanel

  PURPOSE  : popup the RPC Server panel
  RETURNS  : void
  NOTES    :

  UPDATE   : 22.5.1990
******************************************************************************/
static void
ui_displayRPCServerPanel(Widget w, Widget button, caddr_t call_data)
{
    Arg             args[5];
    Position        x, y;
    Dimension       width, height;
    Cardinal        n;

    if (ui_RPCServerIsCreated)
	return;
    ui_RPCServerIsCreated = TRUE;

    /* Upper left corner will be in the center of the calling button */

    n = 0;
    XtSetArg(args[0], XtNwidth, &width);n++;
    XtSetArg(args[1], XtNheight, &height);n++;
    XtGetValues(button, args, n);

    XtTranslateCoords(button, (Position) 0, (Position) (height), &x, &y);

    n = 0;
    XtSetArg(args[n], XtNx, x); n++;
    XtSetArg(args[n], XtNy, y); n++;

    /* Now create Popup */

    ui_popRPCServer =
	XtCreatePopupShell("RPC NEW PANEL", transientShellWidgetClass, button,args, n);

    ui_xCreateRPCServerPanel(ui_popRPCServer);


    ui_RPCServerIsCreated = TRUE;
    ui_checkWindowPosition(ui_popRPCServer);


    n = 0;
    XtSetArg(args[n], XtNwidth, &x); n++;
    XtSetArg(args[n], XtNheight, &y);n++;
    XtGetValues(ui_popRPCServer, args, n);
    n = 0;
    XtSetArg(args[n], XtNmaxWidth, x);n++;
    XtSetArg(args[n], XtNminWidth, x);n++;
    XtSetArg(args[n], XtNminHeight, y);n++;
    XtSetValues(ui_popRPCServer, args, n);

    XtPopup(ui_popRPCServer, XtGrabNone);
}

/*****************************************************************************
  FUNCTION : ui_displayRPCSetupPanel

  PURPOSE  : popup the RPC Setup panel
  RETURNS  : void
  NOTES    :

  UPDATE   : 16.02.94
******************************************************************************/
static void
ui_displayRPCSetupPanel(Widget w, Widget button, caddr_t call_data)
{
    Position        x, y;
    Dimension       width, height;
    Arg             args[5];
    Cardinal        n;
    Widget          doneButton,form,tbutton;

    if (ui_RPCSetupIsCreated)
	return;
    ui_RPCSetupIsCreated = TRUE;

    /* Upper left corner will be in the center of the calling button */

    n = 0;
    XtSetArg(args[0], XtNwidth, &width);n++;
    XtSetArg(args[1], XtNheight, &height);n++;
    XtGetValues(button, args, n);

    XtTranslateCoords(button, (Position) 0, (Position) (height), &x, &y);

    n = 0;
    XtSetArg(args[n], XtNx, x); n++;
    XtSetArg(args[n], XtNy, y); n++;

	/* Now create Popup */

    ui_popRPCSetup = 
	XtCreatePopupShell("RPC SETUP", transientShellWidgetClass, 
			   ui_toplevel, args, n);

    form = 
	XtCreateManagedWidget("form", formWidgetClass, ui_popRPCSetup, 
			      NULL, ZERO);

    ui_xCreateRPCSetupPanel(form);

    doneButton = 
	ui_xCreateButtonItem("done", form, NULL, ui_RPCSetupPanel);
    XtAddCallback(doneButton, XtNcallback,(XtCallbackProc)ui_RPCSetupCallback, 
		  (caddr_t) RPC_DONE);
    tbutton = ui_xCreateButtonItem("apply",form,doneButton, ui_RPCSetupPanel);
    XtAddCallback(tbutton, XtNcallback, (XtCallbackProc) ui_RPCSetupCallback, (caddr_t) RPC_APPLY);
    tbutton = ui_xCreateButtonItem("default2",form,tbutton, ui_RPCSetupPanel);
    XtAddCallback(tbutton, XtNcallback, (XtCallbackProc) ui_RPCSetupCallback, (caddr_t) RPC_DEFAULT);

    ui_checkWindowPosition(ui_popRPCSetup);
    XtPopup(ui_popRPCSetup, XtGrabNone);
    ui_xDontResizeWidget(ui_popRPCSetup); 
    ui_RPCsetSetupValues();
}




#endif

/* End of File */

