/* fake set of low level routines for axis, 
 * to make it independent of plot library.
 * This is the ascii version.
 */
#include <stdio.h>

/* put a coordinate in the file. Coordinates are short integers */
putcoord(i) 
int i;
{ 
	i = (i<0) ? 0 : i;
	i = (i>65535) ? 65535 : i;
	printf(" %d",i)
}
#define cr()        printf("\n")

/* move to a point */
move(ix,iy) { putchar('m'); putcoord(ix); putcoord(iy); cr(); }

/* plot a point */
point(ix,iy) { putchar('p'); putcoord(ix); putcoord(iy); cr(); }

/* line from here to there */
line(ix1,iy1,ix2,iy2) {putchar('l');putcoord(ix1);putcoord(iy1);
	putcoord(ix2);putcoord(iy2);cr(); }

/* continue to a point */
cont(ix,iy) {putchar('n');putcoord(ix);putcoord(iy);cr(); }

/* define plotting space */
space(ix1,iy1,ix2,iy2) {putchar('s');putcoord(ix1);putcoord(iy1);
	putcoord(ix2);putcoord(iy2);cr(); }

/* make a label */
label(s) char *s; {putchar('t');puts(s);}

/* change linestyle */
linemod(s) char *s; {putchar('f');puts(s);}

/* erase the screen */
erase() {putchar('e');cr(); }

/* provide the string index function */
char *index(s,c) char *s,c;{
	while(*s != '\0'){if(*s == c)return(s);s++;}
	return(NULL);
}
