/*    xpplot.c   */
/*
to compile this program type :

cc -o xpplot  xpplot.c  -lm -lX11

then try :

xpplot
xpplot -h
xpplot d
xpplot x y

*/

# define VERSION "2.2.5 Wed Apr  3 17:09:00 METDST 1996 "

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/keysym.h>

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <signal.h>

# define MAXCOLORS 210
# define HISTDIM  1000

# define NWINS      10
# define WinQuit     0
# define WinAbout    1
# define WinOrig     2
# define WinUnzoom   3
# define WinLive     4
# define WinHcopy    5
# define WinLine     6
# define Win1        7
# define Win2        8
# define WinW        9

# define SCREEN 0
# define PS     1

#define MAX_POPUP_STRING_LENGTH  40
#define MAX_MAPPED_STRING_LENGTH 40

# define ALARMPER 0

# define FONT_NAME1 "10x20"
# define FONT_NAME2 "8x13"

# define Globx1  0.2
# define Globx2  0.05
# define Globy1  0.125
# define Globy2  0.125
/*******************************************/
 Display *display;
 int screen;
 int display_w,display_h;
 XSizeHints size_hints;
 GC gc,gcx,cgc[MAXCOLORS];

 int ncolors;
 int colorsready = 0;

 XFontStruct *font_info;
 int font_height = 20,
     font_width  = 10;

 Window winM,wins [NWINS];
 unsigned int width  = 100,
              height = 100,
              win_w,
              win_h,
              border_width=1;
 int
  orx,
  ory;

 int geom_specified = 0;
 unsigned int geom_w,
              geom_h;
 int          geom_x,
              geom_y;

 double gx = 0,
        gy = 0,
        gxmin =0,
        gxmax =1,
        gymin =0,
        gymax =1,
        gxmino=0,
        gxmaxo=1,
        gymino=0,
        gymaxo=1,
        gxright,
        kx=1,
        ky=1,
        qx=0,
        qy=0;
 int    conect = 1,
       maxconect = 6;
 static char Header  [100],
             Header0 [100];
 double sep  = -0.3737,
        sep0 = -0.373710,
        sep1 = -0.373711,
        sep2 = -0.373712,
        sep3 = -0.373713,
        sep4 = -0.373714,
        sep5 = -0.373715,
        eps  = 1E-13;

 int  wl  = 0,
      owl = 0,
      dwl = 1;

 long datal,
      datal0,
      datalx,
      dataly,

      datal1  =  0L,
      datal2  = -1L,

      ddatal1 =  1L,
      ddatal2 =  1L,

      dataax  = 10000L,
      dataay  = 10000L;

 static double *x,*y;
 int infiles=0,inflags=0,infile1=0,infile2=0;

 struct { double xmin,xmax,ymin,ymax; } hist [HISTDIM];
 int nhist = 0;

 int ixp,iyp,ixr,iyr,ixt,iyt;
 int dp = 5;
 double wxp,wyp,wxr,wyr;

 int device = SCREEN;
 FILE *fhcopy;
 static char hname   [100];

 int Sleep   = 0;
 int debug   = 0;
 int zooming = 0;
 int input_is_stdin = 0;

 int gargc;
 char **gargv;

 FILE *fx,*fy;
 double alarmper = ALARMPER;
 static char font_name [100];
/**************************************/
main (argc,argv)
 int argc;
 char **argv;
{
 gargc = argc;
 gargv = argv;

 prolog ();
 setxyo ();

 if (device == SCREEN) xplot ();
 else   hcopyb ();
 return (0);
} /* main */
/**************************************/
myalarm (t)
 double t;
{
 extern void handler ();
 struct itimerval rttimer;
 struct itimerval old_rttimer;

 if(debug)(void)fprintf(stderr,"myalarm called\n");

 (void) signal (SIGALRM,handler);
 rttimer.it_value.tv_sec     = (int)t;
 rttimer.it_value.tv_usec    = (int)(1E6*(t-(int)t));
 rttimer.it_interval.tv_sec  = 0;
 rttimer.it_interval.tv_usec = 0;

 (void)setitimer (ITIMER_REAL, &rttimer, &old_rttimer);
 if(debug)(void)fprintf(stderr,"myalarm O.K.\n");
} /* myalarm */
/*********************************************/
void handler ()
{
 if (infiles == 1) prolong1 ();
 else              prolong2 ();

 myalarm (alarmper);
} /* handler */
/**************************************/
prolong1 ()
{
 long datalyold = dataly;
 long i;
 int greater = 0;

 readdatay ();
 if (dataly > datalyold) {
  if (dataly > dataax) {
   allocdata (&x,dataax *= 2);
   greater = 1;
   gxmax  = dataax;
  };
  for (i=datalx;i<dataly;i++) x[i] = i;
  datalx = dataly;
  datal  = dataly;
  datal0 = dataly;
  datal2 = dataly - 1;
  if (greater)  refreshwin ();
  else  refreshwin2 ();
 };
} /* prolong1 */
/**************************************/
prolong2 ()
{
 long datalold = datal;

 readdatax ();
 readdatay ();

 if (datalx < dataly) datal = datalx;
 else                 datal = dataly;

 if (datal > datalold) {
  datal2 = datal-1;
  refreshwin2 ();
  datal0 = datal;
 };
} /* prolong2 */
/**************************************/
readdatax ()
{
 static char s[1000];
 static int i = 0;
 double w;

 if(debug)(void)fprintf(stderr,"readdatax called\n");
 while (myread(fx,&w,s,&i)) {
  if (datalx >= dataax) allocdata (&x,dataax*=2);
  x[datalx++] = w;
 };
 if(debug)(void)fprintf(stderr,"readdatax O.K.\n");
} /* readdatax */
/**************************************/
readdatay ()
{
 static char s[1000];
 static int i = 0;
 double w;

 if(debug)(void)fprintf(stderr,"readdatay called\n");
 while (myread(fy,&w,s,&i)) {
  if (dataly >= dataay) allocdata (&y,dataay*=2);
  y[dataly++] = w;
 };
 if(debug)(void)fprintf(stderr,"readdatay O.K.\n");
} /* readdata */
/**************************************/
readdata0 ()
{
 double wx,wy;
 long i=0;

 if(debug)(void)fprintf(stderr,"readdata0 called\n");

 while (
  (void) scanf ("%lf",&wx),
  1 ==   scanf ("%lf",&wy)) {

 if (i >= dataax) {
  allocdata (&x,dataax*=2);
  allocdata (&y,dataax*=2);
 };

 x[i  ] = wx;
 y[i++] = wy;

 }  /* while */
 datal  = i;
 datalx = i;
 dataly = i;
} /* readdata0 */
/**************************************/
myread (f,w,s,i)
 FILE *f;
 double *w;
 char *s;
 int *i;
{
 int c;

# define g ((c=getc (f)) != EOF)
# define b (c == ' ' || c == '\t' || c == '\n')

 if (*i == 0) {
  while (g && b);
  if (c!=EOF) s[(*i)++]=c;
 };
 while (g && !b) s[(*i)++]=c;
 if (c!=EOF) {
  s[(*i)]=' ';
  *i = 0;
  if (sscanf (s,"%lf",w) != 1) {
   (void) fprintf (stderr,
    "\nerror in %s : reading %s in input file \n",
    gargv[0], s);
   exit (-1);
  };
  return (1);
 } else return (0);
# undef g
# undef b
} /* myread */
/**************************************/
o(s)
char* s;
{
 if (debug) (void) fprintf (stderr,"%s\n",s);
}
/**************************************/
xplot ()
{
 XEvent report;
 char buffer [ MAX_MAPPED_STRING_LENGTH];
 int bufsize = MAX_MAPPED_STRING_LENGTH;
 KeySym keysym;
/*
 XComposeStatus compose;
*/
 o("xplot called");
 openG ();
 prepbuttons ();

 while (1) {

  if (!zooming && alarmper > 0) myalarm (alarmper);

  XNextEvent (display, &report);

  if (alarmper > 0) myalarm (0.0);

  switch (report.type) {
/*----------------------------------------*/
  case  Expose :

   o("Expose");
   while (XCheckTypedEvent(display,Expose,&report));
   drawwin ();
   break; /* Expose */
/*----------------------------------------*/
  case  ConfigureNotify :

   o("ConfigureNotify");
   width  = report.xconfigure.width;
   height = report.xconfigure.height;
   if (debug) (void)fprintf (stderr,"width  = %d \n",width);
   if (debug) (void)fprintf (stderr,"height = %d \n",height);

   break; /* ConfigureNotify */
/*----------------------------------------*/
  case  ButtonPress:

   o("ButtonPress");
   { Window w = report.xbutton.window;
    if     (w==winM           ){o("winM     ");beginzoom(&report);}
    else if(w==wins[WinQuit  ]){o("WinQuit  ");closeG          ();}
    else if(w==wins[WinAbout ]){o("WinAbout ");makeabout       ();}
    else if(w==wins[WinOrig  ]){o("WinOrig  ");makeorig        ();}
    else if(w==wins[WinUnzoom]){o("WinUnzoom");makeunzoom      ();}
    else if(w==wins[WinLive  ]){o("WinLive  ");cSleep          ();}
    else if(w==wins[WinHcopy ]){o("WinHcopy ");hcopyi          ();}
    else if(w==wins[WinLine  ]){o("WinLine  ");makeline (&report);}
    else if(w==wins[WinW     ]){o("WinW     ");makew    (&report);}
    else if(w==wins[Win1     ]){o("Win1     ");make1    (&report);}
    else if(w==wins[Win2     ]){o("Win2     ");make2    (&report);}
   };
   break; /* ButtonPress */
/*--------------------------------------------------*/
  case KeyPress:

   o("KeyPress");
   if (report.xkey.window == winM) {
    XLookupString
     ((XKeyEvent*)&report,buffer,bufsize,&keysym,
       (XComposeStatus*)NULL /* &compose */);
    {
     int w = buffer[0];
     if (w==3 || w==4 || w=='q' || w=='Q') closeG();
    };
   };
   break; /* KeyPress */
/*----------------------------------------*/
  case  ButtonRelease:

   o("ButtonRelease");

   if (debug) {
    Window w = report.xbutton.window;

    if     (w==winM           ){o("winM     ");}
    else if(w==wins[WinQuit  ]){o("WinQuit  ");}
    else if(w==wins[WinAbout ]){o("WinAbout ");}
    else if(w==wins[WinOrig  ]){o("WinOrig  ");}
    else if(w==wins[WinUnzoom]){o("WinUnzoom");}
    else if(w==wins[WinLive  ]){o("WinLive  ");}
    else if(w==wins[WinHcopy ]){o("WinHcopy ");}
    else if(w==wins[WinLine  ]){o("WinLine  ");}
    else if(w==wins[WinW     ]){o("WinW     ");}
    else if(w==wins[Win1     ]){o("Win1     ");}
    else if(w==wins[Win2     ]){o("Win2     ");}
   };

   if (report.xbutton.window == winM) endzoom (&report);
   break; /* ButtonRelease */
/*----------------------------------------*/
  case  MotionNotify:

   o("MotionNotify");

   if (report.xbutton.button==Button3) MotionBut3 (&report);
   else if (zooming) {

    if ((abs(ixp-ixt)>dp)&&(abs(iyp-iyt)>dp))
     XDrawRectangle (display,winM,gcx,(ixp<ixt?ixp:ixt),
                                      (iyp<iyt?iyp:iyt),
       (unsigned)abs(ixt-ixp),(unsigned)abs(iyp-iyt));
    ixt = report.xmotion.x;
    iyt = report.xmotion.y;
    if ((abs(ixp-ixt)>dp)&&(abs(iyp-iyt)>dp))
     XDrawRectangle (display,winM,gcx,(ixp<ixt?ixp:ixt),
                                       (iyp<iyt?iyp:iyt),
       (unsigned)abs(ixt-ixp),(unsigned)abs(iyp-iyt));
   };
   break; /* MotionNotify */
/*----------------------------------------*/
  case KeyRelease      : o(" KeyRelease       "); break;
  case EnterNotify     : o(" EnterNotify      "); break;
  case LeaveNotify     : o(" LeaveNotify      "); break;
  case FocusIn         : o(" FocusIn          "); break;
  case FocusOut        : o(" FocusOut         "); break;
  case KeymapNotify    : o(" KeymapNotify     "); break;
  case GraphicsExpose  : o(" GraphicsExpose   "); break;
  case NoExpose        : o(" NoExpose         "); break;
  case VisibilityNotify: o(" VisibilityNotify "); break;
  case CreateNotify    : o(" CreateNotify     "); break;
  case DestroyNotify   : o(" DestroyNotify    "); break;
  case UnmapNotify     : o(" UnmapNotify      "); break;
  case MapNotify       : o(" MapNotify        "); break;
  case MapRequest      : o(" MapRequest       "); break;
  case ReparentNotify  : o(" ReparentNotify   "); break;
  case ConfigureRequest: o(" ConfigureRequest "); break;
  case GravityNotify   : o(" GravityNotify    "); break;
  case ResizeRequest   : o(" ResizeRequest    "); break;
  case CirculateNotify : o(" CirculateNotify  "); break;
  case CirculateRequest: o(" CirculateRequest "); break;
  case PropertyNotify  : o(" PropertyNotify   "); break;
  case SelectionClear  : o(" SelectionClear   "); break;
  case SelectionRequest: o(" SelectionRequest "); break;
  case SelectionNotify : o(" SelectionNotify  "); break;
  case ColormapNotify  : o(" ColormapNotify   "); break;
  case ClientMessage   : o(" ClientMessage    "); break;
  case MappingNotify   : o(" MappingNotify    "); break;
  case LASTEvent       : o(" LASTEvent        "); break;
  default:
    if (debug) (void)fprintf (stderr,"? report.type %d\n",report.type);
/*----------------------------------------*/
  } /* switch */
 }  /* while  */
}   /* xplot   */
/*******************************************/
prolog ()
{
 int i;
 extern double valf ();
 int p = 0;
 char *s;

 for (i=1;i<gargc;i++)
  if (gargv[i][0]=='-') {
   inflags++;
   switch (gargv[i][1]) {
/*-------------------------------------------*/
   case 'b' :
    device = PS;
    break;
/*-------------------------------------------*/
   case 'H' :
    help();
    break;
/*-------------------------------------------*/
   case 'h' :
    instruction();
    break;
/*-------------------------------------------*/
   case 'd' :
    debug = 1;
    break;
/*-------------------------------------------*/
   case 'D' :
    debug = 2;
    break;
/*-------------------------------------------*/
   case 't' :
    if(gargv[i][2]==0)s=gargv[++i];else s=gargv[i]+2;
    strcpy (Header,s);
    break;
/*-------------------------------------------*/
   case 'l' :
    if(gargv[i][2]==0)s=gargv[++i];else s=gargv[i]+2;
    conect = vali (s);
    if ((conect < 0)||(conect >= maxconect)) conect = 1;
    break;
/*-------------------------------------------*/
   case 'f' :
    if(gargv[i][2]==0)s=gargv[++i];else s=gargv[i]+2;
    strcpy (hname,s);
    break;
/*-------------------------------------------*/
   case 'p' :
    if(gargv[i][2]==0)s=gargv[++i];else s=gargv[i]+2;
    alarmper = valf (s);
    if (alarmper < 0) alarmper = 0;
    break;
/*-------------------------------------------*/
   case 'F' :
    if(gargv[i][2]==0)s=gargv[++i];else s=gargv[i]+2;
    strcpy (font_name,s);
    break;
/*-------------------------------------------*/
   case 'g' :
    if(gargv[i][2]==0)s=gargv[++i];else s=gargv[i]+2;
    p = sscanf (s,"%ux%u+%d+%d",
       &geom_w,&geom_h,&geom_x,&geom_y);
    if (p == 4) geom_specified = 1;
    break;
/*-------------------------------------------*/
   case NULL :
    input_is_stdin = 1;
    break;
/*-------------------------------------------*/
   default :
    (void)fprintf(stderr,"%s error : unknown option \n\n",gargv[0]);
    instruction ();
    break;
/*-------------------------------------------*/
   } /* switch */
  }
  else {
   infiles++;
   if (infile1==0) infile1=i; else infile2=i;
  };

 if(debug) {
  (void)fprintf(stderr,"gargc          = %d \n",gargc);
  (void)fprintf(stderr,"input_is_stdin = %d \n",input_is_stdin);
  (void)fprintf(stderr,"infiles        = %d \n",infiles);
  (void)fprintf(stderr,"inflags        = %d \n",inflags);
 };

 if      (input_is_stdin) paction0 ();
 else if (infiles == 1)   paction1 ();
 else if (infiles == 2)   paction2 ();
 else instruction ();

 if (datal==0) {
  (void)fprintf (stderr,"error in %s : input file empty\n",
         gargv[0]);
  exit (1);
 };

 if(debug)(void)fprintf(stderr,"datal = %ld\n",datal);

 if(debug)(void)fprintf(stderr,"prolog O.K.\n");
} /* prolog */
/*******************************************/
/* 456 10 123456 20 123456 30 123456 40 123456 50 123456 60 123456 70 1234*/
instruction ()
{
fprintf(stderr,"\n");
fprintf(stderr,"usage   : %s filex filey \n",gargv[0]);
fprintf(stderr,"  or      %s file  (x = 0,1,2,...)\n",gargv[0]);
fprintf(stderr,"  or      %s -     (data are read from stdin, each x-value followed by one y-value)\n\n",gargv[0]);

fprintf(stderr,"purpose : to plot Your data \n\n");

fprintf(stderr,"options : \n");
fprintf(stderr,"(each option must be preceded by one '-' sign) \n");
fprintf(stderr," -h        first help \n");
fprintf(stderr," -H        second help \n");
fprintf(stderr," -b        batch run to make a hardcopy silently\n",
  gargv[0]);
fprintf(stderr," -t\"Title of the picture\" \n",gargv[0]);
fprintf(stderr," -ln       to set line type to n=0..5 (default 1)\n");
fprintf(stderr," -f\"hardcopyfilename\"  ( default hcopy0.ps )\n");
fprintf(stderr," -pn       to set followperiod to n seconds (0 = off)\
 (default %d)\n", ALARMPER);
fprintf(stderr,"           this allows You to watch growing datafiles \
 once in n seconds (n can be noninteger)\n");
fprintf(stderr,"           like tail -f  \n");
fprintf(stderr," -F FontName (default 10x20)\n");
fprintf(stderr," -g WIDTHxHEIGHT+Xoffset+Yoffset \
 to specify the geometry of the main window\n");
fprintf(stderr," -d        for debug mode (prints messages to stderr)\n");
fprintf(stderr," -D        more detailed than d                      \n");

fprintf(stderr,"\nversion %s\n",VERSION);
fprintf(stderr,"Author : Pavel.Pokorny@vscht.cz\n");
fprintf(stderr,"(Pavel POKORNY,\
 Prague Institute of Chemical Technology)\n\n");
exit (1);
} /* instruction */
/*******************************************/
/* 456 10 123456 20 123456 30 123456 40 123456 50 123456 60 123456 70 1234*/
help ()
{
printf("type %s -h for syntax, options and author \n\n",gargv[0]);
printf("input data format : text file \n");
printf("separators : blanks (space,tab,new/line) \n\n");

printf("value -0.3737 in your data works as a line breaker \n");
printf("value -0.373710 .. -0.373715 sets the line type to 0..5 \n\n");

printf("window  button      function \n\n");

printf("Quit    any button  terminate the session \n");
printf("About   any button  about the author \n");
printf("Orig    any button  get the original configuration \n");
printf("Unzoom  any button  get the previous scope after using zoom \n");
printf("                     (to zoom a detail \n");
printf("                      1. press any button \n");
printf("                         in the plot (large) window \n");
printf("                         to mark one corner of the detail \n");
printf("                      2. move the pointer to the opposite \n");
printf("                         corner of the detail \n");
printf("                      3. release the button \n");
printf("                      if You omit step 2. \n");
printf("                       x and y coordinates of the point \n");
printf("                       are printed to the standard output \n");
printf("                       (can be redirected to file dady) \n");
printf("                        by  %s datafile(s) > dady   ) \n",gargv[0]);
/* 456 10 123456 20 123456 30 123456 40 123456 50 123456 60 123456 70 1234*/
printf("Live   any button     toggle between Live and Sleep \n");
printf("                       state of the picture \n");
printf("                      make it Sleep to avoid slow redrawing \n");
printf("                       while reconfiguring large data \n");
printf("Hcopy  any button     store the picture to the file hcopy0.ps \n");
printf("Line   button 1       change the line type (increment) \n");
printf("       button 2                            (decrement) \n");
printf("w=0                   change window length\
 for attractor reconstruction\n");
printf("                       from time series \n");
printf("                       Yn+w  vs Yn          for w>0 \n");
printf("                       Yn+2w vs Yn+w and Yn for w<0 \
using color for 3rd coordinate\n");
printf("       button 1       1 step up \n");
printf("       button 2       1 step down \n");
printf("       button 1 while holding down button 3 - \
make the step 10*larger\n");
printf("       button 2 while holding down button 3 - \
make the step 10*smaller\n");
printf("last 2 windows : choose the first and the last point \n");
printf("                  from your data to be plotted \n");
printf("        use buttons 1,2,3 as in window w=0 \n");
exit (1);
} /* help */
/*******************************************/
paction1 ()
{
 long i;
 double xmin,xmax,ymin,ymax;

 if(debug)(void)fprintf(stderr,"paction1 called\n");

 if (!Header[0]) {
  strcpy (Header,"Plot of ");
  strcat (Header,gargv[infile1]);
 };
 ppopenr (&fy,gargv[infile1]);

 allocdata (&y,dataay);

 readdatay ();
 datalx = dataly;
 datal  = dataly;
 datal0 = dataly;
 datal2 = dataly - 1;
 dataax = dataly;
 allocdata (&x,dataax);

 for (i=0;i<datal;i++) x[i] = i;

 xmin = 0;
 xmax = datal - 1;
 minmax (y,datal,&ymin,&ymax);
 strcpy (Header0,Header);

 setxmin (xmin);
 setxmax (xmax);
 setymin (ymin);
 setymax (ymax);
 if(debug)(void)fprintf(stderr,"paction1 O.K.\n");
} /* paction1 */
/*******************************************/
paction2 ()
{
 double xmin,xmax,ymin,ymax;

 if(debug)(void)fprintf(stderr,"paction2 called\n");
 if (!Header[0]) {
  strcpy (Header,"Plot of ");
  strcat (Header,gargv[infile2]);
  strcat (Header," vs ");
  strcat (Header,gargv[infile1]);
 };
 ppopenr (&fx,gargv[infile1]);
 ppopenr (&fy,gargv[infile2]);

 allocdata (&x,dataax);
 allocdata (&y,dataay);

 readdatax ();
 readdatay ();
 if (datalx < dataly) datal = datalx;
 else                 datal = dataly;
 datal0 = datal;
 datal2 = datal-1;

 minmax (x,datal,&xmin,&xmax);
 minmax (y,datal,&ymin,&ymax);

 strcpy (Header0,Header);

 setxmin (xmin);
 setxmax (xmax);
 setymin (ymin);
 setymax (ymax);
 if(debug)(void)fprintf(stderr,"paction2 O.K.\n");
} /* paction2 */
/*******************************************/
paction0 ()
{
 double xmin,xmax,ymin,ymax;

 if(debug)(void)fprintf(stderr,"paction0 called\n");
 if (!Header[0]) {
  strcpy (Header,"Plot of stdin");
 };

 allocdata (&x,dataax);
 allocdata (&y,dataay);

 readdata0 ();

 if (datalx < dataly) datal = datalx;
 else                 datal = dataly;
 datal0 = datal;
 datal2 = datal-1;

 minmax (x,datal,&xmin,&xmax);
 minmax (y,datal,&ymin,&ymax);

 strcpy (Header0,Header);

 setxmin (xmin);
 setxmax (xmax);
 setymin (ymin);
 setymax (ymax);
 if(debug)(void)fprintf(stderr,"paction2 O.K.\n");
} /* paction0 */
/*******************************************/
action ()
{
 long i;
 double xx,yy;
 int  AfterSep = 1;
 int origc = conect;

 if(debug)(void)fprintf(stderr,"action called\n");
 for (i=datal1; i<=datal2; i++) {
  xx = x[i];
  yy = y[i];
  if      (fabs (yy-sep )<eps){AfterSep=1;conect=origc;}
  else if (fabs (yy-sep0)<eps){AfterSep=1;conect=0;}
  else if (fabs (yy-sep1)<eps){AfterSep=1;conect=1;}
  else if (fabs (yy-sep2)<eps){AfterSep=1;conect=2;}
  else if (fabs (yy-sep3)<eps){AfterSep=1;conect=3;}
  else if (fabs (yy-sep4)<eps){AfterSep=1;conect=4;}
  else if (fabs (yy-sep5)<eps){AfterSep=1;conect=5;}
  else {
   if (AfterSep) movetoG (xx,yy);

   switch (conect) {
   case 0: pointG  (xx,yy); break;
   case 1: if (!AfterSep) linetoG (xx,yy); break;
   case 2: squareG (xx,yy); break;
   case 3: if (!AfterSep) linetoG (xx,yy); squareG (xx,yy); break;
   case 4: crossG  (xx,yy); break;
   case 5: if (!AfterSep) linetoG (xx,yy); crossG (xx,yy); break;
   default: er ("unknown conect");
   };
   AfterSep = 0;

  };
 };
 conect = origc;
 if(debug)(void)fprintf(stderr,"action O.K.\n");
} /* action */
/*******************************************/
actionr ()
{
 int i,c;
 double xx,yy,zz;
 int awl = abs (wl);

 if(debug)(void)fprintf(stderr,"actionr called\n");
 if (!colorsready) prepcolors();

 rainbow ();
 for (i=datal1;i<=datal2-awl;i++) {
  xx = x [i];
  yy = x [i+awl];
  zz = x [i+2*awl];
  c = round ((zz-gymino)/(gymaxo-gymino) * (ncolors-1));
  cpointG (xx,yy,c);
 };
 if(debug)(void)fprintf(stderr,"actionr O.K.\n");
} /* actionr */
/*******************************************/
rainbow ()
{
 int i,i1,i2,k,k1,k2,c;
 double xx,yy;

 if(debug)(void)fprintf(stderr,"rainbow called\n");
 i1 = round (width * (1-Globx2)) + 2;
 i2 = width - 2;
 k1 = round (height * (1-Globy1));
 k2 = round (height *    Globy2 );

 for (i=i1;i<=i2;i++)
 for (k=k1;k>=k2;k--) {
  xx = (i-qx)/kx;
  yy = (k-qy)/ky;
  c = round ((double)(k1-k) / (k1-k2) * (ncolors-1));
  cpointG (xx,yy,c);
 };
 if(debug)(void)fprintf(stderr,"rainbow O.K.\n");
} /* rainbow */
/*******************************************/
setxmin (wx) double wx; { gxmin = wx;}
setxmax (wx) double wx; { gxmax = wx;}
setymin (wx) double wx; { gymin = wx;}
setymax (wx) double wx; { gymax = wx;}

setxyo () {
 gxmino = gxmin;
 gxmaxo = gxmax;
 gymino = gymin;
 gymaxo = gymax;
} /* setxy0 */
/*******************************************/
openG ()
{
 unsigned int   ch_mask;
 XWindowChanges ch_value;

 if(debug)(void)fprintf(stderr,"openG called\n");

 if ((display = XOpenDisplay(getenv("DISPLAY"))) == NULL) {
  (void)fprintf (stderr,
    "%s : cannot open to X server %s\n",
    gargv[0], XDisplayName(getenv("DISPLAY")));
  exit (-1);
 }
 screen    = DefaultScreen (display);
 display_w = DisplayWidth  (display,screen);
 display_h = DisplayHeight (display,screen);
 if (geom_specified) {
  width     = geom_w;
  height    = geom_h;
 } else {
  width     = display_w / 2;
  height    = display_h / 2;
 };
 winM = XCreateSimpleWindow (display,
         RootWindow(display,screen),
         0,0,width,height,border_width,
         WhitePixel(display,screen),
         BlackPixel(display,screen));
 size_hints.flags = 0;
 XSetStandardProperties (display,winM,gargv[0],gargv[0],
   NULL, gargv,gargc, &size_hints);
 XSelectInput (display,winM, ExposureMask
                           | StructureNotifyMask
                           | ButtonPressMask
                           | ButtonReleaseMask
                           | KeyPressMask
                           | ButtonMotionMask);
 load_font (&font_info);
 get_GC (winM,&gc ,font_info);
 get_GC (winM,&gcx,font_info);
 XSetFunction (display,gcx,GXxor);
 XMapWindow (display,winM);

 if (geom_specified) {
  ch_value.x      = geom_x;
  ch_value.y      = geom_y;
  ch_value.width  = geom_w;
  ch_value.height = geom_h;
  ch_mask =  CWX|CWY|CWWidth|CWHeight;
  XConfigureWindow (display,winM,ch_mask,&ch_value);
 };

 if(debug)(void)fprintf(stderr,"openG O.K.\n\n");
} /* openG */
/*******************************************/
prepbuttons ()
{
 int i;

 win_h =     font_height + 4;
 win_w = 6 * font_width  + 4;
 orx     = 2;
 ory     = 2;

 if(debug)(void)fprintf(stderr,"prepbuttons called\n");
 for (i=0; i<NWINS; i++) {
  wins [i] = XCreateSimpleWindow (display,winM,orx,ory,
         win_w,win_h, border_width,
         WhitePixel (display,screen),
         BlackPixel (display,screen));
  XSelectInput(display,wins[i],ExposureMask|ButtonPressMask);
  XMapWindow (display,wins[i]);
  ory += win_h + 2 * border_width + 4;
 };
 if (infiles == 2)  XUnmapWindow (display,wins[WinW]);
 if(debug)(void)fprintf(stderr,"prepbuttons O.K.\n");
} /* prepbuttons */
/*******************************************/
prepcolors ()
{
 int depth = DisplayPlanes (display,screen);
 Visual *visual;
 int c;

 if(debug)(void)fprintf(stderr,"prepcolors called\n");
 if (!colorsready) {
  if (depth == 1) er (" depth = 1, no color on monochrome");
  visual = DefaultVisual (display,screen);
  c = visual->class;
  if (c==GrayScale) prepgrays ();
  else if ((c==PseudoColor)||(c==DirectColor))
   preprealcolors ();
  else er ("cannot allocate colors, read-only visual");
  colorsready = 1;
 };
 if(debug)(void)fprintf(stderr,"prepcolors O.K.\n");
} /* prepcolors */
/*******************************************/
prepgrays ()
{
 Colormap cmap = DefaultColormap (display,screen);
 XColor c;
 unsigned short intens,maxintens = 65535;
 int i=0;
 int status;

 if(debug)(void)fprintf(stderr,"prepgrays called\n");
 do {
  intens=(unsigned short)((maxintens+1)*(double)i/MAXCOLORS);
  c.red   = intens;
  c.green = intens;
  c.blue  = intens;
  status  = XAllocColor (display,cmap,&c);

  if (status == 1) {
   get_GC (winM,&(cgc[i]),font_info);
   XSetForeground (display,cgc[i],c.pixel);
   i++;
  };
 } while ((i<MAXCOLORS) && (status == 1));
 ncolors = i;
 if(debug)(void)fprintf(stderr,"%d grays allocated \n",ncolors+1);
 if(debug)(void)fprintf(stderr,"prepgrays O.K.\n");
} /* prepgrays */
/*******************************************/
preprealcolors ()
{
 Colormap cmap = DefaultColormap (display,screen);
 XColor c;
 unsigned short intens,maxintens = 65535;
 int i=0,imin,imax;
 int status=1;

 if(debug)(void)fprintf(stderr,"preprealcolors called\n");
 imin = 0;
 imax = MAXCOLORS / 2;

 for (i=imin; (i<imax) && status; i++) {
  intens  = (unsigned short)
            ((double)(maxintens+1)*(i-imin)/(imax-imin));
  c.red   = intens;
  c.green = 0;
  c.blue  = maxintens-intens;
  status  = XAllocColor (display,cmap,&c);

  if (status == 1) {
   get_GC (winM,&(cgc[i]),font_info);
   XSetForeground (display,cgc[i],c.pixel);
  };
/* printf ("%6d %6d %6d %6d %6d %6d \n",
i,status,c.red,c.green,c.blue,c.pixel);
*/
 };
 imin = imax;
 imax = 2 * imax;
 for (i=imin; (i<imax) && status; i++) {
  intens  = (unsigned short)
            ((double)(maxintens+1)*(i-imin)/(imax-imin));
  c.red   = maxintens-intens;
  c.green = intens;
  c.blue  = 0;
  status  = XAllocColor (display,cmap,&c);

  if (status == 1) {
   get_GC (winM,&(cgc[i]),font_info);
   XSetForeground (display,cgc[i],c.pixel);
  };
 };
 ncolors = i-1;
/* printf ("ncolors = %d \n",ncolors); */
 if(debug)(void)fprintf(stderr,"%d colors allocated \n",ncolors+1);
 if(debug)(void)fprintf(stderr,"preprealcolors O.K.\n");
} /* preprealcolors */
/*******************************************/
WriteButtons ()
{
 char sL[10],sW[10],s1[10],s2[10];
 int wx = 2,
     wy = font_info->max_bounds.ascent + 2,
     i;

 if(debug)(void)fprintf(stderr,"WriteButtons called\n");
 sprintf (sL,"Line%1d",conect);
 sprintf (sW,"w=%1d",wl);
 sprintf (s1,"%1d",datal1);
 sprintf (s2,"%1d",datal2);

 for (i=0; i< NWINS; i++) XClearWindow (display,wins[i]);
 XDrawString (display,wins[WinQuit  ],gc,wx,wy,"Quit  ",6);
 XDrawString (display,wins[WinAbout ],gc,wx,wy,"About ",6);
 XDrawString (display,wins[WinOrig  ],gc,wx,wy,"Orig  ",6);
 XDrawString (display,wins[WinUnzoom],gc,wx,wy,"Unzoom",6);
 if (Sleep)
 XDrawString (display,wins[WinLive  ],gc,wx,wy,"Sleep ",6);
 else
 XDrawString (display,wins[WinLive  ],gc,wx,wy,"Live  ",6);
 XDrawString (display,wins[WinHcopy ],gc,wx,wy,"Hcopy ",6);
 XDrawString (display,wins[WinLine  ],gc,wx,wy,sL,
   (int)strlen(sL));
 XDrawString (display,wins[WinW     ],gc,wx,wy,sW,
   (int)strlen(sW));
 XDrawString (display,wins[Win1     ],gc,wx,wy,s1,
   (int)strlen(s1));
 XDrawString (display,wins[Win2     ],gc,wx,wy,s2,
   (int)strlen(s2));
 if(debug)(void)fprintf(stderr,"WriteButtons O.K.\n");
} /* WriteButtons */
/*******************************************/
WriteButton2 ()
{
 char s2[10];
 int wx = 2,
     wy = font_info->max_bounds.ascent + 2;

 if(debug)(void)fprintf(stderr,"WriteButton2 called\n");
 sprintf (s2,"%1d",datal2);

 XClearWindow (display,wins[Win2]);
 XDrawString (display,wins[Win2     ],gc,wx,wy,s2,
   (int)strlen(s2));
 if(debug)(void)fprintf(stderr,"WriteButton2 O.K.\n");
} /* WriteButton2 */
/*******************************************/
get_GC (lwin,agc,lfont_info)
 Window lwin;
 GC *agc;
 XFontStruct *lfont_info;
{
 unsigned long valuemask = 0;
 XGCValues values;

 if(debug)(void)fprintf(stderr,"get_GC called\n");
 *agc = XCreateGC (display,lwin,valuemask,&values);
 XSetFont (display,*agc,(Font)(lfont_info->fid));
 XSetForeground (display,*agc,WhitePixel(display,screen));
 if(debug)(void)fprintf(stderr,"get_GC O.K.\n");
} /* get_GC */
/******************************************/
printfontpath ()
{
 int i,n;
 char **p;
/* 456 10 123456 20 123456 30 123456 40 123456 50 123456 60 123456 70 1234*/
 p = XGetFontPath (display,&n);

 (void)fprintf(stderr,"\nFontPath = \n\n");
 for (i=0;i<n;i++) (void) fprintf (stderr,"%s \n",p[i]);
 (void) fprintf(stderr, "\n");
 (void) fprintf(stderr, "use xset to change it \n");
 (void) fprintf(stderr, "or use -F option to set Your choice for font\n");
 (void) fprintf(stderr, "in the misc directory \n");
 (void) fprintf(stderr, "I would expect a file fonts.alias\n\n");

} /* printfontpath */
/******************************************/
load_font (lfont_info)
 XFontStruct **lfont_info;
{

 if(debug)(void)fprintf(stderr,"load_font called\n");

 if ((*lfont_info = XLoadQueryFont (display,font_name))==NULL)
   if ((*lfont_info = XLoadQueryFont (display,FONT_NAME1))==NULL)
    if ((*lfont_info = XLoadQueryFont (display,FONT_NAME2))==NULL) {

     (void)fprintf(stderr,
      "%s : cannot open font %s nor font %s nor font %s\n",
      gargv[0],font_name,FONT_NAME1,FONT_NAME2);
     printfontpath ();
     exit (-1);
    };
 font_height = (*lfont_info)->max_bounds.ascent +
               (*lfont_info)->max_bounds.descent;
 font_width  = (*lfont_info)->max_bounds.width;
 if(debug)(void)printfontpath ();
 if(debug)(void)fprintf(stderr,"load_font O.K.\n");
} /* load_font */
/******************************************/
round (wx) double wx; {return ((int)(wx+0.5));}
/******************************************/
ScreenTransform (wx,wy,ix,iy)
 double wx,wy;
 int *ix,*iy;
{
 double ScreenMax = 16300;

 wx = kx * wx + qx;
 wy = ky * wy + qy;
 if (wx >  ScreenMax) wx =  ScreenMax;
 if (wx < -ScreenMax) wx = -ScreenMax;
 if (wy >  ScreenMax) wy =  ScreenMax;
 if (wy < -ScreenMax) wy = -ScreenMax;
 *ix = round (wx);
 *iy = round (wy);
} /* ScreenTransform */
/******************************************/
PSTransform (wx,wy,wwx,wwy)
 double wx,wy,*wwx,*wwy;
{
 *wwx =     (kx * wx + qx) / width ;
 *wwy = 1 - (ky * wy + qy) / height;
} /* PSTransform */
/******************************************/
textG (wx,wy,s)
 double wx,wy;
 char *s;
{
 int ix,iy;
 double wwx,wwy;

 switch (device) {
  case SCREEN:
   ScreenTransform (wx,wy,&ix,&iy);
   XDrawString (display,winM,gc,ix,iy,s,(int)strlen(s));
   break;
  case PS:
   PSTransform (wx,wy,&wwx,&wwy);
   fprintf (fhcopy,"%G %G moveto ",wwx,wwy);
   fprintf (fhcopy,"(%s) show\n",s);
   break;
 };
} /* textG */
/******************************************/
pointG (wx,wy)
 double wx,wy;
{
 int ix,iy;
 double wwx,wwy;

 switch (device) {
  case SCREEN:
   ScreenTransform (wx,wy,&ix,&iy);
   XDrawPoint (display,winM,gc,ix,iy);
   break;
  case PS:
   PSTransform (wx,wy,&wwx,&wwy);
   fprintf (fhcopy,"%G %G P\n",wwx,wwy);
   break;
 };
} /* pointG */
/******************************************/
cpointG (wx,wy,c)
 double wx,wy;
 int c;
{
 int ix,iy;

 ScreenTransform (wx,wy,&ix,&iy);
 if (c<0) c=0;
 if (c>=ncolors) c = ncolors-1;

 XDrawPoint (display,winM,cgc[c],ix,iy);
} /* cpointG */
/******************************************/
crossG (wx,wy)
 double wx,wy;
{
 int ix,iy,d=2;
 double wwx,wwy;

 switch (device) {
  case SCREEN:
   ScreenTransform (wx,wy,&ix,&iy);
   XDrawLine (display,winM,gc,ix-d,iy  ,ix+d,iy  );
   XDrawLine (display,winM,gc,ix  ,iy-d,ix  ,iy+d);
   break;
  case PS:
   PSTransform (wx,wy,&wwx,&wwy);
   fprintf (fhcopy,"%G %G C\n",wwx,wwy);
   break;
 };
} /* crossG */
/******************************************/
squareG (wx,wy)
 double wx,wy;
{
 int ix,iy,d=2;
 double wwx,wwy;

 switch (device) {
  case SCREEN:
   ScreenTransform (wx,wy,&ix,&iy);
   XDrawLine (display,winM,gc,ix-d,iy-d,ix+d,iy-d);
   XDrawLine (display,winM,gc,ix+d,iy-d,ix+d,iy+d);
   XDrawLine (display,winM,gc,ix+d,iy+d,ix-d,iy+d);
   XDrawLine (display,winM,gc,ix-d,iy+d,ix-d,iy-d);
   break;
  case PS:
   PSTransform (wx,wy,&wwx,&wwy);
   fprintf (fhcopy,"%G %G S\n",wwx,wwy);
   break;
 };
} /* squareG */
/******************************************/
movetoG (wx,wy)
 double wx,wy;
{ gx = wx; gy = wy;
/*

 double wwx,wwy;

 switch (device) {
  case SCREEN:
   gx = wx;
   gy = wy;
   break;
  case PS:
   PSTransform (wx,wy,&wwx,&wwy);
   fprintf (fhcopy,"%G %G M\n",wwx,wwy);
   break;
 };
*/
} /* movetoG */
/******************************************/
lineG  (wx1,wy1,wx2,wy2)
 double wx1,wy1,wx2,wy2;
{
 int ix1,iy1,ix2,iy2;
 double wwx1,wwy1,wwx2,wwy2;

 switch (device) {
  case SCREEN:
   ScreenTransform (wx1,wy1,&ix1,&iy1);
   ScreenTransform (wx2,wy2,&ix2,&iy2);
   XDrawLine (display,winM,gc,ix1,iy1,ix2,iy2);
   movetoG (wx2,wy2);
   break;
  case PS:
   PSTransform (wx1,wy1,&wwx1,&wwy1);
   PSTransform (wx2,wy2,&wwx2,&wwy2);
   fprintf (fhcopy,"%G %G %G %G L\n",wwx1,wwy1,wwx2,wwy2);
   movetoG (wx2,wy2);
   break;
 };
} /* lineG */
/******************************************/
linetoG (wx,wy)
 double  wx,wy;
{
 lineG (gx,gy,wx,wy);
} /* linetoG */
/******************************************/
/*
linerelG (dx,dy)
 double dx,dy;
{
 lineG (gx,gy,gx+dx,gy+dy);
}
*/
 /* linerelG */
/******************************************/
rectangleG (wx1,wy1,wx2,wy2)
 double     wx1,wy1,wx2,wy2;
{
 lineG (wx1,wy1,wx2,wy1);
 lineG (wx2,wy1,wx2,wy2);
 lineG (wx2,wy2,wx1,wy2);
 lineG (wx1,wy2,wx1,wy1);
} /* rectangleG */
/******************************************/
closeG ()
{
 if(debug)(void)fprintf(stderr,"closeG called\n");
 XUnloadFont (display,font_info->fid);
 XFreeGC (display,gc);
 XFreeGC (display,gcx);
 XCloseDisplay (display);
 exit (1);
} /* closeG */
/**************************************/
cSleep ()
{
 Sleep = ! Sleep;
 drawwin ();
} /* cSleep */
/*******************************************/
MotionBut3 (areport)
 XEvent *areport;
{
 zooming = 0;
 ixt = areport->xmotion.x;
 iyt = areport->xmotion.y;
 XDrawPoint(display,winM,gcx,ixt,iyt);

 wxp = (ixt-qx)/kx;
 wyp = (iyt-qy)/ky;
 (void) printf ("%G    %G \n",wxp,wyp);
 (void) fflush (stdout);
} /* MotionBut3 */
/*******************************************/
beginzoom (areport)
 XEvent *areport;
{
 o("beginzoom called");
 if (zooming == 0) {
  zooming = 1;
  ixp = areport->xbutton.x;
  iyp = areport->xbutton.y;
  ixt = ixp;
  iyt = iyp;
  wxp = (ixp-qx)/kx;
  wyp = (iyp-qy)/ky;
 };
 o("beginzoom O.K.");
} /* beginzoom */
/*******************************************/
endzoom (areport)
 XEvent *areport;
{
 o("endzoom called");
 if (zooming == 1) {
  zooming  = 0;
  ixr = areport->xbutton.x;
  iyr = areport->xbutton.y;
  wxr = (ixr-qx)/kx;
  wyr = (iyr-qy)/ky;
  if ((abs(ixp-ixr)>dp)&&(abs(iyp-iyr)>dp)) {
   inchist ();
   gxmin = wxp;
   gxmax = wxr;
   gymin = wyp;
   gymax = wyr;
   if (gxmin>gxmax){double w=gxmin;gxmin=gxmax;gxmax=w;};
   if (gymin>gymax){double w=gymin;gymin=gymax;gymax=w;};
   drawwin ();
  }
  else { /* small displacement */
   if (areport->xbutton.button==Button1)
    (void) printf ("%G    %G ",wxp,wyp);
   (void) printf ("\n");
   (void) fflush (stdout);
  };
 }; /* if zooming */
 o("endzoom O.K.");
} /* endzoom */
/*******************************************/
makeunzoom ()
{
 o("makeunzoom called");
 if (nhist > 0) {
  nhist--;
  gxmin   =  hist [nhist].xmin;
  gxmax   =  hist [nhist].xmax;
  gymin   =  hist [nhist].ymin;
  gymax   =  hist [nhist].ymax;
  drawwin ();
 };
 o("makeunzoom O.K.");
} /* makeunzoom */
/*******************************************/
makeline (areport)
 XEvent *areport;
{
 int old = conect;

 if (areport->xbutton.button==Button1) conect++;
 if (areport->xbutton.button==Button2) conect--;
 if (conect >= maxconect) conect = 0;
 if (conect <  0         ) conect = maxconect-1;
 if (conect != old) drawwin ();
} /* makeline */
/*******************************************/
makew (areport)
 XEvent *areport;
{
 int c = DefaultVisual(display,screen) -> class;

 alarmper = 0;

 if ((areport->xbutton.state) & Button3Mask) {
  if (areport->xbutton.button==Button1) dwl *= 10;
  if (areport->xbutton.button==Button2) dwl /= 10;
  if (dwl < 1) dwl = 1;
 } else {
  if (areport->xbutton.button==Button1) wl += dwl;
  if (areport->xbutton.button==Button2) wl -= dwl;
 };

 if ( (wl < 0) && (
   (DisplayPlanes (display,screen) == 1) ||
   (c != GrayScale && c != PseudoColor && c != DirectColor)
 )) wl = 0;

 if (wl != owl) {
  if (wl == 0) makew0 ();
  else         Reconstr ();
 };
} /* makew */
/*******************************************/
make1 (areport)
 XEvent *areport;
{
 long old = datal1;

 if ((areport->xbutton.state) & Button3Mask) {
  if (areport->xbutton.button==Button1) ddatal1 *= 10;
  if (areport->xbutton.button==Button2) ddatal1 /= 10;
  if (ddatal1 < 1) ddatal1 = 1;
 } else {
  if (areport->xbutton.button==Button1) datal1 += ddatal1;
  if (areport->xbutton.button==Button2) datal1 -= ddatal1;
 };
 if (datal1 > datal2) datal1 = datal2;
 if (datal1 < 0L    ) datal1 = 0L;

 if (datal1 != old) drawwin ();

} /* make1 */
/*******************************************/
make2 (areport)
 XEvent *areport;
{
 long old = datal2;

 if ((areport->xbutton.state) & Button3Mask) {
  if (areport->xbutton.button==Button1) ddatal2 *= 10;
  if (areport->xbutton.button==Button2) ddatal2 /= 10;
  if (ddatal2 < 1) ddatal2 = 1;
 } else {
  if (areport->xbutton.button==Button1) datal2 += ddatal2;
  if (areport->xbutton.button==Button2) datal2 -= ddatal2;
 };
 if (datal2 < datal1 ) datal2 = datal1;
 if (datal2 > datal-1) datal2 = datal-1;

 if (datal2 != old) drawwin ();

} /* make2 */
/*******************************************/
drawwin ()
{
 if(debug)(void)fprintf(stderr,"drawwin called\n");
 if (device == SCREEN) WriteButtons ();

 if (!Sleep) {
  if (device == SCREEN) XClearWindow (display,winM);
  drawfullwin ();
 };
 if(debug)(void)fprintf(stderr,"drawwin O.K.\n\n");
} /* drawwin */
/*******************************************/
refreshwin ()
{
 int olddevice = device;

 device  = SCREEN;

 drawwin ();

 XFlush (display);

 device = olddevice;
} /* refreshwin */
/*******************************************/
refreshwin2 ()
{
 int olddevice = device;

 device  = SCREEN;

 WriteButton2 ();
 drawfullwin ();
 XFlush (display);

 device = olddevice;
} /* refreshwin2 */
/*******************************************/
#define Globx1  0.2
#define Globx2  0.05
#define Globy1  0.125
#define Globy2  0.125
/*******************************************/
drawfullwin ()
{
 double FrameX1 = 0,
        FrameX2 = 1,
        FrameY1 = 0,
        FrameY2 = 1,
        lmargin = FrameX1 + Globx1,
        bmargin = FrameY1 + Globy1,
        rmargin = FrameX2 - Globx2,
        tmargin = FrameY2 - Globy2,
        xl,xr,yl,yr,
        fw = (double)font_width  / width,
        fh = (double)font_height / height;

 int ndivx,ndivy,nddx,nddy;

 if(debug)(void)fprintf(stderr,"drawfullwin called\n");

 AxisParams (gxmin,gxmax,&xl,&xr,&ndivx,&nddx);
 AxisParams (gymin,gymax,&yl,&yr,&ndivy,&nddy);
 gxright  = xr;
 PrepWindow01 ();
 DrawAxes ( lmargin,bmargin,rmargin,tmargin,
           ndivx,nddx,ndivy,nddy,
           xl,xr,yl,yr,
           Header,fw,fh);
 PrepWindow (xl,xr,yl,yr,
             lmargin,rmargin,bmargin,tmargin);
 ClipOn (xl,xr,yl,yr);
 if (wl >= 0) action  ();
 else         actionr ();
 if (device == SCREEN) ClipOff ();

 if(debug)(void)fprintf(stderr,"drawfullwin O.K.\n");

} /* drawfullwin */
/*******************************************/
ClipOn (xl,xr,yl,yr)
 double xl,xr,yl,yr;
{
 int    ixl,ixrr,iyl,iyrr;
 double wxl,wxrr,wyl,wyrr;

 XRectangle r;

 switch (device) {
  case SCREEN:
   ScreenTransform (xl,yl,&ixl ,&iyl );
   ScreenTransform (xr,yr,&ixrr,&iyrr);
   r.x = (short)0;
   r.y = (short)0;
   r.width  = (unsigned short) (ixrr - ixl );
   r.height = (unsigned short) (iyl  - iyrr);
   XSetClipRectangles (display,gc,ixl,iyrr,&r,1,Unsorted);
   break;
  case PS:
   PSTransform (xl,yl,&wxl ,&wyl );
   PSTransform (xr,yr,&wxrr,&wyrr);
   fprintf (fhcopy,"%G %G %G %G CLIP\n",wxl,wyl,wxrr,wyrr);
   break;
 };
} /* ClipOn */
/*******************************************/
ClipOff ()
{
 XSetClipMask (display,gc,None);
} /* ClipOff */
/*******************************************/
PrepWindow (xl,xr,yl,yr,ml,mr,mb,mt)
 double     xl,xr,yl,yr,ml,mr,mb,mt;
{
 double dx  = xr - xl,
        dy  = yr - yl,
        dmx = mr - ml,
        dmy = mt - mb;

 kx =  dmx / dx * width;
 ky = -dmy / dy * height;
 qx = width  *    ml  - kx * xl;
 qy = height * (1-mb) - ky * yl;
} /* PrepWindow */
/*******************************************/
PrepWindow01 ()
{
 PrepWindow (0.0,1.0,0.0,1.0,
             0.0,1.0,0.0,1.0);
} /* PrepWindow01 */
/*******************************************/
DrawAxes ( lmargin,bmargin,rmargin,tmargin,
          xnn,xdl,ynn,ydl,
          xleft,xright,ybottom,ytop,
          sHeader,fw,fh)
 double lmargin,bmargin,rmargin,tmargin;
 int xnn,xdl,ynn,ydl;
 double xleft,xright,ybottom,ytop;
 char *sHeader;
 double fw,fh;

{
 int i,ns;
 double xpos,ypos,AxisValue;
 char AxisString [50];
 double Ticki = 0.008,
        Ticko = 0.008,
        xdx, xdy, ydx, ydy, hdx, hdy;

 if (device == PS) {
  fw = 10.0 / 640;
  fh = 20.0 / 512;
 };

   rectangleG (lmargin,bmargin,rmargin,tmargin);

   for (i=0;i<=xnn;i++) {                    /*  X  */
    xpos=lmargin+i*(rmargin-lmargin) / xnn;
    lineG (xpos,bmargin-Ticko,xpos,bmargin+Ticki);
    AxisValue = xleft+i*(xright-xleft)/xnn;
    sprintf (AxisString,"%1.*f", xdl, AxisValue);
    ns = strlen (AxisString);
    xdx = - 0.5 * ns * fw;
    xdy = - 1.2 *      fh;
    textG (xpos+xdx,bmargin+xdy,AxisString);
   };

   for (i=0;i<=ynn;i++) {                    /*  Y  */
    ypos=bmargin+i*(tmargin-bmargin) / ynn;
    lineG (lmargin-Ticko,ypos,lmargin+Ticki,ypos);
    AxisValue = ybottom+i*(ytop-ybottom)/ynn;
    sprintf (AxisString,"%1.*f", ydl, AxisValue);
    ns = strlen (AxisString);
    ydx = - (ns+2) * fw;
    ydy = - 0.5    * fh;
    if (device == PS) {
     ydx = - (ns+2) * fw;
     ydy = - 0.3    * fh;
    };
    textG (lmargin+ydx,ypos+ydy,AxisString);
   };
   ns  = strlen (sHeader);
   hdx = 0.5 * (rmargin-lmargin - ns*fw);
   hdy = 0.3 * fh;
   textG (lmargin+hdx,tmargin+hdy,sHeader);
} /* DrawAxes */
/*******************************************/
#define MaxUnUsed       0.2
#define e               1e-5
#define e_              1e-5

UnFitted(xleft, xmin, xmax, xright)
double *xleft, *xmin, *xmax, *xright;
{
  return ((*xmin - *xleft) / (*xright - *xleft) > MaxUnUsed ||
	  (*xright - *xmax) / (*xright - *xleft) > MaxUnUsed);
}

double SmoothDown(xx, order, fine)
double xx, order, fine;
{
  xx /= order;
  xx += e;
  xx *= fine;
  xx = (int)xx;
  xx /= fine;
  return (order * xx);
}

#undef e

double SmoothUp(xx, order, fine)
double xx, order, fine;
{
  xx /= order;
  xx -= e_;
  xx *= fine;
  xx = (int)xx + 1.0;
  xx /= fine;
  return (order * xx);
}

#undef e_

Smooth(xmin, xmax, order, fine, XLeft, XRight)
double xmin, xmax, order, fine, *XLeft, *XRight;
{
  if (xmin >= 0) {
    *XLeft = SmoothDown(xmin, order, fine);
    *XRight = SmoothUp(xmax, order, fine);
    return;
  }
  if (xmax <= 0) {
    *XLeft = -SmoothUp(-xmin, order, fine);
    *XRight = -SmoothDown(-xmax, order, fine);
  } else {
    *XLeft = -SmoothUp(-xmin, order, fine);
    *XRight = SmoothUp(xmax, order, fine);
  }
}

Regular(xmin, xmax, XLeft, XRight, Divisions, DecimalDigits)
double xmin, xmax, *XLeft, *XRight;
int *Divisions, *DecimalDigits;
{  /* of Regular */
  double w,order;

  w = xmax - xmin;
  w = log10(w);
  w -= 0.45;
  w = (int)floor(w + 0.5);
  w *= log(10.0);
  w = exp(w);
  order = w;   /* jump at (xmax-xmin) = 10 ** 0.95 = 8.91 */

  Smooth(xmin, xmax, order, 1.0, XLeft, XRight);
  *Divisions = (int)floor((*XRight - *XLeft) / order + 0.5);
  *DecimalDigits = -(int)floor(log10(order) + 0.5);
  if (UnFitted(XLeft, &xmin, &xmax, XRight)) {   /* 2 * finer */
    Smooth(xmin, xmax, order, 2.0, XLeft, XRight);
    *Divisions = (int)floor(2 * (*XRight - *XLeft) / order + 0.5);
    *DecimalDigits = 1 - (int)floor(log10(order) + 0.5);
  }
  if (UnFitted(XLeft, &xmin, &xmax, XRight)) {   /* 5 * finer */
    Smooth(xmin, xmax, order, 5.0, XLeft, XRight);
    *Divisions = (int)floor(5 * (*XRight - *XLeft) / order + 0.5);
    *DecimalDigits = 1 - (int)floor(log10(order) + 0.5);
  }
  if (*Divisions == 1) {
    *Divisions = 5;
    (*DecimalDigits)++;
  }
  if (*Divisions == 2) {
    *Divisions = 4;
    (*DecimalDigits)++;
  }
  if (*DecimalDigits < 0)
    *DecimalDigits = 0;

}  /* of Regular */


Singular(xmin, xmax, XLeft, XRight, Divisions, DecimalDigits)
double xmin, xmax, *XLeft, *XRight;
int *Divisions, *DecimalDigits;
{  /* of Singular */
  if (xmin == 0) {
    *XLeft = -1.0;
    *XRight = 1.0;
    *Divisions = 2;
    *DecimalDigits = 0;
    return;
  }
  if (xmax > 0) /* xmin == xmax */
    Regular(0.0, 2 * xmin, XLeft, XRight, Divisions, DecimalDigits);
  else
    Regular(2 * xmin, 0.0, XLeft, XRight, Divisions, DecimalDigits);
}  /* of Singular */


AxisParams(xmin, xmax, XLeft, XRight, Divisions, DecimalDigits)
double xmin, xmax, *XLeft, *XRight;
int *Divisions, *DecimalDigits;
{  /* of AxisParams */
 if(debug)(void)fprintf(stderr,"AxisParams called\n");

  if (xmin == xmax)
    Singular(xmin, xmax, XLeft, XRight, Divisions, DecimalDigits);
  else
    Regular(xmin, xmax, XLeft, XRight, Divisions, DecimalDigits);

 if(debug)(void)fprintf(stderr,"AxisParams O.K.\n");

}  /* of AxisParams */

#undef MaxUnUsed

/* End. */

 /************************************************/
 ppopenww (af,s)
  FILE **af;
  char *s;
 {
  *af = fopen (s,"w");
  if (*af == NULL) {
   (void) fprintf
    (stderr,"error opening file %s for writing \n\n", s);
    exit (1);
  }
 } /* ppopenww */
 /************************************************/
/*
 ppopenw (af,s)
  FILE **af;
  char *s;
 {
  char c;

  if (fileexists (s)) {
   (void) fprintf
    (stderr,"warning : file %s exists, overwrite ? (y/n) ",s);
    c = getchar();
    if ((c != 'y')&&(c!='Y')) exit (1);
    while (getchar() != 10);
  }
  ppopenww (af,s);
 }
*/
 /* ppopenw */
 /************************************************/
 fileexists (s)
  char *s;
 {
  FILE *f;
  int r;

  f = fopen (s,"r");
  if (f != NULL) (void)fclose (f);
  if (f == NULL) r = 0;
  else           r = 1;

  return (r);
 } /* fileexists */
 /************************************************/
ppopenr (af,s)
 FILE **af;
 char *s;
{
 if(debug)(void)fprintf(stderr,"ppopenr called\n");
 *af = fopen (s,"r");

 if (*af == NULL) {
  (void) fprintf
   (stderr,"error opening file %s for reading \n\n", s);
  exit (1);
 }
 if(debug)(void)fprintf(stderr,"ppopenr O.K.\n");
}  /* ppopenr */
 /************************************************/
 er (s)
 char *s;
 {
  (void) fprintf (stderr," error : %s \n",s);
  exit (1);
 } /* er */
/************************************************/
is_near_sep (w)
 double w;
{
 return (
  (fabs(w-sep ) < eps) ||
  (fabs(w-sep0) < eps) ||
  (fabs(w-sep1) < eps) ||
  (fabs(w-sep2) < eps) ||
  (fabs(w-sep3) < eps) ||
  (fabs(w-sep4) < eps) ||
  (fabs(w-sep5) < eps)
 );
} /* is_near_sep */
/************************************************/
minmax (a,d,xmin,xmax)
 double *a,*xmin,*xmax;
 long d;
{
 long i=0,j;
 double w;

 if(debug)(void)fprintf(stderr,"minmax called\n");
 w = a[i++];
 while (is_near_sep(w)) {w=a[i++];};
 *xmin = w;
 *xmax = w;
 if (debug>1) (void)fprintf(stderr,"%G\n",w);
 for (j=i;j<d;j++) {
  w = a[j];
  if (debug>1) (void)fprintf(stderr,"%G\n",w);
  if ((w > *xmax) && !is_near_sep(w)) *xmax = a[j];
  if ((w < *xmin) && !is_near_sep(w)) *xmin = a[j];
 };

 if(debug){
  (void)fprintf(stderr,"min = %G\n", *xmin);
  (void)fprintf(stderr,"max = %G\n", *xmax);
  (void)fprintf(stderr,"minmax O.K.\n");
 };
} /* minmax */
 /************************************************/
Reconstr ()
{
 long i;

 if (owl != 0) SwapData ();
 datal = datal0 - abs (wl);
 if (datal2 > datal-1) datal2 = datal-1;
 for (i=0; i<datal; i++) x[i] = y[i+wl];
 if (owl == 0) {
  minmax (y,datal0,&gymin,&gymax);
  gxmin = gymin;
  gxmax = gymax;
  nhist  = 0;
 };
 if (wl>0)
  sprintf (Header,"Plot of Yn+%1d vs Yn",wl);
 else
  sprintf (Header,"Plot of Yn+%1d vs Yn and Yn+%1d",
       2*abs(wl),abs(wl));
 owl  = wl;
 SwapData ();
 drawwin ();
} /* Reconstr */
 /************************************************/
inchist ()
{
 hist [nhist].xmin    = gxmin;
 hist [nhist].xmax    = gxmax;
 hist [nhist].ymin    = gymin;
 hist [nhist].ymax    = gymax;
 nhist++;
 if (nhist == HISTDIM) nhist--;
} /* inchist */
/*******************************************/
makeabout ()
{
 (void) fprintf (stderr,"\n\
title:     xpplot                  \n\
author:    Pavel Pokorny          \n\
           Prague Institute of Chemical Technology\n\
e-mail:    Pavel.Pokorny@vscht.cz \n\
publisher: Pavel Pokorny Praha \n\
year:      1995                     \n\
ISBN:      80-901886-2-1            \n\
version:   %s \n\
available: \n\
ftp://tiger.vscht.cz/pub/xpplot/xpplot.tar.gz\n\
ftp://ftp.funet.fi/pub/graphics/packages/xpplot/xpplot.tar.gz \n\
ftp://hpux.csc.liv.ac.uk/hpux/Maths/Misc/xpplot-2.2/xpplot-2.2-ss-9.03.tar.gz \n\n\
Copyright (c) 1995 Pavel Pokorny  \n\n\
This software can be used free of charge under the condition that \n\
it is explicitly cited in every work \n\
for the preparation of which it has been used. \n\n\
This software can be copied, distributed, modified and compiled  \n\
free of charge under the condition that this notice is preserved. \n\n\
",VERSION);
} /* makeabout */
/*******************************************/
makeorig ()
{
 zooming = 0;
 conect  = 1;
 dwl     = 1;
 ddatal1 = 1L;
 ddatal2 = 1L;
 datal   = datal0;
 datal1  = 0L;
 datal2  = datal-1;
 makew0 ();

} /* makeorig */
/*******************************************/
makew0 ()
{
 long i;

 gxmin = gxmino;
 gxmax = gxmaxo;
 gymin = gymino;
 gymax = gymaxo;
 wl    = 0;
 nhist = 0;

 if (owl != 0) {
  SwapData ();
  datal = datal0;
  for (i=0;i<datal;i++) x[i] = i;
  strcpy (Header,Header0);
  owl =wl;
 };
 drawwin ();
} /* makew0 */
/************************************************/
SwapData ()
{
 double *t;
 t = x;
 x = y;
 y = t;
} /* SwapData */
/************************************************/
prephname (s)
 char s[];
{
 int n=0;

 do sprintf (s,"hcopy%1d.ps",n++); while (fileexists (s));
} /* prephname */
/************************************************/
hcopyb ()  /* batch */
{
 if (hname [0] == 0)  prephname (hname);
 hcopys (hname);
} /*hcopyb */
/************************************************/
hcopyi () /* interactive */
{
 int q;

 prephname (hname);
 q = instring (hname);
 if (q && hname[0]) hcopys (hname);
} /*hcopyi */
/************************************************/
hcopys (s)  /* string supplied */
 char s[];
{
 time_t t = time ((time_t*)NULL);
 int odevice = device;

 device = PS;

 ppopenww (&fhcopy,s);

 fprintf (fhcopy,"%%!                                \n");
 fprintf (fhcopy,"%%%%DocumentFonts: Times-Roman     \n");
 fprintf (fhcopy,"%%%%Title: Plot                    \n");
 fprintf (fhcopy,"%%%%Creator: %s version %s\n",
             gargv[0],VERSION);
 fprintf (fhcopy,"%%%%CreationDate:       %s", ctime (&t));
 fprintf (fhcopy,"%%%%For: %s\n",getlogin());
 fprintf (fhcopy,"%%%%Pages: 1                       \n");
 fprintf (fhcopy,"%%%%BoundingBox: 56 255 511 710    \n");
 fprintf (fhcopy,"%%%%EndComments                    \n\n");

 fprintf (fhcopy,"%%%%EndProlog                      \n\n");

 fprintf (fhcopy,"%%%%Page: 1                        \n");
 fprintf (fhcopy,"%%%%PageFonts: Times-Roman         \n\n");

 fprintf (fhcopy,"gsave                              \n\n");

 fprintf (fhcopy,"/inch { 72 mul } def               \n");
 fprintf (fhcopy,"/mm   { 25.4 div inch } def        \n\n");

 fprintf (fhcopy,"/YourX0       20 mm def            \n");
 fprintf (fhcopy,"/YourY0       90 mm def            \n");
 fprintf (fhcopy,"/YourScaleX  160 mm def            \n");
 fprintf (fhcopy,"/YourScaleY  160 mm def            \n");
 fprintf (fhcopy,"/YourAngle     0    def            \n\n");

fprintf(fhcopy,"/centerx YourScaleX 2 div YourX0 add def\n");
fprintf(fhcopy,"/centery YourScaleY 2 div YourY0 add def\n\n");

 fprintf (fhcopy,"/s  YourScaleX YourScaleY add      \n");
 fprintf (fhcopy,"        2 div  def                 \n");
 fprintf (fhcopy,"/s0 180 mm     def                 \n\n");

 fprintf (fhcopy,"/Times-Roman findfont              \n");
 fprintf (fhcopy," 16 s0 div scalefont setfont       \n\n");

 fprintf (fhcopy,"\
/lw  0.2 s div def %% linewidth 0.2 points = 0.2*25.4/72 mm = 0.071 mm \n\
/r   0.1 s div def \n\
/r2  r  2 mul  def %% point radius 0.2 points \n\
/r4  r  4 mul  def \n\
/r8  r  8 mul  def \n\
/r16 r 16 mul  def %% circle (SN,UN and SL) radius 1.6 points \n\
/r32 r 32 mul  def \n\
/r64 r 64 mul  def \n\n\
/d  0.5 s div def %% dash length \n\
/d2 d 2 mul    def \n\
/d4 d 4 mul    def \n\
/d8 d 8 mul    def \n\
 centerx     centery     translate\n\
 YourAngle rotate \n\
 centerx neg centery neg translate\n\n\
 YourX0 YourY0 translate           \n\
 YourScaleX YourScaleY scale       \n\
 lw setlinewidth            \n\n\
/P  { %% POINT                      \n\
     r2 0 360 arc fill } bind def   \n\
/SN  {  %%  stable mode \n\
     r16  0 360 arc fill   } bind def \n\
/UN  {  %% unstable node  \n\
     r16  0 360 arc       \n\
     gsave  1 setgray fill grestore \n\
     stroke } bind def \n\
/SL {   %% saddle   \n\
     2 copy UN 2 copy                   \n\
     r16 90 270 arc lineto fill } bind def \n\
/VL { %% vertical line  \n\
     moveto \n\
     0 r64        rlineto \n\
     0 r64 -2 mul rlineto \n\
     stroke } bind def \n\
/HL { %% horizontal line  \n\
     moveto \n\
     r64 0        rlineto \n\
     r64 -2 mul 0 rlineto \n\
     stroke } bind def \n\
/T { %% triangle    \n\
     moveto \n\
     0 r16 rmoveto   \n\
     r16 neg  r32 neg rlineto   \n\
     r32     0       rlineto   \n\
     r16 neg  r32     rlineto   \n\
     gsave  1 setgray fill grestore \n\
     stroke } bind def \n\
/FT { %% filled triangle           \n\
     moveto                        \n\
     0 r16 rmoveto                 \n\
     r16 neg  r32 neg rlineto      \n\
     r32     0        rlineto      \n\
     r16 neg  r32     rlineto      \n\
     fill } bind def               \n\
/IT { %% inverted triangle         \n\
     moveto                        \n\
     0 r16 neg rmoveto             \n\
     r16 neg r32      rlineto      \n\
     r32     0        rlineto      \n\
     r16 neg r32 neg  rlineto      \n\
     gsave  1 setgray fill grestore\n\
     stroke } bind def             \n\
/FIT { %% filled inverted triangle \n\
     moveto                        \n\
     0 r16 neg rmoveto             \n\
     r16 neg r32      rlineto      \n\
     r32     0        rlineto      \n\
     r16 neg r32 neg  rlineto      \n\
     fill } bind def               \n\
/D { %% diamond                    \n\
     moveto                        \n\
     0 r16 rmoveto                 \n\
     r16 neg  r16 neg rlineto      \n\
     r16      r16 neg rlineto      \n\
     r16      r16     rlineto      \n\
     r16 neg  r16     rlineto      \n\
     gsave  1 setgray fill grestore\n\
     stroke } bind def             \n");
fprintf (fhcopy,"\
/FD { %% filled diamond            \n\
     moveto                        \n\
     0 r16 rmoveto                 \n\
     r16 neg  r16 neg rlineto      \n\
     r16      r16 neg rlineto      \n\
     r16      r16     rlineto      \n\
     r16 neg  r16     rlineto      \n\
     fill } bind def               \n\
/C { %% cross                      \n\
     moveto                        \n\
     r8 neg 0 rmoveto              \n\
     r16    0 rlineto              \n\
     r8 neg r8 neg rmoveto         \n\
     0 r16      rlineto            \n\
     stroke } bind def             \n\
/S { %% square                     \n\
     moveto                        \n\
     r8 neg r8 neg rmoveto         \n\
     r16 0  rlineto                \n\
     0  r16 rlineto                \n\
     r16 neg 0 rlineto             \n\
     closepath                     \n\
     gsave 1 setgray fill grestore \n\
     stroke } bind def             \n\
/FS { %% filled square             \n\
     moveto                        \n\
     r8 neg r8 neg rmoveto         \n\
     r16 0  rlineto                \n\
     0  r16 rlineto                \n\
     r16 neg 0 rlineto             \n\
     closepath                     \n\
     fill } bind def               \n\
/M   {  moveto } bind def          \n\
/LT  {  lineto } bind def          \n\
/RLT { rlineto } bind def          \n\
/SD0 { [             ] 0 setdash } bind def \n\
/SD1 { [ d2 d4       ] 0 setdash } bind def \n\
/SD2 { [ d  d4       ] 0 setdash } bind def \n\
/SD3 { [ d4 d4       ] 0 setdash } bind def \n\
/SD4 { [ d2 d2       ] 0 setdash } bind def \n\
/SD5 { [ d4 d2 d  d2 ] 0 setdash } bind def \n\
/SD6 { [ d8 d4 d  d4 ] 0 setdash } bind def \n\
/DD  {  %% dashed demo  \n\
 gsave 0.1 -0.6 rlineto stroke grestore 0.05 0 rmoveto  \n\
} bind def \n\n\
%% demo 1 \n\n\
%% to see dashed lines uncomment the following 8 lines \n\
%%  (cancel the %% sign)           \n\n\
%%  0.3 0.8 M \n\
%%  SD1 DD \n\
%%  SD2 DD \n\
%%  SD3 DD \n\
%%  SD4 DD \n\
%%  SD5 DD \n\
%%  SD6 DD \n\
%%  SD0 DD \n\n\
%% to use dashed lines \n\n\
%% 0.5 0.6 M \n\n\
%% 0.6 0.6 LT \n\
%% 0.6 0.5 LT \n\
%% 0.7 0.5 LT \n\
%% 0.7 0.4 LT \n\
%% 0.6 0.4 LT \n\
%% 0.6 0.2 LT \n\
%% 0.5 0.2 LT \n\
%% 0.5 0.4 LT \n\
%% 0.4 0.4 LT \n\
%% 0.4 0.5 LT \n\
%% 0.5 0.5 LT \n\
%% 0.5 0.6 LT \n\n\
%% SD6 \n\
%% stroke \n\
%% SD0 \n\n\
%% you can redefine a function (say P) to LT by \n\
%% /P {LT} def \n\n\
/L   { %% line                     \n\
  4 copy pop pop moveto            \n\
  lineto pop pop stroke} bind def\n\n\
/CLIP {                            \n\
 4 copy pop pop moveto             \n\
 3 copy pop exch lineto            \n\
 2 copy          lineto            \n\
 4 copy exch pop exch pop lineto   \n\
 pop pop pop pop                   \n\
 closepath clip newpath } def      \n\n\
");

(void) fprintf (fhcopy,"\
/LATIN {                       \n\
 /Times-Roman findfont         \n\
 16 s0 div scalefont setfont   \n\
} def                        \n\n\
/GREEK {                       \n\
 /Symbol findfont              \n\
 16 s0 div scalefont setfont   \n\
} def                        \n\n\
/LOWINDEX {                    \n\
 0.005 -0.015 rmoveto} def   \n\n\
%% demo 2                    \n\n\
%% to draw a bounding box uncomment the following 4 lines \n\n\
%%  0 0 1 0  L                     \n\
%%  1 0 1 1  L                     \n\
%%  1 1 0 1  L                     \n\
%%  0 1 0 0  L                   \n\n\
%% demo 3                    \n\n\
%% to see axis label uncomment the following 4 lines \n\n\
%% 0.85 0.04 moveto   LATIN (time) show \n\
%%           LOWINDEX GREEK (a)    show \n\
%% 0.06 0.80 moveto   GREEK (b)    show \n\
%%           LOWINDEX LATIN (2)    show \n\n\
%% demo 4                    \n\n\
%% to see marks uncomment the following 14 lines \n\n\
%% 0.22 0.22 0.87 0.87 L   \n\
%% 0.25 0.25           P   \n\
%% 0.30 0.30           SN  \n\
%% 0.35 0.35           UN  \n\
%% 0.4  0.4            SL  \n\
%% 0.45 0.45           T   \n\
%% 0.5  0.5            FT  \n\
%% 0.55 0.55           IT  \n\
%% 0.6  0.6            FIT \n\
%% 0.65 0.65           D   \n\
%% 0.7  0.7            FD  \n\
%% 0.75 0.75           C   \n\
%% 0.8  0.8            S   \n\
%% 0.85 0.85           FS  \n\n\
%% to change the function P to draw a triangle instead of a point  \n\
%% insert the following line (without the %% sign)  \n\
%% at the place you want the change from  \n\
%% /P { T } def                         \n\n\
LATIN                                   \n\n\
%% Here begins the output               \n\n\
");

 drawwin ();

(void) fprintf (fhcopy,"\
%% quit             \n\n\
showpage              \n\
grestore            \n\n\
%%%%Trailer         \n\n\
%% quit               \n\
");

 fclose  (fhcopy);
 device = odevice;
} /* hcopys */
/************************************************/
allocdata (a,n)
 double* *a;
 long n;
{
 if(debug)(void)fprintf(stderr,"allocdata called\n");
 if(debug)(void)fprintf(stderr,"n = %ld \n",n);

 if (*a == NULL)
   *a = (double*) malloc  (          (size_t)(n*sizeof(double)));
 else
   *a = (double*) realloc ((void*)*a,(size_t)(n*sizeof(double)));

 if (*a == NULL) {
  (void) fprintf (stderr,
   "allocdata : cannot allocate memory for %ld doubles",n);
  exit (-1);
 };
 if(debug)(void)fprintf(stderr,"allocdata O.K.\n");
} /* allocdata */
/*********************************************/
 vali (s)
 char *s;
 {
  int i,is;

  is = sscanf(s,"%d",&i);
  if(is!=1){
   fprintf (stderr,"error reading string %s\n",s);
   exit(1);
  };
  return (i);
 } /* vali */
/************************************************/
 double valf (s)
 char *s;
 {
  int is;
  double w;

  is = sscanf(s,"%lf",&w);
  if(is!=1){
   (void) fprintf (stderr,"error reading string %s\n",s);
   exit(1);
  };
  return (w);
 } /* valf */
/************************************************/
instring (string)
 char *string;
{
 static int first = 1;

 static Window pop_win,win1,win0;
 XEvent report;
 static char s1[] = "O.K.";
 static char s0[] = "Cancel";
 char cursor[2];
 char wstring [ MAX_POPUP_STRING_LENGTH+1];
 char buffer [ MAX_MAPPED_STRING_LENGTH];
 int bufsize = MAX_MAPPED_STRING_LENGTH;
 static int start_x,start_y;
 KeySym keysym;
/*
 XComposeStatus compose;
*/
 unsigned int locwidth,locheight;
 int length;
 int xx=orx+0,yy=ory+0;
 int xlus;

 if(debug)(void)fprintf(stderr,"\ninstring called\n\n");

 cursor [0] = (char)25;
 cursor [1] = (char) 0;

 if (first) {
  first = 0;
  locwidth = (MAX_POPUP_STRING_LENGTH + 1) *
              font_info->max_bounds.width + 4;
  locheight = font_info->max_bounds.ascent +
               font_info->max_bounds.descent + 4;
  pop_win = XCreateSimpleWindow
             (display,winM,xx,yy,locwidth,locheight,
             border_width,
             WhitePixel (display,screen),
             BlackPixel (display,screen));
  XSelectInput(display,pop_win,ExposureMask | KeyPressMask);

  xx += locwidth + 4;
  locwidth = strlen (s1) *
              font_info->max_bounds.width + 4;
  win1 = XCreateSimpleWindow
          (display,winM,xx,yy,locwidth,locheight,
            border_width,
            WhitePixel (display,screen),
            BlackPixel (display,screen));
  XSelectInput(display,win1,ExposureMask | ButtonPressMask);

  xx += locwidth + 4;
  locwidth = strlen (s0) *
              font_info->max_bounds.width + 4;
  win0 = XCreateSimpleWindow
          (display,winM,xx,yy,locwidth,locheight,
           border_width,
           WhitePixel (display,screen),
           BlackPixel (display,screen));
  XSelectInput(display,win0,ExposureMask | ButtonPressMask);

  start_x = 2;
  start_y = font_info->max_bounds.ascent + 2;

 };
 XMapWindow (display,pop_win);
 XMapWindow (display,win1);
 XMapWindow (display,win0);
/*--------------------------------------------------*/
/*--------------------------------------------------*/
 while (1) {
  XNextEvent (display, &report);
  switch (report.type) {
/*--------------------------------------------------*/
  case Expose :
   if(debug)(void)fprintf(stderr,
        "instring : Expose\n");

   if (report.xexpose.window == pop_win) {
     strcpy (wstring,string);
     strcat (wstring,cursor);
     XDrawString (display,pop_win,gc,start_x,start_y,
                  wstring, (int)strlen(wstring));
   }
   else if (report.xexpose.window == win1) {
     XDrawString (display,win1,gc,start_x,start_y,
                  s1,(int)strlen(s1));
   }
   else if (report.xexpose.window == win0) {
     XDrawString (display,win0,gc,start_x,start_y,
                  s0,(int)strlen(s0));
   }
   break;
/*--------------------------------------------------*/
  case ButtonPress:
   if(debug)(void)fprintf(stderr,
        "instring : ButtonPress \n");

   if (report.xbutton.window == pop_win) {
   }
   else if (report.xbutton.window == win1) {
    XUnmapWindow (display,pop_win);
    XUnmapWindow (display,win1);
    XUnmapWindow (display,win0);
    if(debug)(void)fprintf(stderr,"\ninstring O.K. \n\n");
    return (1);
   }
   else if (report.xbutton.window == win0) {
    XUnmapWindow (display,pop_win);
    XUnmapWindow (display,win1);
    XUnmapWindow (display,win0);
    if(debug)(void)fprintf(stderr,"\ninstring O.K. \n\n");
    return (0);
   }
   else {
    XBell (display,100);
   };
   break;
/*--------------------------------------------------*/
  case KeyPress:
   if(debug)(void)fprintf(stderr,
        "instring : KeyPress \n");

   if (report.xkey.window == pop_win) {
    xlus = XLookupString
      ((XKeyEvent*)&report,buffer,bufsize,&keysym,
        (XComposeStatus*)NULL /* &compose */);
    buffer [xlus] = (char)0;
    if(debug){
     fprintf(stderr,"xlus = %d \n",xlus);
     fprintf(stderr,"strlen(buffer) = %d \n",(int)strlen(buffer));
    };

/* CR */

    if ((keysym==XK_Return)||(keysym==XK_KP_Enter)||
                (keysym==XK_Linefeed)) {
     XUnmapWindow (display,pop_win);
     XUnmapWindow (display,win1);
     XUnmapWindow (display,win0);
     if(debug)(void)fprintf(stderr,"\ninstring O.K. \n\n");
     return (1);
    }

/* char */

    else if (((keysym>=XK_KP_Space)&&(keysym<=XK_KP_9)) ||
             ((keysym>=XK_space   )&&(keysym<=XK_asciitilde))) {
     if ((strlen (string) + strlen (buffer)) >=
                     MAX_POPUP_STRING_LENGTH)
      XBell (display,100);
     else {
      strcat (string,buffer);
     }
    }

/* Shift_L  Shift_R  CTRL  CAPS_Lock  Extend_char */

    else if ((keysym>=XK_Shift_L)&&(keysym<=XK_Hyper_L)) {
     /*(void)fprintf(stderr,
        "keysym %s is not handled here\n",
                 XKeysymToString (keysym));
     XBell (display,100); */
    }

/* F1... */

    else if ((keysym>=XK_F1)&&(keysym<=XK_F35))
     if (buffer == NULL) {
      /*(void)fprintf (stderr,"Unmapped function key.\n");*/
      XBell (display,100);
     }
     else if ((strlen (string) + strlen (buffer)) >=
                            MAX_POPUP_STRING_LENGTH)
      XBell (display,100);
     else {
      /*strcat (string,buffer);*/
     }

/* Del */

    else if ((keysym==XK_BackSpace)||(keysym==XK_Delete)) {
     if ((length = strlen (string)) > 0) {
      string [length-1] = NULL;
     }
     else {
      XBell (display,100);
     };
    }

/* Esc */

    else if (keysym == XK_Escape) {
     string [0] = NULL;
    }

/* others */

    else {
/*   (void)fprintf(stderr,
     "keysym %s is not handled \n",XKeysymToString (keysym));
*/
     XBell (display,100);
    }

    strcpy (wstring,string);
    strcat (wstring,cursor);
    XClearWindow (display,pop_win);
    XDrawString (display,pop_win,gc,start_x,start_y,
                 wstring,(int)strlen(wstring));
   } /* if (report.xkey.window == pop_win) */
   break;
/*--------------------------------------------------*/
  case MappingNotify:
   if(debug)(void)fprintf(stderr,
        "instring : MappingNotify \n");
   XRefreshKeyboardMapping ((XMappingEvent*)&report);
   break;
/*--------------------------------------------------*/
  default :
   if(debug)(void)fprintf(stderr,"instring : ? report\n");
   break;
  } /*  switch */
 }  /*  while  */
/*--------------------------------------------------*/
/*--------------------------------------------------*/
}   /* instring   */
/*******************************************/
