/*
 * test.c,v 2.3 1992/08/11 00:25:45 pete Exp
 * test.c,v
 * Revision 2.3  1992/08/11  00:25:45  pete
 * Added code for displaying on other than the default visual.  Added
 * handling of WINDOW_DELETE messages.
 *
 * Revision 2.2  1992/07/11  20:06:59  pete
 * Changed background to be the class.  Added ExitCB.
 *
 * Revision 2.1  1992/06/10  02:11:16  ware
 * Rearranged so menubar is at top.  Added a test for the popup
 * placement.  Made the buttons functional, again.
 *
 * Revision 2.0  1992/04/23  02:53:20  ware
 * First public release.
 *
 * Revision 1.21  1992/04/23  02:36:12  ware
 * Messing around with scrollbars
 *
 * Revision 1.20  1992/03/03  17:21:07  ware
 * Added simple test for scrollbar.
 *
 * Revision 1.19  1992/02/26  21:15:28  ware
 * Added an additional label so vpane has better test.  Removed
 * call to _XoWarn() since it obviously works.  Changed timeout to
 * 2 minutes instead of 45 seconds -- really need to make it a resource.
 *
 * Revision 1.18  92/02/04  21:28:15  pete
 * Release 44
 * 
 * Revision 1.17  1991/12/01  16:30:51  pete
 * Use XoProto().
 *
 * Revision 1.16  1991/09/12  09:52:44  pete
 * Fixed so the buttons will actually set the resources on the correct item.
 *
 * Revision 1.15  91/08/26  12:00:26  pete
 * Rename functions to following naming conventions.  Use new menu functions.
 * 
 * Revision 1.14  1991/06/14  04:48:33  pete
 * Added support for parsing DBUG macros.
 *
 * Revision 1.13  91/06/01  10:03:22  pete
 * Working on menubar
 * 
 * Revision 1.12  91/05/29  14:42:16  pete
 * Working on getting the menubar to work.
 * 
 * Revision 1.11  1991/05/25  11:03:14  pete
 * Adding external menus
 *
 * Revision 1.10  91/05/23  16:50:01  pete
 * An actually working version of popup menus.
 * 
 * Revision 1.9  91/05/23  15:23:00  pete
 * Pop submenus down on notify
 * 
 * Revision 1.8  1991/05/22  17:49:48  pete
 * Get it to compile cleanely.  Menus almost work.
 *
 * Revision 1.7  91/05/21  17:16:07  pete
 * Added a timeout to catch errors.  Cut buttons down to 2.
 * 
 * Revision 1.6  91/05/21  15:08:55  pete
 * A minimally working walking menu implementation.
 * 
 * Revision 1.5  1991/05/20  17:54:10  pete
 * Added menu creation.
 *
 * Revision 1.4  91/05/17  10:09:53  pete
 * Finished a prototype declaration.
 * 
 * Revision 1.3  91/05/17  04:46:57  pete
 * Fixed some warnings about unused variables, prototypes.
 * 
 * Revision 1.2  1991/05/16  18:41:18  pete
 * Added buttons to set all the Box resources.
 *
 * Revision 1.1  91/05/15  08:56:50  pete
 * Initial revision
 * 
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xo/Vpane.h>
#include <X11/Xo/Box.h>
#include <X11/Xo/Button.h>
#include <X11/Xo/Label.h>
#include <X11/Xo/Menu.h>
#include <X11/Xo/MenuButton.h>
#include <X11/Xo/MenuBar.h>
#include <X11/Xo/Scrollbar.h>
#include <X11/Xo/List.h>
#include <X11/Xo/ObjLabel.h>
#include <X11/Xo/menu.h>
#include <X11/Xo/dbug.h>

typedef struct
{
	Visual	*visual;
	int	timeout;
} OptionsRec;

OptionsRec	Options;

XtResource resources[] =
{
	{"visual", "Visual", XtRVisual, sizeof (Visual *),
	XtOffsetOf (OptionsRec, visual), XtRImmediate, NULL},
};

XrmOptionDescRec Desc[] =
{
	{"-visual", "*visual", XrmoptionSepArg, NULL}
};

/*
 * Define the default resource values.  With the possible exception of
 * the background color, all these should should be default values
 * of the widgets -- in other words, there existence indicates a bug.
 * The problem is that in the "build" program, there is no implementation
 * yet for overriding resources.
 */

static String	Fallback[] = 
{
	"*Background:				gray75",
	"*Menu*MenuButton.gravity:		West",
	"*MenuButton.moveDelta:			0",
	NULL
};

XoProto (extern int, main, (int argc, char **argv, ...));

XoProto (extern void, make_command, (Widget parent, Widget label, XoGravity type));
XoProto (extern void, make_set_command, (Widget parent, char *name, Widget toset, Arg *args_set, Cardinal cnt_set));
XoProto (extern void, make_menu, (Widget parent, char *name, int flag));
XoProto (static void, QuitTimeout, (XtPointer client_data, XtIntervalId *id));
XoProto (static void, make_print_command, (Widget parent, Widget startat));
XoProto (static void, ScrollCallback, (Widget gw, XtPointer client_data, XtPointer call_data));
XoProto (static void, MoveCallback, (Widget gw, XtPointer client_data, XtPointer call_data));
XoProto (static void, PopupCallback, (Widget gw, XtPointer client_data, XtPointer call_data));
XoProto (static void, PopdownCallback, (Widget gw, XtPointer client_data, XtPointer call_data));
XoProto (static void, make_set_arg, (Widget gw, Widget toset, Arg *args, unsigned int cnt));

int
main (argc, argv)
int		argc;
char		**argv;
{
	XtAppContext	app;
	XoGravity	t;
	Widget		toplevel;
	Widget		paned;
	Widget		button;
	Widget		label;
	Widget		menubar;
	Widget		box;
	Widget		set;
	Cardinal	cnt;
	Arg		args[10];
	XoMenuList	*MenuList;
	XoMenuData	*Menu;
	int		i;
	char		*menufile = "test.menu";
	char		*class = "XoTest";
	Display		*dpy;		/* display */
	char		**xargv;	/* saved argument vector */
	int		xargc;		/* saved argument count */
	Colormap	colormap;	/* created colormap */
	XVisualInfo	vinfo;		/* template for find visual */
	XVisualInfo	*vinfo_list;	/* returned list of visuals */
	int		count;		/* number of matchs (only 1?) */

	DBUG_ENTER ("main");
	DBUG_PROCESS (argv[0]);

	/*
	 * save the command line arguments
	 */

	xargc = argc;
	xargv = (char **) XtMalloc (argc * sizeof (char *));
	bcopy ((char *) argv, (char *) xargv, argc * sizeof (char *));

	cnt = 0;
	toplevel = XtAppInitialize(&app, class,
				   Desc, XtNumber (Desc),
				   &argc, argv,
				   Fallback, args, cnt);
	for (i = 1; i < argc; i++)
	{
		if (argv[i][1] == '#')
		{
			DBUG_PUSH (&argv[i][2]);
		}
		else
		{
			menufile = argv[i];
		}
	}
	dpy = XtDisplay (toplevel);
	cnt = 0;
	XtGetApplicationResources (toplevel, &Options, resources,
				   XtNumber (resources),
				   args, cnt);
	cnt = 0;
	if (Options.visual && Options.visual != DefaultVisualOfScreen (XtScreen (toplevel)))
	{
		XtSetArg (args[cnt], XtNvisual, Options.visual); ++cnt;
		/*
		 * Now we create an appropriate colormap.  We could
		 * use a default colormap based on the class of the
		 * visual; we could examine some property on the
		 * rootwindow to find the right colormap; we could
		 * do all sorts of things...
		 */
		colormap = XCreateColormap (dpy,
					    RootWindowOfScreen (XtScreen (toplevel)),
					    Options.visual,
					    AllocNone);
		XtSetArg (args[cnt], XtNcolormap, colormap); ++cnt;

		/*
		 * Now find some information about the visual.
		 */
		vinfo.visualid = XVisualIDFromVisual (Options.visual);
		vinfo_list = XGetVisualInfo (dpy, VisualIDMask, &vinfo, &count);
		if (vinfo_list && count > 0)
		{
			XtSetArg (args[cnt], XtNdepth, vinfo_list[0].depth);
			++cnt;
			XFree ((XPointer) vinfo_list);
		}
	}
	XtDestroyWidget (toplevel);


	/*
	 * Now create the real toplevel widget.
	 */
	XtSetArg (args[cnt], XtNargv, xargv); ++cnt;
	XtSetArg (args[cnt], XtNargc, xargc); ++cnt;
	toplevel = XtAppCreateShell ((char *) NULL, class,
				applicationShellWidgetClass,
				dpy, args, cnt);

	cnt = 0;
	paned = XtCreateManagedWidget ("paned", xoVpaneWidgetClass,
				     toplevel, args,cnt);

	/*
	 * Create the menubar
	 */
	MenuList = XoMenuReadFile (menufile);
	cnt = 0;
	Menu = XoMenuFind (MenuList, "Main");
	if (Menu)
	{
		menubar = XtCreateManagedWidget ("menubar",
						 xoMenuBarWidgetClass, paned,
						 (Arg *) NULL, 0);
		XoMenuCreate (MenuList, "Main", menubar);
	}
	else
	{
		fprintf (stderr, "No main menu\n");
	}

	/*
	 * Create a dummy scrollbar for trying things out
	 */
	cnt = 0;
	label = XtCreateManagedWidget ("top", xoScrollbarWidgetClass, paned,
				       args, cnt);
	XtAddCallback (label, XtNcallback, ScrollCallback, (XtPointer) NULL);

	/*
	 * Add a button that updates the position of the scrollbar's grip.
	 */
	cnt = 0;
	XtSetArg (args[cnt], XtNlabel, "Move Grip left/right"); ++cnt;
	button = XtCreateManagedWidget ("button", xoButtonWidgetClass, paned,
				       args, cnt);
	XtAddCallback (button, XtNcallback, MoveCallback, (XtPointer) label);

	/*
	 * Add a button that popup's up something to test out
	 * XoWidgetPlace()
	 */
	cnt = 0;
	XtSetArg (args[cnt], XtNlabel, "Create a popup"); ++cnt;
	label = XtCreateManagedWidget ("popup", xoButtonWidgetClass, paned,
				       args, cnt);
	XtAddCallback (label, XtNcallback, PopupCallback,
		       (XtPointer) toplevel);

	/*
	 * make a bunch of buttons that can change where the above button is
	 * moved around
	 */
	cnt = 0;
	box = XtCreateManagedWidget ("box", xoBoxWidgetClass, paned,
				     args, cnt);
	for (t = XoNORTH; t <= XoCENTER; t++)
	{
		make_command (box, button, t);
	}

	/*
	 * The following buttons change how the above box is layed out
	 */
	cnt = 0;
	set = XtCreateManagedWidget ("box3", xoBoxWidgetClass, paned,
				     (Arg *) NULL, 0);
	make_print_command (set, toplevel);
	XtSetArg (args[0], XtNhoffset, 5);
	make_set_command (set, "hoffset 5", box, args, (Cardinal) 1);
	XtSetArg (args[0], XtNhoffset, 20);
	make_set_command (set, "hoffset 20", box, args, (Cardinal) 1);
	XtSetArg (args[0], XtNhoffset, 40);
	make_set_command (set, "hoffset 40", box, args, (Cardinal) 1);
	
	XtSetArg (args[0], XtNvoffset, 5);
	make_set_command (set, "voffset 5", box, args, (Cardinal) 1);
	XtSetArg (args[0], XtNvoffset, 20);
	make_set_command (set, "voffset 20", box, args, (Cardinal) 1);
	XtSetArg (args[0], XtNvoffset, 40);
	make_set_command (set, "voffset 40", box, args, (Cardinal) 1);

	XtSetArg (args[0], XtNshrink, True);
	make_set_command (set, "shrink on", box, args, (Cardinal) 1);
	XtSetArg (args[0], XtNshrink, False);
	make_set_command (set, "shrink off", box, args, (Cardinal) 1);

	XtSetArg (args[0], XtNstretch, True);
	make_set_command (set, "stretch on", box, args, (Cardinal) 1);
	XtSetArg (args[0], XtNstretch, False);
	make_set_command (set, "stretch off", box, args, (Cardinal) 1);

	XtSetArg (args[0], XtNinsertHspace, True);
	make_set_command (set, "insert hspace t", box, args, (Cardinal) 1);
	XtSetArg (args[0], XtNinsertHspace, False);
	make_set_command (set, "insert hspace f", box, args, (Cardinal) 1);

	XtSetArg (args[0], XtNinsertVspace, True);
	make_set_command (set, "insert vspace t", box, args, (Cardinal) 1);
	XtSetArg (args[0], XtNinsertVspace, False);
	make_set_command (set, "insert vspace f", box, args, (Cardinal) 1);

	/*
	 * Add this in for safety.  Especially useful if something goes wrong
	 * with the menu code while a grab is active.
	 */
	(void) XtAppAddTimeOut (app, 1000*120, QuitTimeout, (XtPointer) NULL);
	XoWMAddFocusHandler (toplevel);
	XtRealizeWidget (toplevel);
	XoWMAddDeleteHandler (toplevel);
	XtAppMainLoop (app);
	return 0;
}

static void
QuitTimeout (client_data, id)
XtPointer	client_data;
XtIntervalId	*id;
{
	fprintf (stderr, "Timeout expired, quitting\n");
	exit (0);
}

typedef struct _grav
{
	Widget		w;
	XoGravity	type;
} GravPack;

static void
TestGravity (gw, client_data, call_data)
Widget		gw;
XtPointer	client_data;
XtPointer	call_data;
{
	GravPack	*gravpack;
	Cardinal	cnt;
	Arg		args[10];

	gravpack = (GravPack *) client_data;
	cnt = 0;
	XtSetArg (args[cnt], XtNgravity, gravpack->type); ++cnt;
	XtSetValues (gravpack->w, args, cnt);
}

#ifdef notdef
XoProto (static void, TestManaged, (Widget gw, XtPointer client_data, XtPointer call_data));
static void
TestManaged (gw, client_data, call_data)
Widget		gw;
XtPointer	client_data;
XtPointer	call_data;
{
	WidgetList	array;
	Boolean		found = False;
	int		i;
	Arg		args[10];
	Cardinal	cnt;

	array = (WidgetList) client_data;
	for (i = 0; array[i]; i++)
	{
		if (gw == array[i])
		{
			cnt = 0;
			XtSetArg (args[cnt], XtNdoLayout, False);  ++cnt;
			XtSetValues (XtParent (gw), args, cnt);
			if (i != 0)
				XtUnmanageChild (array[i]);
			found = True;
		}
		else if (found)
		{
			XtManageChild (array[i]);
		}
	}
	cnt = 0;
	XtSetArg (args[cnt], XtNdoLayout, True);  ++cnt;
	XtSetValues (XtParent (gw), args, cnt);
}
#endif

void
make_command (parent, label, type)
Widget		parent;
Widget		label;
XoGravity	type;
{
	Widget		c;
	GravPack	*gravpack;
	char		*name;
	Cardinal	cnt;
	Arg		args[10];

	name = XoGetStringFromGravity (type);
	cnt = 0;
	c = XtCreateManagedWidget (name, xoButtonWidgetClass, parent,
				   args, cnt);
	gravpack = XtNew (GravPack);
	gravpack->w = label;
	gravpack->type = type;
	XtAddCallback (c, XtNcallback, TestGravity, (XtPointer) gravpack);
}

struct _set
{
	Widget		toset;
	Cardinal	cnt;
	Arg		*args;
};

static void
SetArgCB (gw, client_data, call_data)
Widget		gw;
XtPointer	client_data;
XtPointer	call_data;
{
	struct _set	*s;

	s = (struct _set *) client_data;
	if (!s)
		return;
	XtSetValues (s->toset, s->args, s->cnt);
}

static void
ExitCB (gw, client_data, call_data)
Widget		gw;
XtPointer	client_data;
XtPointer	call_data;
{
	printf ("bye bye!\n");
	exit (0);
}

static void
PrintCB (gw, client_data, call_data)
Widget		gw;
XtPointer	client_data;
XtPointer	call_data;
{
	String	message;

	message = (char *) client_data;
	if (!message)
		message = "no message\n";
}

static void
make_set_arg (gw, toset, args, cnt)
Widget		gw;
Widget		toset;
Arg		*args;
unsigned int	cnt;
{
	struct _set	*s;

	s = XtNew (struct _set);
	s->toset = toset;
	s->args = (Arg *) XtMalloc (sizeof (Arg) * cnt);
	s->cnt = cnt;
	bcopy ((char *) args, (char *) s->args, sizeof (Arg) * (int) cnt);
	XtAddCallback (gw, XtNcallback, SetArgCB, (XtPointer) s);
}

void
make_set_command (parent, name, toset, args_set, cnt_set)
Widget		parent;
char		*name;
Widget		toset;
Arg		*args_set;
Cardinal	cnt_set;
{
	Widget		gw;
	Cardinal	cnt;
	Arg		args[10];
	
	cnt = 0;
	gw = XtCreateManagedWidget (name, xoButtonWidgetClass, parent,
				   args, cnt);
	make_set_arg (gw, toset, args_set, (unsigned int) cnt_set);
}

void
make_menu (parent, pname, submenus)
Widget		parent;
char		*pname;			/* name of parent */
int		submenus;
{
	Widget		popup;
	Widget		menu;
	Widget		item;
	char		name[320];
	Arg		args[10];
	Cardinal	cnt;
	int		i;

	cnt = 0;
	if (submenus == 1)
		strcpy (name, "popup");
	else
		sprintf (name, "%s/popup%d", pname, submenus);
	popup = XtCreatePopupShell (name, overrideShellWidgetClass, parent,
				    args, cnt);
	cnt = 0;
	sprintf (name, "%s/menu%d", pname, submenus);
	menu = XtCreateManagedWidget (name, xoMenuWidgetClass, popup,
				      args, cnt);
	cnt = 0;
	XtSetArg (args[cnt], XtNsubMenu, menu); ++cnt;
	XtSetValues (parent, args, cnt);
	cnt = 0;
	(void) XtCreateManagedWidget ("Title", xoLabelWidgetClass,
				      menu, args, cnt);
	for (i = 0; i < 8; i++)
	{
		sprintf (name, "%s.%d", pname, i);
		cnt = 0;
		item = XtCreateManagedWidget (name, xoMenuButtonWidgetClass,
					      menu, args, cnt);
		XtAddCallback (item, XtNcallback, PrintCB,
			       (XtPointer) XtName (item));
		if ((i + 1) %4 == 0 && submenus < 4)
		{
			sprintf (name, "%s/sub%d", pname,submenus);
			make_menu (item, name, submenus + 1);
		}
	}
}

static void
HardCopyCB (gw, client_data, call_data)
Widget		gw;
XtPointer	client_data;
XtPointer	call_data;
{
	XoHardCopy	hardcopy;

	hardcopy.h_dpi_x = 300;
	hardcopy.h_dpi_y = 300;
	hardcopy.h_type = XrmStringToQuark (XoPostscript);
	hardcopy.h_version = 1;
	hardcopy.h_private = NULL;
	XoHardcopy ((Widget) client_data, &hardcopy, 0);
}

static void
make_print_command (parent, startat)
Widget		parent;
Widget		startat;
{
	Arg		args[10];
	Cardinal	cnt;
	Widget		gw;

	cnt = 0;
	gw = XtCreateManagedWidget ("exit", xoButtonWidgetClass,
				    parent, args, cnt);
	/*XtAddCallback (gw, XtNcallback, HardCopyCB, (XtPointer) startat);*/
	XtAddCallback (gw, XtNcallback, ExitCB, (XtPointer) startat);
}

static void
ScrollCallback (gw, client_data, call_data)
	Widget		gw;
	XtPointer	client_data;
	XtPointer	call_data;
{
	double		*p;

	p = (double *) call_data;
}

static void
MoveCallback (gw, client_data, call_data)
	Widget		gw;
	XtPointer	client_data;
	XtPointer	call_data;
{
	Widget		scrollbar;
	double		top;		/* top of the grip */
	double		size;		/* size of the grip */
	Arg		args[10];
	Cardinal	cnt;
	static double	increment = .05;

	scrollbar = (Widget) client_data;
	cnt = 0;
	XtSetArg (args[cnt], XtNtop, &top); ++cnt;
	XtSetArg (args[cnt], XtNsize, &size); ++cnt;
	XtGetValues (scrollbar, args, cnt);
	top += increment;
	if (top + size >= 1.0 || top <= 0.0)
		increment = -increment;
	cnt = 0;
	XtSetArg (args[cnt], XtNtop, &top); ++cnt;
	XtSetValues (scrollbar, args, cnt);
}

static void
PopdownCallback (gw, client_data, call_data)
	Widget		gw;
	XtPointer	client_data;
	XtPointer	call_data;
{
	XtPopdown (XtParent (gw));
}

static void
PopupCallback (gw, client_data, call_data)
	Widget		gw;
	XtPointer	client_data;
	XtPointer	call_data;
{
	Position	x, y;
	Dimension	h, w;
	char		label[BUFSIZ];
	Arg		args[10];
	Cardinal	cnt;
	static Widget	popup;
	static Widget	button;
	static XoGravity	parent = XoNORTH;
	static XoGravity	child = XoNORTH;

	if (!popup)
	{
		cnt = 0;
		XtSetArg (args[cnt], XtNallowShellResize, True); ++cnt;
		popup = XtCreatePopupShell ("popup", transientShellWidgetClass,
					    gw, args, cnt);
		button = XtCreateManagedWidget ("label", xoButtonWidgetClass,
						popup, (Arg *) NULL,
						(Cardinal) 0);
		XtAddCallback (button, XtNcallback, PopdownCallback,
			       (XtPointer) NULL);
	}
	strcpy (label, XoGetStringFromGravity (parent));
	strcat (label, "/");
	strcat (label, XoGetStringFromGravity (child));
	
	cnt = 0;
	XtSetArg (args[cnt], XtNlabel, label); ++cnt;
	XtSetValues (button, args, cnt);
	XoPlaceRelative (popup, XoShellGet (gw), parent, child, 0);

	if (parent++ >= XoCENTER)
	{
		parent = XoNORTH;
		if (child++ >= XoCENTER)
			child = XoNORTH;
	}
	XtPopup (popup, XtGrabNone);
	XoWidgetLoc (popup, &x, &y, &h, &w);

	printf ("%s: (%d,%d)x(%d,%d)\n", XoName (popup),
		x, y, h ,w);
}

