/*
 * Simple.c,v 2.2 1992/08/11 00:06:24 pete Exp
 * Simple.c,v
 * Revision 2.2  1992/08/11  00:06:24  pete
 * Added stdio.h and removed StringDefs.h since now done by  Xo.h
 *
 * Revision 2.1  1992/07/11  20:03:02  pete
 * Cleaned up a comment.
 *
 * Revision 2.0  1992/04/23  02:52:02  ware
 * First public release.
 *
 * Revision 1.7  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.6  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.5  1992/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.4  1991/12/01  16:18:49  pete
 * Use the cursor defined in the resources.  Create with the specified
 * backing store attributes.  Allow cursor and backingStore to be changed
 * in SetValues().
 *
 * Revision 1.3  1991/08/26  11:58:06  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.2  91/05/22  17:49:45  pete
 * Get it to compile cleanely.  Menus almost work.
 *
 * Revision 1.1  91/05/15  08:56:47  pete
 * Initial revision
 *
 */
#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Xo/SimpleP.h>

#include <X11/Xo/SimpleRec.h>

static void
ClassInit ()
{
	_XoRegisterConverters ();
}

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{
	XoSimpleWidget  w = (XoSimpleWidget) new;
	Arg             args[10];
	Cardinal        cnt;

	w->simple.border_widget = NULL;
	if (w->simple.border_class)
	{
		/*
		 * FIX: Need to pass appropriate args along to the widget.
		 * Probably need to create it (so the border widget has a
		 * chance to indicate it's resoruces and then set them
		 * appropriately.
		 */
		cnt = 0;
		w->simple.border_widget =
			XtCreateWidget ("border", w->simple.border_class,
					(Widget) w, args, cnt);
		_XoInheritedSet (new, w->simple.border_widget,
				 arglist, num_args);
	}
}

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* args applied, not set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoSimpleWidget  w = (XoSimpleWidget) new;
	XoSimpleWidget  cur = (XoSimpleWidget) current;
	Boolean         redisplay = False;
	XtValueMask     vals;
	XSetWindowAttributes attrs;

	if (w->simple.border_widget != cur->simple.border_widget)
	{
		redisplay = True;
		if (cur->simple.border_widget)
		{
			XtDestroyWidget (cur->simple.border_widget);
		}
	}
	if (w->simple.cursor != cur->simple.cursor)
	{
		/*
		 * FIX: Does the cursor need to be freed?
		 */
		if (XtIsRealized ((Widget) new))
		{
			XDefineCursor (XtDisplay (new), XtWindow (new),
				       w->simple.cursor);
		}
	}
	if (w->simple.backing_store != cur->simple.backing_store)
	{
		if (XtIsRealized ((Widget) w))
		{
			vals = CWBackingStore;
			attrs.backing_store = w->simple.backing_store;
			XChangeWindowAttributes (XtDisplay (new),
						 XtWindow (new),
						 vals, &attrs);
		}
	}
	/*
	 * We do nothing with the following fields:
	 * fg		- let other subclasses change the foreground color.
	 * 		Nothing displayed.
	 * insensitive_stipple - same.
	 * traverse_accept	- We either have the focus or not.
	 */
	_XoInheritedSet (new, w->simple.border_widget, args, num_args);
	return redisplay;
}

static void
Realize (gw, valueMask, attrs)
	Widget          gw;
	XtValueMask    *valueMask;
	XSetWindowAttributes *attrs;
{
	XoSimpleWidget  w = (XoSimpleWidget) gw;

	attrs->background_pixel = w->core.background_pixel;
	attrs->backing_store = w->simple.backing_store;
	attrs->cursor = w->simple.cursor;
	*valueMask |= CWCursor | CWBackPixel | CWBackingStore;
	XtCreateWindow (gw, InputOutput, (Visual *) CopyFromParent,
			*valueMask, attrs);
}

static void
Redisplay (gw, event, region)
	Widget          gw;
	XEvent         *event;
	Region          region;
{
	XoSimpleWidget  w = (XoSimpleWidget) gw;

	if (w->simple.border_widget)
	{
		_XoObjRedraw (w->simple.border_widget, event, region);
	}
}
