/*
 * ObjLabel.c,v 2.2 1992/08/11 00:08:02 pete Exp
 * ObjLabel.c,v
 * Revision 2.2  1992/08/11  00:08:02  pete
 * Use insensitive stipple.
 *
 * Revision 2.1  1992/07/11  20:05:12  pete
 * Part of the Xo widget set
 *
 * Revision 2.0  1992/04/23  02:51:49  ware
 * First public release.
 *
 * Revision 1.16  1992/04/23  02:18:44  ware
 * Added several classes.  Worked on geometry management
 *
 * Revision 1.15  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.14  1992/02/23  21:14:34  ware
 * Make the text functions use shared GC's to improve performance.
 *
 * Revision 1.13  1992/02/20  17:00:32  ware
 * Fixed a formatting problem.
 *
 * Revision 1.12  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.11  92/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.10  1991/11/30  15:51:19  pete
 * Cleaned up some nitpicky compile time warnings.
 *
 * Revision 1.9  1991/10/19  01:50:32  pete
 * Pass the Object to XtGetGC() and XtReleaseGC() instead of the parent.
 * Worse, I was inconsistent between the two calls.
 *
 * Revision 1.8  1991/08/26  11:58:04  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.7  91/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.6  1991/06/01  10:03:20  pete
 * Working on menubar
 *
 * Revision 1.5  91/05/22  17:49:44  pete
 * Get it to compile cleanely.  Menus almost work.
 *
 * Revision 1.4  91/05/21  17:15:47  pete
 * Calculate height based on the entire font, not just the string.
 *
 * Revision 1.3  91/05/17  04:47:25  pete
 * Fixed some warnings about unused variables, prototypes.
 *
 * Revision 1.2  1991/05/16  18:40:56  pete
 * Added query_geometry
 *
 * Revision 1.1  91/05/15  08:56:46  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Xo/ObjLabelP.h>
#include <X11/Xo/dbug.h>

XoProto (static void, GetGC, (Widget gw));
XoProto (static void, GetGCAttr, (XoObjLabelWidget w, XtGCMask *mask,
				  XGCValues *attr));
XoProto (static void, JustifyLines, (XoObjLabelWidget w, _XoTextInfo * tinfo));
XoProto (static void, AddLine, (XoObjLabelWidget w, String line,
				_XoTextInfo * tinfo));
XoProto (static void, FreeLines, (Widget gw, _XoTextInfo *tinfo));
XoProto (static _XoTextInfo *, MakeLines, (XoObjLabelWidget w, String line));
XoProto (static void, GetTextSize, (Widget gw, Dimension *width, Dimension *height));
XoProto (static void, ObjLabelPostscript, (Widget tree, XoHardCopy * hardcopy));

#include <X11/Xo/ObjLRec.h>

/*
 *----------------------------------------------------------------------
 * RectObj Class Methods
 *----------------------------------------------------------------------
 */

/*
 * ClassPartInitialize - Installs a hardcopy extension for Postscript.
 */

static void
ClassPartInitialize (class)
	WidgetClassRec *class;
{
	XoHardcopyAddExtension (class, XoPostscript, 1L, ObjLabelPostscript,
				(XtPointer) NULL);
}

/*
 * Redraw the string.  Don't attempt to determine the minimum
 * amount of work, just do it.
 */

static void
Redisplay (gw, event, region)
	Widget          gw;		/* should be subclassof ObjDraw */
	XEvent         *event;		/* the exposure event */
	Region          region;		/* the uncovered region */
{
	XoObjLabelWidget w = (XoObjLabelWidget) gw;
	Position        y;
	int             i;

	if (w->obj_draw.no_draw)
		return;
	y = _XoObjDrawTop (w);
	for (i = 0; i < w->obj_label.lines->ti_num_lines; i++)
	{
		CallLabelDraw (w, i, y);
		y += w->obj_label.lines->ti_lines[i].height;
	}
}

static void
Resize (gw)
	Widget		gw;
{
	XoObjLabelWidget w = (XoObjLabelWidget) gw;

	JustifyLines (w, w->obj_label.lines);
	JustifyLines (w, w->obj_label.default_lines);
}

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied but no
					 * set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoObjLabelWidget w = (XoObjLabelWidget) new;
	XoObjLabelWidget cur = (XoObjLabelWidget) current;
	Boolean         newstring = False;
	Boolean         redisplay = False;
	Boolean         need_gc = False;

	DBUG_ENTER ("ObjLabel.SetValues");
	if (w->rectangle.sensitive != cur->rectangle.sensitive ||
	w->rectangle.ancestor_sensitive != cur->rectangle.ancestor_sensitive)
	{
		need_gc = True;
		newstring = True;
		redisplay = True;
	}
	if (w->obj_label.label != cur->obj_label.label)
	{
		newstring = True;
		redisplay = True;
		XtFree (cur->obj_label.label);
		if (w->obj_label.label)
			w->obj_label.label = XtNewString (w->obj_label.label);
		else
			w->obj_label.label = XtNewString (XtName ((Widget) w));
	}
	else if (w->obj_label.label && strcmp (w->obj_label.label, cur->obj_label.label) != 0)
	{
		newstring = True;
		redisplay = True;
	}
	if (w->obj_label.default_label != cur->obj_label.default_label)
	{
		newstring = True;
		XtFree (cur->obj_label.default_label);
		if (w->obj_label.default_label)
			w->obj_label.default_label = XtNewString (w->obj_label.default_label);
	}
	else if (w->obj_label.default_label &&
	strcmp (w->obj_label.default_label, cur->obj_label.default_label) != 0)
	{
		newstring = True;
	}
	if (w->obj_label.justify != cur->obj_label.justify)
	{
		JustifyLines (w, w->obj_label.lines);
		JustifyLines (w, w->obj_label.default_lines);
		redisplay = True;
	}
	if (w->obj_label.font != cur->obj_label.font)
	{
		need_gc = True;
		redisplay = True;
	}
	if (need_gc)
	{
		GetGC ((Widget) w);
		if (!newstring)
		{
			JustifyLines (w, w->obj_label.lines);
			JustifyLines (w, w->obj_label.default_lines);
		}
	}
	if (newstring)
	{
		FreeLines ((Widget) w, w->obj_label.lines);
		w->obj_label.lines = MakeLines (w, w->obj_label.label);
		FreeLines ((Widget) w, w->obj_label.default_lines);
		w->obj_label.default_lines = MakeLines (w, w->obj_label.default_label);
		JustifyLines (w, w->obj_label.lines);
		JustifyLines (w, w->obj_label.default_lines);
		GetTextSize ((Widget) w, &w->rectangle.width,
			     &w->rectangle.height);
	}
	DBUG_RETURN (redisplay);
}

/*
 * Initialize an instance of this object.  We allocate space for a new string,
 * calculate the gc to use and set up the relative coordinates for
 * drawing the text
 */
static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* args passed to create */
	Cardinal       *num_args;	/* number of arguments */
{
	XoObjLabelWidget w = (XoObjLabelWidget) new;

	if (!w->obj_label.label)
	{
		w->obj_label.label = XtName (new);
	}
	w->obj_label.label = XtNewString (w->obj_label.label);
	w->obj_label.gc = NULL;
	w->obj_label.lines = NULL;
	w->obj_label.default_lines = NULL;
	w->obj_label.default_width = 0;
	w->obj_label.default_height = 0;
	w->obj_draw.stipple = XoShadingGetPixmap (XtScreenOfObject (new),
						  w->obj_draw.insensitive_stipple,
						  0, 0, True);
	GetGC ((Widget) w);
	w->obj_label.lines = MakeLines (w, w->obj_label.label);
	JustifyLines (w, w->obj_label.lines);

	w->obj_label.default_lines = MakeLines (w, w->obj_label.default_label);
	JustifyLines (w, w->obj_label.default_lines);
	GetTextSize ((Widget) w, &w->rectangle.width, &w->rectangle.height);
}

static void
Destroy (gw)
	Widget          gw;
{
	XoObjLabelWidget w = (XoObjLabelWidget) gw;

	if (w->obj_label.gc)
		XtReleaseGC (gw, w->obj_label.gc);
	FreeLines (gw, w->obj_label.lines);
	FreeLines (gw, w->obj_label.default_lines);
	if (w->obj_draw.stipple)
	{
		XoShadingReleasePixmap (w->obj_draw.stipple);
		w->obj_draw.stipple = NULL;
	}
}

static XtGeometryResult
GeometryQuery (gw, proposed, desired)
	Widget          gw;
	XtWidgetGeometry *proposed;
	XtWidgetGeometry *desired;
{
	XoObjLabelWidget w = (XoObjLabelWidget) gw;
	XtGeometryResult result;
	Dimension       width, height;

	GetTextSize ((Widget) w, &width, &height);
	/*
	 * I'm just being asked my ideal size
	 */
	if (!proposed->request_mode)
	{
		if (width == w->rectangle.width
		    && height == w->rectangle.height)
			result = XtGeometryNo;
		else
		{
			desired->width = width;
			desired->height = height;
			desired->request_mode = CWWidth | CWHeight;
			result = XtGeometryAlmost;
		}
	}
	else if (XoGeoDimFlags (proposed) == CWWidth)
	{
		desired->height = height;
		desired->request_mode = CWHeight;
		/* we don't adjust height */
		result = XtGeometryYes;
	}
	else if (XoGeoDimFlags (proposed) == CWHeight)
	{
		/* we don't adjust width */
		desired->width = width;
		desired->request_mode = CWWidth;
		result = XtGeometryYes;
	}
	else
	{
		if (proposed->width == width && proposed->height == height)
			result = XtGeometryYes;
		else
		{
			result = XtGeometryNo;
		}
	}
	return result;
}

/*
 *----------------------------------------------------------------------
 * ObjDraw Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * ObjLabel Class Methods
 *----------------------------------------------------------------------
 */

static void
LabelMake (gw, line, l)
	Widget		gw;
	String		line;
	XoLines		*l;
{
	XoObjLabelWidget	w = (XoObjLabelWidget) gw;
	int		direction;
	int		ascent;
	int		descent;
	XCharStruct	overall;	/* determines size of text */

	l->label = (XtPointer) XtNewString (line);
	XTextExtents (w->obj_label.font, (char *) l->label,
		      strlen ((char *) l->label),
		      &direction, &ascent, &descent, &overall);
	l->width = overall.width;
	l->height = 1.2 * (w->obj_label.font->max_bounds.ascent +
 		w->obj_label.font->max_bounds.descent);
	l->offset_y = w->obj_label.font->max_bounds.ascent;
}

static void
LabelDraw (gw, i, y)
	Widget		gw;
	int		i;
	int		y;
{
	XoObjLabelWidget	w = (XoObjLabelWidget) gw;
	XoLines		*l;

	l = &w->obj_label.lines->ti_lines[i];
	XDrawString (XtDisplayOfObject (gw), XtWindowOfObject (gw),
		     w->obj_label.gc,
		     _XoObjDrawLeft(w) + l->offset_x,
		     y + l->offset_y,
		     (char *) l->label, strlen ((char *) l->label));
}

static void
LabelFree (gw, tinfo, i)
	Widget		gw;
	_XoTextInfo	*tinfo;
	int		i;
{
	XoLines		*l;

	l = &tinfo->ti_lines[i];
	XtFree ((char *) l->label);
}


/*
 *----------------------------------------------------------------------
 * ObjLabelFormat Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Private Utilities
 *----------------------------------------------------------------------
 */

static void
GetGC (gw)
	Widget          gw;		/* the widget to calc gc for */
{
	XoObjLabelWidget w = (XoObjLabelWidget) gw;
	XtGCMask	mask;
	XGCValues       values;		/* filled in for gc values */

	if (w->obj_label.gc)
	{
		XtReleaseGC (gw, w->obj_label.gc);
	}
	GetGCAttr (w, &mask, &values);
	w->obj_label.gc = XtGetGC (gw, mask, &values);
}

static void
GetGCAttr (w, mask, attr)
	XoObjLabelWidget	w;
	XtGCMask	*mask;
	XGCValues	*attr;
{
	*mask = 0;
	if (XtIsSensitive ((Widget) w))
	{
		attr->fill_style = FillSolid;
		*mask |= GCFillStyle;
	}
	else
	{
		attr->fill_style = FillStippled;
		attr->stipple = w->obj_draw.stipple;
		*mask |= GCFillStyle|GCStipple;
	}
	attr->foreground = w->obj_draw.fg;
	attr->font = w->obj_label.font->fid;
	*mask |= GCForeground|GCFont;
}

static void
GetTextSize (gw, width, height)
	Widget          gw;
	Dimension      *width;
	Dimension      *height;
{
	XoObjLabelWidget w = (XoObjLabelWidget) gw;
	int             i;
	Dimension       def_w = 0;	/* widest label */
	Dimension       h1 = 0;		/* height of normal label */
	Dimension       h2 = 0;		/* height of default label */
	_XoTextInfo    *tinfo;

	tinfo = w->obj_label.lines;
	for (i = 0; i < w->obj_label.lines->ti_num_lines; i++)
	{
		if (tinfo->ti_lines[i].width > def_w)
			def_w = tinfo->ti_lines[i].width;
		h1 += tinfo->ti_lines[i].height;
	}
	if ((tinfo = w->obj_label.default_lines))
	{
		for (i = 0; i < tinfo->ti_num_lines; i++)
		{
			if (tinfo->ti_lines[i].width > def_w)
				def_w = tinfo->ti_lines[i].width;
			h2 += tinfo->ti_lines[i].height;
		}
	}
	if (def_w == 0)
		def_w = 1;
	/* Make the height the larger of the two */
	h2 = h1 > h2 ? h1 : h2;
	if (h2 == 0)
		h2 = 1;
	if (def_w != w->obj_label.default_width)
		*width = def_w;
	else
		*width = w->rectangle.width;
	if (h2 != w->obj_label.default_height)
		*height = h2;
	else
		*height = w->rectangle.height;
}

static void
JustifyLines (w, tinfo)
	XoObjLabelWidget w;
	_XoTextInfo    *tinfo;
{
	int             i;

	if (!tinfo)
		return;
	for (i = 0; i < tinfo->ti_num_lines; i++)
	{
		switch (w->obj_label.justify)
		{
		case XoJUST_LEFT:
			tinfo->ti_lines[i].offset_x = 0;
			break;
		case XoJUST_CENTER:
			tinfo->ti_lines[i].offset_x =
				(_XoObjDrawRight (w) - _XoObjDrawLeft (w)
					- tinfo->ti_lines[i].width)/2;
			break;
		case XoJUST_RIGHT:
			tinfo->ti_lines[i].offset_x =
				_XoObjDrawRight (w) - _XoObjDrawLeft (w)
					- tinfo->ti_lines[i].width;
			break;
		default:
			_XoWarn ((Widget) w, "Bad Value", "Bad XoJustify", "Bad value specified for justification");
			tinfo->ti_lines[i].offset_x = 0;
			break;
		}
	}
}

static void
FreeLines (gw, tinfo)
	Widget		gw;
	_XoTextInfo    *tinfo;
{
	int             j;

	if (tinfo)
	{
		for (j = 0; j < tinfo->ti_num_lines; j++)
		{
			CallLabelFree(gw, tinfo, j);
		}
		XtFree ((char *) tinfo->ti_lines);
		XtFree ((char *) tinfo);
	}
}

static _XoTextInfo *
MakeLines (w, line)
	XoObjLabelWidget w;
	String          line;
{
	char           *ptr;
	char           *buf;
	unsigned int    buflen = 1024;
	int             len;
	_XoTextInfo    *tinfo;

	if (!line)
		return ((_XoTextInfo *) NULL);
	tinfo = (_XoTextInfo *) XtMalloc (sizeof (_XoTextInfo));
	tinfo->ti_lines = NULL;
	tinfo->ti_num_lines = 0;
	buf = XtMalloc (buflen);
	len = 0;
	for (ptr = line; ptr && *ptr; ptr++)
	{
		if (len + 1 >= buflen)
		{
			buflen *= 2;
			buf = XtRealloc (buf, buflen);
		}
		if (*ptr == '\n')
		{
			buf[len] = '\0';
			len = 0;
			AddLine (w, buf, tinfo);
		}
		else if (*ptr == '\\' && ptr[1] == 'n')
		{
			++ptr;
			buf[len] = '\0';
			len = 0;
			AddLine (w, buf, tinfo);
		}
		else
		{
			buf[len++] = *ptr;
		}
	}
	if (len)
	{
		buf[len] = '\0';
		AddLine (w, buf, tinfo);
	}
	XtFree (buf);
	return (tinfo);
}

static void
AddLine (w, line, tinfo)
	XoObjLabelWidget w;
	String          line;
	_XoTextInfo    *tinfo;
{
	XoLines        *l;

	tinfo->ti_lines = (XoLines *)
		XtRealloc ((char *) tinfo->ti_lines,
			   sizeof (XoLines)
			   * (unsigned) (tinfo->ti_num_lines + 1));
	l = &tinfo->ti_lines[tinfo->ti_num_lines];
	CallLabelMake (w, line, l);
	++tinfo->ti_num_lines;
}

/*
 *----------------------------------------------------------------------
 * Printing extensions
 *----------------------------------------------------------------------
 */

static void
ObjLabelPostscript (gw, hardcopy)
	Widget          gw;
	XoHardCopy     *hardcopy;
{
	XoObjLabelWidget w = (XoObjLabelWidget) gw;

	if (!gw || !hardcopy || !XtIsSubclass (gw, xoObjLabelWidgetClass))
		return;
	if (w->obj_draw.no_draw)
		return;
#ifdef notdef
	y = w->rectangle.y;
	for (i = 0; i < w->obj_label.num_lines; i++)
	{
		_xoPStext (hardcopy, gw,
			   w->obj_label.font,
			   w->obj_draw.fg,
			   w->rectangle.x + w->obj_label.lines[i].offset_x,
			   y + w->obj_label.lines[i].offset_y,
			   w->obj_label.lines[i].label);
		y += w->obj_label.lines[i].height;
	}
#endif
}
