/*
 * A MenuBar makes some special arrangements so that it's children
 * can display pulldown menu's.  Typically, MenuBarButton widgets
 * are used as children although anything that can call newPopup
 * on a mouse down and enter and leave events could do so, also.
 *
 * Uses the enablePopup resource to tell children when one of them
 * has popped up a widget.
 *
 * MenuBar.c,v 2.1 1992/06/23 00:28:51 pete Exp
 * MenuBar.c,v
 * Revision 2.1  1992/06/23  00:28:51  pete
 * Changed interface to _XoMenuNew and _XoMenuDone.
 *
 * Revision 2.0  1992/04/23  02:51:13  ware
 * First public release.
 *
 * Revision 1.13  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.12  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.11  92/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.10  1991/11/30  15:51:19  pete
 * Cleaned up some nitpicky compile time warnings.
 *
 * Revision 1.9  1991/08/30  17:39:07  pete
 * Changed to use the new XtNCallbackMenu callback protocol.  Changed
 * Menu to be a subclass of Column.
 *
 * Revision 1.8  91/08/26  11:57:52  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.7  1991/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.6  1991/06/14  17:37:28  pete
 * Added some documentation and generally cleaning up
 *
 * Revision 1.5  91/06/14  10:21:42  pete
 * Inherit the HandlePopup from Menu.
 *
 * Revision 1.4  1991/06/14  04:45:01  pete
 * Support new class methods from Menu.  Actually working menubars.
 *
 * Revision 1.3  91/06/01  10:03:30  pete
 * Working on menubar
 *
 * Revision 1.2  91/05/29  14:42:16  pete
 * Working on getting the menubar to work.
 *
 * Revision 1.1  1991/05/25  11:03:38  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/MenuBarP.h>
#include <X11/Xo/MenuBarB.h>
#include <X11/Xo/dbug.h>

XoProto (static void, CallbackMenu, (Widget gw, XtPointer client_data, XtPointer call_data));

#include <X11/Xo/MenuBarRec.h>

/*
 *----------------------------------------------------------------------
 * Core Methods
 *----------------------------------------------------------------------
 */

/*
 * ClassPartInit - Inherit some class methods appropriately.
 */

static void
ClassPartInit (class)
	WidgetClassRec *class;
{
	XoMenuBarClassRec *c = (XoMenuBarClassRec *) class;
	XoMenuBarClassRec *super;

	DBUG_ENTER ("MenuBar.ClassPartInit");
	super = (XoMenuBarClassRec *) c->core_class.superclass;
	if (c->menu_bar_class.callback_menu == XtInheritCallbackMenu)
		c->menu_bar_class.callback_menu =
			super->menu_bar_class.callback_menu;
	DBUG_VOID_RETURN;
}

/*
 * Initialize - Install the callback for XtNcallbackMenu.
 */

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{

	DBUG_ENTER ("MenuBar.Initialize");
	/*
	 * Add a callback for children to execute when they want to pop up or
	 * down a submenu.  This allows us to popdown any other submenus that
	 * may have been displayed.
	 */
	if (ThisClass (new).menu_bar_class.callback_menu)
	{
		XtAddCallback (new, XtNcallbackMenu,
			       ThisClass (new).menu_bar_class.callback_menu,
			       (XtPointer) new);
	}
	DBUG_VOID_RETURN;
}


/*
 *----------------------------------------------------------------------
 * Composite Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * CompBase Methods
 *----------------------------------------------------------------------
 */

static void
Traverse (gw, client_data, call_data)
	Widget          gw;
	XtPointer       client_data;	/* data from the application */
	XtPointer       call_data;	/* data from the widget */
{
	XoTraverseInfo *info;
	int             i;		/* where this widget is located */
	Widget          next = NULL;	/* widget to try setting focus to */
	XoMenuBarWidget w = (XoMenuBarWidget) gw;

	DBUG_ENTER ("MenuBar.Traverse");
	if (!(info = (XoTraverseInfo *) call_data))
	{
		_XoWarn (gw, "Traverse", "badArgument", "call data is null");
		DBUG_VOID_RETURN;
	}
	switch (info->t_direction)
	{
	case XoTRAVERSE_HOME:
		next = _XoTraverseAfter (gw, 0, info->t_time);
		break;
	case XoTRAVERSE_END:
		next = _XoTraverseBefore (gw, (int) w->composite.num_children - 1, info->t_time);
		break;
	case XoTRAVERSE_LEFT:
	case XoTRAVERSE_PREVIOUS:
	case XoTRAVERSE_UP:
		i = _XoChildFind (gw, info->t_start);
		next = _XoTraverseBefore (gw, i - 1, info->t_time);
		if (!next)
			next = _XoTraverseBefore (gw, (int) w->composite.num_children - 1, info->t_time);
		break;
	case XoTRAVERSE_RIGHT:
	case XoTRAVERSE_NEXT:
	case XoTRAVERSE_DOWN:
		i = _XoChildFind (gw, info->t_start);
		next = _XoTraverseAfter (gw, i + 1, info->t_time);
		if (!next)
			next = _XoTraverseAfter (gw, 0, info->t_time);
		break;
	}
	if (!next)
	{
		info->t_found = XoTraverse (gw, info->t_direction, info->t_time);
	}
	else
	{
		info->t_found = True;
	}
	DBUG_VOID_RETURN;
}

/*
 *----------------------------------------------------------------------
 * Row Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * MenuBar Methods
 *----------------------------------------------------------------------
 */

static void
CallbackMenu (gw, client_data, call_data)
	Widget          gw;
	XtPointer       client_data;
	XtPointer       call_data;
{
	XoMenuBarWidget w = (XoMenuBarWidget) gw;
	XoPopupInfo    *cb = (XoPopupInfo *) call_data;
	XoPopupInfo     info;

	DBUG_ENTER ("MenuBar.CallbackMenu");
	if (!cb)
		DBUG_VOID_RETURN;
	info = *cb;
	if (cb->pi_action == XoPOPUP_NONE)
	{
		info.pi_submenu = NULL;
		XoEnablePopups (gw, False);
		_XoMenuDone (XtParent (gw), info.pi_submenu, info.pi_start,
			     info.pi_where, info.pi_event, XoPOPUP_NONE);
	}
	else if (!cb->pi_submenu)
	{
		info.pi_submenu = NULL;
		_XoMenuNew (w->menu_bar.popup, info.pi_submenu, info.pi_start,
			    info.pi_where, info.pi_event, info.pi_action);
	}
	else
	{
		XoEnablePopups (gw, True);
		_XoMenuNew (w->menu_bar.popup, info.pi_submenu, info.pi_start,
			    info.pi_where, info.pi_event, info.pi_action);
	}
	DBUG_VOID_RETURN;
}

/*
 *----------------------------------------------------------------------
 * Private Utilities
 *----------------------------------------------------------------------
 */
