#ifndef _TABLE_H_
#define _TABLE_H_
/*
 * table.h,v
 * Revision 2.0  1992/04/23  02:49:48  ware
 * First public release.
 *
 * Revision 1.1  1991/05/01  13:31:17  pete
 * Initial revision
 *
 */

typedef struct 
{
	int	t_count;		/* number of elements */
	char	*t_private;		/* private data */
	int	(*t_add)();		/* function to add an element */
	char	*(*t_find) ();		/* finds an element */
	int	(*t_delete) ();		/* delete an element */
	int	(*t_user_free) ();	/* for application to free on delete */
	int	(*t_first) ();		/* set up for first element */
	char	*(*t_next) ();		/* return the next item */
	int	(*t_release) ();	/* free any private data */
} Table;

/*
 * Define succesful and failure return values
 */
#define ERR	-1
#define SUCCESS	0

/*
 * Attempt to figure out if we should use prototypes
 */

#ifndef _USE_PROTO_
#	if defined(__STDC__) || defined(sgi)
#		define _USE_PROTO_
#	endif
#endif

#ifdef _USE_PROTO_
extern Table	*table_init (void);
extern int	table_add (Table *table, char *datum);
extern char	*table_find (Table *table, char *datum);
extern int	table_delete (Table *table, char *datum);
extern int	table_first (Table *table);
extern char	*table_next (Table *table);
#else	/* !_USE_PROTO_ */
extern Table	*table_init ();
extern int	table_add ();
extern char	*table_find ();
extern int	table_delete ();
extern int	table_first ();
extern char	*table_next ();
#endif	/* !_USE_PROTO_ */

#endif /* _TABLE_H_ */
