#include <stdio.h>
#include <ctype.h>
#include "build.h"
#include INCLUDESTRINGS

var_t *
var_make (name, value)
char		*name;
char		*value;
{
	var_t	*v;

	v = (var_t  *) malloc (sizeof (var_t));
	if (v)
	{
		v->v_name = name;
		v->v_value = value;
		v->v_next = NULL;
	}
	return v;
}

var_t *
var_add (list, var)
var_t		*list;
var_t		*var;			/* new variable */
{
	var_t	*p;			/* for stepping down list */
	var_t	*end;			/* the end of the list */

	if (!var)
		return list;
	if (!list)
		return var;
	/*
	 * See if var is already on the list.  If it is, replace
	 * the old value and free any unused space.
	 */
	end = NULL;
	for (p = list; p; p = p->v_next)
	{
		if (strcmp (p->v_name, var->v_name) == 0)
		{
			free (p->v_value);
			p->v_value = var->v_value;
			free (var->v_name);
			free ((char *) var);
			end = NULL;
			break;
		}
		end = p;
	}
	if (end)
	{
		end->v_next = var;
	}
	return list;
}

char *
var_expand (class, name, buf)
class_t		*class;
char		*name;
char		*buf;
{
	char		*val;		/* looked up value */
	char		*ptr;		/* current point in name */
	char		*bufptr;	/* pointer into returned buf */
	char		namebuf[BUFSIZ];

	if (!name || !*name || !buf)
		return name;
	for (bufptr = buf, ptr = name; *ptr; ptr++)
	{
		if (*ptr != '$')
		{
			*bufptr++ = *ptr;
			continue;
		}
		++ptr;
		/*
		 * Copy the variable into namebuf
		 */
		name = namebuf;
		while (isalnum (*ptr) || *ptr == '_')
			*name++ = *ptr++;
		--ptr;
		*name = '\0';
		val = var_lookup (class->cl_vars, namebuf);
		if (val)
		{
			strcpy (bufptr, val);
			bufptr += strlen (val);
		}
	}
	*bufptr = '\0';
	return buf;
}

	
char *
var_lookup (varlist, name)
var_t		*varlist;
char		*name;
{
	if (!name)
		return ((char *) NULL);
	for (; varlist; varlist = varlist->v_next)
	{
		if (varlist->v_name && (strcmp (varlist->v_name, name) == 0))
			return (varlist->v_value);
	}
	return ((char *) NULL);
}
