/*
 * lex.l,v 2.1 1992/07/23 19:02:49 pete Exp
 *
 * lex.l,v
 * Revision 2.1  1992/07/23  19:02:49  pete
 * Removing several error messages.
 *
 * Revision 2.0  1992/04/23  02:47:40  ware
 * First public release.
 *
 * Revision 1.7  1992/02/04  21:21:23  pete
 * Release 44
 *
 * Revision 1.6  1991/08/26  11:21:57  pete
 * Remove extern declarations.  Added constraints keyword.
 *
 * Revision 1.5  1991/06/29  18:32:20  pete
 * Keep track of current file name.  Reset line numbers on new files.
 *
 * Revision 1.4  1991/05/06  14:29:31  pete
 * Added code for allowing multiple input files.
 *
 * Revision 1.3  91/03/11  15:58:45  pete
 * Added actions and translations to grammar.
 * 
 * Revision 1.2  1991/03/09  16:53:57  pete
 * Count lines in strings, also.
 *
 * Revision 1.1  1991/02/21  05:39:19  pete
 * Initial revision
 *
 */
LETTER		[a-zA-Z_]
DIGIT		[0-9]
WORD		{LETTER}({LETTER}|{DIGIT})*

%{
/*
 * Tell build.h and XoUnistd.h that the flex.skel already included
 * appropriate prototypes
 */
#define HAVE_PROTOS
#include "build.h"
#include "grammar.h"
extern char	**xargv;
extern int	xargc;
extern int	optind;
int		line_number = 1;
extern char	*filename;
XoProto (extern char*, get_string, (void));
%}


%%
\n	{++line_number;}
"{"	{return '{';}
"}"	{return '}';}
"("	{return '(';}
")"	{return ')';}
";"	{return ';';}
","	{return ',';}
"="	{return '=';}
class		{return CLASS;}
class_record	{return CLASS_RECORD;}
field		{return FIELD;}
method		{return METHOD;}
function	{return FUNCTION;}
args		{return ARGS;}
code		{return CODE;}
instance	{return INSTANCE;}
actions		{return ACTIONS;}
translations	{return TRANSLATIONS;}
constraints	{return CONSTRAINTS;}
{WORD}		{
			yylval.u_string = malloc (strlen (yytext) + 1);
			strcpy (yylval.u_string, yytext);
			return WORD;
		}
\"		{
			yylval.u_string = get_string ();
			return WORD;
		}
#.*$		{}
[ \t]+		{}
.		{err ("unknown character");}
<<EOF>>		{if (optind < xargc)
		{
			FILE *f;
			if ((f = fopen (xargv[optind], "r")) == NULL)
			{
				perror (xargv[optind]);
			}
			else
			{
				printf ("Reading %s\n", xargv[optind]);
				yyrestart(f);
			}
			line_number = 1;
			filename = xargv[optind];
			++optind;
			YY_NEW_FILE;
		}
		else
		{
			return EOF;
		}
		}
%%
char *
get_string ()
{
	static char	*buf = NULL;	/* input buffer */
	static int	count = 0;	/* space in input buffer */
	int		ch;		/* current input character */
	int		total;		/* number of characters in buf */
	char		*ptr;

	ptr = buf;
	total = 0;
	while ((ch = input ()) != EOF)
	{
		++total;
		if (total >= count)
		{
			count += 1024;
			if (buf)
				buf = realloc (buf, count);
			else
				buf = malloc (count);
			if (!buf)
			{
				fprintf (stderr, "get_string: no more space for %d characters\n",
					 count);
				return ((char *)NULL);
			}
			ptr = buf + total - 1;
		}
		if (ch == '\\')
		{
			if ((ch = input()) == EOF)
				break;
			else if (ch != '"')
			{
				*ptr++ = '\\';
				++total;
				if (total >= count)
				{
					count += 1024;
					buf = realloc (buf, count);
					ptr = buf + total - 1;
				}
			}
		}
		else if (ch == '"')
			break;
		else if (ch == '\n')
			++line_number;
		*ptr++ = ch;
	}
	*ptr++ = '\0';
	ptr = malloc (strlen (buf) + 1);
	strcpy (ptr, buf);
	return (ptr);
}
