
/*
  This header-file is produced automatically (at least in part) by
  makeHeader of BLAB, Ifi, UiO.
*/


/*

________________________________________________________________

        region.h
        $Id: region.h,v 1.20 1997/03/24 09:32:17 svein Exp $
        Copyright 1990, Blab, UiO
        Image processing lab, Department of Informatics
        University of Oslo
        E-mail: blab@ifi.uio.no
________________________________________________________________
  
  Permission to use, copy, modify and distribute this software and its
  documentation for any purpose and without fee is hereby granted, 
  provided that this copyright notice appear in all copies and that 
  both that copyright notice and this permission notice appear in supporting
  documentation and that the name of B-lab, Department of Informatics or
  University of Oslo not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.

  B-LAB DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL B-LAB
  BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
  OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 

*/

#ifndef _REGION_H_
#define _REGION_H_

_XITE_CPLUSPLUS_BEGIN

#include <xite/biff.h>
#include <xite/histo.h>

#define NORTH 0
#define NORTHWEST 1
#define WEST 2
#define SOUTHWEST 3
#define SOUTH 4
#define SOUTHEAST 5
#define EAST 6
#define NORTHEAST 7

#define nilr (region*)0
#define nily (yline*)0

#define YLXSIZE(yl) ((yl)->xmax - (yl)->xmin + 1)
#define YLXSTOP(yl) (((yl)->xmax)

typedef void *ImageData;
typedef int (*intfunc) _XITE_PARAMS((ImageData data, int x, int y, ImageData reldata));

typedef struct _yline
{
  int xmin, xmax;
  struct _yline *next;
} yline;

/* ymin - ymax = region size    */
/* amin - amax = allocated size */

typedef struct _region
{
  int objectnr, regionnr, ymin, ymax, amin, amax, sons, nc;
  struct _region *next, *previous;
  void *userdata;
  yline **ylines;
} region; 


typedef int (*regionfunc) _XITE_PARAMS((void *data1, int x, int y, void *data2));
extern int regionArea  _XITE_PARAMS(( region *reg, int loop, int *area ));
extern region* regionConvexHull  _XITE_PARAMS(( region * reg ));
extern region* regionCreate  _XITE_PARAMS(( int objnr, int regnr, int nc, int ymin, int ymax ));
extern int regionDraw  _XITE_PARAMS(( IBAND band, region * reg, int loop, int pv ));
extern void regionFree  _XITE_PARAMS(( region ** reg, int loop ));
extern int regionHistoUpdate  _XITE_PARAMS(( IBAND band, region * reg, int loop, histogram histo ));
extern int regionHisto  _XITE_PARAMS(( IBAND band, region * reg, int loop, histogram histo ));
extern int regionImoment  _XITE_PARAMS(( IBAND band, region *reg, int loop, double *moments ));
extern yline* regionInsertYline  _XITE_PARAMS(( region * reg, int y, int xmin, int xmax ));
extern yline* regionDeleteYline  _XITE_PARAMS(( region * reg, int y, int xmin, int xmax ));
extern BiffStatus regionEndInsert  _XITE_PARAMS(( region * reg ));
extern int regionXmean  _XITE_PARAMS(( IBAND band, region *reg, int loop, double *xmean ));
extern int regionYmean  _XITE_PARAMS(( IBAND band, region *reg, int loop, double *ymean ));
extern int regionMean  _XITE_PARAMS(( IBAND band, region *reg, int loop, double *xmean, double *ymean ));
extern int regionXmin  _XITE_PARAMS(( region * reg, int loop, int *xmin ));
extern int regionXmax  _XITE_PARAMS(( region * reg, int loop, int *xmax ));
extern int regionYmin  _XITE_PARAMS(( region * reg, int loop, int *ymin ));
extern int regionYmax  _XITE_PARAMS(( region * reg, int loop, int *ymax ));
extern int regionMinMax  _XITE_PARAMS(( region * reg, int loop, int *xmin, int *ymin, int *xmax, int *ymax ));
extern int regionCMoment  _XITE_PARAMS(( IBAND band, region *reg, int p, int q, int loop, double * moment ));
extern int regionPMoment  _XITE_PARAMS(( IBAND band, region *reg, int p, int q, double xc, double yc, int loop, double *moment ));
extern int regionMoment  _XITE_PARAMS(( IBAND band, region *reg, int p, int q, int loop, double * moment ));
extern BiffStatus regionPerform  _XITE_PARAMS(( void *data, region * reg, int loop, regionfunc performproc, void *performdata ));
extern int regionPerimeter  _XITE_PARAMS(( region *reg, int nc, int loop, int * perimeter ));
extern int regionIsPoint  _XITE_PARAMS(( region * reg, int loop, int x, int y ));
extern int regionPoint  _XITE_PARAMS(( region * reg, int *x, int *y ));
extern region * regionSearch  _XITE_PARAMS(( ImageData data, int x, int y, int xmin, int xmax, int ymin, int ymax, int nc, intfunc relfunc, ImageData reldata ));
extern int regionSort  _XITE_PARAMS(( region **regArr, region ***objArr, int rsize, int *osize ));
extern region* regionCopy  _XITE_PARAMS(( region * reg, int loop ));
extern region* regionUnion  _XITE_PARAMS(( region *reg1, region *reg2, int nc ));
extern int regionOverlap  _XITE_PARAMS(( region *r1, region *r2 ));
extern int regionNeighbor  _XITE_PARAMS(( region *reg1, region *reg2, int *overlap, int *adjacent, int nc ));
extern int regionVolume  _XITE_PARAMS(( IBAND band, region *reg, int loop, int *volume ));
extern BiffStatus regionYline  _XITE_PARAMS(( IBAND input, region ***regions, int nc, int sort, int split, int *size ));

_XITE_CPLUSPLUS_END

#endif /* _REGION_H_ */
