
/*

________________________________________________________________

        ideal.h
        $Id: ideal.h,v 1.10 1997/03/24 09:32:02 svein Exp $
        Copyright 1990, Blab, UiO
        Image processing lab, Department of Informatics
        University of Oslo
        E-mail: blab@ifi.uio.no
________________________________________________________________
  
  Permission to use, copy, modify and distribute this software and its
  documentation for any purpose and without fee is hereby granted, 
  provided that this copyright notice appear in all copies and that 
  both that copyright notice and this permission notice appear in supporting
  documentation and that the name of B-lab, Department of Informatics or
  University of Oslo not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.

  B-LAB DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL B-LAB
  BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
  OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 

*/

#ifndef _IDEAL_H_
#define _IDEAL_H_

_XITE_CPLUSPLUS_BEGIN

#include <xite/biff.h>

/* Window functions. */

typedef enum {
  RECTANGLE,
  BARTLETT,
  TRIANGLE,
  HAMMING,
  HANNING
} window_type;

typedef enum {
  LOWPASS,
  HIGHPASS,
  BANDPASS,
  BANDSTOP,
  LOWPASS_IDEAL,
  BUTTER_LP,
  EXP_LP
} filter_type;


extern double hamming  _XITE_PARAMS(( double n, int size ));
extern double hanning  _XITE_PARAMS(( double n, int size ));
extern double rectangle  _XITE_PARAMS(( double n, int size ));
extern double bartlett  _XITE_PARAMS(( double n, int size ));
extern double triangle  _XITE_PARAMS(( double n, int size ));
extern window_type parseWindowName _XITE_PARAMS(( char *name ));
extern int window  _XITE_PARAMS(( IBAND band, int size, window_type win_type ));
extern int lowpass  _XITE_PARAMS(( IBAND cb, double cut_frequency, int filter_size, window_type win_type ));
extern int lowpassu  _XITE_PARAMS(( IBAND cb, double cut_frequency, int filter_size, window_type win_type, double *sum ));
extern BiffStatus lowpassf  _XITE_PARAMS(( IBAND out_band, double cut_frequency, int filter_size, window_type win_type ));
extern int highpass  _XITE_PARAMS((IBAND cb, double cut_frequency, int *filter_size, window_type win_type ));
extern BiffStatus highpassf  _XITE_PARAMS(( IBAND out_band, double cut_frequency, int *filter_size, window_type win_type ));
extern int bandpass  _XITE_PARAMS(( IBAND cb, double low_cut_frequency, double high_cut_frequency, int filter_size, window_type win_type ));
extern int bandpassu  _XITE_PARAMS(( IBAND cb, double low_cut_frequency, double high_cut_frequency, int filter_size, window_type win_type, double *sum ));
extern BiffStatus bandpassf  _XITE_PARAMS(( IBAND out_band, double low_cut_frequency, double high_cut_frequency, int filter_size, window_type win_type ));
extern int bandstop  _XITE_PARAMS(( IBAND cb, double low_cut_frequency, double high_cut_frequency, int *filter_size, window_type win_type ));
extern BiffStatus bandstopf  _XITE_PARAMS((IBAND out_band, double low_cut_frequency, double high_cut_frequency, int *filter_size, window_type win_type ));
extern BiffStatus lowpassIdealf  _XITE_PARAMS(( IBAND out_band, double cut_frequency ));
extern BiffStatus butterworthf _XITE_PARAMS(( IBAND band, double cut_frequency, int filter_order ));
extern int exponentialf _XITE_PARAMS(( IBAND band, double cut_frequency, int filter_order ));
extern filter_type parseFilterTypeName _XITE_PARAMS(( char *name ));

_XITE_CPLUSPLUS_END

#endif /* _IDEAL_H_ */
