

/*

________________________________________________________________

        ImageOverlayResize.c
        $Id: ImageOverlayPix.c,v 1.20 1995/11/28 16:35:26 svein Exp $
        Copyright 1990, Blab, UiO
        Image processing lab, Department of Informatics
        University of Oslo
        E-mail: blab@ifi.uio.no
________________________________________________________________
  
  Permission to use, copy, modify and distribute this software and its
  documentation for any purpose and without fee is hereby granted, 
  provided that this copyright notice appear in all copies and that 
  both that copyright notice and this permission notice appear in supporting
  documentation and that the name of B-lab, Department of Informatics or
  University of Oslo not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.

  B-LAB DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL B-LAB
  BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
  OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 

*/

#include "ImagePixType.h"

typedef ImageBytePix ImagePixel; 
static unsigned char btrans_s[256];

#define ImageXxxxResize ImageOverlayResize
#define ImageXxxxPrintf ImageOverlayPrintf
#define PrintfFormat "%-3d"

#define RESIZE_NO(a) *a++
#define RESIZE_YES(a) a[*xptr_s]
#define EQ_PRO(left, OP, right) left OP btrans_s[right]
#define EQ_24(a) \
  { j = a; if (j) *ximg_ptr_s++ = btrans_s[j]; else ximg_ptr_s++; }
#define EQ_8(a) \
  { j = a; if (j) *ximg_ptr_s++ = btrans_s[j]; else ximg_ptr_s++; }
#define EQ_4A(a) \
  { j = a; if (j){k = (*ximg_ptr_s & 0xf) << 4; *ximg_ptr_s &= 0xf0;\
				   *ximg_ptr_s += btrans_s[k];} ximg_ptr_s++;}
#define EQ_4B(a) \
  { j = a; if (j){k = *ximg_ptr_s; *ximg_ptr_s &= 0x0f;\
				   *ximg_ptr_s += (btrans_s[k] << 4);}}
#define EQ_2A(a) (a)
#define EQ_2B    ^= 


#define INIT24\
  for(i=0; i<256; i++) btrans_s[i] = i >=128 ? i-128 : i+128;
#define INIT21\
  cells_s = wid->image_overlay.cells;\
  if (wid->image_overlay.colorptr)\
    for(i=0; i<256; i++) btrans_s[i] = \
      wid->image_overlay.colorptr[i % cells_s];\
  else\
    for(i=0; i<256; i++) btrans_s[i] = (i >=128) ? (i-128) : (i+128);
#define INIT8\
  for(i=0; i<256; i++) btrans_s[i] = (i * 147) & 0xff;

/* Example for INIT7:
 * cells_s = 32 and colorptr[0..31] = [192..223]
 * means that [0..255] % cells_s = [0..31]
 * and btrans_s[0..255] = [192..223, 192..223, 192..223, 192..223, ...].
 */
#define INIT7\
  cells_s = wid->image_overlay.cells;\
  if (wid->image_overlay.colorptr)\
    for(i=0; i<256; i++) btrans_s[i] = \
      wid->image_overlay.colorptr[i % cells_s];\
  else\
    for(i=0; i<256; i++) btrans_s[i] = (i >=128) ? (i-128) : (i+128);
#define INIT4\
  for(i=0; i<256; i++) btrans_s[i] = i >=128 ? ((i-128) >> 4) : ((i+128) >> 4);
#define INIT2

#define ADDRESS ImageOverlayScreenXYtoAdr
#define IMAGE_OVERLAY

#include "ImageProtoPix.c"


