/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/
#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
int set_deci();
void set_mono();
void update_lims(), update_sphered(), update_world();
void world_to_plane(), plane_to_screen(), plot_once();
void SetNiceRange(), init_ticks(), update_cprof_plot();
void show_message();
/* */

#define NTFORMS 8
char message[300];
#define DOMAIN_ERROR sprintf(message, "Data outside the domain of function.\n")

static char *tform_names[NTFORMS];
static int *tform_type;
struct {
	Widget cascade;
	Widget btn[NTFORMS];
} tform_menu;

int
transform(xg, cols, ncols, tfnum)
  xgobidata *xg;
  int *cols, ncols;
  int tfnum;
{
  int i, j, n;

  switch(tfnum)
  {
    case 0:    /* Restore original values */
      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
          xg->tform_data[i][j] = xg->raw_data[i][j];

        (void) strcpy(xg->collab_tform[j], xg->collab[j]);
      }
      break;
    case 1:    /* 1/x */
      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
        {
          if (xg->raw_data[i][j] == 0)
          {
            DOMAIN_ERROR;
            show_message(message, xg);
            return(0);
          }
        }
      }

      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
        {
          xg->tform_data[i][j] = (float)
            pow((double) xg->raw_data[i][j], (double) (-1.0));
        }

        (void)
           sprintf(xg->collab_tform[j], "1/%s", xg->collab[j]);
      }
      break;
    case 2:    /* Natural log */
      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
        {
          if (xg->raw_data[i][j] <= 0)
          {
            DOMAIN_ERROR;
            show_message(message, xg);
            return(0);
          }
        }
      }
      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
        {
          xg->tform_data[i][j] = (float)
            log((double) xg->raw_data[i][j]);
        }

        (void)
           sprintf(xg->collab_tform[j], "ln(%s)", xg->collab[j]);
      }
      break;

    case 3:    /* Fourth root */
      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
        {
          if (xg->raw_data[i][j] < 0)
          {
            DOMAIN_ERROR;
            show_message(message, xg);
            return(0);
          }
        }
      }

      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
        {
          if (xg->raw_data[i][j] < 0)
          {
            xg->tform_data[i][j] = (float)
              - pow( - (double) xg->raw_data[i][j],
                   (double) (1.0/4.0));
          }
          else
          {
            xg->tform_data[i][j] = (float)
              pow((double) xg->raw_data[i][j],
                (double) (1.0/4.0));
          }
        }
        (void)
           sprintf(xg->collab_tform[j], "%s^(1/4)", xg->collab[j]);
      }
      break;

    case 4:    /* Cube root */
      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
        {
          if (xg->raw_data[i][j] < 0)
          {
            xg->tform_data[i][j] = (float)
              - pow( - (double) xg->raw_data[i][j],
                   (double) (1.0/3.0));
          }
          else
          {
            xg->tform_data[i][j] = (float)
              pow((double) xg->raw_data[i][j],
                (double) (1.0/3.0));
          }
        }
        (void)
           sprintf(xg->collab_tform[j], "%s^(1/3)", xg->collab[j]);
      }
      break;

    case 5:    /* Square root */
      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
        {
          if (xg->raw_data[i][j] < 0)
          {
            DOMAIN_ERROR;
            show_message(message, xg);
            return(0);
          }
        }
      }
      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
        {
          xg->tform_data[i][j] = (float)
            sqrt((double) xg->raw_data[i][j]);
        }

        (void)
           sprintf(xg->collab_tform[j], "%s^1/2", xg->collab[j]);
      }
      break;
    case 6:    /* Square */
      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
          xg->tform_data[i][j] = (float)
            pow((double) xg->raw_data[i][j], (double) 2);

        (void)
           sprintf(xg->collab_tform[j], "%s^2", xg->collab[j]);
      }
      break;
    case 7:    /* Cube */
      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        for (i=0; i<xg->nrows; i++)
          xg->tform_data[i][j] = (float)
            pow((double) xg->raw_data[i][j], (double) 3);

        (void)
           sprintf(xg->collab_tform[j], "%s^3", xg->collab[j]);
      }
      break;
  }
  return(1);
}

/* ARGSUSED */
XtCallbackProc
tform_choose_cback(w, xgobi, cback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t cback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;
  int j, n;
  int varno = -1, tfno;
  char *tf_name;
  Widget label = XtParent(XtParent(w));
  int *cols, ncols;
  int groupno;

  if (xg->is_touring && (xg->is_princ_comp || xg->is_pp) )
  {
    sprintf(message,
      "Sorry, it isn't possible to transform variables during\n");
    strcat(message,
      "projection pursuit or when principal components are used.\n");
    show_message(message, xg);
  }
  else
  {
    /*
     * Figure out which variable is to be transformed.
    */
    for (varno=0; varno<xg->ncols_used; varno++)
      if (xg->varlabw[varno] == label)
        break;

    if (varno < 0)
    {
      (void) fprintf(stderr, "error in tform_choose_cback\n");
      return;
    }

    /*
     * Figure out which transformation to do.
    */
    XtVaGetValues(w, XtNlabel, &tf_name, NULL);

    for (tfno=0; tfno<NTFORMS; tfno++)
      if (strcmp(tf_name, tform_names[tfno]) == 0)
        break;

    /*
     * Figure out which columns to transform.
    */
    ncols = 0;
    groupno = xg->vgroup_ids[varno];
    cols = (int *) XtMalloc((Cardinal) xg->ncols_used * sizeof(int));
    for (j=0; j<xg->ncols_used; j++)
    {
      if (xg->vgroup_ids[j] == groupno)
        cols[ncols++] = j;
    }

    /*
     * Call the appropriate transformation program.
    */
    if ( transform(xg, cols, ncols, tfno) )
    {
      update_sphered(xg, cols, ncols);
      update_lims(xg);
      update_world(xg);

      /* Set tform_type[] for transformed columns */
      for (n=0; n<ncols; n++)
        tform_type[cols[n]] = tfno;

      world_to_plane(xg);
      plane_to_screen(xg);
      /*
       * This bit of init_axes() is needed.
      */
      for (n=0; n<ncols; n++)
      {
        j = cols[n];
        xg->nicelim[j].min = xg->lim0[j].min;
        xg->nicelim[j].max = xg->lim0[j].max;
        SetNiceRange(j, xg);
        xg->deci[j] = set_deci(xg->tickdelta[j]);
      }

      if (xg->is_xyplotting)
        init_ticks(&xg->xy_vars, xg);
      else if (xg->is_dotplotting)
        init_ticks(&xg->dotplot_vars, xg);

      plot_once(xg);

      if (xg->is_cprof_plotting)
        update_cprof_plot(xg);
    }
    XtFree((XtPointer) cols);
  }
  XtDestroyWidget((Widget) tform_menu.cascade);
}

/* ARGSUSED */
XtEventHandler
add_tform_menu(w, xgobi, evnt)
/*
 * Add menus for choosing a data transformation.
*/
  Widget w;
  xgobidata *xgobi;
  XEvent *evnt;
{
  xgobidata *xg = (xgobidata *) xgobi;
  int i, k, varno;
  static int initd = 0;

  for (varno=0; varno<xg->ncols; varno++)
    if (xg->varlabw[varno] == w)
      break;

  if (initd == 0)
  {
    for (i=0; i<NTFORMS; i++)
      tform_names[i] = (char *) XtMalloc((Cardinal) 25 * sizeof(char));

    strcpy(tform_names[0], "Restore Variable");
    strcpy(tform_names[1], "Inverse");
    strcpy(tform_names[2], "Natural Log");
    strcpy(tform_names[3], "Fourth Root");
    strcpy(tform_names[4], "Cube Root");
    strcpy(tform_names[5], "Square Root");
    strcpy(tform_names[6], "Square");
    strcpy(tform_names[7], "Cube");

    initd = 1;
  }

  tform_menu.cascade = XtVaCreatePopupShell("menu",
    simpleMenuWidgetClass, xg->varlabw[varno],
    NULL);
  if (mono) set_mono(tform_menu.cascade);

  for (k=0; k<NTFORMS; k++)
  {
    tform_menu.btn[k] = XtVaCreateManagedWidget("Command",
      smeBSBObjectClass, tform_menu.cascade,
      XtNlabel, (String) tform_names[k],
      XtNleftMargin, (Dimension) 24,
      NULL);
    if (mono) set_mono(tform_menu.btn[k]);
    XtAddCallback(tform_menu.btn[k], XtNcallback,
      (XtCallbackProc) tform_choose_cback, (XtPointer) xg);
  }

  XtVaSetValues(tform_menu.btn[tform_type[varno]],
    XtNleftBitmap, menu_mark, NULL);
}

void
alloc_transform_types(xg)
  xgobidata *xg;
{
  tform_type = (int *) XtRealloc((char *) tform_type,
    (Cardinal) xg->ncols * sizeof(int));
}

void
init_transform_types(xg)
/*
 * Set each tranformation type to 0;
*/
  xgobidata *xg;
{
  int j;

  for (j=0; j<xg->ncols; j++)
    tform_type[j] = 0;
}
