/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
XtCallbackProc tour_speed_cback();
XtCallbackProc tour_pause_cback();
XtCallbackProc tour_backtrack_cback();
XtCallbackProc tour_cycleback_cback();
XtCallbackProc tour_reinit_cback();
XtCallbackProc tour_receive_cback();
XtCallbackProc tour_step_cback();
XtCallbackProc tour_step_go_cback();
XtCallbackProc tour_local_cback();
XtCallbackProc choose_tour_io_cback();
XtCallbackProc princ_comp_cback();
XtCallbackProc tour_pp_cback();
XtCallbackProc tour_section_cback();
XtCallbackProc choose_tour_interp_cback();
Widget CreateToggle(), CreateCommand();
void set_mono(), add_sbar_help();
void make_pp_panel();
void make_section_panel();
void add_menupb_help();
/* */

Widget tour_panel, tour_cmd[8], tour_label[2];
Widget tour_sbar;
Widget tour_interp_menu_cmd, tour_interp_menu, tour_interp_menu_btn[3];
int tour_interp_btn = 0;

#define PAUSE tour_cmd[0]
#define REINIT tour_cmd[1]
#define RECEIVE tour_cmd[2]
#define STEP tour_cmd[3]
#define GO tour_cmd[4]
#define LOCALSCAN tour_cmd[5]
#define BACKTRACK tour_cmd[6]
#define DIRECTION tour_cmd[7]

void
stop_receive_tour(xg)
  xgobidata *xg;
{
  XtCallCallbacks(RECEIVE, XtNcallback, (XtPointer) xg);
  XtVaSetValues(RECEIVE,
    XtNstate, (Boolean) False,
    NULL);
}

void
set_receive_tour(xg, state)
  xgobidata *xg;
  Boolean state;
{
  XtVaSetValues(RECEIVE,
    XtNstate, (Boolean) state,
    NULL);
}

void
set_sens_receive(sens)
  int sens;
{
  XtVaSetValues(RECEIVE,
    XtNsensitive, (Boolean) sens,
    NULL);
}

void
turn_off_local_scan(xg)
  xgobidata *xg;
{
  XtCallCallbacks(LOCALSCAN, XtNcallback, (XtPointer) xg);
  XtVaSetValues(LOCALSCAN,
    XtNstate, (Boolean) False,
    NULL);
}

void
make_tour_io_menu(xg, parent)
  xgobidata *xg;
  Widget parent;
{
  int k;

  xg->tour_io_menu_cmd = XtVaCreateManagedWidget("MenuButton",
    menuButtonWidgetClass, parent,
    XtNlabel, (String) "I/O",
    XtNmenuName, (String) "Menu",
    XtNfromVert, (Widget) DIRECTION,
    NULL);
  if (mono) set_mono(xg->tour_io_menu_cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    xg->tour_io_menu_cmd, "Tour_IOMenu");

  xg->tour_io_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass,
    xg->tour_io_menu_cmd,
    NULL);
  if (mono) set_mono(xg->tour_io_menu);

  xg->tour_io_menu_btn[0] = XtVaCreateWidget("Command",
    smeBSBObjectClass, xg->tour_io_menu,
    XtNlabel, (String) "Save Coeffs",
    NULL);
  if (mono) set_mono(xg->tour_io_menu_btn[0]);

  xg->tour_io_menu_btn[1] = XtVaCreateWidget("Command",
    smeBSBObjectClass, xg->tour_io_menu,
    XtNlabel, (String) "Save History",
    XtNsensitive, (Boolean) False,
    NULL);
  if (mono) set_mono(xg->tour_io_menu_btn[1]);

  xg->tour_io_menu_btn[2] = XtVaCreateWidget("Command",
    smeBSBObjectClass, xg->tour_io_menu,
    XtNlabel, (String) "Read History",
    XtNsensitive, (Boolean) False,
    NULL);
  if (mono) set_mono(xg->tour_io_menu_btn[2]);

  XtManageChildren(xg->tour_io_menu_btn, 3);

  for (k=0; k<3; k++)
  {
    XtAddCallback(xg->tour_io_menu_btn[k], XtNcallback,
      (XtCallbackProc) choose_tour_io_cback, (XtPointer) xg);
  }
}

void
init_tour_interp_menu(xg)
  xgobidata *xg;
{
  XtVaSetValues(tour_interp_menu_btn[0],
    XtNleftBitmap, menu_mark, NULL);
}

void
make_tour_interp_menu(xg, parent)
  xgobidata *xg;
  Widget parent;
/*
 * Build a menu to contain interpolation choices.
*/
{
  int j;

  tour_interp_menu_cmd = XtVaCreateManagedWidget("MenuButton",
    menuButtonWidgetClass, parent,
    XtNlabel, (String) "Interp",
    XtNmenuName, (String) "Menu",
    XtNfromHoriz, (Widget) xg->tour_io_menu_cmd,
    XtNfromVert, (Widget) BACKTRACK,
    NULL);
  if (mono) set_mono(tour_interp_menu_cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    tour_interp_menu_cmd, "Tour_InterpMenu");

  tour_interp_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass,
    tour_interp_menu_cmd, NULL);
  if (mono) set_mono(tour_interp_menu);

  tour_interp_menu_btn[0] = XtVaCreateWidget("Command",
    smeBSBObjectClass, tour_interp_menu,
    XtNlabel, (String) "Geodesic",
    XtNleftMargin, (Dimension) 24,
    NULL);
  if (mono) set_mono(tour_interp_menu_btn[0]);

  tour_interp_menu_btn[1] = XtVaCreateWidget("Command",
    smeBSBObjectClass, tour_interp_menu,
    XtNlabel, (String) "Householder",
    XtNleftMargin, (Dimension) 24,
    NULL);
  if (mono) set_mono(tour_interp_menu_btn[1]);

  tour_interp_menu_btn[2] = XtVaCreateWidget("Command",
    smeBSBObjectClass, tour_interp_menu,
    XtNlabel, (String) "Givens",
    XtNleftMargin, (Dimension) 24,
    NULL);
  if (mono) set_mono(tour_interp_menu_btn[2]);

  XtManageChildren(tour_interp_menu_btn, 3);

  for (j=0; j<3; j++)
    XtAddCallback(tour_interp_menu_btn[j], XtNcallback,
      (XtCallbackProc) choose_tour_interp_cback, (XtPointer) xg);
}

void
make_tour(xg)
  xgobidata *xg;
{
  Dimension width;
  char str[30];
  Dimension max_width;
/*
 * Widest button label used in this panel.
*/
  sprintf(str, "ProjPrst Section");
  max_width = XTextWidth(appdata.font, str, strlen(str)) +
    4 * ASCII_TEXT_BORDER_WIDTH + 3 + 2;
  /* borders around text, spacing between widgets, widget borders */

/*
 * TourPanel
*/
  tour_panel = XtVaCreateManagedWidget("TourPanel",
    formWidgetClass, xg->box0,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNright, (XtEdgeType) XtChainLeft,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNbottom, (XtEdgeType) XtChainTop,
    XtNmappedWhenManaged, (Boolean) False,
    NULL);
  if (mono) set_mono(tour_panel);
/*
 * tour speed scrollbar
*/
  tour_sbar = XtVaCreateManagedWidget("Scrollbar",
    scrollbarWidgetClass, tour_panel,
    XtNwidth, (Dimension) max_width,
    XtNorientation, (XtOrientation) XtorientHorizontal,
    NULL);
  if (mono) set_mono(tour_sbar);

  add_sbar_help(&xg->nhelpids.sbar,
    tour_sbar, "Tour_Speed");

  XawScrollbarSetThumb(tour_sbar, 20.*TOURSTEP0 + .05, -1.);
  XtAddCallback(tour_sbar, XtNjumpProc,
    (XtCallbackProc) tour_speed_cback, (XtPointer) xg);

/*
 * tour pause control
*/
  PAUSE = CreateToggle(xg, "Pause",
    True, (Widget) NULL, tour_sbar, (Widget) NULL, False, ANY_OF_MANY,
    tour_panel, "Tour_Pause");
  XtAddCallback(PAUSE, XtNcallback,
    (XtCallbackProc) tour_pause_cback, (XtPointer) xg);

/*
 * Reinit button
*/
  REINIT = CreateCommand(xg, "Reinit",
    True, PAUSE, tour_sbar,
    tour_panel, "Tour_Reinit");
  XtAddCallback(REINIT, XtNcallback,
    (XtCallbackProc) tour_reinit_cback, (XtPointer) xg);

/*
 * Button to allow linked touring; turns on receive mode.
*/
  RECEIVE = CreateToggle(xg, "Receive Tour",
    True, (Widget) NULL, REINIT, (Widget) NULL,
    False, ANY_OF_MANY,
    tour_panel, "Tour_Receive");
  XtAddCallback(RECEIVE, XtNcallback,
    (XtCallbackProc) tour_receive_cback, (XtPointer) xg);
/*
 * Button to allow stepping instead of continuous grand tour
*/
  STEP = CreateToggle(xg, "Step",
    True, (Widget) NULL, RECEIVE, (Widget) NULL, False, ANY_OF_MANY,
    tour_panel, "Tour_StepGo");
  XtAddCallback(STEP, XtNcallback,
    (XtCallbackProc) tour_step_cback, (XtPointer) xg);
/* */

  GO = CreateCommand(xg, "Go",
    False, STEP, RECEIVE,
    tour_panel, "Tour_StepGo");
  XtAddCallback(GO, XtNcallback,
    (XtCallbackProc) tour_step_go_cback, (XtPointer) xg);

/*
 * Button for local scan
*/
  LOCALSCAN = CreateToggle(xg, "Local Scan",
    True, (Widget) NULL, STEP, (Widget) NULL, False, ANY_OF_MANY,
    tour_panel, "Tour_LocalScan");
  XtAddCallback(LOCALSCAN, XtNcallback,
    (XtCallbackProc) tour_local_cback, (XtPointer) xg);

/*
 * tour backtrack control: initiate insensitive, turn on
 * when there are more than two or three elements in the
 * history file
*/
  BACKTRACK = CreateToggle(xg, "Backtrck",
    False, (Widget) NULL, LOCALSCAN, (Widget) NULL, False, ANY_OF_MANY,
    tour_panel, "Tour_Backtrack");
  XtAddCallback(BACKTRACK, XtNcallback,
    (XtCallbackProc) tour_backtrack_cback, (XtPointer) xg);

/*
 * label to record number of bases in history file
*/
  sprintf(str, "%d ", MAXHIST);
  width = XTextWidth(appdata.font, str, strlen(str));

  tour_label[0] = XtVaCreateManagedWidget("TourLabel",
    asciiTextWidgetClass, tour_panel,
    XtNfromVert, (Widget) LOCALSCAN,
    XtNfromHoriz, (Widget) BACKTRACK,
    XtNstring, (String) "1",
    XtNdisplayCaret, (Boolean) False,
    XtNwidth, (Dimension) width,
    NULL);
  if (mono) set_mono(tour_label[0]);

/*
 * Button to allow cycling backwards and forwards through backtracking
*/
  DIRECTION = CreateCommand(xg, "F",
    False, tour_label[0], LOCALSCAN,
    tour_panel, "Tour_BtrackDir");
  XtAddCallback(DIRECTION, XtNcallback,
    (XtCallbackProc) tour_cycleback_cback, (XtPointer) xg);

  XtManageChildren(&PAUSE, 8);

  make_tour_io_menu(xg, tour_panel );

  make_tour_interp_menu(xg, tour_panel);

/*
 * Button for switching to proncipal component axes
*/
  xg->princ_comp_cmd = CreateToggle(xg, "PrnCmp Basis",
    True, (Widget) NULL, xg->tour_io_menu_cmd, (Widget) NULL, False,
    ANY_OF_MANY,
    tour_panel, "Tour_PrinComp");
  XtManageChild(xg->princ_comp_cmd);
  XtAddCallback(xg->princ_comp_cmd, XtNcallback,
    (XtCallbackProc) princ_comp_cback, (XtPointer) xg);

/*
 * tour projection pursuit control
*/
  xg->proj_pursuit_cmd = CreateToggle(xg, "ProjPrst",
    True, (Widget) NULL, (Widget) xg->princ_comp_cmd,
    (Widget) NULL, False, ANY_OF_MANY,
    tour_panel, "ToPP");
  XtManageChild(xg->proj_pursuit_cmd);
  XtAddCallback(xg->proj_pursuit_cmd, XtNcallback,
    (XtCallbackProc) tour_pp_cback, (XtPointer) xg);

/*
 * Button for section tour
*/
  xg->tour_section_cmd = CreateToggle(xg, "Section",
    True, (Widget) xg->proj_pursuit_cmd, (Widget)  xg->princ_comp_cmd,
    (Widget) xg->proj_pursuit_cmd, False, ANY_OF_MANY,
    tour_panel, "Tour_Section");
  XtManageChild(xg->tour_section_cmd);
  XtAddCallback(xg->tour_section_cmd, XtNcallback,
    (XtCallbackProc) tour_section_cback, (XtPointer) xg);

  make_pp_panel(xg, tour_panel);
  make_section_panel(xg, tour_panel, max_width);
}

void
highlight_pause_cmd()
{
  XtVaSetValues(PAUSE, XtNstate, (Boolean) True, NULL);
}

void
reset_pause_cmd(xg)
  xgobidata *xg;
{
  XtCallCallbacks(PAUSE, XtNcallback, (XtPointer) xg);
  XtVaSetValues(PAUSE, XtNstate, (Boolean) True, NULL);
}

void
reset_cycleback_cmd(xg, set, sens, label)
  xgobidata *xg;
  int set, sens;
  char *label;
{
  if (set)
    XtVaSetValues(DIRECTION,
      XtNsensitive, (Boolean) sens,
      XtNlabel, (String) label,
      NULL);
  else
    XtVaSetValues(DIRECTION,
      XtNlabel, (String) label,
      NULL);
}

void
set_sens_localscan(xg, sens)
  xgobidata *xg;
  int sens;
{
  XtVaSetValues(LOCALSCAN,
    XtNsensitive, (Boolean) sens,
    NULL);
}

void
set_sens_reinit(xg, sens)
  xgobidata *xg;
  int sens;
{
  XtVaSetValues(REINIT,
    XtNsensitive, (Boolean) sens,
    NULL);
}

void
set_sens_go(xg, sens)
  xgobidata *xg;
  int sens;
{
  XtVaSetValues(GO,
    XtNsensitive, (Boolean) sens,
    NULL);
}

void
turn_off_stepping(xg)
  xgobidata *xg;
{
  XtCallCallbacks(STEP, XtNcallback, (XtPointer) NULL);
  XtVaSetValues(STEP,
    XtNstate, (Boolean) 0,
    NULL);

}

void
set_sens_step(xg, sens)
  xgobidata *xg;
  int sens;
{
  XtVaSetValues(STEP,
    XtNsensitive, (Boolean) sens,
    NULL);
}

void
set_sens_speed(xg, sens)
  xgobidata *xg;
  int sens;
{
  XtVaSetValues(tour_sbar,
    XtNsensitive, (Boolean) sens,
    NULL);
}

void
set_sens_interp(xg, sens)
  xgobidata *xg;
  int sens;
{
  XtVaSetValues(tour_interp_menu_cmd,
    XtNsensitive, (Boolean) sens,
    NULL);
}

void
set_sens_io(xg, sens0, sens1, sens2)
  xgobidata *xg;
  int sens0, sens1, sens2;
{
  XtVaSetValues(xg->tour_io_menu_btn[0],
    XtNsensitive, (Boolean) sens0,
    NULL);
  XtVaSetValues(xg->tour_io_menu_btn[1],
    XtNsensitive, (Boolean) sens1,
    NULL);
  XtVaSetValues(xg->tour_io_menu_btn[2],
    XtNsensitive, (Boolean) sens2,
    NULL);
}

void
highlight_backtrack_cmd()
{
  XtVaSetValues(BACKTRACK, XtNstate, (Boolean) False, NULL);
}

void
reset_backtrack_cmd(xg, reset, set, sens, activ)
  xgobidata *xg;
  int reset, set, sens, activ;
{
  if (reset)
    XtVaSetValues(BACKTRACK,
      XtNstate, (Boolean) set,
      XtNsensitive, (Boolean) sens,
      NULL);
  else
    XtVaSetValues(BACKTRACK,
      XtNsensitive, (Boolean) sens,
      NULL);

  if (activ)
    XtCallCallbacks(BACKTRACK, XtNcallback, (XtPointer) NULL);
}

set_sens_direction(xg, sens)
  xgobidata *xg;
  int sens;
{
  XtVaSetValues(DIRECTION,
    XtNsensitive, (Boolean) sens,
    NULL);
}

void
reset_tourhist_cmds(xg, sens)
  xgobidata *xg;
  int sens;
{
  XtVaSetValues(xg->tour_io_menu_btn[1],
    XtNsensitive, (Boolean) sens,
    NULL);

  XtVaSetValues(xg->tour_io_menu_btn[2],
    XtNsensitive, (Boolean) sens,
    NULL);
}

void
reset_interp_cmd(sens)
  int sens;
{
  XtVaSetValues(tour_interp_menu_cmd,
    XtNsensitive, (Boolean) sens,
    NULL);
}

void
map_tour_panel(xg, is_tour_on)
  xgobidata *xg;
  Boolean is_tour_on;
{
  if (is_tour_on)
    XtMapWidget(tour_panel);
  else
    XtUnmapWidget(tour_panel);
}

void
nback_update_label(xg)
  xgobidata *xg;
{
  char str[10];

  (void) sprintf(str, "%d", xg->nhist_list);
  XtVaSetValues(tour_label[0],
    XtNstring, (String) str,
    NULL);
}

void
reinit_tour(xg)
  xgobidata *xg;
{
  XtCallCallbacks(REINIT, XtNcallback, (XtPointer) xg);
}

#undef PANEL1
#undef PANEL2
#undef PANEL3

#undef PAUSE
#undef STEP
#undef GO
#undef LOCALSCAN
#undef BACKTRACK
#undef DIRECTION
#undef REINIT
