/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
void read_array();
int read_rowlabels(), read_collabels();
int read_erase(), read_extra_resources();
int read_vgroups(), read_connecting_lines();
int read_brush_indices();
void destroy_varsel_widgets(), reset_var_panel();
void copy_raw_to_tform();
void fill_extra_column();
void update_lims(), update_world();
void world_to_plane();
void alloc_tour(), allocate_arrays(), alloc_plot_arrays();
void alloc_pipeline_arrays();
void free_tour(), free_arrays(), free_plot_arrays();
void free_pipeline_arrays();
void init_axes(), init_line_colors(), init_ticks();
void init_tour(), ndata_reset_main_panel();
void plane_to_screen(), plot_once(), refresh_vboxes();
void reinit_tour_hist(), reset_3d_cmds();
void reset_backtrack_cmd(), reset_cycleback_cmd();
void set_title_and_icon(), set_varsel_label(), sphered_data_fn();
void turn_off_pc(), turn_off_pp();
void turn_off_cprof_plotting();
void fname_popup();
void turn_on_xyplotting(), map_xyplot();
void init_brush_menus();
void init_dotplot_vars();
void init_xyplot_vars();
void init_rotate_vars();
void init_brush_vars();
void init_scale_vars();
void init_identify_vars();
void init_line_edit_vars();
void alloc_brush_arrays(), free_brush_arrays();
void alloc_rotate_arrays(), free_rotate_arrays();
void alloc_line_edit_arrays(), free_line_edit_arrays();
void alloc_axis_arrays(), free_axis_arrays();
void show_message();
/* */

/* ARGSUSED */
XtCallbackProc
place_ndata_popup(w, xgobi, callback_data)
/*
 * Determine where to place the popup window in which the user enters
 * a filename; invoked before ndata_read.
*/
  Widget w;
  XtPointer xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  turn_on_xyplotting(xg);
  map_xyplot(True);

  (void) strcpy(xg->save_type, READ_DATA );
  fname_popup(w, xg);
}

void
read_data(w, xg)
  Widget w;
  xgobidata *xg;
{
  int k;
  char *filename;
  char fname[100];
  float ftmp;
  FILE *fopen(), *fp;
  int ncols_prev = xg->ncols;
  int fclose();

  XtVaGetValues(w,
    XtNstring, &filename,
    NULL);
/*
 * All very interesting, but not useful so far.  Perhaps if I
 * begin looking for "name filename" in the resource file, it
 * will turn out to be useful after all.
 *
 *  XrmDatabase *newdb = (XrmDatabase *) NULL;
 *  XrmPutStringResource(&newdb,
 *    (String) "*title", (String) "NewData");
 *  XrmPutStringResource(&newdb,
 *    (String) "*iconName", (String) "NewData");
 *
 *  XrmMergeDatabases(newdb, &display->db);
 *  XrmPutFileDatabase(display->db, "/u/dfs/xgobi/DBold");
*/
  if (Sprocess)
  {
    return;
  }
  else if ((fp = fopen(filename, "r")) == NULL)
  {
    strcpy(fname, filename);
    strcat(fname, ".dat");
    if ((fp = fopen(fname, "r")) == NULL)
    {
      char message[200];
      sprintf(message, "Failed to open either %s or %s for reading\n",
        filename, fname);
      show_message(message, xg);
      return;
    }
  }

/* Check that this is truly a readable file, not a directory */
  if (fscanf(fp, "%f", &ftmp) < 0)
  {
    char message[200];
    sprintf(message, "Failed to open either %s or %s for reading\n",
      filename, fname);
    show_message(message, xg);
    return;
  }
/* Check that the file closes normally */
  if (fclose(fp) == EOF)
  {
    char message[200];
    sprintf(message, "Failed to close %s normally.\n",
      filename);
    show_message(message, xg);
    return;
  }
/*
 * Now that we know this is a reasonable file, free the old
 * arrays before determining a new xg->nrows and xg->ncols.
*/
  if (xg->is_pp)
    turn_off_pp(xg);
  if (xg->is_princ_comp)
    turn_off_pc(xg);
  free_plot_arrays();
  free_brush_arrays(xg);
  free_rotate_arrays();
  free_line_edit_arrays(xg);
  free_axis_arrays(xg);
  free_pipeline_arrays(xg);
  if (ncols_prev >2)
    free_tour(xg);

  for (k=0; k<xg->nrows; k++)
    XtFree((XtPointer) xg->raw_data[k]);
  XtFree((XtPointer) xg->raw_data);

  for (k=0; k<ncols_prev; k++)
    XtFree((XtPointer) xg->collab[k]);
  XtFree((XtPointer) xg->collab);
  for (k=0; k<ncols_prev; k++)
    XtFree((XtPointer) xg->collab_tform[k]);
  XtFree((XtPointer) xg->collab_tform);

  for (k=0; k<xg->nrows; k++)
    XtFree((XtPointer) xg->rowlab[k]);
  XtFree((XtPointer) xg->rowlab);

  XtFree((XtPointer) xg->vgroup_ids);
  XtFree((XtPointer) xg->connecting_lines);
  XtFree((XtPointer) xg->erased);

  (void) read_array(filename, xg);
  fill_extra_column(xg);
  (void) read_extra_resources(filename);
  (void) read_collabels(filename, xg);
  (void) read_rowlabels(filename, xg);
  (void) read_vgroups(filename, xg);
  (void) read_connecting_lines(filename, False, xg);
  (void) read_erase(filename, xg);

  destroy_varsel_widgets(ncols_prev, xg);

  set_title_and_icon(filename, xg);
  alloc_pipeline_arrays(xg);
  alloc_plot_arrays(xg);
  alloc_brush_arrays(xg);  /* has to be done before read_brush_indices() */
  alloc_rotate_arrays(xg);
  alloc_line_edit_arrays(xg);
  alloc_axis_arrays(xg);

  if (read_brush_indices(filename, xg))
    init_line_colors(xg);

/*
 * Reinitialize variables and data arrays.
*/
  xg->nrows_in_plot = xg->nrows;

  init_dotplot_vars(xg);
  init_xyplot_vars(xg);
  init_rotate_vars(xg);
  init_brush_vars(xg);
  init_scale_vars(xg);
  init_identify_vars(xg);
  init_line_edit_vars(xg);

  if (xg->ncols > 2)
  {
    alloc_tour(xg);
    reinit_tour_hist(xg);
    init_tour(xg, 0);
  }
  copy_raw_to_tform(xg);

  ndata_reset_main_panel(xg);
/*
 * See whether rotate and tour should be sensitive or insensitive.
*/
  reset_3d_cmds(xg);
/*
 * Backtracking has to be off, and the forward/backward button insensitive.
*/
  reset_backtrack_cmd(xg, 1, 0, 1, 0);
  reset_cycleback_cmd(xg, 1, 0, "F");

/*
 * If case profile plot is up, close it
*/
  if (xg->is_cprof_plotting)
    turn_off_cprof_plotting(xg);

  if (xg->ncols > 2)
    sphered_data_fn(xg);
  update_lims(xg);
  update_world(xg);

/*
 * Reinitialize variable selection panel.
*/
  set_varsel_label(xg);
  XSync(display, False);
  reset_var_panel(xg);

/*
 * Reinitialize the brush menus
  init_brush_menus(xg);
*/

  world_to_plane(xg);
  plane_to_screen(xg);
/*
 * Reinitialize axes and ticks.
*/
  init_axes(xg, 0);
  init_ticks(&xg->xy_vars, xg);

  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
place_savedata_popup(w, xgobi, callback_data)
/*
 * Determine where to place the popup window in which the user enters
 * a filename; invoked before ndata_read.
*/
  Widget w;
  XtPointer xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  (void) strcpy(xg->save_type, SAVE_DATA );
  fname_popup(w, xg);
}

void
save_data(w, xg)
  Widget w;
  xgobidata *xg;
{
  int i, j;
  char *filename;
  FILE *fopen(), *fp;
  int fclose();
  char message[200];

  XtVaGetValues(w,
    XtNstring, &filename,
    NULL);

  if (Sprocess)
  {
    return;
  }
  else
  {
    fp = fopen(filename, "w");
    if (fp == NULL)
    {
      sprintf(message, "Failed to open %s for writing.\n", filename);
      show_message(message, xg);
      return;
    }
    else
    {
      /*
       * If using principal components and touring is on,
       * then write out the sphered data.  Otherwise, write out
       * the transformed data.
      */
      if (xg->is_touring && xg->is_princ_comp)
      {
        sprintf(message,
          "Writing out sphered data for active variables only.\n");
        show_message(message, xg);
        for (i=0; i<xg->nrows_in_plot; i++)
        {
          if (!xg->erased[i])
          {
            for (j=0; j<xg->numvars_t; j++)
              (void) fprintf(fp, "%f ",
                xg->sphered_data[i][ xg->tour_vars[j] ]);
            (void) fprintf(fp, "\n");
          }
        }
      }
      else
      {
        for (i=0; i<xg->nrows_in_plot; i++)
        {
          if (!xg->erased[i])
          {
            for (j=0; j<xg->ncols_used; j++)
              (void) fprintf(fp, "%f ", xg->tform_data[i][j]);
            (void) fprintf(fp, "\n");
          }
        }
      }
    }
    fclose(fp);
  }
}
