/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
Boolean RunWorkProcs();
int find_nearest_point();
int qsort();
void fname_popup();
void plot_once(), init_line_colors();
void quickplot_once();
void turn_on_showlines();
void show_message();
Widget CreateToggle(), CreateCommand();
void set_mono();
/* */

static Widget line_edit_panel, le_cmd[5];

#define ADD le_cmd[0]
#define DELETE le_cmd[1]
#define REMOVE_ALL le_cmd[2]
#define SAVE le_cmd[3]
#define READ le_cmd[4]

XSegment *connecting_segs;
Boolean is_le_adding, is_le_deleting;
static int *avec, *bvec;
static int le_start = -1, le_nearest_pt = -1, le_nearest_line = -1;

/* --------- Dynamic allocation section ----------- */
void
alloc_line_edit_arrays(xg)
/*
 * Dynamically allocate arrays.
*/
  xgobidata *xg;
{
/*
 * It might be a good idea to use nrows_in_plot rather
 * than nrows for these.  It would require a lot of
 * Reallocing, but would enable XGobi to handle larger
 * matrices.
*/
  Cardinal nl = (Cardinal) xg->nlinks;

  connecting_segs = (XSegment *)
    XtMalloc(nl * sizeof(XSegment));

  xg->line_color_ids = (unsigned long *)
    XtMalloc(nl * sizeof(unsigned long));
  xg->line_color_now = (unsigned long *)
    XtMalloc(nl * sizeof(unsigned long));
  xg->line_color_prev = (unsigned long *)
    XtMalloc(nl * sizeof(unsigned long));
  xg->xed_by_new_brush = (unsigned short *)
    XtMalloc(nl * sizeof(unsigned short));
}

void
free_line_edit_arrays(xg)
/*
 * Dynamically free arrays.
*/
  xgobidata *xg;
{
  XtFree((XtPointer) connecting_segs);

  XtFree((XtPointer) xg->line_color_ids);
  XtFree((XtPointer) xg->line_color_now);
  XtFree((XtPointer) xg->line_color_prev);
  XtFree((XtPointer) xg->xed_by_new_brush);
}

void
realloc_lines(xg)
  xgobidata *xg;
{
  xg->connecting_lines = (connect_lines *)
    XtRealloc((XtPointer) xg->connecting_lines,
    (unsigned) xg->nlinks * sizeof(connect_lines));

  connecting_segs = (XSegment *)
    XtRealloc((XtPointer) connecting_segs,
    (unsigned) xg->nlinks * sizeof(XSegment));

  xg->line_color_ids = (unsigned long *)
    XtRealloc((XtPointer) xg->line_color_ids,
    (unsigned) xg->nlinks * sizeof(unsigned long));
  xg->line_color_now = (unsigned long *)
    XtRealloc((XtPointer) xg->line_color_now,
    (unsigned) xg->nlinks * sizeof(unsigned long));
  xg->line_color_prev = (unsigned long *)
    XtRealloc((XtPointer) xg->line_color_prev,
    (unsigned) xg->nlinks * sizeof(unsigned long));
  xg->xed_by_new_brush = (unsigned short *)
    XtRealloc((XtPointer) xg->xed_by_new_brush,
    (unsigned) xg->nlinks * sizeof(unsigned short));
}

/* --------- End of dynamic allocation section ----------- */

void
init_line_edit_vars(xg)
  xgobidata *xg;
{
  static Boolean firsttime = True;

  if (firsttime)
  {
    is_le_deleting = True;
    is_le_adding = False;

    firsttime = False;
  }
  xg->is_line_editing = False;
}

int
sort_by_abvecs(x1, x2)
  int *x1, *x2;
{
  int val = 0;

  if ( (avec[*x1] < avec[*x2]) ||
     (avec[*x1] == avec[*x2] && bvec[*x1] < bvec[*x2]) )
  {
    val = -1;
  }
  else if ( (avec[*x1] > avec[*x2]) ||
        (avec[*x1] == avec[*x2] && bvec[*x1] > bvec[*x2]) )

  {
    val = 1;
  }

  return(val);
}

void
sort_connecting_lines(xg)
  xgobidata *xg;
{
  int i;
  int *tvec, *indx;
/*
 * sort_by_abvecs is used by qsort to put indx in the order of the
 * b's within the a's.
*/
  indx = (int *) XtMalloc((Cardinal) xg->nlinks * sizeof(int));
  avec = (int *) XtMalloc((Cardinal) xg->nlinks * sizeof(int));
  bvec = (int *) XtMalloc((Cardinal) xg->nlinks * sizeof(int));
  tvec = (int *) XtMalloc((Cardinal) xg->nlinks * sizeof(int));

  for (i=0; i<xg->nlinks; i++)
  {
    avec[i] = xg->connecting_lines[i].a;
    bvec[i] = xg->connecting_lines[i].b;
    indx[i] = i;
  }

  qsort((char *) indx, xg->nlinks, sizeof(int), sort_by_abvecs);

  for (i=0; i<xg->nlinks; i++)
  {
    xg->connecting_lines[i].a = avec[indx[i]];
    xg->connecting_lines[i].b = bvec[indx[i]];
  }

  for (i=0; i<xg->nlinks; i++)
    tvec[i] = xg->line_color_ids[i];
  for (i=0; i<xg->nlinks; i++)
    xg->line_color_ids[i] = tvec[indx[i]];

  for (i=0; i<xg->nlinks; i++)
    tvec[i] = xg->line_color_now[i];
  for (i=0; i<xg->nlinks; i++)
    xg->line_color_now[i] = tvec[indx[i]];

  for (i=0; i<xg->nlinks; i++)
    tvec[i] = xg->line_color_prev[i];
  for (i=0; i<xg->nlinks; i++)
    xg->line_color_prev[i] = tvec[indx[i]];

  XtFree((XtPointer) avec);
  XtFree((XtPointer) bvec);
  XtFree((XtPointer) tvec);
  XtFree((XtPointer) indx);
}

int
read_connecting_lines(data_in, literal, xg)
  char *data_in;
  Boolean literal;
  xgobidata *xg;
{
/*
 * If literal is True, then read the filename exactly as it's
 * been given, without appending .lines.  This option is used
 * by the read_lines callback.
*/
  int i, fs, nblocks, bsize = 500;
  int ok = 1;
  int jlinks = 0;
  char fname[110];
  FILE *fopen(), *fp;
  int fclose();

/*
 * Check file exists and open it - for stdin no open needs to be done
 * only assigning fp to be stdin.
*/
  if (data_in != NULL && strcmp(data_in,"stdin") != 0)
  {
    strcpy(fname, data_in);
    if (!literal)
      strcat(fname, ".lines");
    if ((fp = fopen(fname, "r")) != NULL)
    {
      int a, b;

      xg->nlinks = 0;
      /*
       * Allocate space for <bsize> connecting lines.
      */
      xg->connecting_lines = (connect_lines *) XtMalloc(
        (Cardinal) bsize * sizeof(connect_lines));
      nblocks = 1;

      while (1)
      {
        fs = fscanf(fp, "%d %d", &a, &b);
        if (fs == EOF)
        {
          break;
        }
        else if (fs < 0)
        {
          ok = 0;
/* won't change this one; called at startup */
          fprintf(stderr, "Error in reading .lines file\n");
          exit(1);
        }

        if (a < 1 || b > xg->nrows)
        {
          ok = 0;
          fprintf(stderr, "Entry in .lines file > number of rows or < 1\n");
          exit(1);
        }
        else
        {
          /*
           * Sort lines data such that a <= b
          */
          if (a <= b)
          {
            xg->connecting_lines[xg->nlinks].a = a;
            xg->connecting_lines[xg->nlinks].b = b;
          }
          else
          {
            xg->connecting_lines[xg->nlinks].a = b;
            xg->connecting_lines[xg->nlinks].b = a;
          }

          (xg->nlinks)++;
          jlinks++;
          if (jlinks == bsize)
          {
          /*
           * Allocate space for <bsize> more connecting links.
          */
            nblocks++;

            xg->connecting_lines = (connect_lines *)
              XtRealloc((XtPointer) xg->connecting_lines,
              (unsigned) (nblocks*bsize) *
              sizeof(connect_lines));
            jlinks = 0;
          }
        }
      } /* end while */
      /*
       * Close the data file
      */
      if (fclose(fp) == EOF)
        fprintf(stderr, "Error in closing .lines file");
    }
    else /* Create defaults */
    {
      xg->nlinks = xg->nrows - 1;
      xg->connecting_lines = (connect_lines *) XtMalloc(
        (Cardinal) xg->nlinks * sizeof(connect_lines));

      for (i=0; i<xg->nlinks; i++)
      {
        xg->connecting_lines[i].a = i+1;
        xg->connecting_lines[i].b = i+2;
      }
    }
  } else { /* Create defaults */
    xg->nlinks = xg->nrows - 1;
    xg->connecting_lines = (connect_lines *) XtMalloc(
      (Cardinal) xg->nlinks * sizeof(connect_lines));

    for (i=0; i<xg->nlinks; i++)
    {
      xg->connecting_lines[i].a = i+1;
      xg->connecting_lines[i].b = i+2;
    }
  }

  return(ok);
}

int
find_nearest_line(cursor_pos, xg)
  icoords *cursor_pos;
  xgobidata *xg;
{
  int sqdist, near, j, lineid, xdist, ydist;
  icoords a, b, distab, distac, d;
  float proj;

  lineid = -1;
  if (xg->nlinks)
  {
    xdist = ydist = sqdist = near = 1000 * 1000;
    for (j=0; j<xg->nlinks; j++)
    {
      if (!xg->erased[xg->connecting_lines[j].a-1] &&
          !xg->erased[xg->connecting_lines[j].b-1])
      {
        a.x = xg->screen[xg->connecting_lines[j].a-1].x;
        a.y = xg->screen[xg->connecting_lines[j].a-1].y;
        b.x = xg->screen[xg->connecting_lines[j].b-1].x;
        b.y = xg->screen[xg->connecting_lines[j].b-1].y;

        distab.x = b.x - a.x;
        distab.y = b.y - a.y;
        distac.x = cursor_pos->x - a.x;
        distac.y = cursor_pos->y - a.y;

        if (distab.x == 0 && distab.y != 0)
        {
          sqdist = distac.x * distac.x ;
          if (sqdist <= near && abs(distac.y) < ydist)
          {
            near = sqdist;
            ydist = abs(distac.y) ;
            lineid = j;
          }
        }
        else if (distab.y == 0 && distab.x != 0)
        {
          sqdist = distac.y * distac.y ;
          if (sqdist <= near && abs(distac.x) < xdist)
          {
            near = sqdist;
            xdist = abs(distac.x) ;
            lineid = j;
          }
        }
        else if (distab.x != 0 && distab.y != 0)
        {
          proj = ((float) ((distac.x * distab.x) +
                           (distac.y * distab.y))) /
                 ((float) ((distab.x * distab.x) +
                           (distab.y * distab.y)));

          d.x = (int) (proj * (float) (b.x - a.x)) + a.x;
          d.y = (int) (proj * (float) (b.y - a.y)) + a.y;

          if (BETWEEN(a.x, b.x, d.x) && BETWEEN(a.y, b.y, d.y))
          {
            sqdist = (cursor_pos->x - d.x) * (cursor_pos->x - d.x) +
                 (cursor_pos->y - d.y) * (cursor_pos->y - d.y);
          } else {
            sqdist = MIN(
             (cursor_pos->x - a.x) * (cursor_pos->x - a.x) +
             (cursor_pos->y - a.y) * (cursor_pos->y - a.y),
             (cursor_pos->x - b.x) * (cursor_pos->x - b.x) +
             (cursor_pos->y - b.y) * (cursor_pos->y - b.y) );
          }
          if (sqdist < near)
          {
            near = sqdist;
            lineid = j;
          }
        }
      }
    }
  }
  return(lineid);
}

void
line_edit_proc(xg)
  xgobidata *xg;
{
  int root_x, root_y;
  unsigned int kb;
  Window root, child;
  icoords cpos;
  static int ocpos_x = 0, ocpos_y = 0;
  static int icount = 0;

/*
 * Get the current pointer position.
*/
  if (XQueryPointer(display, xg->plot_window, &root, &child,
            &root_x, &root_y, &cpos.x, &cpos.y, &kb))
  {
    /*
     * If the pointer is inside the plotting region ...
    */
    if ((0 < cpos.x && cpos.x < xg->max.x) &&
      (0 < cpos.y && cpos.y < xg->max.y))
    {
      icount = 1;
      /*
       * If the pointer has moved ...
      */
      if ((cpos.x != ocpos_x) || (cpos.y != ocpos_y))
      {
        ocpos_x = cpos.x;
        ocpos_y = cpos.y;

        if (is_le_adding)
          le_nearest_pt = find_nearest_point(&cpos, xg);

        else if (is_le_deleting && xg->connect_the_points)
          le_nearest_line = find_nearest_line(&cpos, xg);

        quickplot_once(xg);
      }
    }
    else
    {
      le_nearest_pt = -1;
      le_nearest_line = -1;
      if (icount)
      {
        /*
         * Plot once ... then there won't be an id in the plot
         * if the cursor is outside the plot window.
        */

        quickplot_once(xg);
        icount = 0;
      }
    }
  }
}

void
add_line(a, b, xg)
  int a, b;
  xgobidata *xg;
{
  int n = xg->nlinks;

  xg->nlinks++;

  realloc_lines(xg);
  xg->connecting_lines[n].a = a+1;
  xg->connecting_lines[n].b = b+1;

  xg->line_color_now[n]  = plotcolors.fg;
  xg->line_color_ids[n]  = plotcolors.fg;
  xg->line_color_prev[n] = plotcolors.fg;

  sort_connecting_lines(xg);
}


/* ARGSUSED */
XtEventHandler
add_line_button(w, xg, evnt, dispatch)
  Widget w;
  xgobidata *xg;
  XEvent *evnt;
  Boolean *dispatch;
{
  XButtonEvent *xbutton = (XButtonEvent *) evnt;
  int root_x, root_y;
  unsigned int kb;
  Window root, child;
  icoords cpos;
  static int last_addeda = -1, last_addedb = -1;
  int i;

  switch (xbutton->type)
  {
    case ButtonPress:

      if (xbutton->button == 1)
      {
        if (le_nearest_pt != -1)
        {
          /*
           * Get the current pointer position.
          */
          if (XQueryPointer(display, xg->plot_window, &root, &child,
            &root_x, &root_y, &cpos.x, &cpos.y, &kb))
          {
            le_nearest_pt = find_nearest_point(&cpos, xg);
          }
        }
        le_start = le_nearest_pt;
      }
      else if (xbutton->button == 2 &&
           last_addeda > -1 && last_addedb > -1)
      /*
       * delete most recently added line, which is at
       * the end of the connecting_lines[] structure
      */
      {
        int link_to_remove;

        for (i=0; i<xg->nlinks; i++)
        {
          if (xg->connecting_lines[i].a == last_addeda &&
            xg->connecting_lines[i].b == last_addedb)
          {
            link_to_remove = i;
            break;
          }
        }

        for (i=link_to_remove; i<(xg->nlinks-1); i++)
        {
          xg->connecting_lines[i].a = xg->connecting_lines[i+1].a;
          xg->connecting_lines[i].b = xg->connecting_lines[i+1].b;

          xg->line_color_now[i]  = xg->line_color_now[i+1];
          xg->line_color_ids[i]  = xg->line_color_ids[i+1];
          xg->line_color_prev[i] = xg->line_color_prev[i+1];
        }

        xg->nlinks--;
        realloc_lines(xg);
        last_addeda = last_addedb = -1;
      }

      break;

    case ButtonRelease:

      if (xbutton->button == 1)
      {
        if (le_start != -1 && le_nearest_pt && (le_nearest_pt != le_start) )
        {
          if (le_start <= le_nearest_pt)
            add_line(le_start, le_nearest_pt, xg);
          else
            add_line(le_nearest_pt, le_start, xg);

          last_addeda = xg->connecting_lines[xg->nlinks-1].a;
          last_addedb = xg->connecting_lines[xg->nlinks-1].b;
        }
        le_start = -1;
        le_nearest_pt = -1;
      }
      break;

  }
  plot_once(xg);
}

/* ARGSUSED */
static XtEventHandler
delete_line_button(w, xg, evnt, dispatch)
  Widget w;
  xgobidata *xg;
  XEvent *evnt;
  Boolean *dispatch;
{
  int root_x, root_y;
  unsigned int kb;
  Window root, child;
  icoords cpos;
  XButtonEvent *xbutton = (XButtonEvent *) evnt;
  int i;
  static int last_deleteda = -1, last_deletedb = -1;
  static long last_color_now, last_color_ids, last_color_prev;

  if (xbutton->type == ButtonPress)
  {
    if (xbutton->button == 1 && le_nearest_line > -1)
    {
      last_deleteda = xg->connecting_lines[le_nearest_line].a;
      last_deletedb = xg->connecting_lines[le_nearest_line].b;

      last_color_now  = xg->line_color_now[le_nearest_line];
      last_color_ids  = xg->line_color_ids[le_nearest_line];
      last_color_prev = xg->line_color_prev[le_nearest_line];

      for (i=le_nearest_line; i<(xg->nlinks-1); i++)
      {
        xg->connecting_lines[i].a = xg->connecting_lines[i+1].a;
        xg->connecting_lines[i].b = xg->connecting_lines[i+1].b;

        xg->line_color_now[i]  = xg->line_color_now[i+1];
        xg->line_color_ids[i]  = xg->line_color_ids[i+1];
        xg->line_color_prev[i] = xg->line_color_prev[i+1];
      }
      xg->nlinks--;
      realloc_lines(xg);
      /*
       * Get the current pointer position.
      */
      if (XQueryPointer(display, xg->plot_window, &root, &child,
        &root_x, &root_y, &cpos.x, &cpos.y, &kb))
      {
        le_nearest_line = find_nearest_line(&cpos, xg);
      }
    }
    else if (xbutton->button == 2 && last_deleteda > -1)
    {
      xg->nlinks++;
      realloc_lines(xg);
      xg->connecting_lines[xg->nlinks-1].a = last_deleteda;
      xg->connecting_lines[xg->nlinks-1].b = last_deletedb;
      last_deleteda = last_deletedb = -1;

      xg->line_color_now[xg->nlinks-1]  = last_color_now;
      xg->line_color_ids[xg->nlinks-1]  = last_color_ids;
      xg->line_color_prev[xg->nlinks-1] = last_color_prev;
    }
  }
  plot_once(xg);
}

void
map_line_edit(xg)
    xgobidata *xg;
{
  if (xg->is_line_editing)
    XtMapWidget(line_edit_panel);
  else
    XtUnmapWidget(line_edit_panel);
}

/* ARGSUSED */
XtCallbackProc
line_editor_cback(w, xgobi, callback_data)
/*
 * If the plot window is fully or partially exposed, clear and redraw.
*/
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  if (!xg->is_line_editing)
  {
    le_nearest_pt = -1;
    xg->is_line_editing = True;
    (void) XtAppAddWorkProc(app_con, RunWorkProcs, NULL);
    if (is_le_adding)
    {
      XtAddEventHandler(xg->workspace,
        ButtonPressMask | ButtonReleaseMask,
        FALSE, (XtEventHandler) add_line_button, (XtPointer) xg);
      (void) XtAppAddWorkProc(app_con, RunWorkProcs, NULL);
      XtMapWidget(xg->le_add_mouse);
    }
    else if (is_le_deleting)
    {
      XtAddEventHandler(xg->workspace,
        ButtonPressMask | ButtonReleaseMask,
        FALSE, (XtEventHandler) delete_line_button, (XtPointer) xg);
      (void) XtAppAddWorkProc(app_con, RunWorkProcs, NULL);
      XtMapWidget(xg->le_delete_mouse);
      le_nearest_line = -1;
    }
    map_line_edit(xg);
/*
 * Since it makes no sense to use the line editor if the
 * lines aren't drawn, draw them.
*/
    if (!xg->connect_the_points)
      turn_on_showlines(xg) ;

    plot_once(xg);
  }
  else
  {

    if (is_le_adding)
    {
      XtRemoveEventHandler(xg->workspace,
        XtAllEvents, TRUE,
        (XtEventHandler) add_line_button, (XtPointer) xg);
      XtUnmapWidget(xg->le_add_mouse);
    }
    else if (is_le_deleting)
    {
      XtRemoveEventHandler(xg->workspace,
        XtAllEvents, TRUE,
        (XtEventHandler) delete_line_button, (XtPointer) xg);
      XtUnmapWidget(xg->le_delete_mouse);
    }
    xg->is_line_editing = False;
    map_line_edit(xg);
  }
}

/* ARGSUSED */
XtCallbackProc
add_lines_cback(w, xgobi, callback_data)
/*
 *  Initiate line adding mode.
*/
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  if (!is_le_adding)
  {
    is_le_adding = True;
    le_start = -1;
    XtAddEventHandler(xg->workspace,
      ButtonPressMask | ButtonReleaseMask,
      FALSE, (XtEventHandler) add_line_button, (XtPointer) xg);
    XtMapWidget(xg->le_add_mouse);
  }
  else
  {
    XtRemoveEventHandler(xg->workspace,
      XtAllEvents,
      TRUE, (XtEventHandler) add_line_button, (XtPointer) xg);
    is_le_adding = False;
    le_start = -1;
    XtUnmapWidget(xg->le_add_mouse);
  }
}

/* ARGSUSED */
XtCallbackProc
delete_lines_cback(w, xgobi, callback_data)
/*
 * Initiate line deletion mode
*/
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  if (!is_le_deleting)
  {
    is_le_deleting = True;
    XtAddEventHandler(xg->workspace,
      ButtonPressMask | ButtonReleaseMask,
      FALSE, (XtEventHandler) delete_line_button, (XtPointer) xg);
    XtMapWidget(xg->le_delete_mouse);
    le_nearest_line = -1;
  }
  else
  {
    XtRemoveEventHandler(xg->workspace,
      XtAllEvents, TRUE,
      (XtEventHandler) delete_line_button, (XtPointer) xg);
    is_le_deleting = False;
    le_start = -1;
    XtUnmapWidget(xg->le_delete_mouse);
  }
}

/* ARGSUSED */
XtCallbackProc
remove_all_lines_cback(w, xgobi, callback_data)
/*
 * Remove all the lines -- this isn't just not showing them,
 * it's removing them altogether.
*/
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->nlinks = 0;
  le_start = -1;

  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
save_lines_cback(w, xgobi, callback_data)
/*
 * Save the lines in a file.
*/
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  (void) strcpy(xg->save_type, SAVE_LINES );
  fname_popup(w, xg);
}

void
line_edit_save(w, xg)
  Widget w;
  xgobidata *xg;
{
  int j;
  char *rootname;
  char outfname[100];
  long foo;
  FILE *fopen(), *fp;
  int fclose();

  XtVaGetValues(w,
    XtNstring, &rootname,
    NULL);

  if (Sprocess)
  {
    (void) strcpy(outfname, Spath0);
    (void) strcat(outfname, rootname);
    (void) strcat(outfname, ".lines");
    if ( (fp = fopen(outfname, "w")) == NULL)
    {
      char message[200];
      sprintf(message,
        "Failed to open the file '%s' for writing.\n", outfname);
      show_message(message, xg);
    }
    else
    {
      /*
       * "1" indicates that the following is an
       * S data structure of one element.
      */
      (void) fprintf(fp, "%cS data%c", (char) 0 , (char) 1);
      /*
       * "2" indicates that the following is of type
       * integer; "4" would imply numeric, or double.
      */
      foo = (long) 2;
      if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
        fprintf(stderr, "xgobi: error in writing connecting lines.\n");
      /*
       * "2*xg->nlinks" says the following has "2*xg->nlinks" elements."
      */
      foo = (long) (2*xg->nlinks) ;
      if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
        fprintf(stderr, "xgobi: error in writing connecting lines.\n");

      for (j=0; j<xg->nlinks; j++)
      {
        foo = (long) xg->connecting_lines[j].a ;
        if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
          fprintf(stderr, "xgobi: error in writing connecting lines.\n");
        foo = (long) xg->connecting_lines[j].b ;
        if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
          fprintf(stderr, "xgobi: error in writing connecting lines.\n");
      }
      if (fclose(fp) == EOF)
        fprintf(stderr, "xgobi: error in writing connecting lines.\n");
    }
  }
  else
  {
    strcpy(outfname, rootname);
    strcat(outfname, ".lines");

    if ( (fp = fopen(outfname, "w")) == NULL)
/*
      (void) fprintf(stderr, "The file '%s' can't be opened for writing\n",
             outfname);
*/
    {
      char message[200];
      sprintf(message,
        "Failed to open the file '%s' for writing.\n", outfname);
      show_message(message, xg);
    }
    else
    {
      for (j=0; j<xg->nlinks; j++)
        fprintf(fp, "%d %d\n",
          xg->connecting_lines[j].a, xg->connecting_lines[j].b);
      if (fclose(fp) == EOF)
        fprintf(stderr, "Error in writing '%s'\n", outfname);
    }
  }
}

/* ARGSUSED */
XtCallbackProc
read_lines_cback(w, xgobi, callback_data)
/*
 * Read lines from a file.
*/
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  (void) strcpy(xg->save_type, READ_LINES );
  fname_popup(w, xg);
}

void
line_edit_read(w, xg)
  Widget w;
  xgobidata *xg;
{
  char *fname;
  int i;

  XtVaGetValues(w,
    XtNstring, &fname,
    NULL);

  XtFree((XtPointer) xg->connecting_lines);
  if (read_connecting_lines(fname, True, xg) == 0)  /* True or False? */
  {
    /*
     * As a backup, create the defaults.
    */
    (void) fprintf(stderr, "problem in reading connecting lines file\n");
    xg->nlinks = xg->nrows - 1;
    realloc_lines(xg);

    for (i=0; i<xg->nlinks; i++)
    {
      xg->connecting_lines[i].a = i+1;
      xg->connecting_lines[i].b = i+2;
    }
  }
  else
    realloc_lines(xg);

  init_line_colors(xg);
  plot_once(xg);
}

/* ------ Initialization section ------ */

void
make_line_editor(xg)
    xgobidata *xg;
{
  /*
   * LineEditPanel
  */
  line_edit_panel = XtVaCreateManagedWidget("LineEditPanel",
    boxWidgetClass, xg->box0,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNright, (XtEdgeType) XtChainLeft,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNbottom, (XtEdgeType) XtChainTop,
    XtNmappedWhenManaged, (Boolean) False,
    NULL);
  if (mono) set_mono(line_edit_panel);
  /*
   * Add Lines
  */
  ADD = CreateToggle(xg, "Add",
    True, (Widget) NULL, (Widget) NULL,
    (Widget) NULL, False, ONE_OF_MANY,
    line_edit_panel, "LE_AddLines");
  /*
   * Delete Lines
  */
  DELETE = CreateToggle(xg, "Delete",
    True, (Widget) NULL, (Widget) NULL,
    (Widget) ADD, True, ONE_OF_MANY,
    line_edit_panel, "LE_RmLines");
  /*
   * Remove all connecting lines button.
  */
  REMOVE_ALL = CreateCommand(xg, "Remove all lines",
    True, (Widget) NULL, (Widget) NULL,
    line_edit_panel, "LE_RmAllLines");

  SAVE = CreateCommand(xg, "Save in file",
    True, (Widget) NULL, (Widget) NULL,
    line_edit_panel, "LE_Save");

  /*
   * Inactive if running XGobi from S
  */
  READ = CreateCommand(xg, "Read from file",
    (Boolean) !Sprocess, (Widget) NULL, (Widget) NULL,
    line_edit_panel, "LE_Read");

  XtManageChildren(le_cmd, 5);

  XtAddCallback(ADD, XtNcallback,
    (XtCallbackProc) add_lines_cback, (XtPointer) xg);
  XtAddCallback(DELETE, XtNcallback,
    (XtCallbackProc) delete_lines_cback, (XtPointer) xg);
  XtAddCallback(REMOVE_ALL, XtNcallback,
    (XtCallbackProc) remove_all_lines_cback, (XtPointer) xg);
  XtAddCallback(SAVE, XtNcallback,
    (XtCallbackProc) save_lines_cback, (XtPointer) xg);
  XtAddCallback(READ, XtNcallback,
    (XtCallbackProc) read_lines_cback, (XtPointer) xg);
}


/* ------------------ End of initialization section  -------------- */
/* ------------------ Routines for the final drawing -------------- */

void
draw_heavy_line(lineid, win, xg)
  int lineid;
  Drawable win;
  xgobidata *xg;
{
  int start = xg->connecting_lines[lineid].a-1;
  int end   = xg->connecting_lines[lineid].b-1;

  if (!mono)
    XSetForeground(display, copy_GC, xg->line_color_now[lineid]);
  XSetLineAttributes(display, copy_GC,
    2, LineSolid, CapButt, JoinMiter);

  XDrawLine(display, win, copy_GC,
    xg->screen[start].x, xg->screen[start].y,
    xg->screen[end].x, xg->screen[end].y);

  if (!mono)
    XSetForeground(display, copy_GC, plotcolors.fg);
  XSetLineAttributes(display, copy_GC,
    0, LineSolid, CapButt, JoinMiter);
}

static void
find_line_colors_used(xg, ncolors_used, colors_used)
  xgobidata *xg;
  int *ncolors_used;
  unsigned long *colors_used;
{
  Boolean new_color;
  int i, k;

  /*
   * Need this line here to initialize -- especially to cover
   * the odd case that you're using xgobi in mono mode on a
   * color display.
  */
  colors_used[0] = xg->line_color_now[0];
  /*
   * Loop once through line_color_now[], collecting the colors
   * currently in use into the line_colors_used[] vector.
  */
  if ( (xg->is_color_painting && xg->is_line_painting) ||
     xg->got_new_paint)
  {
    *ncolors_used = 1;
    for (i=0; i<xg->nlinks; i++)
    {
      new_color = True;
      for (k=0; k<*ncolors_used; k++)
      {
        if (colors_used[k] == xg->line_color_now[i])
        {
          new_color = False;
          break;
        }
      }
      if (new_color)
      {
        colors_used[*ncolors_used] = xg->line_color_now[i];
        (*ncolors_used)++;
      }
    }
  }
}

void
draw_connecting_lines(xg)
  xgobidata *xg;
{
  int j, k;
  int from, to;
  int nlinks_in_plot;
  unsigned long current_color;
  static unsigned long line_colors_used[NCOLORS+1];
  static int nline_colors_used = 1;

  if (!mono)
  {
    find_line_colors_used(xg, &nline_colors_used, line_colors_used);

    /*
     * Now loop through line_colors_used[], plotting the glyphs of each
     * color in a group.
    */
    for (k=0; k<nline_colors_used; k++)
    {
      current_color = line_colors_used[k];
      nlinks_in_plot = 0;

      for (j=0; j<xg->nlinks; j++)
      {
        from = xg->connecting_lines[j].a - 1;
        to = xg->connecting_lines[j].b - 1;
        if (!xg->erased[from] && !xg->erased[to])
        {
          if (xg->line_color_now[j] == current_color)
          {
            connecting_segs[nlinks_in_plot].x1 = xg->screen[from].x;
            connecting_segs[nlinks_in_plot].y1 = xg->screen[from].y;
            connecting_segs[nlinks_in_plot].x2 = xg->screen[to].x;
            connecting_segs[nlinks_in_plot].y2 = xg->screen[to].y;
            nlinks_in_plot++;
          }
        }
      }
      XSetForeground(display, copy_GC, current_color );
      XDrawSegments(display, xg->pixmap0, copy_GC,
        connecting_segs, nlinks_in_plot);
    }
  }
  else    /* if mono */
  {
    nlinks_in_plot = 0;
    for (j=0; j<xg->nlinks; j++)
    {
      from = xg->connecting_lines[j].a - 1;
      to = xg->connecting_lines[j].b - 1;
      if (!xg->erased[from] && !xg->erased[to])
      {
        connecting_segs[nlinks_in_plot].x1 = xg->screen[from].x;
        connecting_segs[nlinks_in_plot].y1 = xg->screen[from].y;
        connecting_segs[nlinks_in_plot].x2 = xg->screen[to].x;
        connecting_segs[nlinks_in_plot].y2 = xg->screen[to].y;
        nlinks_in_plot++;
      }
    }
    XDrawSegments(display, xg->pixmap0, copy_GC,
      connecting_segs, nlinks_in_plot);
  }
}

void
draw_diamond_around_point(id, win, xg)
  int id;
  Drawable win;
  xgobidata *xg;
{
  XPoint diamond[5];

  diamond[0].x = diamond[4].x = xg->screen[id].x - 3;
  diamond[0].y = diamond[4].y = xg->screen[id].y;

  diamond[1].x = xg->screen[id].x;
  diamond[1].y = xg->screen[id].y - 3;

  diamond[2].x = xg->screen[id].x + 3;
  diamond[2].y = xg->screen[id].y;

  diamond[3].x = xg->screen[id].x;
  diamond[3].y = xg->screen[id].y + 3;

  XSetForeground(display, copy_GC, plotcolors.fg);
  XDrawLines(display, win, copy_GC,
    diamond, 5, CoordModeOrigin);
}

void
draw_dotted_line(start, end, win, xg)
  int start;
  int end;
  Drawable win;
  xgobidata *xg;
{
  XSetLineAttributes(display, copy_GC,
    0, LineOnOffDash, CapButt, JoinMiter);

  XDrawLine(display, win, copy_GC,
    xg->screen[start].x, xg->screen[start].y,
    xg->screen[end].x, xg->screen[end].y);

  XSetLineAttributes(display, copy_GC,
    0, LineSolid, CapButt, JoinMiter);
}

void
draw_editing_lines(xg)
  xgobidata *xg;
{
  if (is_le_adding)
  {
    if (le_start != -1)
    {
      draw_diamond_around_point(le_start, xg->plot_window, xg);
      if (le_nearest_pt != -1 && is_le_adding)
        draw_dotted_line(le_start, le_nearest_pt, xg->plot_window, xg);
    }
    else
    {
      if (le_nearest_pt > -1)
        draw_diamond_around_point(le_nearest_pt, xg->plot_window, xg);
    }
  }
  else if (is_le_deleting && xg->connect_the_points &&
           le_nearest_line > -1)
  {
    draw_heavy_line(le_nearest_line, xg->plot_window, xg);
  }
}

