/*
 * $Id: udrm.h,v 1.1 1991/04/10 19:37:47 steve Exp $
 *
 * $__Header$
 *
 * Unidata resource-manager API:
 */

#ifndef UD_UDRM_H_INCLUDED
#define UD_UDRM_H_INCLUDED

/*
 *	Macro for declaring functions regardless of the availability of 
 *	function prototypes.  NB: will need double parens in actual use (e.g.
 *	"int func PROTO((int a, char *cp))").
 */
#ifndef	PROTO
#   if defined(__STDC__) || defined(__GNUC__) \
	|| defined(__cplusplus) || defined(c_plusplus)
#	define	PROTO(a)	a
#   else
#	define	PROTO(a)	()
#   endif
#endif

/*
 * Eventually, we want to extract what we need out of these to be
 * independent of X.
 */
#include <X11/Xlib.h>
#include <X11/Xresource.h>

#define	UrmDatabase	XrmDatabase
#define	UrmValue	XrmValue

extern int	UrmGetFileDatabase	PROTO((
    char	*filename,
    UrmDatabase	*db
));

extern int	UrmGetStringDatabase	PROTO((
    char	*string,
    UrmDatabase *db
)); 

extern int	 UrmGetResource		PROTO((
    UrmDatabase	db,
    char	*NameKey,
    char	*ClassKey,
    char	**type,
    UrmValue	*value 
));

extern int	UrmInitialize		PROTO((
    void
));

extern void	UrmMergeDatabases	PROTO((
    UrmDatabase	src_db,
    UrmDatabase	*dst_db
)); 

extern void	UrmPutLineResource	PROTO((
    UrmDatabase	*db,
    char	*line
)); 

extern void	UrmPutStringResource	PROTO((
    UrmDatabase	*db,
    char	*StoreKey,
    char	*value
));

#endif	/* UD_UDRM_H_INCLUDED not defined */
