/*
 * <string.h> library for the Unidata POSIX programming environment under 
 * NewsOS 3.3a.
 */

/*LINTLIBRARY*/

#ifndef lint
    static char	rcsid[]	= "$Id: string.c,v 1.2 1991/11/18 22:06:43 steve Exp $";
#endif

#include "udposix.h"
#include <string.h>
#include <sys/types.h>


/*
 * Return the error-string corresponding to a given error-number.
 */
    char*
strerror(errnum)
    int		errnum;
{
    extern int	sys_nerr;
    extern char	**sys_errlist;

    return errnum < 0 || errnum >= sys_nerr
	? "Unknown error"
	: sys_errlist[errnum];
}


/*
 * Copy bytes from one region to another.  Correctly handle overlap.
 */
    VOIDP
memmove(s, ct, n)
    VOIDP	s;
    const VOIDP	ct;
    size_t	n;
{
    (void)bcopy(ct,s,n);
    
    return s;
}
