/*
 * $Id: float.h,v 1.1 1991/09/11 20:36:39 steve Exp $
 *
 * <float.h> header-file for the ConvexOS 9.1 version of the Unidata
 * applications programming environment (UDAPE).
 */

#ifndef UDPOSIX_H_INCLUDED
#   ifdef __GNUC__
#	include "/usr/local/lib/gcc-include/float.h"
#   else
#	include "/usr//include/values.h"
#   endif
#else

#   ifndef	UD_FLOAT_H_INCLUDED
#   define	UD_FLOAT_H_INCLUDED

	/*
	 * Include native header-file.
	 */
#       ifdef __GNUC__
#           include "/usr/local/lib/gcc-include/float.h"
#       else
#           include "/usr//include/values.h"
#       endif

	/*
	 * Declare/define missing items.
	 */
#       ifndef __GNUC__
#	    define FLT_RADIX	_EXPBASE	
#	    define FLT_ROUNDS	1
#	    define FLT_DIG	6
#	    define FLT_EPSILON	((float)1.19209290e-07)
#	    define FLT_MANT_DIG	FSIGNIF	
#	    define FLT_MAX	MAXFLOAT	
#	    define FLT_MAX_EXP	FMAXEXP 	
#	    define FLT_MIN	MINFLOAT	
#	    define FLT_MIN_EXP	FMINEXP 	

#	    define DBL_DIG	15
#	    define DBL_EPSILON	2.2204460492503131e-16
#	    define DBL_MANT_DIG	DSIGNIF	
#	    define DBL_MAX	MAXDOUBLE	
#	    define DBL_MAX_EXP	DMAXEXP 	
#	    define DBL_MIN	MINDOUBLE	
#	    define DBL_MIN_EXP	DMINEXP 	
#       endif	/* __GNUC__ undefined above */

#    endif	/* UD_FLOAT_H_INCLUDED undefined above */

#endif	/* UDPOSIX_H_INCLUDED defined above*/
