// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1993,94,95,96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        themenus.h
//
// Purpose:     interface to scene viewer menus and dialogs
//
// Created:     17 Dec 92   Michael Pichler
//
// Changed:     19 Jan 96   Michael Pichler
//
// $Id: themenus.h,v 1.12 1996/01/30 11:24:43 mpichler Exp $
//
//</file>



#ifndef hg_viewer_hg3d_themenus_h
#define hg_viewer_hg3d_themenus_h


class SceneWindow;
class SceneMenus;

#include <hyperg/utils/str.h>

#include <ge3d/vectors.h>

#include <InterViews/action.h>
#include <InterViews/telltale.h>
class Patch;

class GEContext;
class HG3dInputHandler;
class LayoutKit;
class Menu;
class WidgetKit;
class WFileChooser;
class ColourDialog;
class ApplicationWindow;
class FieldBrowser;
class TextBrowser;
class QvPerspectiveCamera;
class QvOrthographicCamera;
class NavigationSettingsDialog;


/*** MenuGroupCallback ***/
// action for calling a member function of SceneMenus with integer argument

typedef void (SceneMenus::*SceneMenuMemberFunction) (int);
// pointer to member function of SceneMenus with int argument

class MenuGroupCallback: public Action
{
  public:
    MenuGroupCallback (SceneMenus*, SceneMenuMemberFunction, int arg);

    virtual void execute ();

  private:
    SceneMenus* sm_;
    SceneMenuMemberFunction fu_;
    int arg_;
};



/*** SceneMenus ***/

class SceneMenus
{
  public:
    SceneMenus (Patch* menupatch, Patch* buttonpatch, SceneWindow* scene,
                GEContext*, HG3dInputHandler*,  // @@@ soon removing them
                WidgetKit* kit, const LayoutKit* layout);  // pointers must not be nil
    ~SceneMenus ();

    void updateLanguage ()
    { createMenus ();  createButtons ();  updateDialogs (); }

    void createMenus ();
    void createButtons ();
    void updateDialogs ();

    TextBrowser* errorBrowser ()        // error browser (nil if not yet created)
    { return errorbrowser_; }
    TextBrowser* errorBrowserInstance ();  // instance of error browser (created if not yet done)

    void selectionChanged ();  // hint that selection changed - enable/disable anchor menu items
    void sceneChanged ();  // hint on clearing/loading a scene - enable/disable file menu items

    void navigationMode (int);
    void selectionMode (int);
    void twosidedPolys (int);
    void doLighting (int);
    void highlightingMode (int);
    void displayMode (int mode, int interactive);
    void openFile ();
    void saveOriginalScene ();
    void toggleShowAnchors ();

    void resetView ();
    void levelView ();
    void untiltView ();

    void addViewpoint (               // add camera to viewpoint menu
      const char* name, QvPerspectiveCamera*, QvOrthographicCamera*
    );
    void clearViewpoints ();
    void selectViewpoint (int num);  // running from 0

    void toggleAntialiasing ();
    int antialiasing () const
    { return (aaliasingstate_->flags () & TelltaleState::is_chosen); }

    void setCollisionDetection (int flag);

    void applyColours (ColourDialog*);  // callback

    enum {  // space ball flags
      sb_translate, sb_rotate, sb_saf,  // 0..2
      sb_numflags  // 3
    };
    int getSballFlag (int i);           // returns setting of i-th sb. flag
    int toggleSballFlag (int i);        // toggles i-th spaceball flag; returns new value
    void toggleSballMode ();            // toggle navigation mode (flip/walk)

    float sballSensitivity () const;    // return sensitivity of spaceball
    void decreaseSballSensitivity ();
    void increaseSballSensitivity ();
    void resetSballSensitivity ();

  private:
    // submenus
    Menu* filePulldown (WidgetKit&, const LayoutKit&);
    Menu* demoPullright (WidgetKit&, const LayoutKit&);
    Menu* usabilityPullright (WidgetKit&, const LayoutKit&);
    Menu* navigatePulldown (WidgetKit&, const LayoutKit&);
    Menu* anchorsPulldown (WidgetKit&, const LayoutKit&);
    Menu* viewPulldown (WidgetKit&, const LayoutKit&);
    Menu* anchorsPullright (WidgetKit&, const LayoutKit&);
    Menu* colorPullright (WidgetKit&, const LayoutKit&);
    Menu* documentPulldown (WidgetKit&, const LayoutKit&);
    // Menu* optionsPulldown (WidgetKit&, const LayoutKit&);
    Menu* specialPulldown (WidgetKit&, const LayoutKit&);
    Menu* helpPulldown (WidgetKit&, const LayoutKit&);
    void updateAbout (WidgetKit&, const LayoutKit&);

    // dialogs
    void buildOpenFC ();
    void buildColourDialog ();
    void buildErrorDialog ();
    void buildSpaceballDialog ();

    void loadDemo (const char*);  // file name relative to demo path
    void browseDemo (const char*, const point3D& position, const point3D& lookat);
    void saveScene (int format, const char* filemask);
    void saveVRMLScene ();
    void saveSDFScene ();
    void saveDepth ();  // will be merged into saveScene
    void documentInfo (int);
    void toggleColourDialog ();
    void colourChanged ();
    void anchorMotionChanged ();
    void velocityControlChanged ();
    void arbitraryRotationChanged ();
    void collisionDetectionChanged ();
    void showAnchorsChanged ();
    void aaliasingChanged ();
    void viewingLightChanged ();
    void toggleTextureLighting ();
    void removeSelection ();
    void printData ();
    void printAll ();
    void cameraInfo ();
    void toggleAbout ();
    void toggleErrorDialog ();
    void closeErrorDialog ();
    void toggleNavigationSettingsDialog ();
    void destroyNavsetdlg ();
    void toggleSpaceballDialog ();
    void closeSpaceballDialog ();
    void movementMode (int);
    void setDisplayMode (int);
    void setInteractiveMode (int);
    void sb_checkbuttons (int);
    void updateSensitivity ();

    Patch* menupatch_;
    Patch* buttonpatch_;
    SceneWindow* scene_;
    GEContext* gecontext_;
    HG3dInputHandler* inputhand_;
    WidgetKit* kit_;
    const LayoutKit* layout_;
    WFileChooser* openfc_;
//    WFileChooser* savefc_;
    ColourDialog* coldlg_;
    ApplicationWindow* errorwindow_;
    TextBrowser* errorbrowser_;
    NavigationSettingsDialog* navsetdlg_;
    ApplicationWindow* sballwindow_;

    Menu* viewpointsPr_;

    TelltaleState* saveasstate_;
    TelltaleState* exportSDFstate_;
    TelltaleState* exportVRMLstate_;
    TelltaleState* sourceanchorstate_;
    TelltaleState* deleteanchorstate_;
    TelltaleState* anchorinfostate_;
    TelltaleState* activateanchorstate_;
    TelltaleState* removeselectionstate_;
    TelltaleState* anchormotionstate_;
    TelltaleState* velocitycontrolstate_;
    TelltaleState* arbitraryrotstate_;
    TelltaleState* colldetectionstate_;
    TelltaleState* showanchorstate_;

    TelltaleState* wireframe_;
    TelltaleState* hiddenline_;
    TelltaleState* flatshading_;
    TelltaleState* smoothshading_;
    TelltaleState* texturing_;

    TelltaleState* intsame_;
    TelltaleState* intwire_;
    TelltaleState* inthline_;
    TelltaleState* intflat_;
    TelltaleState* intsmooth_;
    TelltaleState* inttexture_;

    TelltaleState* aaliasingstate_;
    TelltaleState* navflipobjstate_;
    TelltaleState* navwalkstate_;
    TelltaleState* navflystate_;
    TelltaleState* navflytostate_;
    TelltaleState* navheadsupstate_;
    TelltaleState* viewlgtstate_;
    RString demopath_;

    TelltaleState* sbflagstate_ [sb_numflags];
    FieldBrowser* sbsensfieldb_;
    int sbsensitivity2_;

  friend class MenuGroupCallback;
  friend class LoadDemoCallback;
  friend class BrowseDemoCallback;
  friend class SetColourCallback;
  friend class ViewpointCallback;

};  // SceneMenus


inline TextBrowser* SceneMenus::errorBrowserInstance ()
{
  if (!errorbrowser_)  // create instance
    buildErrorDialog ();
  return errorbrowser_;
}


#endif
